package javax.microedition.io;

import java.io.IOException;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2000, 2005  All Rights Reserved
 */

/**
 * The interface for HTTPS connections.
 *
 * @author OTI
 * @since MIDP 2.0
 * @version initial
 *
 */
public interface HttpsConnection extends HttpConnection {

/**
 * Answers the port number of the connection on the remote host.
 *
 * @return int	the port number
 *
 */
public int getPort();

/**
 * Answers the security information associated with this connection.
 *
 * @return the security information for this connection
 * @throws IOException if a connection failure occurs
 */
public SecurityInfo getSecurityInfo() throws IOException;

}
