package javax.microedition.io;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

import java.io.IOException;

/**
 * Represents a DatagramConnection that knows its local address and port number.
 *
 * @author OTI
 * @since MIDP 2.0
 * @version initial
 */
public interface UDPDatagramConnection extends DatagramConnection {

	/**
	 * Answers the local address for this UDPDatagramConnection.
	 * @return String	the local address
	 * @throws IOException	if the connection has been closed
	 */
	public String getLocalAddress() throws IOException;

	/**
	 * Answers the local port number for this UDPDatagramConnection.
	 * @return int	the port number
	 * @throws IOException	if the connection has been closed
	 */
	public int getLocalPort() throws IOException;

}
