package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2006  All Rights Reserved
 */

import com.ibm.ive.midp.*;

class AlertPeer extends FormPeer implements IEventListener {

	int fHandle;
	boolean fMousePressed;

	public AlertPeer(Display display, Alert alert) {
		super(display, alert);
	}

	void create() {
		if (OS.usesSoftKeys) {
			super.create();
			return;
		}

		Device.syncExec(new Runnable() {
			public void run() {
				OS.EnableWindow(fDisplay.fPeer.fHandle, false);
				fHandle = OS.CreateChildWindow(fDisplay.fPeer.fHandle, getFlags());

				Rectangle rect = getAlertBounds();
				int flags = OS.SWP_NOZORDER | OS.SWP_DRAWFRAME | OS.SWP_NOACTIVATE;
				OS.SetWindowPos(fHandle, 0, rect.x, rect.y, rect.width, rect.height, flags);

				fWidth = OS.GetClientWidth(fHandle);
				fHeight = OS.GetClientHeight(fHandle);
				OS.ShowWindow(fHandle, OS.SW_SHOW);
			}
		});

		Device.addEventListener(this, fHandle);
		super.create();
	}

	void dispose() {
		super.dispose();
		((Alert)fDisplayable).cancelAlarm();

		if (OS.usesSoftKeys) return;

		final AlertPeer peer = this;
		Device.syncExec(new Runnable() {
			public void run() {
				OS.EnableWindow(fDisplay.fPeer.fHandle, true);
				Device.removeEventListener(peer, fHandle);
				OS.DestroyWindow(fHandle);
				fHandle = 0;
			}
		});
	}

	int getFlags() {
		return OS.WS_POPUP | OS.WS_CAPTION | OS.WS_BORDER | OS.WS_SYSMENU | OS.WS_THICKFRAME | OS.WS_CLIPCHILDREN;
	}

	void setInitialFocus() {
		/* no-op for alerts */
	}

	void layout() {
		super.layout();
		((Alert)fDisplayable).setContentModal(fContentComponent.fLayout.fLayoutHeight > fContentComponent.fHeight);
	}

	static String getDismissLabel() {
		return MsgDrawnCommon.getString("AlertPeer.DismissLabel"); //$NON-NLS-1$
	}

	public void changeType() {
	}

	public int getWindowHandle() {
		if (OS.usesSoftKeys) return super.getWindowHandle();
		return fHandle;
	}

	public boolean dispatchEvent(Event e) {
		if (OS.usesSoftKeys) return super.dispatchEvent(e);
		switch (e.fType) {
			case Event.MENU_SELECTED:
				return super.dispatchEvent(e);
			case Event.WINDOW_PAINT:
				repaint();
				return false;
			case Event.VERTICAL_SCROLL:
				fContentComponent.scrollTo(0, e.fScrollOrSelectionIndex);
				return false;
			case Event.WINDOW_RESIZE:
				if (fDisplayable == null || fDisplayable.fPeer == null || fDisplayable.fPeer.fInvalidated) return false;
				fDisplayable.fPeer.resize(e.fX, e.fY);
				return false;
			case Event.WINDOW_CLOSED:
				((Alert) fDisplayable).advance();
				return true;
		}
		return false;
	}

	public boolean dispatchPointerEvent(Event e) {
		if (OS.usesSoftKeys) return super.dispatchEvent(e);
		switch (e.fType) {
			case Event.POINTER_PRESSED:
				fMousePressed = true;
				super.pointerPressed(e.fX, e.fY);
				return false;
			case Event.POINTER_RELEASED:
				fMousePressed = false;
				super.pointerReleased(e.fX, e.fY);
				return false;
			case Event.POINTER_MOVED:
				if (!fMousePressed) return false;
				super.pointerDragged(e.fX, e.fY);
				return false;
			default:
				return false;
		}
	}

	public boolean getAllowMenuEvents() {
		return false;
	}

	/*
	 * This method is not called resize because OS.SetWindowPos generates a WM_SIZE event
	 * which again calls resize() resulting in an infinite loop
	 */
	void alertResize(int newWidth, int newHeight) {
		Rectangle rect = getAlertBounds();
		int flags = OS.SWP_NOZORDER | OS.SWP_DRAWFRAME | OS.SWP_NOACTIVATE;
		// Reposition the Alert window
		OS.SetWindowPos(fHandle, 0, rect.x, rect.y, rect.width, rect.height, flags);
	}

	Rectangle getAlertBounds() {
		int shellHeight = Device.getShellHeight();
		int x = fDisplay.fPeer.getX();
		int y = fDisplay.fPeer.getY() + (shellHeight / 4);
		int width = Device.getShellWidth();
		int height = shellHeight / 2;

		Rectangle rect = new Rectangle(x, y, width, height);
		return rect;
	}
}
