package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM.
 * (c) Copyright IBM Corp 2000, 2005.
 *
 */

import com.ibm.ive.midp.*;

/**
 * This class represents different types of alerts.
 * Every object of this type is able to play a sound on display.
 *
 * @see Alert
 */
public class AlertType {

	public static final AlertType ALARM = new AlertType();
	public static final AlertType CONFIRMATION = new AlertType();
	public static final AlertType ERROR = new AlertType();
	public static final AlertType INFO = new AlertType();
	public static final AlertType WARNING = new AlertType();

	protected AlertType() {
	}

	public boolean playSound(Display aDisplay) {
		if (aDisplay == null) throw new NullPointerException();

		if (this == ALARM) return Device.playSound(Device.SOUND_ALARM);
		if (this == WARNING) return Device.playSound(Device.SOUND_WARNING);
		if (this == ERROR) return Device.playSound(Device.SOUND_ERROR);
		if (this == CONFIRMATION) return Device.playSound(Device.SOUND_CONFIRMATION);
		if (this == INFO) return Device.playSound(Device.SOUND_INFO);

		return false;
	}
}
