package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2004, 2005  All Rights Reserved
 */

class Border {

	static final int DEFAULT_BUTTON_ARC = 8;

	int getWidth(int componentType) {
		/* Default border width */
		switch (componentType) {
			case Item.TYPE_DATEFIELD:
			case Item.TYPE_GAUGE:
				return 3;
			default:
				return 1;
		}
	}

	int getHeight(int componentType) {
		/* Default border height */
		switch (componentType) {
			case Item.TYPE_GAUGE:
				return 3;
			default:
				return 1;
		}
	}

	/* May be overridden by subclasses */
	void paintChoiceGroupBorder(Component c, Graphics g, boolean hasFocus, int x, int y, int w, int h) {
//		if (((ChoiceComponent)c).isPopup()) {
//			paintRectangularBorder(g, Graphics.SOLID, DisplayPeer.COLOR_BORDER_RGB, x, y, w, h);
//			return;
//		}
		paintRectangularBorder(g, Graphics.DOTTED, hasFocus ? DisplayPeer.COLOR_BORDER_RGB : DisplayPeer.COLOR_BACKGROUND_RGB, x, y, w, h);
	}

	/* May be overridden by subclasses */
	void paintButtonBorder(Component c, Graphics g, int strokeStyle, int x, int y, int w, int h) {
		int color;

		ButtonWidget button = (ButtonWidget) c;

		if (!button.fEnabled) {
			color = DisplayPeer.COLOR_MENU_DISABLED_BORDER;
		} else if (button.hasFocus()) {
			color = DisplayPeer.COLOR_FOREGROUND_RGB;
		} else {
			color = DisplayPeer.COLOR_BORDER_RGB;
		}

		g.setColor(color);
		g.setStrokeStyle(strokeStyle);
		g.drawRect(x, y, w, h);
	}

	void paintRectangularBorder(Graphics g, int strokeStyle, int color, int x, int y, int w, int h) {
		g.setColor(color);
		int oldStrokeStyle;
		if ((oldStrokeStyle = g.getStrokeStyle()) == strokeStyle) {
			g.drawRect(x, y, w, h);
		} else {
			g.setStrokeStyle(strokeStyle);
			g.drawRect(x, y, w, h);
			g.setStrokeStyle(oldStrokeStyle);
		}
	}

	/* Paints the border.
	 * @param x, y, w , h   Required to be passed considering the
	 * commands which require values from ButtonData.
	 * @param hasFocus CommandButtons set different colour
	 * for Border depending on whether they have focus or not.
	 */
	void paint(Component c, Graphics g, boolean hasFocus, int x, int y, int w, int h){
		switch (c.getType()) {
			case Item.TYPE_CHOICEGROUP:
				paintChoiceGroupBorder(c, g, hasFocus, x, y, w, h);
				break;
			case Item.TYPE_GAUGE:
				paintRectangularBorder(g, Graphics.DOTTED, DisplayPeer.COLOR_BORDER_RGB, x, y, w, h);
				break;
			case Item.TYPE_STRING:
				StringItemPeer stringItemPeer = (StringItemPeer) c;
				if (stringItemPeer.isHyperlink()) {
					paintRectangularBorder(g, Graphics.DOTTED, DisplayPeer.COLOR_FOREGROUND_RGB, x, y, w, h);
				} else if (stringItemPeer.usesButton()) {
					paintButtonBorder(c, g, Graphics.SOLID, x, y, w, h);
				} else {
					// non-interactive mode
					paintRectangularBorder(g, Graphics.DOTTED, DisplayPeer.COLOR_BORDER_RGB, x, y, w, h);
				}
				break;
			case Item.TYPE_IMAGE:
				if (((ImageItemPeer)c).isHyperlink()) {
					paintRectangularBorder(g, Graphics.DOTTED, DisplayPeer.COLOR_BORDER_RGB, x, y, w, h);
				} else {
					paintButtonBorder(c, g, Graphics.SOLID, x, y, w, h);
				}
				break;
			case Item.TYPE_BUTTON:
				paintButtonBorder(c, g, Graphics.SOLID, x, y, w, h);
				break;
			case Item.TYPE_DATEFIELD:
			case Item.TYPE_CUSTOM:
				paintRectangularBorder(g, Graphics.DOTTED, DisplayPeer.COLOR_FOREGROUND_RGB, x, y, w, h);
				break;
		}
	}
}
