package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

/**
 * Common interface for types representing user's choices,
 * <code>List</code> and <code>ChoiceGroup</code>
 *
 * @see List
 * @see ChoiceGroup
 **/
public interface Choice {

	public static final int EXCLUSIVE = 1;
	public static final int IMPLICIT  = 3;
	public static final int MULTIPLE  = 2;

	public static final int TEXT_WRAP_ON = 1;
	public static final int TEXT_WRAP_OFF = 2;
	public static final int TEXT_WRAP_DEFAULT = 0;

	public static final int POPUP = 4;

	public int append(String elementName, Image image);
	public void delete(int elementIndex);

	public Image getImage(int elementIndex);
	public int getSelectedFlags(boolean[] selectedElementsToQuery);
	public int getSelectedIndex();
	public String getString(int elementIndex);
	public void insert(int elementIndex, String elementName, Image image);
	public boolean isSelected(int elementIndex);
	public void set(int elementIndex, String elementName, Image image);
	public void setSelectedFlags(boolean[] selectedArrayToSet);
	public void setSelectedIndex(int elementIndex, boolean isSelected);
	public int size();
	public abstract void setFitPolicy(int policy);
	public abstract void setFont(int index, Font font);
	public abstract void deleteAll();
	public abstract int getFitPolicy();
	public abstract Font getFont(int index);
}
