package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2005  All Rights Reserved
 */

abstract class CommandButton extends ButtonWidget {

	static final int RIGHT_MARGIN = 4;

	static final int TEXT_H_MARGIN = 3;
	static final int TEXT_V_MARGIN = 2;

	static final int TOTAL_TEXT_H_MARGIN = 2 * TEXT_H_MARGIN;
	static final int TOTAL_TEXT_V_MARGIN = 2 * TEXT_V_MARGIN;

	static final int DEFAULT_MIN_WIDTH = TOTAL_TEXT_H_MARGIN	+ gFont.getStringWidth("W..."); //$NON-NLS-1$

	static final int BORDER_WIDTH = gBorder.getWidth(Item.TYPE_BUTTON);
	static final int BORDER_HEIGHT = gBorder.getHeight(Item.TYPE_BUTTON);
	static final int TOTAL_BORDER_WIDTH = 2 * BORDER_WIDTH;
	static final int TOTAL_BORDER_HEIGHT = 2 * BORDER_HEIGHT;
	static final String MENU_STRING = " ... "; //$NON-NLS-1$
	static final int MENU_BUTTON_WIDTH = gFont.getStringWidth(MENU_STRING) + TOTAL_BORDER_WIDTH + TOTAL_TEXT_H_MARGIN;

	static final int SELECTION_OFFSET = 1;
	static final int HIGHLIGHT_OFFSET = 1;

	static final int HEIGHT = FONT_HEIGHT + TOTAL_TEXT_V_MARGIN + TOTAL_BORDER_HEIGHT;

	Command fCommand;

	CommandButton(Composite parent, String text, Command command) {
		super(parent);
		fText = stripNewlines(text);
		fCommand = command;
		if (text != null) {
			fWidth = gFont.getStringWidth(fText) + TOTAL_BORDER_WIDTH + TOTAL_TEXT_H_MARGIN;
			fHeight = HEIGHT;
		}
	}

	int getType() {
		return Item.TYPE_BUTTON;
	}
}
