package javax.microedition.lcdui;

import com.ibm.ive.midp.*;
import com.ibm.ive.midp.util.*;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2006  All Rights Reserved
 */

class CommandManager {

	Displayable fDisplayable;
	DisplayablePeer fDisplayablePeer;

	DisplayableCommandComponent fCommandComponent;
	MenuBarComponent fMenuBarComponent;

	ItemComponent fItemMenuItem; // The Form Item whose commands are in the Item Menu

	final static int ACTIONS = 0;
	final static int ITEM = 1;
	final static int HELP = 2;
	final static int NAVIGATION = 3;

	CommandManager(Displayable d, DisplayablePeer p) {
		fDisplayable = d;
		fDisplayablePeer = p;
		createComponents();
		update();
	}

	void createComponents() {
		if (!OS.usesSoftKeys) {
			fCommandComponent = new DisplayableCommandComponent(fDisplayablePeer);
		}
		fMenuBarComponent = new MenuBarComponent(fDisplayablePeer);
	}

	void dispose() {
		if (fCommandComponent != null) {
			fCommandComponent.dispose();
			fCommandComponent = null;
		}
		if (fMenuBarComponent != null) {
			fMenuBarComponent.dispose();
			fMenuBarComponent = null;
		}
	}

	static int getFixedDisplayHeight() {
		if (OS.usesSoftKeys) return 0;
		if (OS.IsWinCE) return CommandComponent.MIN_HEIGHT;
		return CommandComponent.MIN_HEIGHT + MenuBarComponent.getMenuHeight();
	}

	void dispatchEvent(Event e) {
		switch (e.fType) {
		case Event.MENU_OPENING:
			if (fMenuBarComponent != null) fMenuBarComponent.showNotify();
			return;
		case Event.MENU_CLOSING:
			if (fMenuBarComponent != null) fMenuBarComponent.hideNotify();
			return;
		case Event.MENU_SELECTED:
			if (fMenuBarComponent != null) fMenuBarComponent.dispatchMenuSelection(e);
			return;
		}
	}

	void displayCommandMenu(boolean isMenuButton) {
		if (fMenuBarComponent != null) fMenuBarComponent.show();
	}

	int getDisplayHeight(DisplayablePeer d) {
		if (OS.usesSoftKeys) return 0;

		boolean reserveCommandHeight = (d instanceof CanvasPeer) && !(((CanvasPeer) d).fFullScreen) && MIDletManager.getMidpVersion() == 1;
		if (reserveCommandHeight) {
			return CommandComponent.MIN_HEIGHT;
		}

		if ((fCommandComponent != null && fCommandComponent.isShowing())) {
			return CommandComponent.MIN_HEIGHT;
		}
		return 0;
	}

	void focusChanged(Component focus) {
		if (fItemMenuItem != null && fMenuBarComponent != null) {
			fMenuBarComponent.updateItemMenu(null);
			fItemMenuItem = null;
		}
		if (focus instanceof ItemComponent) {
			ItemComponent focusComponent = (ItemComponent) focus;
			FastVector itemCommands = focusComponent.fItem.fCommands;
			if (itemCommands == null || itemCommands.size() == 0) return;
			if (fMenuBarComponent == null) {
				fMenuBarComponent = new MenuBarComponent(fDisplayablePeer);
			}
			fMenuBarComponent.updateItemMenu(focusComponent.fItem);
			fItemMenuItem = focusComponent;
		}
	}

	void update() {
		if (Display.gCurrentDisplay.fCurrent != fDisplayable) return;

		boolean menuShowing = fMenuBarComponent.isShown();
		boolean commandBarShowing = fCommandComponent != null && fCommandComponent.isShown();

		FastVector allCommands = null;
		if (fDisplayablePeer.fDisplayable.fCommands != null) {
			allCommands = fDisplayablePeer.fDisplayable.fCommands.clone();
		} else {
			allCommands = new FastVector();
		}

		/* Try to set all screen commands to the command component. */
		int[] types = new int[] {Command.SCREEN, Command.OK, Command.CANCEL};
		FastVector screenCommands = fDisplayablePeer.fDisplayable.getSortedCommands(allCommands, types);

		int lastIndex = -1;
		if (fCommandComponent != null) lastIndex = fCommandComponent.setCommands(screenCommands);

		/* Remove screen commands that the command component will display. */
		for (int i = 0; i <= lastIndex; i++) {
			allCommands.removeElement(screenCommands.elementAt(i));
		}
		/* ItemCommands to be set to the MenuBar */
		FastVector itemCommands = null;
		if (fItemMenuItem == null || fItemMenuItem.fItem.fCommands == null) {
			itemCommands = new FastVector();
		} else {
			if (fItemMenuItem != null) itemCommands = fItemMenuItem.fItem.fCommands.clone();
		}
		/* Setting the remaining DisplayableCommands and ItemCommands to the MenuBar */
		fMenuBarComponent.setCommands(allCommands, itemCommands);

		if (menuShowing != fMenuBarComponent.isShown()) {
			fDisplayablePeer.scheduleUpdate(DisplayablePeer.LAYOUT_CHANGED);
			return;
		}
		if (fCommandComponent != null) {
			if (commandBarShowing == fCommandComponent.isShown()) {
				// layout is the same but buttons may have changed
				if (commandBarShowing) {
					fCommandComponent.layout();
					fCommandComponent.repaint();
				}
			} else {
				// layout changed
				fDisplayablePeer.scheduleUpdate(DisplayablePeer.LAYOUT_CHANGED);
			}
		}
	}
}
