package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2004, 2005  All Rights Reserved
 */

class DisplayableCommandComponent extends CommandComponent {

	DisplayablePeer fDisplayablePeer;

	DisplayableCommandComponent(DisplayablePeer peer) {
		super(peer);
		fDisplayablePeer = peer;
		fWidth = peer.fWidth;
		fLayoutData = Item.LAYOUT_2 | Item.LAYOUT_EXPAND | Item.LAYOUT_SHRINK
			| Item.LAYOUT_NEWLINE_BEFORE;
	}

	void dispose() {
		super.dispose();

		if (fDisplayablePeer.fFocusComponent == this) {
			fDisplayablePeer.fFocusComponent = null;
		}
	}

	public void dispatchCommand(CommandButton button) {
		fDisplayablePeer.dispatchCommand(button.fCommand);
	}

	boolean isShowing() {
		return fVisibleCommandCount > 0;
	}

	boolean traverseDown() {
		if (fSelectedButtonIndex >= 0) {
			((PushButton) fComponents.elementAt(fSelectedButtonIndex)).fHighlighted = true;
		}
		return true; /* keep focus as displayable commands are at the bottom of the screen */
	}

	int getType() {
		return Item.TYPE_DISPLAYABLECOMMAND;
	}

	void paint(Graphics g) {
		g.setColor(DisplayPeer.COLOR_MENU_BACKGROUND_RGB);
		g.fillRect(0, 0, fWidth, fHeight);
		g.setColor(DisplayPeer.COLOR_MENU_SHADOW_RGB);
		g.drawLine(0, 0, fWidth, 0);
		super.paint(g);
	}

	CommandButton createButton(Composite parent, String text, Command command) {
		return new PushButton(parent, text, command);
	}
}
