package javax.microedition.lcdui;

import com.ibm.ive.midp.*;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2006  All Rights Reserved
 */

class LabelComponent extends Component {

	static final int BORDER_HEIGHT = gBorder.getHeight(Item.TYPE_STRING);
	static final int TOTAL_BORDER_HEIGHT = 2 * BORDER_HEIGHT;
	static final int BORDER_WIDTH = gBorder.getWidth(Item.TYPE_STRING);
	static final int TOTAL_BORDER_WIDTH = 2 * BORDER_WIDTH;

	static final int MARGIN_HEIGHT = 2;

	boolean fInvalidParsedStrings = false;

	// Cache variables used for Item dimension calls
	// These are calculated values stored in the cache
	int fTotalMarginHeight;

	int fMinContentWidth;
	int fCachedWidth;
	int fCachedHeight;
	int fLineHeight;
	TextComponent fTextComponent;
	static final Font BOLD_FONT = Font.getFont(Font.FACE_SYSTEM, Font.STYLE_BOLD, Font.SIZE_MEDIUM);

	LabelComponent(Composite parent, String text) {
		super(parent);
		fTextComponent = new TextComponent(Item.TYPE_LABEL, BOLD_FONT);
		fLineHeight =  BOLD_FONT._getHeight();
		setText(text);
	}

	/**
	 * Return the minimum height for the displayed String.
	 * @return int The line height in pixels
	 */
	int getMinimumHeight() {
		return fTextComponent.getNumberOfLines(getPreferredWidth() - TOTAL_BORDER_WIDTH, Item.TYPE_LABEL, false) * getDrawnRowHeight() + TOTAL_BORDER_HEIGHT;
	}

	/**
	 * Return the minimum width for the displayed String.
	 * @return int The line width in pixels
	 */
	int getMinimumWidth() {
		if (fMinContentWidth == -1) {
			int maxDisplayableWidth = Device.getDisplayWidth();
			if (fTextComponent.fStrippedText == null) {
				fMinContentWidth = 0;
			} else if (fTextComponent.fStrippedText.indexOf("\n") != -1) { //$NON-NLS-1$
				fMinContentWidth = maxDisplayableWidth;
			} else {
				fMinContentWidth = BOLD_FONT.getStringWidth(fTextComponent.fStrippedText) + TOTAL_BORDER_WIDTH;
				if (fMinContentWidth > maxDisplayableWidth) fMinContentWidth = maxDisplayableWidth;
			}
		}

		return fMinContentWidth;
	}

	public void setText(String text) {
		fTextComponent.setText(text, true);
		fMinContentWidth = -1;
		fTotalMarginHeight = -1;
		fInvalidParsedStrings = true;
		fHeight = getMinimumHeight();
		fWidth = getMinimumWidth();
		addText();
	}

	void sizeChanged(int w, int h) {
		if (w != fCachedWidth || h != fCachedHeight) {
			fInvalidParsedStrings = true;
			fCachedWidth = w;
			fCachedHeight = h;
		}
		fWidth = Math.min(fWidth, w);
		addText();
	}

	void addText() {
		if (fInvalidParsedStrings) {
			fInvalidParsedStrings = false;
			int lineWidth = fWidth - TOTAL_BORDER_WIDTH;
			int maxDisplayableRows = (fHeight - fTotalMarginHeight - TOTAL_BORDER_HEIGHT) / fLineHeight;
			fTextComponent.parse(fWidth, lineWidth, maxDisplayableRows, false);
		}
	}

	/**
	 * Paint the text of the StringItem
	 * @param Graphics g The Graphics component on which to draw the text
	 */
	protected void paint(Graphics g) {
		int xOffset = BORDER_WIDTH;
		int yOffset = BORDER_HEIGHT;
		int anchor = 0;

		g.setFont(BOLD_FONT);
		g.setColor(DisplayPeer.COLOR_DISPLAYABLE_BACKGROUND_RGB);
		g.fillRect(0, 0, fWidth, fHeight);
		g.setColor(DisplayPeer.COLOR_FOREGROUND_RGB);

		if (fTextComponent.fFormattedTextLength == 1) yOffset = BORDER_HEIGHT + (fHeight - fLineHeight - TOTAL_BORDER_HEIGHT) / 2;

		for (int i = 0; i < fTextComponent.fFormattedTextLength; i++) {
			g.drawStringWithTabExpansion(fTextComponent.fFormattedText[i], xOffset, yOffset, anchor);
			yOffset += fLineHeight + MARGIN_HEIGHT;
		}
	}

	boolean traverse(int direction, int viewWidth, int viewHeight, int[] visibleRectangle, int x, int y) {
		if (visibleRectangle[2] < viewWidth || visibleRectangle[3] < viewHeight) {
			visibleRectangle[0] = 0;
			visibleRectangle[1] = 0;
			visibleRectangle[2] = viewWidth;
			visibleRectangle[3] = viewHeight;
			return true;
		}
		return false;
	}

	int getDrawnRowHeight() {
		if (fTotalMarginHeight == -1) fTotalMarginHeight = MARGIN_HEIGHT;
		return fLineHeight + fTotalMarginHeight;
	}
}
