package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

import com.ibm.ive.midp.*;

public class List extends Screen implements Choice {

	public static final Command SELECT_COMMAND = new Command("", Command.SCREEN, 0); //$NON-NLS-1$

	ChoiceImpl fChoice;
	private Command fSelectCommand = SELECT_COMMAND;

	public List(String title, int listType) {
		super(title);

		// Make sure that list type is one of the three valid options
		if ((listType != Choice.EXCLUSIVE) && (listType != Choice.MULTIPLE) && (listType != Choice.IMPLICIT) ) {
		    throw new IllegalArgumentException();
		}

		fChoice = new ChoiceImpl(listType);
	}

	List(String title) {
		super(title);
	}

	public List(String title, int type, String[] strings, Image[] images) {
		this(title, type);

		fChoice.setContents(strings, images);
	}

	public int append(String string, Image image) {
		synchronized (Device.gDisplayableLock) {
			return fChoice.append(string, image);
		}
	}

	public void delete(int index) {
		synchronized (Device.gDisplayableLock) {
			fChoice.delete(index);
		}
	}

	public void deleteAll() {
		synchronized (Device.gDisplayableLock) {
			fChoice.deleteAll();
		}
	}

	public int getFitPolicy() {
		synchronized (Device.gDisplayableLock) {
			return fChoice.getFitPolicy();
		}
	}

	public Font getFont(int index) {
		synchronized (Device.gDisplayableLock) {
			return fChoice.getFont(index);
		}
	}

	public Image getImage(int elementIndex) {
		synchronized (Device.gDisplayableLock) {
			return fChoice.getImage(elementIndex);
		}
	}

	public int getSelectedFlags(boolean[] selectedElementsToQuery) {
		synchronized (Device.gDisplayableLock) {
			return fChoice.getSelectedFlags(selectedElementsToQuery);
		}
	}

	public int getSelectedIndex() {
		synchronized (Device.gDisplayableLock) {
			return fChoice.getSelectedIndex();
		}
	}

	public String getString(int index) {
		synchronized (Device.gDisplayableLock) {
			return fChoice.getString(index);
		}
	}

	public void insert(int index, String string, Image image) {
		synchronized (Device.gDisplayableLock) {
			fChoice.insert(index, string, image);
		}
	}

	public boolean isSelected(int index) {
		synchronized (Device.gDisplayableLock) {
			return fChoice.isSelected(index);
		}
	}

	public void removeCommand(Command command) {
		synchronized (Device.gDisplayableLock) {
			// The current select command is removed then the
			// default select command should be used instead
			if (command == fSelectCommand) {
				fSelectCommand = SELECT_COMMAND;
			}

			super.removeCommand(command);
		}
	}

	public void set(int index, String string, Image image) {
		synchronized (Device.gDisplayableLock) {
			fChoice.set(index, string, image);
		}
	}

	public void setFitPolicy(int policy) {
		synchronized (Device.gDisplayableLock) {
			fChoice.setFitPolicy(policy);
		}
	}

	public void setFont(int index, Font font) {
		synchronized (Device.gDisplayableLock) {
			fChoice.setFont(index,font);
		}
	}

	public void setSelectCommand(Command command) {
		synchronized (Device.gDisplayableLock) {
			// This method is only valid for IMPLICIT lists
			if (fChoice.fType != Choice.IMPLICIT) return;

			if (command != null && command != SELECT_COMMAND) {
				// It is ok to not check that the command has already been
				// added since addCommand will do nothing if a command is added
				// twice
				addCommand(command);
			}
			fSelectCommand = command;
		}
	}

	public void setSelectedFlags(boolean[] selectedArrayToSet) {
		synchronized (Device.gDisplayableLock) {
			fChoice.setSelectedFlags(selectedArrayToSet);
		}
	}

	public void setSelectedIndex(int index, boolean isSelected) {
		synchronized (Device.gDisplayableLock) {
			fChoice.setSelectedIndex(index, isSelected);
		}
	}

	public int size() {
		synchronized (Device.gDisplayableLock) {
			return fChoice.size();
		}
	}

	int getDisplayableType() {
		return TYPE_LIST;
	}

	void fireSelectCommand() {
		if (fSelectCommand != null) sendCommand(fSelectCommand);
	}

	void setPeer(IChoicePeer peer) {
		fChoice.fPeer = peer;
	}

	int getType() {
		return fChoice.fType;
	}

	void updateSelectionIndex(int newIndex) {
		fChoice.updateSelectionIndex(newIndex);
	}

	void updateSelectionList(int index, boolean selection) {
		fChoice.updateSelectionList(index, selection);
	}
}
