package javax.microedition.lcdui;

import java.io.IOException;
import javax.microedition.midlet.*;
import com.ibm.ive.midp.IAppManager;
import com.ibm.ive.midp.IMIDletAccessor;
import com.ibm.ive.midp.MidpMsg;
import com.ibm.ive.midp.util.*;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2005  All Rights Reserved
 */

class MIDletSuite extends MIDlet implements CommandListener {

	private IAppManager fAppManager;
	private List fMIDletList;
	private Command fExit;

	public MIDletSuite(IAppManager appManager) {
		super();
		if (!com.ibm.oti.vm.VM.callerIsBootstrap()) throw new SecurityException();
		fAppManager = appManager;

		fMIDletList = new List("MIDletSuite", Choice.IMPLICIT); //$NON-NLS-1$
		String[] midlets = MIDletManager.getMIDletNames();
		String[] icons = MIDletManager.getMIDletIconNames();
		for (int i = 0; i < midlets.length; i++) {
			Image image = null;
			if (icons[i] != null) {
				try {
					image = Image.createImage(icons[i]);
				} catch (IOException e) {
				}
			}
			fMIDletList.append(midlets[i], image);
		}

		// Select the first midlet by default if at least one midlet exists
		if (midlets.length > 0) fMIDletList.setSelectedIndex(0, true);

		fMIDletList.setCommandListener(this);
		fExit = new Command(MidpMsg.getString("Displayable.ExitCommand"), Command.SCREEN, 0); //$NON-NLS-1$
		fMIDletList.addCommand(fExit);

		IMIDletAccessor accessor = MIDletManager.getAccessor(this);
		accessor.setMidletIndex(midlets.length); // midletNames.length+1 is used by PushRegistryAlarmMIDlet
	}

	protected void destroyApp(boolean flag) throws MIDletStateChangeException {
	}

	protected void pauseApp() {
	}

	protected void startApp() throws MIDletStateChangeException {
		Display.getDisplay(this).setCurrent(fMIDletList);
	}

	public void commandAction(Command aCommand, Displayable aDisplayable) {
		if (!com.ibm.oti.vm.VM.callerIsBootstrap()) throw new SecurityException();

		if (aCommand == List.SELECT_COMMAND) {
			launch();
		} else if (aCommand == fExit) {
			notifyDestroyed();
		}
	}

	private void launch() {
		fAppManager.launch(fMIDletList.getSelectedIndex());
	}
}
