package javax.microedition.lcdui;

import com.ibm.ive.midp.*;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2006  All Rights Reserved
 */

/*
 * A List for verifying user controllable permissions.
 */

class PermissionDialog {

	/**
	 * Open the dialog and run the event loop.  Display
	 * the message followed by the choices.  The dialog
	 * closes only when the user selects one of the choices.
	 *
	 * @return the selected index, or the defaultIndex if an error occurred.
	 */
	static synchronized int open(String message, String[] choices, int defaultIndex) {
		if (!com.ibm.oti.vm.VM.callerIsBootstrap()) throw new SecurityException();

		PermissionForm form = new PermissionForm(message, choices, defaultIndex);

		Display display = Display.gCurrentDisplay;
		boolean createDisplay = Display.gCurrentDisplay == null;
		if (createDisplay) display = new Display(null);

		Displayable currentDisplayable = display.fCurrent;
		if (currentDisplayable == null) currentDisplayable = new Form(""); //$NON-NLS-1$

		if (Device.gUiThread == Thread.currentThread()) {
			display.setCurrentImpl(form);
			while (form.fRunning) {
				Device.dispatchSerialRunnable(true, false);
				Device.readAndDispatch();
			}
		} else if (Device.gSerialThread == Thread.currentThread()) {
			display.setCurrentImpl(form);
			while (form.fRunning) {
				Device.dispatchSerialRunnable(false, false);
			}

			if (!Device.gRunning) return defaultIndex;
		} else {
			if (display.fPeer == null) return defaultIndex;
			display.setCurrentImpl(form);
			while (!form._isShown()) Thread.yield();
			synchronized (display.fLock) {
				synchronized (form) {
					try {
						form.wait();
					} catch (InterruptedException e) {
						e.printStackTrace();
					}
				}
			}
		}

		if (createDisplay) {
			display.dispose();
		} else {
			display.setCurrentImpl(currentDisplayable);
		}

		return form.getSelection();
	}
}
