package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2005  All Rights Reserved
 */

class SpacerPeer extends Component {

	Spacer fSpacer;

	SpacerPeer(Composite parent, Spacer spacer) {
		super(parent);
		fSpacer = spacer;
		fSpacer.fPeer = this;
	}

	void setMinimumSize(int width, int height) {
		ItemComponent c = (ItemComponent) fParent;
		int maxWidth = c.getMaxContentWidth();
		int maxHeight = c.getMaxContentHeight();
		if (width > maxWidth) fSpacer.fMinWidth = maxWidth;
		if (height > maxHeight) fSpacer.fMinHeight = maxHeight;
		invalidate();
	}

	void paint(Graphics g) {
		g.setColor(DisplayPeer.COLOR_DISPLAYABLE_BACKGROUND_RGB);
		g.fillRect(0, 0, fWidth, fHeight);
	}

	int getMinimumHeight() {
		return fSpacer.fMinHeight;
	}

	int getMinimumWidth() {
		return fSpacer.fMinWidth;
	}

	boolean isEditable() {
		return false;
	}
}
