package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

import com.ibm.ive.midp.*;

/**
 * A <code>StringItem</code> is an <code>Item</code> subclass
 * that contains a <code>String</code>.
 **/
public class StringItem extends Item {

	String fText;
	int fAppearanceMode;
	Font fFont;

	StringItemPeer fPeer;

	public StringItem(String label, String content) {
		super(label);
		fText = content;
		fAppearanceMode = PLAIN;
	}

	public StringItem(String label, String content, int appearance) {
		super(label);

		checkAppearanceMode(appearance);
		fText = content;
		fAppearanceMode = appearance;
	}

	public String getText() {
		synchronized (Device.gDisplayableLock) {
			return fText;
		}
	}

	public void setText(String content) {
		synchronized (Device.gDisplayableLock) {
			// exit if nothing has changed
			if ((fText == null && content == null) || (fText != null && fText.equals(content))) return;

			fText = content;

			// Keep peer in sync with text changes
			if (fPeer != null) fPeer.setText(content);
		}
	}

	public int getAppearanceMode() {
		synchronized (Device.gDisplayableLock) {
			return fAppearanceMode;
		}
	}

	public Font getFont() {
		synchronized (Device.gDisplayableLock) {
			return _getFont();
		}
	}

	Font _getFont() {
		if (fFont == null) return Font.getFont(Font.FONT_STATIC_TEXT);
		return fFont;
	}

	public void setFont(Font font) {
		synchronized (Device.gDisplayableLock) {
			if (fFont == font) return;
			fFont = font;
			// Keep peer in sync with font changes
			if (fPeer != null) fPeer.setFont(font);
		}
	}

	int getType() {
		return TYPE_STRING;
	}

	int getHAlignment() {
		if ((fLayout & Item.LAYOUT_2) != 0) {
			return super.getHAlignment();
		} else {
			return Item.LAYOUT_LEFT;
		}
	}

	ItemComponent getItemComponent() {
		if (fPeer == null) return null;
		return (ItemComponent) fPeer.fParent;
	}
}
