package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2005, 2006 All Rights Reserved
 */

class TextComponent  {

	static final int DEFAULT_TEXT_STORE_SIZE = 4;
	static final int INDENT = 15;

	int fFormattedTextLength;
	String[] fFormattedText = new String[DEFAULT_TEXT_STORE_SIZE];
	String fStrippedText; // Text with appropriate leading \n removed
	int fItemType;
	Font fFont;

	TextComponent(int type, Font font) {
		fItemType = type;
		fFont = font;
	}

	void addString(String str) {
		if (fFormattedTextLength == fFormattedText.length) {
			String[] newArray = new String[fFormattedText.length * 2];
			System.arraycopy(fFormattedText, 0, newArray, 0, fFormattedText.length);
			fFormattedText = newArray;
		}
		fFormattedText[fFormattedTextLength] = str;
		fFormattedTextLength++;
	}

	void parse(int componentWidth, int width, int maxDisplayableRow, boolean hasIndicator) {
		int index = 0;
		int rowCount = 0;
		int lineWidth = width;
		fFormattedText = new String[DEFAULT_TEXT_STORE_SIZE];
		fFormattedTextLength = 0;
		int indentedWidth = width - INDENT;

		if (fStrippedText == null || fStrippedText.length() == 0) return;

		char[] textArray = fStrippedText.toCharArray();
		int wrapIndex;
		while (true) {
			if (fItemType == Item.TYPE_CHOICEGROUP) {
				lineWidth =  hasIndicator || fFormattedTextLength == 0 ? width : indentedWidth;
				// provide for margin as done while painting
				lineWidth -= ChoiceComponent.H_MARGIN;
			}

			wrapIndex = fFont.getCharsInLine(textArray, index, lineWidth);
			if (fItemType == Item.TYPE_CHOICEGROUP){
				if (wrapIndex == -1) break;
			} else {
				if (wrapIndex == -1 || rowCount > maxDisplayableRow) break;
			}
			rowCount++;
			String text = String.valueOf(textArray, index, textArray[index + wrapIndex - 1] == '\n' ? wrapIndex - 1 : wrapIndex);

			// Need to form elipses here
			if (fItemType != Item.TYPE_CHOICEGROUP && rowCount == maxDisplayableRow) text = Widget.format(text, componentWidth, fFont);
			index += wrapIndex;
			addString(text);
		}
	}

	void setText(String text, boolean stripNewLines) {
		fStrippedText = stripNewLines ? Component.stripNewlines(text) : text;
	}

	int getNumberOfLines(int width, int appearanceMode, boolean interactive) {
		if (fStrippedText == null || fStrippedText.length() == 0) return 0;

		// For StringItem types
		if (appearanceMode == Item.BUTTON || (appearanceMode == Item.PLAIN && interactive)) {
			return 1;
		}
		return fFont.getNumberOfLines(fStrippedText, width);
	}
}
