package javax.microedition.lcdui;

import com.ibm.ive.midp.*;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

public class TextField extends Item {

	/*
	 * Restrictive constraints reside in the low
	 * order 16 bits of the constraint value.
	 */

	public static final int ANY = 0;
	public static final int EMAILADDR = 1;
	public static final int NUMERIC = 2;
	public static final int PHONENUMBER = 3;
	public static final int URL = 4;

	public static final int DECIMAL = 5;
	public static final int PASSWORD = 0x10000;

	/** Mask for determining the current constraints. */
	public static final int CONSTRAINT_MASK = 0xFFFF;

	public static final int INITIAL_CAPS_SENTENCE = 0x200000;

	public static final int INITIAL_CAPS_WORD = 0x100000;

	public static final int NON_PREDICTIVE = 0x80000;

	public static final int SENSITIVE = 0x40000;

	public static final int UNEDITABLE = 0x20000;

	TextImpl fText;

	public TextField(String label, String text, int maxSize, int constraints) {
		super(label);

		fText = new TextImpl(text, maxSize, constraints);
	}

	public void delete(int offset, int length) {
		synchronized (Device.gDisplayableLock) {
			fText.delete(offset, length);
		}
	}

	public int getCaretPosition() {
		synchronized (Device.gDisplayableLock) {
			return fText.getCaretPosition();
		}
	}

	public int getChars(char[] chars) {
		synchronized (Device.gDisplayableLock) {
			return fText.getChars(chars);
		}
	}

	public int getConstraints() {
		synchronized (Device.gDisplayableLock) {
			return fText.getConstraints();
		}
	}

	public int getMaxSize() {
		synchronized (Device.gDisplayableLock) {
			return fText.getMaxSize();
		}
	}

	public String getString() {
		synchronized (Device.gDisplayableLock) {
			return fText.getString();
		}
	}

	public void insert(char[] chars, int offset, int length, int position) {
		synchronized (Device.gDisplayableLock) {
			fText.insert(chars, offset, length, position);
		}
	}

	public void insert(String text, int position) {
		synchronized (Device.gDisplayableLock) {
			fText.insert(text, position);
		}
	}

	public void setChars(char[] chars, int offset, int length) {
		synchronized (Device.gDisplayableLock) {
			fText.setChars(chars, offset, length);
		}
	}

	public void setConstraints(int constraints) {
		synchronized (Device.gDisplayableLock) {
			fText.setConstraints(constraints);
		}
	}

	public void setInitialInputMode(String characterSubset) {
		synchronized (Device.gDisplayableLock) {
			fText.setInitialInputMode(characterSubset);
		}
	}

	public int setMaxSize(int size) {
		synchronized (Device.gDisplayableLock) {
			return fText.setMaxSize(size);
		}
	}

	public void setString(String text) {
		synchronized (Device.gDisplayableLock) {
			fText.setString(text);
		}
	}

	public int size() {
		synchronized (Device.gDisplayableLock) {
			return fText.size();
		}
	}

	int getType() {
		return TYPE_TEXTFIELD;
	}

	int getHAlignment() {
		if ((fLayout & Item.LAYOUT_2) != 0) {
			return super.getHAlignment();
		} else {
			return Item.LAYOUT_LEFT;
		}
	}

	ItemComponent getItemComponent() {
		if (fText.fPeer == null) return null;
		return (ItemComponent) fText.fPeer.fParent;
	}
}
