package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2003, 2005  All Rights Reserved
 */

class TickerPeer extends Component implements Runnable {

	static final int V_PADDING = 2;
	static final int SCROLL_INCREMENT = 5;

	static final int TOTAL_V_PADDING = 2 * V_PADDING;
	static final int TICKER_MIN_HEIGHT = Component.gFont.getHeight() + TOTAL_V_PADDING;

	int fThreshold;
	Ticker fTicker;
	Animator fAnimator;
	String fText;

	public TickerPeer(DisplayablePeer displayablePeer) {
		super(displayablePeer);
		update();
		fLayoutData |= Item.LAYOUT_2 | Item.LAYOUT_EXPAND | Item.LAYOUT_NEWLINE_AFTER;
	}

	/*
	 * Intended to be called only by Animator.
	 */
	public void run() {
		fTicker.fScrollOffset -= SCROLL_INCREMENT;
		if (fTicker.fScrollOffset < fThreshold) {
			fTicker.fScrollOffset = fWidth;
		}
		repaint();
	}

	private void computeThreshold() {
		fThreshold = -getTextWidth();
		if (fTicker.fScrollOffset == 0) fTicker.fScrollOffset = fWidth;
	}

	int getTextWidth() {
		return gFont.getStringWidth(fText);
	}

	void layout() {
		computeThreshold();
	}

	int getMinimumHeight() {
		return TICKER_MIN_HEIGHT;
	}

	int getMinimumWidth() {
		/* Unused. */
		return 0;
	}

	void paint(Graphics g) {
		g.setColor(DisplayPeer.COLOR_TICKER_BACKGROUND_RGB);
		g.fillRect(0, 0, fWidth, fHeight);
		g.setColor(DisplayPeer.COLOR_TICKER_FOREGROUND_RGB);
		g.setFont(gFont);
		g.drawStringWithTabExpansion(fText, fTicker.fScrollOffset, V_PADDING, 0);
	}

	void update() {
		DisplayablePeer peer = (DisplayablePeer) fParent;
		boolean isShown = fShown;
		boolean needToHide = peer.isFullScreenCanvasPeer() || peer.fDisplayable.fTicker == null;

		if (needToHide) {
			hide();
			deregister();
		} else {
			fTicker = getDisplayable().fTicker;
			fTicker.fPeer = this;
			fText = fTicker.getFormattedString();
			computeThreshold();
			if (fAnimator == null) {
				fAnimator = Animator.getAnimator(getDisplay());
				fAnimator.add(this);
			}
			show();
		}
		if (isShown != fShown) invalidate();
	}

	void deregister() {
		if (fTicker != null) fTicker.fPeer = null;
		if (fAnimator != null) fAnimator.remove(this);
		fTicker = null;
		fAnimator = null;
	}

	void dispose() {
		deregister();
		super.dispose();
	}
}
