package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

import com.ibm.ive.midp.*;

class TitleComponent extends Widget {

	static final int TITLE_MIN_HEIGHT = 0;

	TitleComponent(DisplayablePeer peer) {
		super(peer);
		setTitle(peer.fDisplayable.fTitle);
	}

	void setTitle(String title) {
		Device.asyncExec(new Runnable() {
			public void run() {
				DisplayablePeer displayablePeer = getDisplayablePeer();
				OS.SetWindowText(displayablePeer.getWindowHandle(), displayablePeer.fDisplayable.getDisplayReadyTitle());
			}
		});
	}

	void showNotify() {
		update();
	}

	public void update() {
		setTitle(getDisplayablePeer().fDisplayable.getDisplayReadyTitle());
	}
}
