package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

import com.ibm.ive.midp.*;
import com.ibm.oti.midlet.help.*;
import com.ibm.oti.security.midp.*;

class UserPermission extends UserPermissionAgent implements IMIDletPermissions{

	private String fMidletVendor;

	UserPermission(String midletVendor) {
		super();
		fMidletVendor = midletVendor;

		if (!com.ibm.oti.vm.VM.callerIsBootstrap()) {
			throw new SecurityException();
		}
	}

	/**
	 * @see com.ibm.oti.security.midp.UserPermissionAgent#checkPermission(String, String, int[], int)
	 */
	public int checkPermission(String suiteName, String permissionName, int[] allowedModes, int defaultMode) {

		// get the interaction mode the user wants to use (set on permission's page or with
		// this dialog)
		MidletSuiteId midletSuiteId = new MidletSuiteId(suiteName, fMidletVendor);
		String userInteraction = MidletLoader.getMetadataEntry(midletSuiteId, METADATA_CLASSNAME, permissionName);
		if (userInteraction != null) {
			switch (Integer.parseInt(userInteraction)) {
				case DENY:
					defaultMode = MODE_DENY_ALWAYS;
					break;

				case ONESHOT:
					defaultMode = MODE_GRANT_ONCE;
					break;

				case SESSION:
					defaultMode = MODE_GRANT_SESSION;
					break;

				case BLANKET:
					defaultMode = MODE_GRANT_ALWAYS;
					break;
			}
		}

		// user should never see a prompt when they have these selected
		if (defaultMode == MODE_GRANT_ALWAYS || defaultMode == MODE_DENY_ALWAYS) return defaultMode;

		// responses for the user to choose from
		String[] choices;
		// response pre-selected for the user (assume the first)
		int defaultSelection = 0;
		String question;
		int[] modes = allowedModes;

		if (PermissionMsg.getString(USER_PERMISSION_INTERACTION).equals("y")) { //$NON-NLS-1$
			// user can change the interaction mode, get the appropriate question
			question = PermissionMsg.getIndirectString(USER_PERMISSION_MSG + permissionName, new String[] {suiteName});
			// build responses the user can choose from based on changing the interaction
			// mode at the same time permission is granted or denied.
			choices = new String[allowedModes.length];
			for (int i = 0; i < allowedModes.length; i++) {
				switch (allowedModes[i]) {
					case MODE_DENY_ALWAYS:
						choices[i] = PermissionMsg.getString(USER_DENY_MSG);
						break;

					case MODE_DENY_ONCE:
						choices[i] = PermissionMsg.getString(USER_DENY_ONCE_MSG);
						break;

					case MODE_GRANT_ONCE:
						choices[i] = PermissionMsg.getString(USER_GRANT_ONCE_MSG);
						break;

					case MODE_DENY_SESSION:
						choices[i] = PermissionMsg.getString(USER_DENY_SESSION_MSG);
						break;

					case MODE_GRANT_SESSION:
						choices[i] = PermissionMsg.getString(USER_GRANT_SESSION_MSG);
						break;

					case MODE_GRANT_ALWAYS:
						choices[i] = PermissionMsg.getString(USER_BLANKET_MSG);
						break;

					default:
						// shouldn't happen
						break;
				}
				// preselect the default choice
				if (allowedModes[i] == defaultMode) defaultSelection = i;
			}
		} else {
			// can't alter the interaction mode, so the user can only choose between
			// grant or deny the permission
			choices = new String[] { PermissionMsg.getString(USER_YES_MSG), PermissionMsg.getString(USER_NO_MSG) };
			// convert the default mode to an interaction, and setup the
			// the modes that correspond to the yes, no answers (for passing
			// back the correct value.
			if (defaultMode == MODE_GRANT_SESSION || defaultMode == MODE_DENY_SESSION) {
				// get the question to grant/deny session permission
				question = PermissionMsg.getIndirectString(USER_SESSION_MSG + permissionName, new String[] {suiteName});
				// deny once isn't right here should be deny session.
				modes = new int[] { MODE_GRANT_SESSION, MODE_DENY_SESSION };
			} else if (defaultMode == MODE_DENY_ONCE || defaultMode == MODE_GRANT_ONCE) {
				// get the question to grant/deny one-time permission
				question = PermissionMsg.getIndirectString(USER_ONESHOT_MSG + permissionName, new String[] {suiteName});
				modes = new int[] { MODE_GRANT_ONCE, MODE_DENY_ONCE };
			} else {
				// make compiler happy
				question = ""; //$NON-NLS-1$
			}
		}

		int selected = PermissionDialog.open(question, choices, defaultSelection);

		return modes[selected];
	}
}
