package javax.microedition.lcdui;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2005  All Rights Reserved
 */

abstract class WindowContent extends Composite {

	WindowContent(Composite parent) {
		super(parent);
		fLayoutData |= Item.LAYOUT_2 | Item.LAYOUT_VSHRINK
			| Item.LAYOUT_VEXPAND | Item.LAYOUT_SHRINK
			| Item.LAYOUT_EXPAND | Item.LAYOUT_NEWLINE_BEFORE | Item.LAYOUT_NEWLINE_AFTER;
	}

	void updateItemValues() {
		/* This method is called by the deferred update mechanism. */
	}

	int getMinimumHeight() {
		//TODO - HACK
		return 20;
	}

	int getMinimumWidth() {
		//TODO - HACK
		return 20;
	}

	int getPreferredHeight() {
		return fParent.fHeight;
	}

	int getPreferredWidth() {
		return fParent.fWidth;
	}

	void resizeWithDeltas(int deltaX, int deltaY) {
		/* no-op */
	}

	void scrollTo(int scrollXLocation, int scrollYLocation) {
		/* no-op for ContentComponent. Overridden by Scrollable */
	}

	void createScrollBar() {
		/* no-op for ContentComponent. Overridden by Scrollable */
	}
}
