package javax.microedition.media.control;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

import javax.microedition.media.*;

/**
 * The VolumeControl is used to query or set the volume.
 * Volume values range from 0 (silence) to 100 (maximum).
 */
public interface VolumeControl extends Control {

	/**
	 * Return the volume level.
	 *
	 * @return The current volume level, or -1 if it has not been set.
	 */
	public int getLevel();

	/**
	 * Return indication if the volume is muted.
	 *
	 * @return Returns true if the volumem is muted, false if not.
	 */
	public boolean isMuted();

	/**
	 * Sets the volume level.
	 * Values are from 0 to 100.  If a number outside the range
	 * is passed in, the closest valid value will be used instead.
	 */
	public int setLevel(int level);

	/**
	 * Mutes or unmutes the volume.
	 *
	 * @param mute Use true to mute the volume, false to unmute the volume.
	 */
	public void setMute(boolean mute);

}
