package javax.microedition.midlet;

import com.ibm.ive.midp.*;
import com.ibm.ive.midp.util.*;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2002, 2005  All Rights Reserved
 */

class MIDletAccessor implements IMIDletAccessor {

	MIDlet fMidlet;

	MIDletAccessor(MIDlet midlet) {
		fMidlet = midlet;
		MIDletManager.addAccessor(midlet, this);
	}

	public void destroyApp(boolean unconditional) throws MIDletStateChangeException {
		if (Device.DEBUG_SERIAL_QUEUE) {
			if (Thread.currentThread() != Device.gSerialThread) throw new IllegalStateException();
		}
		fMidlet.destroyApp(unconditional);
	}

	public void pauseApp() {
		if (Device.DEBUG_SERIAL_QUEUE) {
			if (Thread.currentThread() != Device.gSerialThread) throw new IllegalStateException();
		}
		fMidlet.pauseApp();
	}

	public void startApp() throws MIDletStateChangeException {
		if (Device.DEBUG_SERIAL_QUEUE) {
//			if (Thread.currentThread() != Device.gSerialThread) throw new IllegalStateException();
		}
		fMidlet.startApp();
	}

	public int getState() {
		return fMidlet.fState;
	}

	public void setState(int state) {
		fMidlet.fState = state;
	}

	public int getMidletIndex() {
		return fMidlet.fId;
	}

	public void setMidletIndex(int id) {
		fMidlet.fId = id;
	}

	public void setAppManager(IAppManager manager) {
		fMidlet.fAppManager = manager;
	}

}
