package javax.microedition.rms;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2000, 2004  All Rights Reserved
 */

/**
 * This interface defines a record listener. Once registered with a
 * record store, a record listener gets notified by the RS when its records
 * are added/deleted/modified. All record listeners registered with a store
 * get removed when the store is closed.
 *
 * @author		OTI
 * @version		initial
 */
public interface RecordListener {

/**
 * 	This method is sent to the receiver when a new record is added to the RS
 *
 * @author		OTI
 * @version		initial
 *
 * @param 		recordStore 	RS that fired the event
 * @param 		recordId 		the record ID
 */
public void recordAdded(RecordStore recordStore,int recordId);

/**
 * 	This method is sent to the receiver when a record is modified
 *
 * @author		OTI
 * @version		initial
 *
 * @param 		recordStore		RS that fired the event
 * @param 		recordId		the record ID
 */
public void recordChanged(RecordStore recordStore,int recordId);

/**
 * 	This method is sent to the receiver when a record is deleted from the RS
 *
 * @author		OTI
 * @version		initial
 *
 * @param 		recordStore		RS that fired the event
 * @param 		recordId		the record ID
 */
public void recordDeleted(RecordStore recordStore,int recordId);
}
