
/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 1998, 2004  All Rights Reserved
 */

package com.ibm.oti.io;

import com.ibm.oti.util.BinarySearch;

abstract class CharacterConverterSimple extends CharacterConverter {
	private static final boolean useNative = com.ibm.oti.vm.VM.useNatives();

abstract String byteTable();
abstract String charKeys();
abstract String charValues();

private native int convertImpl(byte[] bytes, int offset, char[] chars, int charOffset, int total, String byteTable);

public int convert(byte[] bytes, int offset, char[] chars, int charOffset, int total) {
	if (useNative)
		return convertImpl(bytes, offset, chars, charOffset, total, byteTable());

	String byteTable = byteTable();
	for (int i=total; --i >= 0;) {
		byte value = bytes[offset++];
		// bytes are -128 to 127
		chars[charOffset++] = (char)(value < 0 ? byteTable.charAt(value+128) : value);
	}
	return offset;
}

private native byte[] convertImpl(char[] chars, int offset, int length, String charKeys, String charValues);

public byte[] convert(char[] chars, int offset, int length) {
	if (useNative)
		return convertImpl(chars, offset, length, charKeys(), charValues());

	byte[] bytes = new byte[length];
	int o1 = 0, end = offset+length;
	String charKeys = charKeys();
	String charValues = charValues();
	for (int i=offset; i<end; i++) {
		char ch = chars[i];
		if (ch <= 127) bytes[o1++] = (byte)ch;
		else {
			int result = BinarySearch.binarySearch(charKeys, ch);
			if (result >= 0) bytes[o1++] = (byte)charValues.charAt(result);
			else {
				if (ch >= 0xd800 && ch < 0xdc00 &&
					i + 1 < end && chars[i+1] >= 0xdc00
					&& chars[i+1] < 0xe000)
						i++;
				bytes[o1++] = (byte)'?';
			}
		}
	}
	if (o1 < bytes.length) {
		byte[] newBytes = new byte[o1];
		System.arraycopy(bytes, 0, newBytes, 0, o1);
		return newBytes;
	}
	return bytes;
}
}
