
/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2000, 2002  All Rights Reserved
 */

package com.ibm.oti.io;

import com.ibm.oti.util.BinarySearch;

class CharacterConverter_MS936 extends CharacterConverter_GBK {

public int countChars(byte[] value, int offset, int count) {
	if (count < 0) throw new StringIndexOutOfBoundsException();
	int length = offset + count, total = 0;
	while (offset < length) {
		int lead = value[offset++] & 0xff;
		if (lead >= 0x80) {
			if (offset < length) {
				offset++;
				total++;
			}
		} else total++;
	}
	return total;
}

public int convert(byte[] value, int offset, char[] chars, int charOffset, int total) {
	total += charOffset;
	String table;
	while (charOffset < total) {
		int lead = value[offset++] & 0xff;
		if (lead < 128) chars[charOffset++] = (char)lead;
		else {
			int index = value[offset++] & 0xff;
			if (lead < 0x81 || lead > 0xfe ||
				index < 0x40 || index > 0xfe || index == 0x7f)
			{
				chars[charOffset++] = 0xfffd;
			} else {
				if (index >= 0x7f) index--;
				index -= 0x40;
				if (lead >= lbSplit) {
					table = GBK_2;
					lead -= lbSplit;
				} else {
					table = GBK;
					lead -= 0x81;
				}
				index += lead * 190;
				char result;
				if (index == 7491) // a8 92
					chars[charOffset++] = 0x2295;
				else if (index < byteMapLength && (result = table.charAt(index)) != 0)
					chars[charOffset++] = result;
				else
					chars[charOffset++] = 0xfffd;
			}
		}
	}
	return offset;
}

public byte[] convert(char[] value, int offset, int count) {
	int total = 0;
	count += offset;
	for (int i=offset; i<count; i++) {
		char ch = value[i];
		if (ch < 128) total++;
		else total += 2;
	}
	int out = 0;
	String values = null;
	byte[] result = new byte[total];
	for (int i=offset; i<count; i++) {
		char ch = value[i];
		if (ch < 128) result[out++] = (byte)ch;
		else {
			int index;
			if (ch <= 0x9fa5) {
				if (ch == 0x2295) ch = 0x2641;
				else if (ch == 0x2641) ch = 0x2295;
				values = GBKValues;
				if (ch >= 0x4e00)
					index = 847 + (ch - 0x4e00);
				else
					index = BinarySearch.binarySearch(GBKKeys, ch);
			} else if (ch < 0xe000) index = -1;
			else if (ch <= 0xe864) {
				values = GBKValues2;
				index = ch - 0xe000;
			} else {
				values = GBKValues3;
				index = BinarySearch.binarySearch(GBKKeys2, ch);
			}
			if (index == -1) {
				result[out++] = '?';
			} else {
				int cp = values.charAt(index);
				byte high = (byte)(cp >> 8);
				if (high != 0) result[out++] = high;
				result[out++] = (byte)cp;
			}
		}
	}
	if (out < result.length) {
		byte[] correct = new byte[out];
		System.arraycopy(result, 0, correct, 0, out);
		result = correct;
	}
	return result;
}

}
