package com.ibm.oti.io;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2001, 2006  All Rights Reserved
 */

public class CharacterConverter_UNICODE extends CharacterConverter_UNICODELITTLE {

boolean bigEndian = true;

/* byte[] -> length */
private int countChars(byte[] value, int offset, int count, boolean[] endian) {
	if (count < 0) throw new StringIndexOutOfBoundsException();
	if (count < 2) return 0;
	if (readTag) {
		int tag = ((value[offset] & 0xff) << 8) + (value[offset+1] & 0xff);
		if (tag == 0xfeff) {
			endian[0] = true;
			return (count / 2) - 1;
		}
		if (tag == 0xfffe) {
			endian[0] = false;
			return (count / 2) - 1;
		}
		return -1;
	}
	return count / 2;
}

/* byte[] -> char[] + offset */
private int convert(byte[] value, int offset, char[] result, int charOffset, int total, boolean isBigEndian) {
	// Can't consume any bytes, it is unknown how many are available
	if (total == 0) return offset;
	if (readTag) {
		offset += 2;
		if (isModal) readTag = false;
	}
	int end = offset + (total << 1);
	if (isBigEndian) {
		for (int i=offset; i<end; i += 2)
			result[charOffset++] = (char)(((value[i] & 0xff) << 8) + (value[i+1] & 0xff));
	} else {
		for (int i=offset; i<end; i += 2)
			result[charOffset++] = (char)(((value[i+1] & 0xff) << 8) + (value[i] & 0xff));
	}
	return end;
}

public char[] convert(byte[] value, int offset, int length) {
	boolean[] endian = new boolean[1];
	int numChars = countChars(value, offset, length, endian);
	if (numChars == -1) {
		return new char[0];
	}
	char[] chars = new char[numChars];
	convert(value, offset, chars, 0, numChars, endian[0]);
	return chars;
}

/* byte[] -> length */
public int countChars(byte[] value, int offset, int count) {
	if (!isModal) throw new RuntimeException("IllegalStateException"); //$NON-NLS-1$
	boolean[] endian = new boolean[1];
	int numChars = countChars(value, offset, count, endian);
	bigEndian = endian[0];
	return numChars;
}

/* byte[] -> char[] + offset */
public int convert(byte[] value, int offset, char[] result, int charOffset, int total) {
	if (!isModal) throw new RuntimeException("IllegalStateException"); //$NON-NLS-1$
	return convert(value, offset, result, charOffset, total, bigEndian);
}

}

