package com.ibm.oti.io;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2001, 2006  All Rights Reserved
 */

public class CharacterConverter_UTF16 extends CharacterConverter_UNICODE {

/* char[] -> byte[] */
public byte[] convert(char[] value, int offset, int count) {
	int total = (count << 1) + (writeTag ? 2 : 0);
	byte[] result = new byte[total];
	int index = 0;
	if (writeTag) {
		result[index++] = (byte)0xfe;
		result[index++] = (byte)0xff;
		if (isModal) writeTag = false;
	}
	int end = offset + count;
	for (int i=offset; i<end; i++) {
		result[index++] = (byte)(value[i] >> 8);
		result[index++] = (byte)value[i];
	}
	return result;
}
}

