
/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 1998, 2006  All Rights Reserved
 */

package com.ibm.oti.io;

class CharacterConverter_UTF8 extends com.ibm.oti.io.CharacterConverter {

public int countChars(byte[] value, int offset, int count) {
	if (count < 0) throw new StringIndexOutOfBoundsException();
	int length = offset + count, total = 0;
	int o = offset;
	while (o < length) {
		int tag = value[o];
		if (tag >= 0) o++; // >= 0x80 is negative
		else if ((tag & 0xe0) == 0xc0) {
			if ((o + 1) < length) {
				if ((value[o+1] & 0xc0) == 0x80) o += 2;
				else return total == 0 ? -1 : total;
			} else break;
		} else if ((tag & 0xf0) == 0xe0) {
			if ((o + 2) < length) {
				if ((value[o+1] & 0xc0) == 0x80 &&
					(value[o+2] & 0xc0) == 0x80) o += 3;
				else return total == 0 ? -1 : total;
			} else break;
		} else if ((tag & 0xf8) == 0xf0) {
			if ((o + 3) < length) {
				if ((value[o+1] & 0xc0) == 0x80 &&
					(value[o+2] & 0xc0) == 0x80 &&
					(value[o+3] & 0xc0) == 0x80 &&
					(((((tag & 7) << 2) |
						((value[o+1] >> 4) & 3)) - 1) & 0x1f) < 0x10)
				{
					o += 4;
					total++;
				} else return total == 0 ? -1 : total;
			} else break;
		} else return total == 0 ? -1 : total;
		total++;
	}
	return total;
}

public int convert(byte[] value, int offset, char[] result, int charOffset, int total) {
	// Assumes countChars() has been called to count number of chars
	int end = charOffset + total;
	while (charOffset < end) {
		byte b = value[offset++];
		if (b >= 0) // >= 0x80 is negative
			result[charOffset++] = (char)b;
		else if ((b & 0xe0) == 0xc0)
			result[charOffset++] = (char)(((b & 0x1f) << 6) +
				(value[offset++] & 0x3f));
		else if ((b & 0xf0) == 0xe0)
			result[charOffset++] = (char)(((b & 0xf) << 12) +
				((value[offset++] & 0x3f) << 6) +
				(value[offset++] & 0x3f));
		else {
			result[charOffset++] = (char)(((((b & 7) << 2) +
				((value[offset] >> 4) & 3) - 1) << 6) +
				((value[offset++] & 0xf) << 2) +
				((value[offset] >> 4) & 3) + 0xd800);
			result[charOffset++] = (char)(((value[offset++] & 0xf) << 6) +
				(value[offset++] & 0x3f) + 0xdc00);
		}
	}
	return offset;
}

public byte[] convert(char[] value, int offset, int count) {
	int total = 0;
	for (int i=offset+count; --i >= offset;) {
		char ch = value[i];
		if (ch < 0x80) total++;
		else if (ch < 0x800) total += 2;
		else if (ch >= 0xdc00 && ch < 0xe000 && i > 0 &&
			value[i-1] >= 0xd800 && value[i-1] < 0xdc00)
		{
			i--;
			total += 4;
		} else total += 3;
	}
	byte[] result = new byte[total];
	int pos = result.length;
	for (int i=offset+count; --i >= offset;) {
		char ch = value[i];
		if (ch < 0x80) result[--pos] = (byte)ch;
		else if (ch < 0x800) {
			result[--pos] = (byte)(0x80 | (ch & 0x3f));
			result[--pos] = (byte)(0xc0 | (ch >> 6));
		} else if (ch >= 0xdc00 && ch < 0xe000 && i > 0 &&
			value[i-1] >= 0xd800 && value[i-1] < 0xdc00)
		{
			int temp = (value[i-1] & 0x3c0) + 0x40;
			result[--pos] = (byte)(0x80 | (ch & 0x3f));
			result[--pos] = (byte)(0x80 | ((ch >> 6) & 0xf) |
				((value[i-1] & 3) << 4));
			result[--pos] = (byte)(0x80 | ((value[i-1] >> 2) & 0xf) |
				((temp >> 2) & 0x30));
			result[--pos] = (byte)(0xf0 | (temp >> 8));
			i--;
		} else {
			result[--pos] = (byte)(0x80 | (ch & 0x3f));
			result[--pos] = (byte)(0x80 | ((ch >> 6) & 0x3f));
			result[--pos] = (byte)(0xe0 | (ch >> 12));
		}
	}
	return result;
}

}
