//////////////////////////////////////////////////////////////////////////////
//
// Minimal
// Copyright 2004 by Thierry Tremblay
//
// Minimal Sample for PocketHAL
// For more info: http://www.droneship.com
//
//////////////////////////////////////////////////////////////////////////////

#include "minimal.h"
#include "../common/utility.h"



//////////////////////////////////////////////////////////////////////////////
//
// Declare the program's entry point
//
//////////////////////////////////////////////////////////////////////////////

PHAL_DECLARE_ENTRY_POINT( MinimalGame );



//////////////////////////////////////////////////////////////////////////////
//
// MinimalGame
//
//////////////////////////////////////////////////////////////////////////////

MinimalGame::MinimalGame()
{
    m_config.m_appName     = TEXT("Minimal");
    m_config.m_orientation = ORIENTATION_NORMAL;
}



bool MinimalGame::OnInitialize()
{
    if (!Game::OnInitialize())
        return false;

    m_currentColor = COLOR_BLACK;
    
    return true;
}



bool MinimalGame::OnGameLoop()
{
    Display* display = GetDisplay();

    if (display->BeginScene())
    {
        // Render one frame
        Clear( display->GetBackBuffer(), m_currentColor );
        DrawText( display->GetBackBuffer(), 0, 0, GetFPSString() );
        display->Swap();

        // Toggle between two colors
        if (m_currentColor != COLOR_GREEN)
            m_currentColor = COLOR_GREEN;
        else
            m_currentColor = COLOR_RED;
    }

    return Game::OnGameLoop();
}

