/* $Id: sdl_v.h 2704 2005-07-25 07:16:10Z tron $ */

#ifndef VIDEO_SDL_H
#define VIDEO_SDL_H

#include "../hal.h"

extern const HalVideoDriver _sdl_video_driver;

/* Borrowed from GAPI video for SDL 1.2.6 */
#define GX_FULLSCREEN   0x01        // for OpenDisplay()
#define GX_NORMALKEYS   0x02
#define GX_LANDSCAPEKEYS    0x03

struct GXKeyList {
    short vkUp;             // key for up
    POINT ptUp;             // x,y position of key/button.  Not on screen but in screen coordinates.
    short vkDown;
    POINT ptDown;
    short vkLeft;
    POINT ptLeft;
    short vkRight;
    POINT ptRight;
    short vkA;
    POINT ptA;
    short vkB;
    POINT ptB;
    short vkC;
    POINT ptC;
    short vkStart;
    POINT ptStart;
};

typedef int   (*PFNGXOpenInput)();
typedef int   (*PFNGXCloseInput)();
typedef struct GXKeyList (*PFNGXGetDefaultKeys)(int iOptions);

struct GapiFunc
{
    PFNGXOpenInput            GXOpenInput;
    PFNGXCloseInput           GXCloseInput;
    PFNGXGetDefaultKeys       GXGetDefaultKeys;
};

extern HMODULE GAPI_GetGapiLib(void);

struct GapiFunc gxFunc;
static HMODULE g_hGapiLib;

#define LINK(type,name,import) \
	if( g_hGapiLib ) \
		name = (PFN##type)GetProcAddress( g_hGapiLib, _T(import) ); 

#endif
