/*
 * Copyright (c) 2005 Christer Weinigel <christer@weinigel.se>
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies.  The author makes no representations about the suitability
 * of this software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 *
 * This file just contains definitions for a bunch of Windows CE APIs.
 * The constants are taken from different sources on the net, so this
 * file does not look very much like the real Windows include files.
 * Real windows applications will surely not work with this file, for
 * example the enums below are probably defines originally, so any
 * code depending on that will break.
 */

typedef int BOOL;
typedef void *LPVOID;
typedef unsigned short WORD;
typedef unsigned long DWORD;

typedef unsigned HANDLE;

/* Virtual */

enum VirtualTypes {
    MEM_COMMIT = 0x1000,
    MEM_RESERVE = 0x2000,
    MEM_DECOMMIT = 0x4000,
    MEM_RELEASE = 0x8000, 
};

enum VirtualProtection {
    PAGE_NOACCESS		= 0x01,            
    PAGE_READONLY		= 0x02,
    PAGE_READWRITE		= 0x04,  
    PAGE_EXECUTE		= 0x10,
    PAGE_EXECUTE_READ		= 0x20,
    PAGE_EXECUTE_READWRITE	= 0x40,
    PAGE_GUARD			= 0x100,          
    PAGE_NOCACHE		= 0x200,
    PAGE_PHYSICAL		= 0x400,
};

typedef struct _SYSTEMTIME { 
    WORD wYear; 
    WORD wMonth; 
    WORD wDayOfWeek; 
    WORD wDay; 
    WORD wHour; 
    WORD wMinute; 
    WORD wSecond; 
    WORD wMilliseconds; 
} SYSTEMTIME;

LPVOID VirtualAlloc(LPVOID lpAddress, DWORD dwSize, DWORD flAllocationType, DWORD flProtect);

BOOL VirtualCopy(LPVOID lpvDest, LPVOID lpvSrc, DWORD cbSize, DWORD fdwProtect);

BOOL VirtualFree(LPVOID lpAddress, DWORD dwSize, DWORD dwFreeType); 

typedef SYSTEMTIME *LPSYSTEMTIME;

DWORD GetTickCount(); 
void GetSystemTime(LPSYSTEMTIME lpSystemTime); 
void GetLocalTime(LPSYSTEMTIME lpSystemTime); 

static inline unsigned readl(LPVOID p) {
    return *((DWORD *)p);
}

static inline void writel(unsigned value, LPVOID p) {
    *((DWORD *)p) = value;
}

static inline unsigned readw(LPVOID p) {
    unsigned addr = (unsigned)p;
    DWORD v = *((DWORD *)(addr & ~3));
    return (addr & 2) ? (v >> 16) : (v & 0xffff);
}

/* Process and Thread Functions */

enum ThreadPriority {
    THREAD_PRIORITY_TIME_CRITICAL	= 0,
    THREAD_PRIORITY_HIGHEST		= 1,
    THREAD_PRIORITY_ABOVE_NORMAL	= 2,
    THREAD_PRIORITY_NORMAL		= 3,
    THREAD_PRIORITY_BELOW_NORMAL	= 4,
    THREAD_PRIORITY_LOWEST		= 5,
    THREAD_PRIORITY_ABOVE_IDLE		= 6,
    THREAD_PRIORITY_IDLE		= 7,
};

enum {
    NUM_SYS_HANDLES	= 32,
    SYS_HANDLE_BASE	= 64,
    SH_CURTHREAD	= 1,
};

BOOL SetThreadPriority(HANDLE hThread, int nPriority); 

BOOL CeSetThreadPriority(HANDLE hThread, int nPriority); 
BOOL CeSetThreadQuantum(HANDLE hThread, DWORD dwTime); 
BOOL SetKMode (BOOL fMode);

void Sleep(DWORD dwMilliseconds);

static inline HANDLE GetCurrentThread() {
    return (HANDLE)(SH_CURTHREAD+SYS_HANDLE_BASE);
}

/* Kernel Functions */

DWORD SetProcPermissions(DWORD newperms);

/* Misc */

DWORD GetLastError(void);

typedef unsigned long *PULONG;
LPVOID AllocPhysMem(DWORD cbSize, DWORD fdwProtect, DWORD dwAlignmentMask, DWORD dwFlags, PULONG pPhysicalAddress);

