#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

int main()
{
    char s[256];
    char *p, *start;
    int index;
    int value;
    int group;
    int num;

    while (fgets(s, sizeof(s), stdin)) {
	group = tolower(*s);
	if (group < 'a' || group > 'h') {
	    printf("invalid group\n");
	    continue;
	}

	start = s + 1;

	if (!isdigit(*start)) {
	    printf("bad index\n");
	    continue;
	}

	p = start;
	while (*p && !isspace(*p))
	    p++;
	if (*p)
	    *p++ = '\0';
	if (p == start) {
	    printf("bad index\n");
	    continue;
	}

	index = atoi(start);

	num = (group - 'a') * 32 + index;

	while (*p && isspace(*p))
	    p++;

	if (*p) {
	    start = p;
	    while (*p && !isspace(*p))
		p++;
	    if (*p)
		*p++ = '\0';
	    value = atoi(start);
	} else {
	    value = -1;
	}

	if (value == -1) {
	    printf("GET %c%d (%d)\n", group, index, num);
	    sprintf(s, "cat /sys/devices/platform/s3c2410-gpio.%d/val", num);
	} else {
	    printf("SET %c%d (%d) to %d\n", group, index, num, value);
	    sprintf(s, "echo %d >/sys/devices/platform/s3c2410-gpio.%d/val",
		    value ? 1 : 0, num);
	}
	system(s);
    }
	
    exit(0);
}

 
/*
  Local variables:
  compile-command: "make CROSS_COMPILE=/opt/crosstool/gcc-3.4.1-glibc-2.3.3/arm-9tdmi-linux-gnu/bin/arm-9tdmi-linux-gnu- -k "
  End:
*/

