#include <string.h>

#ifndef HD_PRINTF
#define HD_PRINTF printf
#endif

#ifndef HD_COLS
#define HD_COLS 8
#endif

static void hd_base(const char *label, unsigned base, void *buf, unsigned count)
{
    unsigned offset;
    unsigned n;
    unsigned i;
    int same;
    unsigned char *p = buf;

    offset = 0;
    same = 0;

    for (offset = 0; offset < count; offset += HD_COLS) {
	n = count - offset;
	if (n > HD_COLS)
	    n = HD_COLS;

	if (offset && n == HD_COLS && 
	    memcmp(p + offset - HD_COLS, p + offset, HD_COLS) == 0) {
            if (!same)
                printf("  ...  \n");

	    same++;
	    offset += HD_COLS;
	    continue;
	} else
            same = 0;

	printf("%08x  ", base + offset);

	for (i = 0; i < HD_COLS; i++) {
	    if (i && !(i & 7))
		printf("- ");

	    if (i < n)
		printf("%02x ", p[offset + i]);
	    else
		printf("   ");
	}

	putchar(' ');

	for (i = 0; i < n; i++) {
	    unsigned char c = p[offset + i];

	    if (c >= ' ' && c < 127)
		putchar(c);
	    else
		putchar('.');
	}

	putchar('\n');
        
        offset += n;
    }

    if (same)
	printf("%08x\n", base + offset);
}

static inline void hd(const char *label, void *buf, unsigned count)
{
    hd_base(label, 0, buf, count);
}
