/*
 * Copyright (c) 2005 Christer Weinigel <christer@weinigel.se>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This is just a test program that blinks the blue led on an Acer n30.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "winhack.h"

int main()
{
    DWORD base = 0x56000000;
    DWORD size = 0x10000;
    LPVOID mem;
    unsigned addr;
    unsigned value;
    unsigned offset = 0x0024;
    int i;

    printf("Blue\n");

    mem = VirtualAlloc(NULL, size, MEM_RESERVE, PAGE_NOACCESS);
    if (!mem) {
	printf("VirtualAlloc failed\n");
	exit(1);
    }

    if (!VirtualCopy(mem, (LPVOID)(base >> 8),  size, PAGE_READWRITE | PAGE_PHYSICAL | PAGE_NOCACHE)) {
	printf("VirtualCopy failed\n");
	VirtualFree(mem, 0, MEM_RELEASE);
	exit(1);
    }

    for (i = 0; i < 5; i++) {
	offset = 0x56000064 - base;
	addr = base + offset;

	value = readl(mem + offset);
	value ^= 0x0000040;
	writel(value, mem + offset);

	printf("0x%08x 0x%08x\n", addr, value);

	if (value & 0x40)
	    Sleep(1000);
	else
	    Sleep(3000);
    }

    VirtualFree(mem, 0, MEM_RELEASE);

    exit(0);
}
