/*
 * Copyright (c) 2005 Christer Weinigel <christer@weinigel.se>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "winhack.h"

#define WORDS (16*1024)

int main()
{
    LPVOID mem;
    unsigned base = 0x30201000;
    unsigned size = WORDS * sizeof(unsigned);
    int i;

    mem = VirtualAlloc(NULL, size, MEM_RESERVE, PAGE_NOACCESS);
    if (!mem) {
	printf("VirtualAlloc failed\n");
	exit(1);
    }

    if (!VirtualCopy(mem, (LPVOID)(base >> 8),  size, PAGE_READWRITE | PAGE_PHYSICAL | PAGE_NOCACHE)) {
	printf("VirtualCopy failed\n");
	VirtualFree(mem, 0, MEM_RELEASE);
	exit(1);
    }

    for (i = 0; i < WORDS; i++)
	printf("%08x\n", readl(mem + i * 4));

    exit(0);
}
