/*
 * Copyright (c) 2005 Christer Weinigel <christer@weinigel.se>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This is a program that dumps the specified registers.  It spends
 * three seconds in a loop reading each register and whenever the
 * register changes it prints out the new register contents.
 *
 * This is pretty good way to see what registers Windows CE is
 * modifying.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "winhack.h"

DWORD regs[] = {
    /* IO registers */

    /* interrupt controller */
    0x4a000000, 0x4a000004, 0x4a000008, 0x4a00000c, 
    0x4a000010, 0x4a000014, 0x4a000018, 0x4a00001c, 

    /* dma controller 0 */
    0x4b000000, 0x4b000004, 0x4b000008, 0x4b00000c, 
    0x4b000010, 0x4b000014, 0x4b000018, 0x4b00001c, 
    0x4b000020, 

    /* dma controller 1 */
    0x4b000040, 0x4b000044, 0x4b000048, 0x4b00004c, 
    0x4b000050, 0x4b000054, 0x4b000058, 0x4b00005c, 
    0x4b000060, 

    /* dma controller 2 */
    0x4b000080, 0x4b000084, 0x4b000088, 0x4b00008c, 
    0x4b000090, 0x4b000094, 0x4b000098, 0x4b00009c, 
    0x4b0000a0, 

    /* dma controller 3 */
    0x4b0000c0, 0x4b0000c4, 0x4b0000c8, 0x4b0000cc, 
    0x4b0000d0, 0x4b0000d4, 0x4b0000d8, 0x4b0000dc, 
    0x4b0000e0, 

    /* clock & power management */
    0x4c000000, 0x4c000004, 0x4c000008, 0x4c00000c, 
    0x4c000010, 0x4c000014, 

    /* lcd controller */
    0x4d000000, 0x4d000004, 0x4d000008, 0x4d00000c, 
    0x4d000010, 0x4d000014, 0x4d000018, 0x4d00001c, 
    0x4d000020, 0x4d000024, 0x4d000028, 

    0x4d00004c, 
    0x4d000050, 0x4d000054, 0x4d000058, 0x4d00005c, 
    0x4d000060, 

    /* uart 0 */
    0x50000000, 0x50000004, 0x50000008, 0x5000000c, 
    0x50000010, 0x50000014, 0x50000018, 0x5000001c, 
    0x50000020, 0x50000024, 0x50000028, 

    /* uart 1 */
    0x50004000, 0x50004004, 0x50004008, 0x5000400c, 
    0x50004010, 0x50004014, 0x50004018, 0x5000401c, 
    0x50004020, 0x50004024, 0x50004028, 

    /* uart 2 */
    0x50008000, 0x50008004, 0x50008008, 0x5000800c, 
    0x50008010, 0x50008014, 0x50008018, 0x5000801c, 
    0x50008020, 0x50008024, 0x50008028, 

    /* timer */
    0x51000000, 0x51000004, 0x51000008, 0x5100000c, 
    0x51000010, 0x51000014, 0x51000018, 0x5100001c, 
    0x51000020, 0x51000024, 0x51000028, 0x5100002c, 
    0x51000030, 0x51000034, 0x51000038, 0x5100003c, 
    0x51000040, 

    /* usb device */

    0x52000140, 0x52000144, 0x52000148, 
    0x52000158, 0x5200014c, 
    0x5200016c,
    0x52000170, 0x52000178, 
    0x52000180, 0x52000184, 0x52000188, 
    0x52000190, 0x52000194, 0x52000198, 0x5200019c,
    0x520001c0, 0x520001c4, 0x520001c8, 0x520001cc,
    0x520001d0, 
    0x52000200, 0x52000204, 0x52000208, 0x5200020c,
    0x52000210, 0x52000210, 0x52000218, 0x5200021c,
    0x52000220, 0x52000224, 0x52000228, 0x5200022c,
    0x52000240, 0x52000244, 0x52000248, 0x5200024c,
    0x52000260, 0x52000264, 0x52000268, 0x5200026c,

    /* watchdog */
    0x53000000, 0x53000004, 0x53000008, 

    /* iic */
    0x54000000, 0x54000004, 0x54000008, 0x5400000c, 

    /* iis */
    0x55000000, 0x55000004, 0x55000008, 0x5500000c, 
    0x55000010, 

    /* gpios */
    0x56000000, 0x56000004, 	/* Port A */
    0x56000010, 0x56000014, 0x56000018,	/* Port B */
    0x56000020, 0x56000024, 0x56000028,	/* Port C */
    0x56000030, 0x56000034, 0x56000038,	/* Port D */
    0x56000040, 0x56000044, 0x56000048,	/* Port E */
    0x56000050, 0x56000054, 0x56000058,	/* Port F */
    0x56000060, 0x56000064, 0x56000068,	/* Port G */
    0x56000070, 0x56000074, 0x56000078,	/* Port H */
    0x56000080,			/* Misc control register */
    0x56000084,			/* DCLK control */
    0x56000088,			/* ext int ctrl 0 */
    0x5600008c,			/* ext int ctrl 1 */
    0x56000090,			/* ext int ctrl 2 */
    0x5600009c,			/* ext int filter 2 */
    0x560000a0,			/* ext int filter 3 */
    0x560000a4,			/* ext int mask */
    0x560000ac,			/* external pin status */
    0x560000b0,			/* chip id */
    0x560000b4,			/* reset status */
    0x560000b8,			/* infrom 0 */
    0x560000bc,			/* infrom 1 */

    /* rtc */
    0x57000040, 0x57000044, 
    0x57000050, 0x57000054, 0x57000058, 0x5700005c,
    0x57000060, 0x57000064, 0x57000068, 0x5700006c,
    0x57000070, 0x57000074, 0x57000078, 0x5700007c,
    0x57000080, 0x57000084, 0x57000088, 

    /* adc */
    0x58000000, 0x58000004, 0x58000008, 0x5800000c, 
    0x58000010, 

    /* spi0  */
    0x59000000, 0x59000004, 0x59000008, 0x5900000c, 
    0x59000010, 0x59000014, 

    /* spi1  */
    0x59000020, 0x59000024, 0x59000028, 0x5900002c, 
    0x59000030, 0x59000034, 

    /* SD */
    0x5a000000, 0x5a000004, 0x5a000008, 0x5a00000c, 
    0x5a000010, 0x5a000014, 0x5a000018, 0x5a00001c, 
    0x5a000020, 0x5a000024, 0x5a000028, 0x5a00002c, 
    0x5a000030, 0x5a000034, 0x5a000038, 0x5a00003c, 
    0x5a000040, 
};

int main()
{
    DWORD base;
    DWORD size = 0x10000;
    LPVOID mem;
    unsigned t0;
    unsigned t;
    unsigned addr;
    unsigned last_value;
    unsigned value;
    unsigned offset = 0x0024;
    int i;
    int first;
    int duration = 1000;

    puts("Reading Registers...");

    for (i = 0; i < sizeof(regs) / sizeof(*regs); i++) {
	mem = VirtualAlloc(NULL, size, MEM_RESERVE, PAGE_NOACCESS);
	if (!mem) {
	    printf("VirtualAlloc failed\n");
	    exit(1);
	}

	base = regs[i] & ~(size-1);
	
	if (!VirtualCopy(mem, (LPVOID)(base >> 8),  size, PAGE_READWRITE | PAGE_PHYSICAL | PAGE_NOCACHE)) {
	    printf("VirtualCopy failed\n");
	    VirtualFree(mem, 0, MEM_RELEASE);
	    exit(1);
	}

	offset = regs[i] - base;
	addr = base + offset;

	t0 = GetTickCount();
	last_value = 0;
	first = 1;
	while (1) {
	    t = GetTickCount();
	    value = readl(mem + offset);
	    
	    if (first) {
		last_value = ~value;
		first = 0;
	    }
	    if (last_value != value) {
		printf("0x%08x %04d 0x%08x %d\n", addr, t - t0, value, first);
		last_value = value;
	    }

	    if (!duration || (t - t0) > duration)
		break;

	    Sleep(1);
	}

	VirtualFree(mem, 0, MEM_RELEASE);
    }

    exit(0);
}
