using System;
using System.Drawing;
using System.Collections;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace kfuncs
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			base.Dispose( disposing );
		}
		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.listBox1 = new System.Windows.Forms.ListBox();
			// 
			// listBox1
			// 
			this.listBox1.Size = new System.Drawing.Size(224, 184);
			// 
			// Form1
			// 
			this.ClientSize = new System.Drawing.Size(226, 343);
			this.Controls.Add(this.listBox1);
			this.MinimizeBox = false;
			this.Text = "Form1";
			this.Load += new System.EventHandler(this.Form1_Load);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>

		static void Main() 
		{
			Application.Run(new Form1());
		}

		private void Form1_Load(object sender, System.EventArgs e)
		{
			long creatTime, krnlTime, exitTime, userTime;
			bool ret = GetThreadTimes(GetCurrentThread(), out creatTime, out exitTime, out krnlTime, out userTime);
			DateTime dtCreate = DateTime.FromFileTime(creatTime);
			TimeSpan tsKernel = TimeSpan.FromTicks(krnlTime);
			DateTime dtExit = DateTime.FromFileTime(exitTime);
			TimeSpan tsUser = TimeSpan.FromTicks(userTime);
			listBox1.Items.Add(string.Format("Curr. Proc: {0:X}", GetCurrentProcess()));
			listBox1.Items.Add(string.Format("Curr. Thread: {0:X}", GetCurrentThread()));
			listBox1.Items.Add(string.Format("Curr. ProcID: {0:X}", GetCurrentProcessID()));
			listBox1.Items.Add(string.Format("Curr. ThreadID: {0:X}", GetCurrentThreadID()));
			listBox1.Items.Add(string.Format("Curr. Thread Prio: {0:X}", GetThreadPriority(GetCurrentThread())));
			listBox1.Items.Add(string.Format("Created: {0}", dtCreate));
			listBox1.Items.Add(string.Format("User time (sec): {0}", tsUser.TotalSeconds));
			listBox1.Items.Add(string.Format("Kernel time (sec): {0}", tsKernel.TotalSeconds));
		} 


		const int SYS_HANDLE_BASE	 = 64;
		const int SH_WIN32          = 0;
		const int SH_CURTHREAD      = 1;
		const int SH_CURPROC        = 2;
		const uint SYSHANDLE_OFFSET = 0x004;
		const uint PUserKDataARM = 0xFFFFC800;
		private System.Windows.Forms.ListBox listBox1;
		const uint PUserKDataX86 = 0x00005800;

		static int GetCurrentProcessID()
		{
			uint PUserKData = GetCPUArchitecture()==PROCESSOR_ARCHITECTURE.PROCESSOR_ARCHITECTURE_ARM? PUserKDataARM: PUserKDataX86;
			IntPtr pBase = new IntPtr((int) (PUserKData + SYSHANDLE_OFFSET));
			return Marshal.ReadInt32(pBase, SH_CURTHREAD * 4);
		}

		static int GetCurrentThreadID()
		{
			uint PUserKData = GetCPUArchitecture()==PROCESSOR_ARCHITECTURE.PROCESSOR_ARCHITECTURE_ARM? PUserKDataARM: PUserKDataX86;
			IntPtr pBase = new IntPtr((int) (PUserKData + SYSHANDLE_OFFSET));
			return Marshal.ReadInt32(pBase, SH_CURPROC * 4);
		}

		static IntPtr GetCurrentProcess()
		{
			return new IntPtr(SH_CURPROC + SYS_HANDLE_BASE);
		}

		static IntPtr GetCurrentThread()
		{
			return new IntPtr(SH_CURTHREAD + SYS_HANDLE_BASE);
		}

		public static PROCESSOR_ARCHITECTURE GetCPUArchitecture()
		{
			SYSTEM_INFO si = new SYSTEM_INFO();
			GetSystemInfo(ref si);
			return (PROCESSOR_ARCHITECTURE)si.wProcessorArchitecture;
		}

		public enum PROCESSOR_ARCHITECTURE
		{
			PROCESSOR_ARCHITECTURE_INTEL =0,
			PROCESSOR_ARCHITECTURE_MIPS  =1,
			PROCESSOR_ARCHITECTURE_ALPHA =2,
			PROCESSOR_ARCHITECTURE_PPC   =3,
			PROCESSOR_ARCHITECTURE_SHX   =4,
			PROCESSOR_ARCHITECTURE_ARM   =5,
			PROCESSOR_ARCHITECTURE_IA64  =6,
			PROCESSOR_ARCHITECTURE_ALPHA64 =7,
			PROCESSOR_ARCHITECTURE_UNKNOWN =0xFFFF,
		}
		[DllImport("Coredll")]		
		public static extern void GetSystemInfo( ref SYSTEM_INFO SystemInfo);

		[DllImport("Coredll")]		
		public static extern int GetThreadPriority( 
			IntPtr hThread);

		[DllImport("Coredll")]		
		public static extern bool GetThreadTimes (
			IntPtr hThread, 
			out long lpCreationTime, 
			out long lpExitTime, 
			out long lpKernelTime,
			out long lpUserTime);

	}
	public struct SYSTEM_INFO 
	{
		public ushort wProcessorArchitecture;
		public ushort wReserved;
		public uint dwPageSize;
		public int lpMinimumApplicationAddress;
		public int lpMaximumApplicationAddress;
		public uint dwActiveProcessorMask;
		public uint dwNumberOfProcessors;
		public uint dwProcessorType;
		public uint dwAllocationGranularity;
		public ushort wProcessorLevel;
		public ushort wProcessorRevision;
	}
}
