package jp.mobilehackerz.is01root;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.app.PendingIntent;
import android.appwidget.AppWidgetManager;
import android.content.ComponentName;
import android.widget.RemoteViews;

public class RootSwitchService extends Service {
	final public String MSG_CHANGE = "jp.mobilehackerz.is01root.CHANGE";
	final public String MSG_UPDATE = "jp.mobilehackerz.is01root.UPDATE";

	@Override
	public void onStart(Intent intent, int startId) {
		super.onStart(intent, startId);
 
		Intent buttonIntent = new Intent();
		buttonIntent.setAction(MSG_CHANGE);
		PendingIntent pendingIntent = PendingIntent.getService(this, 0, buttonIntent, 0);
		RemoteViews remoteViews = new RemoteViews(getPackageName(), R.layout.widget);
		remoteViews.setOnClickPendingIntent(R.id.ImageView01, pendingIntent);

		if (MSG_CHANGE.equals(intent.getAction())) {
			if (IS01root.isSuInstalledAndDisabled()) {
				IS01root.DoEnableSu();
			} else if (IS01root.isSuInstalledAndEnabled()) {
				IS01root.DoDisableSu();
			} else if (IS01root.isSuInstalled()) {
				IS01root.DoBootSh();
			}
		}

		// 表示更新
		int imgid;
		if (IS01root.isSuInstalledAndDisabled()) {
			imgid = R.drawable.widget_off;
		} else if (IS01root.isSuInstalledAndEnabled()) {
			imgid = R.drawable.widget_on;
		} else if (IS01root.isSuInstalled()) {
			imgid = R.drawable.widget_middle;
		} else {
			imgid = R.drawable.widget_blank;
		}
		remoteViews.setImageViewResource(R.id.ImageView01, imgid);
		//
		ComponentName thisWidget = new ComponentName(this, RootSwitchWidgetProvider.class);
		AppWidgetManager manager = AppWidgetManager.getInstance(this);
		manager.updateAppWidget(thisWidget, remoteViews);
	}

	@Override
	public IBinder onBind(Intent arg0) {
		return null;
	}

}
