/*
 * breaksuid & nandunlock for IS01 BB01.00.16
 * by goroh_kun(goroh.kun@gmail.com)
 */

#include <stdio.h>
#include <stdint.h>
#include <unistd.h>

typedef struct mapinfo mapinfo;

struct mapinfo {
    mapinfo *next;
    unsigned start;
    unsigned end;
    char perm[8];
    char name[1024];
};

// 6f000000-6f01e000 rwxp 00000000 00:0c 16389419   /android/lib/libcomposer.so
// 012345678901234567890123456789012345678901234567890123456789
// 0         1         2         3         4         5

static int read_mapinfo(FILE *fp, mapinfo* mi)
{
    char line[1024];
    int len;

skip:
    if(fgets(line, 1024, fp) == 0) return -1;

    len = strlen(line);
    if(len < 1) return -1;
    line[--len] = 0;

    if(mi == 0) return -1;

    mi->start = strtoul(line, 0, 16);
    mi->end = strtoul(line + 9, 0, 16);
    strncpy(mi->perm, line + 18, 4);

    if(len < 50) {
        //mi->name[0] = '\0';
	goto skip;
    } else {
        strcpy(mi->name, line + 49);
    }

    return 0;
}

static mapinfo *search_maps(const char* perm, const char* name)
{
    char tmp[128];
    FILE *fp;
    mapinfo *mi;
    
    fp = fopen("/proc/self/maps", "r");
    if(fp == 0) return 0;
    
    mi = calloc(1, sizeof(mapinfo) + 16);

    while(!read_mapinfo(fp, mi)) {
        if(!strcmp(mi->perm, perm) && !strcmp(mi->name, name)){
            fclose(fp);
            return mi;
        }
    }

    fclose(fp);
    free(mi);
    return 0;
}

static const char const pattern_setuid[] = {
	0xD5,0x70,0xA0,0xE3, // MOV     R7, #0xD5
	0x00,0x00,0x00,0xEF, // SVC     0
};

static char* search_pattern(mapinfo *mi, const char* const pattern, int len)
{
	char* addr = (char*)mi->start;
	for (addr = (char*)mi->start; addr < (char*)mi->end; addr++){
		if(addr[0] != pattern[0]) continue;
		if (memcmp(addr, pattern, len) == 0) {
			return addr;
		}
	}
	return 0;
}

extern void b(void* adr, char value);
void memdump(char* addr)
{
   int i;
   printf("%08x : ", addr);
   for(i=0; i<16; i++){
     printf("%02x ", *addr++);
   }
   printf("\n");
}

struct msm_nand_protect_area_info {
	uint64_t start;
	uint64_t end;
	uint32_t flg;
} * s_protect_info = 0;

static void is01bb16_nandunlock()
{
	s_protect_info = (void*)0x805D2BE0;
//	b((void*)&s_protect_info[0].flg, 0); //boot
	b((void*)&s_protect_info[1].flg, 0); //recovery
//	b((void*)&s_protect_info[2].flg, 0); //system
}

static void breaksuid_libc()
{
	char*addr = 0;
	mapinfo *mi;
	mi = search_maps("r-xp", "/system/lib/libc.so");
	if(!mi) return;
	addr = search_pattern(mi, pattern_setuid, sizeof(pattern_setuid));
	free(mi);
	if(addr == 0){
		return;
	}
memdump((void*)(addr - 4));
	b((void*)(addr), 0xc7);
	b((void*)(addr+1), 0x70);
memdump((void*)(addr - 4));
}

int main(int argc, char** argv)
{
//	breaksuid_libc();
	is01bb16_nandunlock();
}

