#!/bin/sh
DIR_NAME="$1"
IMG_SRC="Image"
RAM_DISK="ramdisk"
KERNEL="boot.img"

if [ ! $DIR_NAME ] ; then
  echo "ERROR!"
  exit
fi

cd ${DIR_NAME}
../mkbootfs ${RAM_DISK} > ${RAM_DISK}.img
../mkbootimg --kernel ${IMG_SRC} --ramdisk ${RAM_DISK}.img --cmdline "console=ttyMSM2,115200n8 androidboot.hardware=qcom" --base 0x20000000 -o tmpboot.img
../ubinize -o ${KERNEL} -p 128KiB -m 2048 -O 256 ../ubi.cfg
exit 0
