/* This is an autogenerated file from hip_dd_l_h_gen.pl */

#ifndef SIGS_H
#define SIGS_H

typedef CsrInt16 csr_place_holding_type;

typedef enum CSR_ANTENNA_ID
{
    CSR_ANTENNA_UNKNOWN                           = 0x0000,
    CSR_ANTENNA_1                                 = 0x0001,
    CSR_ANTENNA_2                                 = 0x0002,
    CSR_ANTENNA_MULTIPLE                          = 0x00ff
} CSR_ANTENNA_ID;

typedef CsrUint16 CSR_ASSOCIATION_ID;

typedef enum CSR_AUTHENTICATION_TYPE
{
    CSR_OPEN_SYSTEM                               = 0x0000,
    CSR_SHARED_KEY                                = 0x0001,
    CSR_FAST_BSS_TRANSITION                       = 0x0002
} CSR_AUTHENTICATION_TYPE;

typedef CsrUint16 CSR_AUTONOMOUS_SCAN_ID;

typedef enum CSR_BSS_TYPE
{
    CSR_INFRASTRUCTURE                            = 0x0000,
    CSR_INDEPENDENT                               = 0x0001,
    CSR_ANY_BSS                                   = 0x0002
} CSR_BSS_TYPE;

typedef CsrUint16 CSR_BEACON_PERIODS;

typedef CsrUint16 CSR_BLACKOUT_ID;

typedef enum CSR_BLACKOUT_SOURCE
{
    CSR_DOT11_LOCAL                               = 0x0001,
    CSR_DOT11_REMOTE                              = 0x0002,
    CSR_OTHER_RADIO                               = 0x0004
} CSR_BLACKOUT_SOURCE;

typedef enum CSR_BLACKOUT_TYPE
{
    CSR_LOCAL_DEVICE_ONLY                         = 0x0001,
    CSR_SPECIFIED_PEER                            = 0x0002,
    CSR_CURRENT_CHANNEL                           = 0x0004
} CSR_BLACKOUT_TYPE;

typedef enum CSR_BLOCK_ACK_POLICY
{
    CSR_DELAYED                                   = 0x0000,
    CSR_IMMEDIATE                                 = 0x0001
} CSR_BLOCK_ACK_POLICY;

typedef enum CSR_BOOT_LOADER_OPERATION
{
    CSR_BOOT_LOADER_IDLE                          = 0x00,
    CSR_BOOT_LOADER_RESTART                       = 0x01,
    CSR_BOOT_LOADER_PATCH                         = 0x02,
    CSR_BOOT_LOADER_IMAGE_0                       = 0x10,
    CSR_BOOT_LOADER_IMAGE_1                       = 0x11,
    CSR_BOOT_LOADER_IMAGE_2                       = 0x12,
    CSR_BOOT_LOADER_IMAGE_3                       = 0x13
} CSR_BOOT_LOADER_OPERATION;

typedef CsrUint16 CSR_CAPABILITY_INFORMATION;

typedef enum CSR_CHANNEL_OFFSET
{
    CSR_SCN                                       = 0x0000,
    CSR_SCA                                       = 0x0001,
    CSR_SCB                                       = 0x0003
} CSR_CHANNEL_OFFSET;

typedef CsrUint16 CSR_CHANNEL_STARTING_FACTOR;

typedef enum CSR_CHANNEL_SWITCH_MODE
{
    CSR_CONTINUE                                  = 0x0000,
    CSR_PAUSE_UNTIL_SWITCH                        = 0x0001
} CSR_CHANNEL_SWITCH_MODE;

typedef CsrUint32 CSR_CIPHER_SUITE_SELECTOR;

typedef CsrUint32 CSR_CLIENT_TAG;

typedef enum CSR_COEXISTENCE_DIRECTION
{
    CSR_COEXISTENCE_NONE                          = 0x0000,
    CSR_COEXISTENCE_DOT11_INPUT                   = 0x0001,
    CSR_COEXISTENCE_DOT11_OUTPUT                  = 0x0002
} CSR_COEXISTENCE_DIRECTION;

typedef enum CSR_CONNECTION_STATUS
{
    CSR_DISCONNECTED                              = 0x0000,
    CSR_CONNECTED                                 = 0x0001
} CSR_CONNECTION_STATUS;

typedef CsrInt16 CSR_DECIBELS;

typedef CsrInt32 CSR_HERTZ_DELTA;

typedef CsrUint32 CSR_IPV4_ADDRESS;

typedef enum CSR_INITIATOR
{
    CSR_RECIPIENT                                 = 0x0000,
    CSR_ORIGINATOR                                = 0x0001
} CSR_INITIATOR;

typedef enum CSR_IFINTERFACE
{
    CSR_INDEX_2G4                                 = 0x0001,
    CSR_INDEX_5G                                  = 0x0002
} CSR_IFINTERFACE;

typedef enum CSR_KEY_TYPE
{
    CSR_GROUP                                     = 0x0000,
    CSR_PAIRWISE                                  = 0x0001,
    CSR_STAKEY                                    = 0x0002,
    CSR_IGTK                                      = 0x0003
} CSR_KEY_TYPE;

typedef enum CSR_LINK_MARGIN_CATEGORY
{
    CSR_ULM                                       = 0x0001,
    CSR_DLM                                       = 0x0002,
    CSR_ALL                                       = 0xffff
} CSR_LINK_MARGIN_CATEGORY;

typedef enum CSR_LOADER_OPERATION
{
    CSR_LOADER_IDLE                               = 0x0000,
    CSR_LOADER_COPY                               = 0x0001
} CSR_LOADER_OPERATION;

typedef struct CSR_MAC_ADDRESS
{
    CsrUint8 x[6];
} CSR_MACADDRESS;

typedef enum CSR_MIB_STATUS
{
    CSR_MIB_SUCCESSFUL                            = 0x0000,
    CSR_MIB_INVALID_PARAMETERS                    = 0x0001,
    CSR_MIB_WRITE_ONLY                            = 0x0002,
    CSR_MIB_READ_ONLY                             = 0x0003
} CSR_MIB_STATUS;

typedef enum CSR_MEASUREMENT_CATEGORY
{
    CSR_MC_SPECTRUM_MANAGEMENT                    = 0x0000,
    CSR_MC_RADIO_MEASUREMENT                      = 0x0005,
    CSR_MC_CCX_MEASUREMENT                        = 0x0006
} CSR_MEASUREMENT_CATEGORY;

typedef CsrUint16 CSR_MEGAHERTZ;

typedef enum CSR_MEMORY_SPACE
{
    CSR_NONE                                      = 0x00,
    CSR_SHARED_DATA_MEMORY                        = 0x01,
    CSR_EXTERNAL_FLASH_MEMORY                     = 0x02,
    CSR_EXTERNAL_SRAM                             = 0x03,
    CSR_REGISTERS                                 = 0x04,
    CSR_PHY_PROCESSOR_DATA_MEMORY                 = 0x10,
    CSR_PHY_PROCESSOR_PROGRAM_MEMORY              = 0x11,
    CSR_PHY_PROCESSOR_ROM                         = 0x12,
    CSR_MAC_PROCESSOR_DATA_MEMORY                 = 0x20,
    CSR_MAC_PROCESSOR_PROGRAM_MEMORY              = 0x21,
    CSR_MAC_PROCESSOR_ROM                         = 0x22,
    CSR_BT_PROCESSOR_DATA_MEMORY                  = 0x30,
    CSR_BT_PROCESSOR_PROGRAM_MEMORY               = 0x31,
    CSR_BT_PROCESSOR_ROM                          = 0x32
} CSR_MEMORY_SPACE;

typedef CsrUint16 CSR_MICROSECONDS16;

typedef CsrUint32 CSR_MICROSECONDS32;

typedef CsrUint16 CSR_NATURAL16;

typedef CsrUint32 CSR_NATURAL32;

typedef enum CSR_NEIGHBOR_REPORT_REQUEST_TYPE
{
    CSR_NRRT_BASIC                                = 0x0000,
    CSR_NRRT_TBTT_OFFSET                          = 0x0001
} CSR_NEIGHBOR_REPORT_REQUEST_TYPE;

typedef CsrUint32 CSR_PCI_POINTER;

typedef CsrUint16 CSR_PERIODIC_ID;

typedef enum CSR_PERIODIC_SCHEDULING_MODE
{
    CSR_PSM_PERIODIC_SCHEDULE_PS_POLL             = 0x0001,
    CSR_PSM_PERIODIC_SCHEDULE_PM_BIT              = 0x0002,
    CSR_PSM_PERIODIC_SCHEDULE_UAPSD               = 0x0004,
    CSR_PSM_PERIODIC_SCHEDULE_SAPSD               = 0x0008
} CSR_PERIODIC_SCHEDULING_MODE;

typedef enum CSR_POWER_MANAGEMENT_MODE
{
    CSR_PMM_ACTIVE_MODE                           = 0x0000,
    CSR_PMM_POWER_SAVE                            = 0x0001,
    CSR_PMM_FAST_POWER_SAVE                       = 0x0002
} CSR_POWER_MANAGEMENT_MODE;

typedef enum CSR_PRIORITY
{
    CSR_QOS_UP0                                   = 0x0000,
    CSR_QOS_UP1                                   = 0x0001,
    CSR_QOS_UP2                                   = 0x0002,
    CSR_QOS_UP3                                   = 0x0003,
    CSR_QOS_UP4                                   = 0x0004,
    CSR_QOS_UP5                                   = 0x0005,
    CSR_QOS_UP6                                   = 0x0006,
    CSR_QOS_UP7                                   = 0x0007,
    CSR_QOS_TSID0                                 = 0x0008,
    CSR_QOS_TSID1                                 = 0x0009,
    CSR_QOS_TSID2                                 = 0x000a,
    CSR_QOS_TSID3                                 = 0x000b,
    CSR_QOS_TSID4                                 = 0x000c,
    CSR_QOS_TSID5                                 = 0x000d,
    CSR_QOS_TSID6                                 = 0x000e,
    CSR_QOS_TSID7                                 = 0x000f,
    CSR_CONTENTION                                = 0x8000,
    CSR_CONTENTION_FREE                           = 0x8001
} CSR_PRIORITY;

typedef enum CSR_PROTECT_TYPE
{
    CSR_PT_NONE                                   = 0x0000,
    CSR_PT_RX                                     = 0x0001,
    CSR_PT_TX                                     = 0x0002,
    CSR_PT_RX_TX                                  = 0x0003,
    CSR_PT_RX_MMPDU                               = 0x0004,
    CSR_PT_TX_MMPDU                               = 0x0005,
    CSR_PT_RX_TX_MMPDU                            = 0x0006
} CSR_PROTECT_TYPE;

typedef enum CSR_REASON_CODE
{
    CSR_UNSPECIFIED_REASON                        = 0x0001,
    CSR_AUTHENTICATION_NOT_VALID                  = 0x0002,
    CSR_DEAUTHENTICATED_LEAVE_BSS                 = 0x0003,
    CSR_DISASSOCIATED_INACTIVITY                  = 0x0004,
    CSR_AP_OVERLOAD                               = 0x0005,
    CSR_CLASS2_FRAME_ERROR                        = 0x0006,
    CSR_CLASS3_FRAME_ERROR                        = 0x0007,
    CSR_DISASSOCIATED_LEAVE_BSS                   = 0x0008,
    CSR_ASSOCIATION_NOT_AUTHENTICATED             = 0x0009,
    CSR_DISASSOCIATED_POWER_CAPABILITY            = 0x000a,
    CSR_DISASSOCIATED_SUPPORTED_CHANNELS          = 0x000b,
    CSR_INVALID_INFORMATION_ELEMENT               = 0x000d,
    CSR_MICHAEL_MIC_FAILURE                       = 0x000e,
    CSR_FOURWAY_HANDSHAKE_TIMEOUT                 = 0x000f,
    CSR_GROUP_KEY_UPDATE_TIMEOUT                  = 0x0010,
    CSR_HANDSHAKE_ELEMENT_DIFFERENT               = 0x0011,
    CSR_INVALID_GROUP_CIPHER                      = 0x0012,
    CSR_INVALID_PAIRWISE_CIPHER                   = 0x0013,
    CSR_INVALID_AKMP                              = 0x0014,
    CSR_UNSUPPORTED_RSN_IE_VERSION                = 0x0015,
    CSR_INVALID_RSN_IE_CAPABILITIES               = 0x0016,
    CSR_DOT1X_AUTH_FAILED                         = 0x0017,
    CSR_CIPHER_REJECTED_BY_POLICY                 = 0x0018,
    CSR_SERVICE_CHANGE_PRECLUDES_TS               = 0x001F,
    CSR_QOS_UNSPECIFIED_REASON                    = 0x0020,
    CSR_QOS_INSUFFICIENT_BANDWIDTH                = 0x0021,
    CSR_QOS_EXCESSIVE_NOT_ACK                     = 0x0022,
    CSR_QOS_TXOP_LIMIT_EXCEEDED                   = 0x0023,
    CSR_QSTA_LEAVING                              = 0x0024,
    CSR_END_BA                                    = 0x0025,
    CSR_END_DLS                                   = 0x0025,
    CSR_END_TS                                    = 0x0025,
    CSR_UNKNOWN_DLS                               = 0x0026,
    CSR_UNKNOWN_BA                                = 0x0026,
    CSR_UNKNOWN_TS                                = 0x0026,
    CSR_TIMEOUT                                   = 0x0027,
    CSR_STAKEY_MISMATCH                           = 0x002d,
    CSR_UNICAST_KEY_NEGOTIATION_TIMEOUT           = 0xf019,
    CSR_MULTICAST_KEY_ANNOUNCEMENT_TIMEOUT        = 0xf01a,
    CSR_INCOMPATIBLE_UNICAST_KEY_NEGOTIATION_IE   = 0xf01b,
    CSR_INVALID_MULTICAST_CIPHER                  = 0xf01c,
    CSR_INVALID_UNICAST_CIPHER                    = 0xf01d,
    CSR_UNSUPPORTED_WAPI_IE_VERSION               = 0xf01e,
    CSR_INVALID_WAPI_CAPABILITY_IE                = 0xf01f,
    CSR_WAI_CERTIFICATE_AUTHENTICATION_FAILED     = 0xf020
} CSR_REASON_CODE;

typedef enum CSR_RECEPTION_STATUS
{
    CSR_RX_SUCCESS                                = 0x0000,
    CSR_RX_FAILURE                                = 0x0001
} CSR_RECEPTION_STATUS;

typedef enum CSR_RESULT_CODE
{
    CSR_RC_SUCCESS                                = 0x0000,
    CSR_RC_UNSPECIFIED_FAILURE                    = 0x0001,
    CSR_RC_REFUSED_CAPABILITIES_MISMATCH          = 0x000a,
    CSR_RC_REASSOCIATION_DENIED_NO_ASSOCIATION    = 0x000b,
    CSR_RC_REFUSED_EXTERNAL_REASON                = 0x000c,
    CSR_RC_REFUSED_AUTHENTICATION_MISMATCH        = 0x000d,
    CSR_RC_REFUSED_INVALID_AUTHENTICATION_SEQUENCE_NUMBER= 0x000e,
    CSR_RC_REFUSED_CHALLENGE_FAILURE              = 0x000f,
    CSR_RC_REFUSED_AUTHENTICATION_TIMEOUT         = 0x0010,
    CSR_RC_REFUSED_AP_OUT_OF_MEMORY               = 0x0011,
    CSR_RC_REFUSED_BASIC_RATES_MISMATCH           = 0x0012,
    CSR_RC_REFUSED_SHORT_PREAMBLE_REQUIRED        = 0x0013,
    CSR_RC_REFUSED_PBCC_MODULATION_REQUIRED       = 0x0014,
    CSR_RC_REFUSED_CHANNEL_AGILITY_REQUIRED       = 0x0015,
    CSR_RC_REFUSED_SPECTRUM_MANAGEMENT_REQUIRED   = 0x0016,
    CSR_RC_REFUSED_POWER_CAPABILITY_UNACCEPTABLE  = 0x0017,
    CSR_RC_REFUSED_SUPPORTED_CHANNELS_UNACCEPTABLE= 0x0018,
    CSR_RC_REFUSED_SHORT_SLOT_REQUIRED            = 0x0019,
    CSR_RC_REFUSED_DSSS_OFDM_REQUIRED             = 0x001a,
    CSR_RC_REFUSED_NO_HT_SUPPORT                  = 0x001b,
    CSR_RC_R0KH_UNREACHABLE                       = 0x001c,
    CSR_RC_REFUSED_PCO_TRANSITION_SUPPORT         = 0x001d,
    CSR_RC_ASSOCIATION_REQUEST_REJECTED_TEMPORARILY= 0x001e,
    CSR_RC_ROBUST_MANAGEMENT_FRAME_POLICY_VIOLATION= 0x001f,
    CSR_RC_FAILURE                                = 0x0020,
    CSR_RC_REFUSED_AP_BANDWIDTH_INSUFFICIENT      = 0x0021,
    CSR_RC_REFUSED_POOR_OPERATING_CHANNEL         = 0x0022,
    CSR_RC_REFUSED_QOS_REQUIRED                   = 0x0023,
    CSR_RC_REFUSED_REASON_UNSPECIFIED             = 0x0025,
    CSR_RC_REFUSED                                = 0x0025,
    CSR_RC_INVALID_PARAMETERS                     = 0x0026,
    CSR_RC_REJECTED_WITH_SUGGESTED_TSPEC_CHANGES  = 0x0027,
    CSR_RC_REJECTED_INVALID_IE                    = 0x0028,
    CSR_RC_REJECTED_INVALID_GROUP_CIPHER          = 0x0029,
    CSR_RC_REJECTED_INVALID_PAIRWISE_CIPHER       = 0x002a,
    CSR_RC_REJECTED_INVALID_AKMP                  = 0x002b,
    CSR_RC_REJECTED_UNSUPPORTED_RSN_VERSION       = 0x002c,
    CSR_RC_REJECTED_INVALID_RSN_CAPABILITY        = 0x002d,
    CSR_RC_REJECTED_SECURITY_POLICY               = 0x002e,
    CSR_RC_REJECTED_FOR_DELAY_PERIOD              = 0x002f,
    CSR_RC_NOT_ALLOWED                            = 0x0030,
    CSR_RC_NOT_PRESENT                            = 0x0031,
    CSR_RC_NOT_QSTA                               = 0x0032,
    CSR_RC_REJECTED_LISTENINTERVAL_TOO_LARGE      = 0x0033,
    CSR_RC_INVALID_FT_ACTION_FRAME_COUNT          = 0x0034,
    CSR_RC_INVALID_PMKID                          = 0x0035,
    CSR_RC_INVALID_MDIE                           = 0x0036,
    CSR_RC_INVALID_FTIE                           = 0x0037,
    CSR_RC_UNSPECIFIED_QOS_FAILURE                = 0x00c8,
    CSR_RC_WRONG_POLICY                           = 0x00c9,
    CSR_RC_INSUFFICIENT_BANDWIDTH                 = 0x00ca,
    CSR_RC_INVALID_TSPEC_PARAMETERS               = 0x00cb,
    CSR_RC_TIMEOUT                                = 0x8000,
    CSR_RC_TOO_MANY_SIMULTANEOUS_REQUESTS         = 0x8001,
    CSR_RC_BSS_ALREADY_STARTED_OR_JOINED          = 0x8002,
    CSR_RC_NOT_SUPPORTED                          = 0x8003,
    CSR_RC_TRANSMISSION_FAILURE                   = 0x8004,
    CSR_RC_REFUSED_NOT_AUTHENTICATED              = 0x8005,
    CSR_RC_RESET_REQUIRED_BEFORE_START            = 0x8006,
    CSR_RC_LM_INFO_UNAVAILABLE                    = 0x8007,
    CSR_RC_INVALID_UNICAST_CIPHER                 = 0xf02f,
    CSR_RC_INVALID_MULTICAST_CIPHER               = 0xf030,
    CSR_RC_UNSUPPORTED_WAPI_IE_VERSION            = 0xf031,
    CSR_RC_INVALID_WAPI_CAPABILITY_IE             = 0xf032
} CSR_RESULT_CODE;

typedef enum CSR_ROUTING_INFORMATION
{
    CSR_NULL_RT                                   = 0x0000
} CSR_ROUTING_INFORMATION;

typedef enum CSR_SCAN_TYPE
{
    CSR_SC_ACTIVE_SCAN                            = 0x0000,
    CSR_SC_PASSIVE_SCAN                           = 0x0001
} CSR_SCAN_TYPE;

typedef CsrUint16 CSR_SECONDS;

typedef enum CSR_SERVICE_CLASS
{
    CSR_REORDERABLE_MULTICAST                     = 0x0000,
    CSR_STRICTLY_ORDERED                          = 0x0001,
    CSR_QOS_ACK                                   = 0x0002,
    CSR_QOS_NO_ACK                                = 0x0003,
    CSR_QOS_LOCAL_MULTICAST                       = 0x0004
} CSR_SERVICE_CLASS;

typedef enum CSR_SIGNAL_ID
{
    CSR_MA_UNITDATA_REQUEST_ID                    = 0x0100,
    CSR_MA_UNITDATA_CONFIRM_ID                    = 0x0101,
    CSR_MA_UNITDATA_INDICATION_ID                 = 0x0103,
    CSR_MA_UNITDATA_STATUS_INDICATION_DEPRECATED_ID= 0x0107,
    CSR_MA_SNIFFDATA_INDICATION_ID                = 0x010b,
    CSR_MA_UNITDATA_CANCEL_REQUEST_ID             = 0x010c,
    CSR_MA_PACKET_REQUEST_ID                      = 0x0110,
    CSR_MA_PACKET_CONFIRM_ID                      = 0x0111,
    CSR_MA_PACKET_INDICATION_ID                   = 0x0113,
    CSR_MLME_RESET_REQUEST_ID                     = 0x0200,
    CSR_MLME_RESET_CONFIRM_ID                     = 0x0201,
    CSR_MLME_GET_REQUEST_ID                       = 0x0204,
    CSR_MLME_GET_CONFIRM_ID                       = 0x0205,
    CSR_MLME_SET_REQUEST_ID                       = 0x0208,
    CSR_MLME_SET_CONFIRM_ID                       = 0x0209,
    CSR_MLME_GET_NEXT_REQUEST_ID                  = 0x020c,
    CSR_MLME_GET_NEXT_CONFIRM_ID                  = 0x020d,
    CSR_MLME_POWERMGT_REQUEST_ID                  = 0x0210,
    CSR_MLME_POWERMGT_CONFIRM_ID                  = 0x0211,
    CSR_MLME_SCAN_REQUEST_ID                      = 0x0214,
    CSR_MLME_SCAN_CONFIRM_ID                      = 0x0215,
    CSR_MLME_SCAN_INDICATION_ID                   = 0x0217,
    CSR_MLME_JOIN_REQUEST_ID                      = 0x0218,
    CSR_MLME_JOIN_CONFIRM_ID                      = 0x0219,
    CSR_MLME_AUTHENTICATE_REQUEST_ID              = 0x021c,
    CSR_MLME_AUTHENTICATE_CONFIRM_ID              = 0x021d,
    CSR_MLME_AUTHENTICATE_RESPONSE_ID             = 0x021e,
    CSR_MLME_AUTHENTICATE_INDICATION_ID           = 0x021f,
    CSR_MLME_DEAUTHENTICATE_REQUEST_ID            = 0x0220,
    CSR_MLME_DEAUTHENTICATE_CONFIRM_ID            = 0x0221,
    CSR_MLME_DEAUTHENTICATE_INDICATION_ID         = 0x0223,
    CSR_MLME_ASSOCIATE_REQUEST_ID                 = 0x0224,
    CSR_MLME_ASSOCIATE_CONFIRM_ID                 = 0x0225,
    CSR_MLME_ASSOCIATE_RESPONSE_ID                = 0x0226,
    CSR_MLME_ASSOCIATE_INDICATION_ID              = 0x0227,
    CSR_MLME_REASSOCIATE_REQUEST_ID               = 0x0228,
    CSR_MLME_REASSOCIATE_CONFIRM_ID               = 0x0229,
    CSR_MLME_REASSOCIATE_RESPONSE_ID              = 0x022a,
    CSR_MLME_REASSOCIATE_INDICATION_ID            = 0x022b,
    CSR_MLME_DISASSOCIATE_REQUEST_ID              = 0x022c,
    CSR_MLME_DISASSOCIATE_CONFIRM_ID              = 0x022d,
    CSR_MLME_DISASSOCIATE_INDICATION_ID           = 0x022f,
    CSR_MLME_START_REQUEST_ID                     = 0x0230,
    CSR_MLME_START_CONFIRM_ID                     = 0x0231,
    CSR_MLME_ADDTS_REQUEST_ID                     = 0x0234,
    CSR_MLME_ADDTS_CONFIRM_ID                     = 0x0235,
    CSR_MLME_ADDTS_RESPONSE_ID                    = 0x0236,
    CSR_MLME_ADDTS_INDICATION_ID                  = 0x0237,
    CSR_MLME_DELTS_REQUEST_ID                     = 0x0238,
    CSR_MLME_DELTS_CONFIRM_ID                     = 0x0239,
    CSR_MLME_DELTS_INDICATION_ID                  = 0x023b,
    CSR_MLME_DLS_REQUEST_ID                       = 0x023c,
    CSR_MLME_DLS_CONFIRM_ID                       = 0x023d,
    CSR_MLME_DLS_INDICATION_ID                    = 0x023f,
    CSR_MLME_DLSTEARDOWN_REQUEST_ID               = 0x0240,
    CSR_MLME_DLSTEARDOWN_CONFIRM_ID               = 0x0241,
    CSR_MLME_DLSTEARDOWN_INDICATION_ID            = 0x0243,
    CSR_MLME_HL_SYNC_REQUEST_ID                   = 0x0244,
    CSR_MLME_HL_SYNC_CONFIRM_ID                   = 0x0245,
    CSR_MLME_HL_SYNC_INDICATION_ID                = 0x0247,
    CSR_MLME_ADDBA_REQUEST_ID                     = 0x0248,
    CSR_MLME_ADDBA_CONFIRM_ID                     = 0x0249,
    CSR_MLME_ADDBA_RESPONSE_ID                    = 0x024a,
    CSR_MLME_ADDBA_INDICATION_ID                  = 0x024b,
    CSR_MLME_DELBA_REQUEST_ID                     = 0x024c,
    CSR_MLME_DELBA_CONFIRM_ID                     = 0x024d,
    CSR_MLME_DELBA_INDICATION_ID                  = 0x024f,
    CSR_MLME_SCHEDULE_REQUEST_ID                  = 0x0250,
    CSR_MLME_SCHEDULE_CONFIRM_ID                  = 0x0251,
    CSR_MLME_SCHEDULE_INDICATION_ID               = 0x0253,
    CSR_MLME_MREQUEST_REQUEST_ID                  = 0x0254,
    CSR_MLME_MREQUEST_CONFIRM_ID                  = 0x0255,
    CSR_MLME_MREQUEST_INDICATION_ID               = 0x0257,
    CSR_MLME_MEASURE_REQUEST_ID                   = 0x0258,
    CSR_MLME_MEASURE_CONFIRM_ID                   = 0x0259,
    CSR_MLME_MREPORT_REQUEST_ID                   = 0x025c,
    CSR_MLME_MREPORT_CONFIRM_ID                   = 0x025d,
    CSR_MLME_MREPORT_INDICATION_ID                = 0x025f,
    CSR_MLME_CHANNELSWITCH_REQUEST_ID             = 0x0260,
    CSR_MLME_CHANNELSWITCH_CONFIRM_ID             = 0x0261,
    CSR_MLME_CHANNELSWITCH_RESPONSE_ID            = 0x0262,
    CSR_MLME_CHANNELSWITCH_INDICATION_ID          = 0x0263,
    CSR_MLME_TPCADAPT_REQUEST_ID                  = 0x0264,
    CSR_MLME_TPCADAPT_CONFIRM_ID                  = 0x0265,
    CSR_MLME_SETKEYS_REQUEST_ID                   = 0x0268,
    CSR_MLME_SETKEYS_CONFIRM_ID                   = 0x0269,
    CSR_MLME_DELETEKEYS_REQUEST_ID                = 0x026c,
    CSR_MLME_DELETEKEYS_CONFIRM_ID                = 0x026d,
    CSR_MLME_MICHAELMICFAILURE_INDICATION_ID      = 0x0273,
    CSR_MLME_EAPOL_REQUEST_ID                     = 0x0274,
    CSR_MLME_EAPOL_CONFIRM_ID                     = 0x0275,
    CSR_MLME_STAKEYESTABLISHED_INDICATION_ID      = 0x027b,
    CSR_MLME_SETPROTECTION_REQUEST_ID             = 0x027c,
    CSR_MLME_SETPROTECTION_CONFIRM_ID             = 0x027d,
    CSR_MLME_PROTECTEDFRAMEDROPPED_INDICATION_ID  = 0x0283,
    CSR_MLME_SNIFFJOIN_REQUEST_ID                 = 0x0284,
    CSR_MLME_SNIFFJOIN_CONFIRM_ID                 = 0x0285,
    CSR_MLME_CONNECTED_INDICATION_ID              = 0x028b,
    CSR_MLME_SCAN_CANCEL_REQUEST_ID               = 0x028c,
    CSR_MLME_LINKMEASURE_REQUEST_ID               = 0x0294,
    CSR_MLME_LINKMEASURE_CONFIRM_ID               = 0x0295,
    CSR_MLME_HL_SYNC_CANCEL_REQUEST_ID            = 0x0298,
    CSR_MLME_HL_SYNC_CANCEL_CONFIRM_ID            = 0x0299,
    CSR_MLME_ADD_PERIODIC_REQUEST_ID              = 0x02a0,
    CSR_MLME_ADD_PERIODIC_CONFIRM_ID              = 0x02a1,
    CSR_MLME_DEL_PERIODIC_REQUEST_ID              = 0x02a4,
    CSR_MLME_DEL_PERIODIC_CONFIRM_ID              = 0x02a5,
    CSR_MLME_ADD_AUTONOMOUS_SCAN_REQUEST_ID       = 0x02a8,
    CSR_MLME_ADD_AUTONOMOUS_SCAN_CONFIRM_ID       = 0x02a9,
    CSR_MLME_DEL_AUTONOMOUS_SCAN_REQUEST_ID       = 0x02ac,
    CSR_MLME_DEL_AUTONOMOUS_SCAN_CONFIRM_ID       = 0x02ad,
    CSR_MLME_AUTONOMOUS_SCAN_INDICATION_ID        = 0x02b3,
    CSR_MLME_AUTONOMOUS_SCAN_RESULTS_REQUEST_ID   = 0x02b4,
    CSR_MLME_AUTONOMOUS_SCAN_RESULTS_CONFIRM_ID   = 0x02b5,
    CSR_MLME_AUTONOMOUS_SCAN_RESULTS_INDICATION_ID= 0x02b7,
    CSR_MLME_SET_UNITDATA_FILTER_REQUEST_ID       = 0x02b8,
    CSR_MLME_SET_UNITDATA_FILTER_CONFIRM_ID       = 0x02b9,
    CSR_MLME_FT_JOIN_REQUEST_ID                   = 0x02bc,
    CSR_MLME_FT_JOIN_CONFIRM_ID                   = 0x02bd,
    CSR_MLME_RESOURCE_REQUEST_REQUEST_ID          = 0x02c0,
    CSR_MLME_RESOURCE_REQUEST_CONFIRM_ID          = 0x02c1,
    CSR_MLME_RESOURCE_REQUEST_RESPONSE_ID         = 0x02c2,
    CSR_MLME_RESOURCE_REQUEST_INDICATION_ID       = 0x02c3,
    CSR_MLME_RESOURCE_REQUEST_LOCAL_REQUEST_ID    = 0x02c4,
    CSR_MLME_RESOURCE_REQUEST_LOCAL_CONFIRM_ID    = 0x02c5,
    CSR_MLME_REMOTE_REQUEST_REQUEST_ID            = 0x02c8,
    CSR_MLME_REMOTE_REQUEST_CONFIRM_ID            = 0x02c9,
    CSR_MLME_REMOTE_REQUEST_INDICATION_ID         = 0x02cb,
    CSR_MLME_PAUSE_AUTONOMOUS_SCAN_REQUEST_ID     = 0x02cc,
    CSR_MLME_PAUSE_AUTONOMOUS_SCAN_CONFIRM_ID     = 0x02cd,
    CSR_MLME_NEIGHBORREPREQ_REQUEST_ID            = 0x02d0,
    CSR_MLME_NEIGHBORREPREQ_CONFIRM_ID            = 0x02d1,
    CSR_MLME_NEIGHBORREPREQ_INDICATION_ID         = 0x02d3,
    CSR_MLME_NEIGHBORREPRESP_REQUEST_ID           = 0x02d4,
    CSR_MLME_NEIGHBORREPRESP_CONFIRM_ID           = 0x02d5,
    CSR_MLME_NEIGHBORREPRESP_INDICATION_ID        = 0x02d7,
    CSR_MLME_AUTONOMOUS_SCAN_DONE_INDICATION_ID   = 0x02db,
    CSR_MLME_ADD_TRIGGERED_GET_REQUEST_ID         = 0x02dc,
    CSR_MLME_ADD_TRIGGERED_GET_CONFIRM_ID         = 0x02dd,
    CSR_MLME_DEL_TRIGGERED_GET_REQUEST_ID         = 0x02e0,
    CSR_MLME_DEL_TRIGGERED_GET_CONFIRM_ID         = 0x02e1,
    CSR_MLME_TRIGGERED_GET_INDICATION_ID          = 0x02e7,
    CSR_MLME_VSPECIFIC_REQUEST_ID                 = 0x02ec,
    CSR_MLME_VSPECIFIC_CONFIRM_ID                 = 0x02ed,
    CSR_MLME_VSPECIFIC_INDICATION_ID              = 0x02ef,
    CSR_MLME_ADD_WDS_REQUEST_ID                   = 0x02f0,
    CSR_MLME_ADD_WDS_CONFIRM_ID                   = 0x02f1,
    CSR_MLME_DEL_WDS_REQUEST_ID                   = 0x02f4,
    CSR_MLME_DEL_WDS_CONFIRM_ID                   = 0x02f5,
    CSR_MLME_ADD_BLACKOUT_REQUEST_ID              = 0x02f8,
    CSR_MLME_ADD_BLACKOUT_CONFIRM_ID              = 0x02f9,
    CSR_MLME_DEL_BLACKOUT_REQUEST_ID              = 0x02fc,
    CSR_MLME_DEL_BLACKOUT_CONFIRM_ID              = 0x02fd,
    CSR_MLME_SAQUERY_REQUEST_ID                   = 0x0300,
    CSR_MLME_SAQUERY_CONFIRM_ID                   = 0x0301,
    CSR_MLME_SAQUERY_RESPONSE_ID                  = 0x0302,
    CSR_MLME_SAQUERY_INDICATION_ID                = 0x0303,
    CSR_MLME_ADD_RX_TRIGGER_REQUEST_ID            = 0x0304,
    CSR_MLME_ADD_RX_TRIGGER_CONFIRM_ID            = 0x0305,
    CSR_MLME_DEL_RX_TRIGGER_REQUEST_ID            = 0x0308,
    CSR_MLME_DEL_RX_TRIGGER_CONFIRM_ID            = 0x0309,
    CSR_DS_UNITDATA_REQUEST_ID                    = 0x0400,
    CSR_DS_UNITDATA_RESPONSE_ID                   = 0x0402,
    CSR_DS_UNITDATA_INDICATION_ID                 = 0x0403,
    CSR_DS_UNITDATA_CANCEL_INDICATION_ID          = 0x0407,
    CSR_DS_STA_NOTIFY_REQUEST_ID                  = 0x0408,
    CSR_DEBUG_STRING_INDICATION_ID                = 0x0803,
    CSR_DEBUG_WORD16_INDICATION_ID                = 0x0807,
    CSR_DEBUG_GENERIC_REQUEST_ID                  = 0x0808,
    CSR_DEBUG_GENERIC_CONFIRM_ID                  = 0x0809,
    CSR_DEBUG_GENERIC_INDICATION_ID               = 0x080b
} CSR_SIGNAL_ID;

typedef CsrUint16 CSR_SIMPLE_POINTER;

typedef enum CSR_SNIFFER_RECEPTION_STATUS
{
    CSR_SNIFF_SUCCESS                             = 0x0000,
    CSR_SNIFF_UNSUPPORTED_MODULATION              = 0x0001,
    CSR_SNIFF_BAD_FCS                             = 0x0002,
    CSR_SNIFF_BAD_SIGNAL                          = 0x0003
} CSR_SNIFFER_RECEPTION_STATUS;

typedef enum CSR_SOURCE_TYPE
{
    CSR_SCR_AP                                    = 0x0000,
    CSR_SCR_PORTAL                                = 0x0001
} CSR_SOURCE_TYPE;

typedef enum CSR_SYMBOL_ID
{
    CSR_SLT_END                                   = 0x0000,
    CSR_SLT_PCI_SLOT_CONFIG                       = 0x0001,
    CSR_SLT_SDIO_SLOT_CONFIG                      = 0x0002,
    CSR_SLT_BUILD_ID_NUMBER                       = 0x0003,
    CSR_SLT_BUILD_ID_STRING                       = 0x0004,
    CSR_SLT_PERSISTENT_STORE_DB                   = 0x0005,
    CSR_SLT_RESET_VECTOR_PHY                      = 0x0006,
    CSR_SLT_RESET_VECTOR_MAC                      = 0x0007,
    CSR_SLT_SDIO_LOADER_CONTROL                   = 0x0008,
    CSR_SLT_TEST_CMD                              = 0x0009,
    CSR_SLT_TEST_ALIVE_COUNTER                    = 0x000a,
    CSR_SLT_TEST_PARAMETERS                       = 0x000b,
    CSR_SLT_TEST_RESULTS                          = 0x000c,
    CSR_SLT_TEST_VERSION                          = 0x000d,
    CSR_SLT_MIB_PSID_RANGES                       = 0x000e,
    CSR_SLT_KIP_TABLE                             = 0x000f,
    CSR_SLT_PANIC_DATA_PHY                        = 0x0010,
    CSR_SLT_PANIC_DATA_MAC                        = 0x0011,
    CSR_SLT_BOOT_LOADER_CONTROL                   = 0x0012
} CSR_SYMBOL_ID;

typedef struct CSR_TSF_TIME
{
    CsrUint8 x[8];
} CSR_TSF_TIME;

typedef CsrUint16 CSR_TIME_UNITS;

typedef enum CSR_TRANSMISSION_STATUS
{
    CSR_TX_SUCCESSFUL                             = 0x0000,
    CSR_TX_RETRY_LIMIT                            = 0x0001,
    CSR_TX_LIFETIME                               = 0x0002,
    CSR_TX_NO_BSS                                 = 0x0003,
    CSR_TX_EXCESSIVE_DATA_LENGTH                  = 0x0004,
    CSR_TX_NON_NULL_SOURCE_ROUTING                = 0x0005,
    CSR_TX_UNSUPPORTED_PRIORITY                   = 0x0006,
    CSR_TX_UNAVAILABLE_PRIORITY                   = 0x0007,
    CSR_TX_UNSUPPORTED_SERVICE_CLASS              = 0x0008,
    CSR_TX_UNAVAILABLE_SERVICE_CLASS              = 0x0009,
    CSR_TX_UNAVAILABLE_KEY_MAPPING                = 0x000a,
    CSR_TX_EDCA_TIMEOUT                           = 0x000b,
    CSR_TX_BLOCK_ACK_TIMEOUT                      = 0x000c
} CSR_TRANSMISSION_STATUS;

typedef CsrUint16 CSR_TRIGGER_ID;

typedef CsrUint16 CSR_TRIGGERED_ID;

typedef enum CSR_UNIT_DATA_FILTER_MODE
{
    CSR_UDFM_OPT_OUT                              = 0x0000,
    CSR_UDFM_OPT_IN                               = 0x0003
} CSR_UNIT_DATA_FILTER_MODE;

typedef enum CSR_UPDATE_TYPE
{
    CSR_ADD                                       = 0x0000,
    CSR_MOVE                                      = 0x0001,
    CSR_DELETE                                    = 0x0002
} CSR_UPDATE_TYPE;

typedef CsrUint16 CSR_BUFFER_HANDLE;

typedef CsrUint16 CSR_CHANNEL_NUMBER;

typedef struct CSR_DATA_REFERENCE
{
    CsrUint16                                   SlotNumber;
    CsrUint16                                   DataLength;
} CSR_DATAREF;

typedef CsrUint16 CSR_DIALOG_TOKEN;

typedef struct CSR_GENERIC_POINTER
{
    CsrUint24                                   MemoryOffset;
    CSR_MEMORY_SPACE                            MemorySpace;
} CSR_GENERIC_POINTER;

typedef struct CSR_MA_UNITDATA_REQUEST
{
    CSR_DATAREF                                 Data;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              Da;
    CSR_MACADDRESS                              Sa;
    CSR_ROUTING_INFORMATION                     RoutingInformation;
    CSR_PRIORITY                                Priority;
    CSR_SERVICE_CLASS                           ServiceClass;
    CSR_CLIENT_TAG                              HostTag;
} CSR_MA_UNITDATA_REQUEST;

typedef struct CSR_MA_UNITDATA_CANCEL_REQUEST
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_CLIENT_TAG                              HostTag;
} CSR_MA_UNITDATA_CANCEL_REQUEST;

typedef struct CSR_MLME_ADDBA_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerQstaAddress;
    CSR_DIALOG_TOKEN                            DialogToken;
    CSR_PRIORITY                                Tid;
    CSR_RESULT_CODE                             ResultCode;
    CSR_BLOCK_ACK_POLICY                        BlockAckPolicy;
    CSR_NATURAL16                               BufferSize;
    CSR_TIME_UNITS                              BlockAckTimeout;
} CSR_MLME_ADDBA_CONFIRM;

typedef struct CSR_MLME_ADDBA_INDICATION
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerQstaAddress;
    CSR_DIALOG_TOKEN                            DialogToken;
    CSR_PRIORITY                                Tid;
    CSR_BLOCK_ACK_POLICY                        BlockAckPolicy;
    CSR_NATURAL16                               BufferSize;
    CSR_TIME_UNITS                              BlockAckTimeout;
} CSR_MLME_ADDBA_INDICATION;

typedef struct CSR_MLME_ADDBA_RESPONSE
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerQstaAddress;
    CSR_DIALOG_TOKEN                            DialogToken;
    CSR_PRIORITY                                Tid;
    CSR_RESULT_CODE                             ResultCode;
    CSR_BLOCK_ACK_POLICY                        BlockAckPolicy;
    CSR_NATURAL16                               BufferSize;
    CSR_TIME_UNITS                              BlockAckTimeout;
} CSR_MLME_ADDBA_RESPONSE;

typedef struct CSR_MLME_ADDTS_CONFIRM
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
    CSR_DIALOG_TOKEN                            DialogToken;
} CSR_MLME_ADDTS_CONFIRM;

typedef struct CSR_MLME_ADDTS_INDICATION
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_DIALOG_TOKEN                            DialogToken;
    CSR_MACADDRESS                              NonapQstaAddress;
} CSR_MLME_ADDTS_INDICATION;

typedef struct CSR_MLME_ADDTS_REQUEST
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_DIALOG_TOKEN                            DialogToken;
    CSR_TIME_UNITS                              AddtsFailureTimeout;
} CSR_MLME_ADDTS_REQUEST;

typedef struct CSR_MLME_ADDTS_RESPONSE
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
    CSR_DIALOG_TOKEN                            DialogToken;
    CSR_MACADDRESS                              NonapQstaAddress;
} CSR_MLME_ADDTS_RESPONSE;

typedef struct CSR_MLME_ADD_AUTONOMOUS_SCAN_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
    CSR_AUTONOMOUS_SCAN_ID                      AutonomousScanId;
} CSR_MLME_ADD_AUTONOMOUS_SCAN_CONFIRM;

typedef struct CSR_MLME_ADD_AUTONOMOUS_SCAN_REQUEST
{
    CSR_DATAREF                                 ChannelList;
    CSR_DATAREF                                 InformationElements;
    CSR_AUTONOMOUS_SCAN_ID                      AutonomousScanId;
    CSR_IFINTERFACE                             Ifindex;
    CSR_CHANNEL_STARTING_FACTOR                 ChannelStartingFactor;
    CSR_BSS_TYPE                                BssType;
    CSR_MACADDRESS                              Bssid;
    CSR_SCAN_TYPE                               ScanType;
    CSR_MICROSECONDS32                          ProbeDelay;
    CSR_TIME_UNITS                              MinChannelTime;
    CSR_TIME_UNITS                              MaxChannelTime;
} CSR_MLME_ADD_AUTONOMOUS_SCAN_REQUEST;

typedef struct CSR_MLME_ADD_BLACKOUT_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_BLACKOUT_ID                             BlackoutId;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_ADD_BLACKOUT_CONFIRM;

typedef struct CSR_MLME_ADD_BLACKOUT_REQUEST
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_BLACKOUT_ID                             BlackoutId;
    CSR_BLACKOUT_TYPE                           BlackoutType;
    CSR_BLACKOUT_SOURCE                         BlackoutSource;
    CSR_MICROSECONDS32                          BlackoutStartReference;
    CSR_MICROSECONDS32                          BlackoutPeriod;
    CSR_MICROSECONDS32                          BlackoutDuration;
    CSR_MACADDRESS                              PeerStaAddress;
} CSR_MLME_ADD_BLACKOUT_REQUEST;

typedef struct CSR_MLME_ADD_PERIODIC_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_PERIODIC_ID                             PeriodicId;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_ADD_PERIODIC_CONFIRM;

typedef struct CSR_MLME_ADD_PERIODIC_REQUEST
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_PERIODIC_ID                             PeriodicId;
    CSR_MICROSECONDS32                          MaximumLatency;
    CSR_PERIODIC_SCHEDULING_MODE                PeriodicSchedulingMode;
    CsrInt16                                    WakeHost;
    CSR_PRIORITY                                Tid;
} CSR_MLME_ADD_PERIODIC_REQUEST;

typedef struct CSR_MLME_ADD_RX_TRIGGER_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_TRIGGER_ID                              TriggerId;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_ADD_RX_TRIGGER_CONFIRM;

typedef struct CSR_MLME_ADD_RX_TRIGGER_REQUEST
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_TRIGGER_ID                              TriggerId;
    CSR_PRIORITY                                Priority;
} CSR_MLME_ADD_RX_TRIGGER_REQUEST;

typedef struct CSR_MLME_ADD_TRIGGERED_GET_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
    CSR_TRIGGERED_ID                            TriggeredId;
} CSR_MLME_ADD_TRIGGERED_GET_CONFIRM;

typedef struct CSR_MLME_ADD_TRIGGERED_GET_REQUEST
{
    CSR_DATAREF                                 MibAttribute;
    CSR_DATAREF                                 Dummydataref2;
    CSR_TRIGGERED_ID                            TriggeredId;
} CSR_MLME_ADD_TRIGGERED_GET_REQUEST;

typedef struct CSR_MLME_ADD_WDS_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_ADD_WDS_CONFIRM;

typedef struct CSR_MLME_ADD_WDS_REQUEST
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              WdsApMacAddress;
} CSR_MLME_ADD_WDS_REQUEST;

typedef struct CSR_MLME_ASSOCIATE_REQUEST
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerStaAddress;
    CSR_TIME_UNITS                              AssociateFailureTimeout;
    CSR_CAPABILITY_INFORMATION                  CapabilityInformation;
    CSR_BEACON_PERIODS                          ListenInterval;
} CSR_MLME_ASSOCIATE_REQUEST;

typedef struct CSR_MLME_AUTHENTICATE_CONFIRM
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerStaAddress;
    CSR_AUTHENTICATION_TYPE                     AuthenticationType;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_AUTHENTICATE_CONFIRM;

typedef struct CSR_MLME_AUTHENTICATE_INDICATION
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerStaAddress;
    CSR_AUTHENTICATION_TYPE                     AuthenticationType;
} CSR_MLME_AUTHENTICATE_INDICATION;

typedef struct CSR_MLME_AUTHENTICATE_REQUEST
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerStaAddress;
    CSR_AUTHENTICATION_TYPE                     AuthenticationType;
    CSR_TIME_UNITS                              AuthenticationFailureTimeout;
} CSR_MLME_AUTHENTICATE_REQUEST;

typedef struct CSR_MLME_AUTHENTICATE_RESPONSE
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerStaAddress;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_AUTHENTICATE_RESPONSE;

typedef struct CSR_MLME_AUTONOMOUS_SCAN_DONE_INDICATION
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
    CSR_AUTONOMOUS_SCAN_ID                      AutonomousScanId;
} CSR_MLME_AUTONOMOUS_SCAN_DONE_INDICATION;

typedef struct CSR_MLME_AUTONOMOUS_SCAN_RESULTS_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
    CSR_AUTONOMOUS_SCAN_ID                      AutonomousScanId;
} CSR_MLME_AUTONOMOUS_SCAN_RESULTS_CONFIRM;

typedef struct CSR_MLME_AUTONOMOUS_SCAN_RESULTS_INDICATION
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_AUTONOMOUS_SCAN_ID                      AutonomousScanId;
    CSR_MACADDRESS                              Bssid;
    CSR_CHANNEL_NUMBER                          Channel;
    CSR_MEGAHERTZ                               ChannelFrequency;
    CSR_DECIBELS                                Rssi;
    CSR_DECIBELS                                Snr;
} CSR_MLME_AUTONOMOUS_SCAN_RESULTS_INDICATION;

typedef struct CSR_MLME_AUTONOMOUS_SCAN_RESULTS_REQUEST
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_AUTONOMOUS_SCAN_ID                      AutonomousScanId;
} CSR_MLME_AUTONOMOUS_SCAN_RESULTS_REQUEST;

typedef struct CSR_MLME_CHANNELSWITCH_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_CHANNELSWITCH_CONFIRM;

typedef struct CSR_MLME_CHANNELSWITCH_INDICATION
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerMacAddress;
    CSR_CHANNEL_SWITCH_MODE                     Mode;
    CSR_CHANNEL_NUMBER                          ChannelNumber;
    CSR_CHANNEL_OFFSET                          SecondaryChannelOffset;
    CSR_BEACON_PERIODS                          ChannelSwitchCount;
} CSR_MLME_CHANNELSWITCH_INDICATION;

typedef struct CSR_MLME_CHANNELSWITCH_REQUEST
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_CHANNEL_SWITCH_MODE                     Mode;
    CSR_CHANNEL_NUMBER                          ChannelNumber;
    CSR_CHANNEL_OFFSET                          SecondaryChannelOffset;
    CSR_BEACON_PERIODS                          ChannelSwitchCount;
} CSR_MLME_CHANNELSWITCH_REQUEST;

typedef struct CSR_MLME_CHANNELSWITCH_RESPONSE
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_CHANNEL_SWITCH_MODE                     Mode;
    CSR_CHANNEL_NUMBER                          ChannelNumber;
    CSR_CHANNEL_OFFSET                          SecondaryChannelOffset;
    CSR_BEACON_PERIODS                          ChannelSwitchCount;
} CSR_MLME_CHANNELSWITCH_RESPONSE;

typedef struct CSR_MLME_CONNECTED_INDICATION
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_CONNECTION_STATUS                       ConnectionStatus;
    CSR_MACADDRESS                              PeerMacAddress;
} CSR_MLME_CONNECTED_INDICATION;

typedef struct CSR_MLME_DEAUTHENTICATE_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerStaAddress;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_DEAUTHENTICATE_CONFIRM;

typedef struct CSR_MLME_DEAUTHENTICATE_INDICATION
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerStaAddress;
    CSR_REASON_CODE                             ReasonCode;
} CSR_MLME_DEAUTHENTICATE_INDICATION;

typedef struct CSR_MLME_DEAUTHENTICATE_REQUEST
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerStaAddress;
    CSR_REASON_CODE                             ReasonCode;
} CSR_MLME_DEAUTHENTICATE_REQUEST;

typedef struct CSR_MLME_DELBA_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerQstaAddress;
    CSR_INITIATOR                               Direction;
    CSR_PRIORITY                                Tid;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_DELBA_CONFIRM;

typedef struct CSR_MLME_DELBA_INDICATION
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerQstaAddress;
    CSR_INITIATOR                               Direction;
    CSR_PRIORITY                                Tid;
    CSR_REASON_CODE                             ReasonCode;
} CSR_MLME_DELBA_INDICATION;

typedef struct CSR_MLME_DELBA_REQUEST
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerQstaAddress;
    CSR_INITIATOR                               Direction;
    CSR_PRIORITY                                Tid;
    CSR_REASON_CODE                             ReasonCode;
} CSR_MLME_DELBA_REQUEST;

typedef struct CSR_MLME_DELETEKEYS_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_DELETEKEYS_CONFIRM;

typedef struct CSR_MLME_DELETEKEYS_REQUEST
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_NATURAL16                               KeyId;
    CSR_KEY_TYPE                                KeyType;
    CSR_MACADDRESS                              Address;
} CSR_MLME_DELETEKEYS_REQUEST;

typedef struct CSR_MLME_DEL_AUTONOMOUS_SCAN_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
    CSR_AUTONOMOUS_SCAN_ID                      AutonomousScanId;
} CSR_MLME_DEL_AUTONOMOUS_SCAN_CONFIRM;

typedef struct CSR_MLME_DEL_AUTONOMOUS_SCAN_REQUEST
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_AUTONOMOUS_SCAN_ID                      AutonomousScanId;
} CSR_MLME_DEL_AUTONOMOUS_SCAN_REQUEST;

typedef struct CSR_MLME_DEL_BLACKOUT_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_BLACKOUT_ID                             BlackoutId;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_DEL_BLACKOUT_CONFIRM;

typedef struct CSR_MLME_DEL_BLACKOUT_REQUEST
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_BLACKOUT_ID                             BlackoutId;
} CSR_MLME_DEL_BLACKOUT_REQUEST;

typedef struct CSR_MLME_DEL_PERIODIC_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_PERIODIC_ID                             PeriodicId;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_DEL_PERIODIC_CONFIRM;

typedef struct CSR_MLME_DEL_PERIODIC_REQUEST
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_PERIODIC_ID                             PeriodicId;
} CSR_MLME_DEL_PERIODIC_REQUEST;

typedef struct CSR_MLME_DEL_RX_TRIGGER_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_TRIGGER_ID                              TriggerId;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_DEL_RX_TRIGGER_CONFIRM;

typedef struct CSR_MLME_DEL_RX_TRIGGER_REQUEST
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_TRIGGER_ID                              TriggerId;
} CSR_MLME_DEL_RX_TRIGGER_REQUEST;

typedef struct CSR_MLME_DEL_TRIGGERED_GET_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
    CSR_TRIGGERED_ID                            TriggeredId;
} CSR_MLME_DEL_TRIGGERED_GET_CONFIRM;

typedef struct CSR_MLME_DEL_TRIGGERED_GET_REQUEST
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_TRIGGERED_ID                            TriggeredId;
} CSR_MLME_DEL_TRIGGERED_GET_REQUEST;

typedef struct CSR_MLME_DEL_WDS_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_DEL_WDS_CONFIRM;

typedef struct CSR_MLME_DEL_WDS_REQUEST
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              WdsApMacAddress;
} CSR_MLME_DEL_WDS_REQUEST;

typedef struct CSR_MLME_DISASSOCIATE_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_DISASSOCIATE_CONFIRM;

typedef struct CSR_MLME_DISASSOCIATE_INDICATION
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerStaAddress;
    CSR_REASON_CODE                             ReasonCode;
} CSR_MLME_DISASSOCIATE_INDICATION;

typedef struct CSR_MLME_DISASSOCIATE_REQUEST
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerStaAddress;
    CSR_REASON_CODE                             ReasonCode;
} CSR_MLME_DISASSOCIATE_REQUEST;

typedef struct CSR_MLME_DLS_CONFIRM
{
    CSR_DATAREF                                 SupportedRates;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerMacAddress;
    CSR_RESULT_CODE                             ResultCode;
    CSR_CAPABILITY_INFORMATION                  CapabilityInformation;
    CSR_SECONDS                                 DlsTimeoutValue;
} CSR_MLME_DLS_CONFIRM;

typedef struct CSR_MLME_DLS_INDICATION
{
    CSR_DATAREF                                 SupportedRates;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerMacAddress;
    CSR_CAPABILITY_INFORMATION                  CapabilityInformation;
    CSR_SECONDS                                 DlsTimeoutValue;
    CSR_TIME_UNITS                              DlsResponseTimeout;
} CSR_MLME_DLS_INDICATION;

typedef struct CSR_MLME_DLS_REQUEST
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerMacAddress;
    CSR_CAPABILITY_INFORMATION                  CapabilityInformation;
    CSR_SECONDS                                 DlsTimeoutValue;
    CSR_TIME_UNITS                              DlsResponseTimeout;
} CSR_MLME_DLS_REQUEST;

typedef struct CSR_MLME_DLSTEARDOWN_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerMacAddress1;
    CSR_MACADDRESS                              PeerMacAddress2;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_DLSTEARDOWN_CONFIRM;

typedef struct CSR_MLME_DLSTEARDOWN_INDICATION
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerMacAddress;
    CSR_REASON_CODE                             ReasonCode;
} CSR_MLME_DLSTEARDOWN_INDICATION;

typedef struct CSR_MLME_DLSTEARDOWN_REQUEST
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerMacAddress1;
    CSR_MACADDRESS                              PeerMacAddress2;
    CSR_REASON_CODE                             ReasonCode;
} CSR_MLME_DLSTEARDOWN_REQUEST;

typedef struct CSR_MLME_EAPOL_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
    CSR_PRIORITY                                ProvidedPriority;
    CSR_CLIENT_TAG                              ProvidedHostTag;
} CSR_MLME_EAPOL_CONFIRM;

typedef struct CSR_MLME_EAPOL_REQUEST
{
    CSR_DATAREF                                 Data;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              Sa;
    CSR_MACADDRESS                              Da;
    CSR_PRIORITY                                Priority;
    CSR_CLIENT_TAG                              HostTag;
} CSR_MLME_EAPOL_REQUEST;

typedef struct CSR_MLME_FT_JOIN_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_FT_JOIN_CONFIRM;

typedef struct CSR_MLME_FT_JOIN_REQUEST
{
    CSR_DATAREF                                 ScanInformationElements;
    CSR_DATAREF                                 StaInformationElements;
    CSR_IFINTERFACE                             Ifindex;
    CSR_MACADDRESS                              Bssid;
    CSR_TIME_UNITS                              BeaconPeriod;
    CSR_TSF_TIME                                Timestamp;
    CSR_TSF_TIME                                LocalTime;
    CSR_CHANNEL_NUMBER                          Channel;
    CSR_CAPABILITY_INFORMATION                  CapabilityInformation;
    CSR_BEACON_PERIODS                          JoinFailureTimeout;
    CSR_MICROSECONDS32                          ProbeDelay;
} CSR_MLME_FT_JOIN_REQUEST;

typedef struct CSR_MLME_GET_CONFIRM
{
    CSR_DATAREF                                 MibAttributeValue;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MIB_STATUS                              Status;
    CSR_NATURAL16                               ErrorIndex;
} CSR_MLME_GET_CONFIRM;

typedef struct CSR_MLME_GET_REQUEST
{
    CSR_DATAREF                                 MibAttribute;
    CSR_DATAREF                                 Dummydataref2;
} CSR_MLME_GET_REQUEST;

typedef struct CSR_MLME_GET_NEXT_CONFIRM
{
    CSR_DATAREF                                 MibAttributeValue;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MIB_STATUS                              Status;
    CSR_NATURAL16                               ErrorIndex;
} CSR_MLME_GET_NEXT_CONFIRM;

typedef struct CSR_MLME_GET_NEXT_REQUEST
{
    CSR_DATAREF                                 MibAttribute;
    CSR_DATAREF                                 Dummydataref2;
} CSR_MLME_GET_NEXT_REQUEST;

typedef struct CSR_MLME_HL_SYNC_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              GroupAddress;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_HL_SYNC_CONFIRM;

typedef struct CSR_MLME_HL_SYNC_REQUEST
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              GroupAddress;
} CSR_MLME_HL_SYNC_REQUEST;

typedef struct CSR_MLME_HL_SYNC_CANCEL_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              GroupAddress;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_HL_SYNC_CANCEL_CONFIRM;

typedef struct CSR_MLME_HL_SYNC_CANCEL_REQUEST
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              GroupAddress;
} CSR_MLME_HL_SYNC_CANCEL_REQUEST;

typedef struct CSR_MLME_JOIN_CONFIRM
{
    CSR_DATAREF                                 BeaconFrame;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_JOIN_CONFIRM;

typedef struct CSR_MLME_JOIN_REQUEST
{
    CSR_DATAREF                                 ScanInformationElements;
    CSR_DATAREF                                 StaInformationElements;
    CSR_IFINTERFACE                             Ifindex;
    CSR_MACADDRESS                              Bssid;
    CSR_TIME_UNITS                              BeaconPeriod;
    CSR_TSF_TIME                                Timestamp;
    CSR_TSF_TIME                                LocalTime;
    CSR_CHANNEL_NUMBER                          Channel;
    CSR_CAPABILITY_INFORMATION                  CapabilityInformation;
    CSR_BEACON_PERIODS                          JoinFailureTimeout;
    CSR_MICROSECONDS32                          ProbeDelay;
} CSR_MLME_JOIN_REQUEST;

typedef struct CSR_MLME_LINKMEASURE_REQUEST
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerMacAddress;
    CSR_DIALOG_TOKEN                            DialogToken;
    CSR_DECIBELS                                TransmitPower;
    CSR_DECIBELS                                MaxTransmitPower;
} CSR_MLME_LINKMEASURE_REQUEST;

typedef struct CSR_MLME_MEASURE_CONFIRM
{
    CSR_DATAREF                                 MeasurementReportSet;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
    CSR_DIALOG_TOKEN                            DialogToken;
} CSR_MLME_MEASURE_CONFIRM;

typedef struct CSR_MLME_MEASURE_REQUEST
{
    CSR_DATAREF                                 MeasurementRequestSet;
    CSR_DATAREF                                 Dummydataref2;
    CSR_DIALOG_TOKEN                            DialogToken;
} CSR_MLME_MEASURE_REQUEST;

typedef struct CSR_MLME_MICHAELMICFAILURE_INDICATION
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_NATURAL16                               Count;
    CSR_MACADDRESS                              Address;
    CSR_KEY_TYPE                                KeyType;
    CSR_NATURAL16                               KeyId;
    CSR_NATURAL16                               Tsc[4];
} CSR_MLME_MICHAELMICFAILURE_INDICATION;

typedef struct CSR_MLME_MREPORT_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_MREPORT_CONFIRM;

typedef struct CSR_MLME_MREPORT_INDICATION
{
    CSR_DATAREF                                 MeasurementReportSet;
    CSR_DATAREF                                 InformationElements;
    CSR_MACADDRESS                              PeerMacAddress;
    CSR_DIALOG_TOKEN                            DialogToken;
    CSR_MEASUREMENT_CATEGORY                    MeasurementCategory;
} CSR_MLME_MREPORT_INDICATION;

typedef struct CSR_MLME_MREPORT_REQUEST
{
    CSR_DATAREF                                 MeasurementReportSet;
    CSR_DATAREF                                 InformationElements;
    CSR_MACADDRESS                              PeerMacAddress;
    CSR_DIALOG_TOKEN                            DialogToken;
    CSR_MEASUREMENT_CATEGORY                    MeasurementCategory;
} CSR_MLME_MREPORT_REQUEST;

typedef struct CSR_MLME_MREQUEST_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_MREQUEST_CONFIRM;

typedef struct CSR_MLME_MREQUEST_INDICATION
{
    CSR_DATAREF                                 MeasurementRequestSet;
    CSR_DATAREF                                 InformationElements;
    CSR_MACADDRESS                              PeerMacAddress;
    CSR_DIALOG_TOKEN                            DialogToken;
    CSR_NATURAL16                               NumberOfRepetitions;
    CSR_MEASUREMENT_CATEGORY                    MeasurementCategory;
} CSR_MLME_MREQUEST_INDICATION;

typedef struct CSR_MLME_MREQUEST_REQUEST
{
    CSR_DATAREF                                 MeasurementRequestSet;
    CSR_DATAREF                                 InformationElements;
    CSR_MACADDRESS                              PeerMacAddress;
    CSR_DIALOG_TOKEN                            DialogToken;
    CSR_NATURAL16                               NumberOfRepetitions;
    CSR_MEASUREMENT_CATEGORY                    MeasurementCategory;
} CSR_MLME_MREQUEST_REQUEST;

typedef struct CSR_MLME_NEIGHBORREPREQ_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
    CSR_DIALOG_TOKEN                            DialogToken;
} CSR_MLME_NEIGHBORREPREQ_CONFIRM;

typedef struct CSR_MLME_NEIGHBORREPREQ_INDICATION
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerStaAddress;
    CSR_DIALOG_TOKEN                            DialogToken;
} CSR_MLME_NEIGHBORREPREQ_INDICATION;

typedef struct CSR_MLME_NEIGHBORREPREQ_REQUEST
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_DIALOG_TOKEN                            DialogToken;
} CSR_MLME_NEIGHBORREPREQ_REQUEST;

typedef struct CSR_MLME_NEIGHBORREPRESP_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
    CSR_DIALOG_TOKEN                            DialogToken;
} CSR_MLME_NEIGHBORREPRESP_CONFIRM;

typedef struct CSR_MLME_NEIGHBORREPRESP_INDICATION
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
    CSR_DIALOG_TOKEN                            DialogToken;
} CSR_MLME_NEIGHBORREPRESP_INDICATION;

typedef struct CSR_MLME_NEIGHBORREPRESP_REQUEST
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerStaAddress;
    CSR_DIALOG_TOKEN                            DialogToken;
} CSR_MLME_NEIGHBORREPRESP_REQUEST;

typedef struct CSR_MLME_PAUSE_AUTONOMOUS_SCAN_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
    CSR_AUTONOMOUS_SCAN_ID                      AutonomousScanId;
} CSR_MLME_PAUSE_AUTONOMOUS_SCAN_CONFIRM;

typedef struct CSR_MLME_PAUSE_AUTONOMOUS_SCAN_REQUEST
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_AUTONOMOUS_SCAN_ID                      AutonomousScanId;
    CsrInt16                                    Pause;
} CSR_MLME_PAUSE_AUTONOMOUS_SCAN_REQUEST;

typedef struct CSR_MLME_POWERMGT_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_POWERMGT_CONFIRM;

typedef struct CSR_MLME_POWERMGT_REQUEST
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_POWER_MANAGEMENT_MODE                   PowerManagementMode;
    CsrInt16                                    WakeUp;
    CsrInt16                                    ReceiveDtims;
    CSR_BEACON_PERIODS                          ListenInterval;
} CSR_MLME_POWERMGT_REQUEST;

typedef struct CSR_MLME_PROTECTEDFRAMEDROPPED_INDICATION
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              Address1;
    CSR_MACADDRESS                              Address2;
} CSR_MLME_PROTECTEDFRAMEDROPPED_INDICATION;

typedef struct CSR_MLME_REASSOCIATE_REQUEST
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              NewApAddress;
    CSR_TIME_UNITS                              ReassociateFailureTimeout;
    CSR_CAPABILITY_INFORMATION                  CapabilityInformation;
    CSR_BEACON_PERIODS                          ListenInterval;
} CSR_MLME_REASSOCIATE_REQUEST;

typedef struct CSR_MLME_REMOTE_REQUEST_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerMacAddress;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_REMOTE_REQUEST_CONFIRM;

typedef struct CSR_MLME_REMOTE_REQUEST_INDICATION
{
    CSR_DATAREF                                 ContentOfFtActionFrame;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerMacAddress;
} CSR_MLME_REMOTE_REQUEST_INDICATION;

typedef struct CSR_MLME_REMOTE_REQUEST_REQUEST
{
    CSR_DATAREF                                 ContentOfFtActionFrame;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerMacAddress;
} CSR_MLME_REMOTE_REQUEST_REQUEST;

typedef struct CSR_MLME_RESET_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_RESET_CONFIRM;

typedef struct CSR_MLME_RESET_REQUEST
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              StaAddress;
    CsrInt16                                    SetDefaultMib;
} CSR_MLME_RESET_REQUEST;

typedef struct CSR_MLME_RESOURCE_REQUEST_CONFIRM
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerMacAddress;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_RESOURCE_REQUEST_CONFIRM;

typedef struct CSR_MLME_RESOURCE_REQUEST_INDICATION
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerMacAddress;
} CSR_MLME_RESOURCE_REQUEST_INDICATION;

typedef struct CSR_MLME_RESOURCE_REQUEST_REQUEST
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerMacAddress;
} CSR_MLME_RESOURCE_REQUEST_REQUEST;

typedef struct CSR_MLME_RESOURCE_REQUEST_RESPONSE
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerMacAddress;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_RESOURCE_REQUEST_RESPONSE;

typedef struct CSR_MLME_RESOURCE_REQUEST_LOCAL_CONFIRM
{
    CSR_DATAREF                                 ResourceDescriptors;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              MacAddress;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_RESOURCE_REQUEST_LOCAL_CONFIRM;

typedef struct CSR_MLME_RESOURCE_REQUEST_LOCAL_REQUEST
{
    CSR_DATAREF                                 ResourceDescriptors;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              MacAddress;
} CSR_MLME_RESOURCE_REQUEST_LOCAL_REQUEST;

typedef struct CSR_MLME_SAQUERY_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerStaAddress;
    CSR_NATURAL16                               TransactionId[8];
} CSR_MLME_SAQUERY_CONFIRM;

typedef struct CSR_MLME_SAQUERY_INDICATION
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerStaAddress;
    CSR_NATURAL16                               TransactionId[8];
} CSR_MLME_SAQUERY_INDICATION;

typedef struct CSR_MLME_SAQUERY_REQUEST
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerStaAddress;
    CSR_NATURAL16                               TransactionId[8];
} CSR_MLME_SAQUERY_REQUEST;

typedef struct CSR_MLME_SAQUERY_RESPONSE
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerStaAddress;
    CSR_NATURAL16                               TransactionId[8];
} CSR_MLME_SAQUERY_RESPONSE;

typedef struct CSR_MLME_SCAN_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_SCAN_CONFIRM;

typedef struct CSR_MLME_SCAN_REQUEST
{
    CSR_DATAREF                                 ChannelList;
    CSR_DATAREF                                 InformationElements;
    CSR_IFINTERFACE                             Ifindex;
    CSR_BSS_TYPE                                BssType;
    CSR_MACADDRESS                              Da;
    CSR_MACADDRESS                              Bssid;
    CSR_SCAN_TYPE                               ScanType;
    CSR_MICROSECONDS32                          ProbeDelay;
    CSR_TIME_UNITS                              MinChannelTime;
    CSR_TIME_UNITS                              MaxChannelTime;
} CSR_MLME_SCAN_REQUEST;

typedef struct CSR_MLME_SCAN_CANCEL_REQUEST
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
} CSR_MLME_SCAN_CANCEL_REQUEST;

typedef struct CSR_MLME_SCHEDULE_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_SCHEDULE_CONFIRM;

typedef struct CSR_MLME_SCHEDULE_INDICATION
{
    CSR_DATAREF                                 ScheduleElement;
    CSR_DATAREF                                 Dummydataref2;
} CSR_MLME_SCHEDULE_INDICATION;

typedef struct CSR_MLME_SCHEDULE_REQUEST
{
    CSR_DATAREF                                 ScheduleElement;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              NonapQstaAddress;
} CSR_MLME_SCHEDULE_REQUEST;

typedef struct CSR_MLME_SET_CONFIRM
{
    CSR_DATAREF                                 MibAttributeValue;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MIB_STATUS                              Status;
    CSR_NATURAL16                               ErrorIndex;
} CSR_MLME_SET_CONFIRM;

typedef struct CSR_MLME_SET_REQUEST
{
    CSR_DATAREF                                 MibAttributeValue;
    CSR_DATAREF                                 Dummydataref2;
} CSR_MLME_SET_REQUEST;

typedef struct CSR_MLME_SETKEYS_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_SETKEYS_CONFIRM;

typedef struct CSR_MLME_SETKEYS_REQUEST
{
    CSR_DATAREF                                 Key;
    CSR_DATAREF                                 Dummydataref2;
    CSR_NATURAL16                               Length;
    CSR_NATURAL16                               KeyId;
    CSR_KEY_TYPE                                KeyType;
    CSR_MACADDRESS                              Address;
    CSR_NATURAL16                               SequenceNumber[8];
    CsrInt16                                    AuthenticatorSupplicantOrInitiatorPeer;
    CSR_CIPHER_SUITE_SELECTOR                   CipherSuiteSelector;
} CSR_MLME_SETKEYS_REQUEST;

typedef struct CSR_MLME_SETPROTECTION_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_SETPROTECTION_CONFIRM;

typedef struct CSR_MLME_SETPROTECTION_REQUEST
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              Address;
    CSR_PROTECT_TYPE                            ProtectType;
    CSR_KEY_TYPE                                KeyType;
} CSR_MLME_SETPROTECTION_REQUEST;

typedef struct CSR_MLME_SET_UNITDATA_FILTER_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_SET_UNITDATA_FILTER_CONFIRM;

typedef struct CSR_MLME_SET_UNITDATA_FILTER_REQUEST
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_UNIT_DATA_FILTER_MODE                   UnitDataFilterMode;
    CSR_IPV4_ADDRESS                            ArpFilterAddress;
} CSR_MLME_SET_UNITDATA_FILTER_REQUEST;

typedef struct CSR_MLME_SNIFFJOIN_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             Resultcode;
} CSR_MLME_SNIFFJOIN_CONFIRM;

typedef struct CSR_MLME_SNIFFJOIN_REQUEST
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_IFINTERFACE                             Ifindex;
    CSR_CHANNEL_NUMBER                          Channel;
    CSR_CHANNEL_STARTING_FACTOR                 ChannelStartingFactor;
} CSR_MLME_SNIFFJOIN_REQUEST;

typedef struct CSR_MLME_STAKEYESTABLISHED_INDICATION
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              Address1;
    CSR_MACADDRESS                              Address2;
} CSR_MLME_STAKEYESTABLISHED_INDICATION;

typedef struct CSR_MLME_START_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
    CSR_MACADDRESS                              Bssid;
} CSR_MLME_START_CONFIRM;

typedef struct CSR_MLME_START_REQUEST
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_IFINTERFACE                             Ifindex;
    CSR_TIME_UNITS                              BeaconPeriod;
    CSR_CHANNEL_NUMBER                          Channel;
    CSR_MICROSECONDS32                          ProbeDelay;
    CSR_CAPABILITY_INFORMATION                  CapabilityInformation;
    CsrInt16                                    BluetoothAmp;
} CSR_MLME_START_REQUEST;

typedef struct CSR_MLME_TRIGGERED_GET_INDICATION
{
    CSR_DATAREF                                 MibAttributeValue;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MIB_STATUS                              Status;
    CSR_NATURAL16                               ErrorIndex;
    CSR_TRIGGERED_ID                            TriggeredId;
} CSR_MLME_TRIGGERED_GET_INDICATION;

typedef struct CSR_MLME_VSPECIFIC_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
} CSR_MLME_VSPECIFIC_CONFIRM;

typedef struct CSR_MLME_VSPECIFIC_INDICATION
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerMacAddress;
} CSR_MLME_VSPECIFIC_INDICATION;

typedef struct CSR_MLME_VSPECIFIC_REQUEST
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerMacAddress;
} CSR_MLME_VSPECIFIC_REQUEST;

typedef CsrUint16 CSR_PROCESS_ID;

typedef CsrUint16 CSR_RCPI;

typedef CsrUint16 CSR_RSNI;

typedef CsrUint16 CSR_RATE;

typedef CsrUint16 CSR_REPORTED_FRAME;

typedef CsrUint16 CSR_SEQUENCE_NUMBER;

typedef struct CSR_SIGNAL_PRIMITIVE_HEADER
{
    CsrInt16                                    SignalId;
    CSR_PROCESS_ID                              ReceiverProcessId;
    CSR_PROCESS_ID                              SenderProcessId;
} CSR_SIGNAL_PRIMITIVE_HEADER;

typedef CsrUint32 CSR_TS_INFO;

typedef struct CSR_DEBUG_GENERIC_CONFIRM
{
    CSR_DATAREF                                 DebugVariable;
    CSR_DATAREF                                 Dummydataref2;
    CSR_NATURAL16                               DebugWords[8];
} CSR_DEBUG_GENERIC_CONFIRM;

typedef struct CSR_DEBUG_GENERIC_INDICATION
{
    CSR_DATAREF                                 DebugVariable;
    CSR_DATAREF                                 Dummydataref2;
    CSR_NATURAL16                               DebugWords[8];
} CSR_DEBUG_GENERIC_INDICATION;

typedef struct CSR_DEBUG_GENERIC_REQUEST
{
    CSR_DATAREF                                 DebugVariable;
    CSR_DATAREF                                 Dummydataref2;
    CSR_NATURAL16                               DebugWords[8];
} CSR_DEBUG_GENERIC_REQUEST;

typedef struct CSR_DEBUG_STRING_INDICATION
{
    CSR_DATAREF                                 DebugMessage;
    CSR_DATAREF                                 Dummydataref2;
} CSR_DEBUG_STRING_INDICATION;

typedef struct CSR_DEBUG_WORD16_INDICATION
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_NATURAL16                               DebugWords[16];
} CSR_DEBUG_WORD16_INDICATION;

typedef struct CSR_DS_STA_NOTIFY_REQUEST
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              StaAddress;
    CSR_UPDATE_TYPE                             UpdateType;
} CSR_DS_STA_NOTIFY_REQUEST;

typedef struct CSR_DS_UNITDATA_INDICATION
{
    CSR_DATAREF                                 Data;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              Da;
    CSR_MACADDRESS                              Sa;
    CSR_ROUTING_INFORMATION                     RoutingInformation;
    CSR_RECEPTION_STATUS                        ReceptionStatus;
    CSR_PRIORITY                                Priority;
    CSR_SERVICE_CLASS                           ServiceClass;
    CSR_CLIENT_TAG                              HostTag;
} CSR_DS_UNITDATA_INDICATION;

typedef struct CSR_DS_UNITDATA_REQUEST
{
    CSR_DATAREF                                 Data;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              Da;
    CSR_MACADDRESS                              Sa;
    CSR_ROUTING_INFORMATION                     RoutingInformation;
    CSR_PRIORITY                                Priority;
    CSR_SERVICE_CLASS                           ServiceClass;
    CSR_SOURCE_TYPE                             SourceType;
} CSR_DS_UNITDATA_REQUEST;

typedef struct CSR_DS_UNITDATA_RESPONSE
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              Da;
    CSR_MACADDRESS                              Sa;
    CSR_TRANSMISSION_STATUS                     TransmissionStatus;
    CSR_ROUTING_INFORMATION                     RoutingInformation;
    CSR_PRIORITY                                ProvidedPriority;
    CSR_SERVICE_CLASS                           ProvidedServiceClass;
    CSR_CLIENT_TAG                              ProvidedHostTag;
} CSR_DS_UNITDATA_RESPONSE;

typedef struct CSR_DS_UNITDATA_CANCEL_INDICATION
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_CLIENT_TAG                              HostTag;
} CSR_DS_UNITDATA_CANCEL_INDICATION;

typedef struct CSR_MA_PACKET_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_TRANSMISSION_STATUS                     TransmissionStatus;
    CSR_NATURAL16                               RetryCount;
    CSR_RATE                                    Rate;
    CSR_CLIENT_TAG                              HostTag;
} CSR_MA_PACKET_CONFIRM;

typedef struct CSR_MA_PACKET_INDICATION
{
    CSR_DATAREF                                 Data;
    CSR_DATAREF                                 Dummydataref2;
    CSR_TSF_TIME                                LocalTime;
    CSR_CHANNEL_NUMBER                          Channel;
    CSR_RECEPTION_STATUS                        ReceptionStatus;
    CSR_DECIBELS                                Rssi;
    CSR_DECIBELS                                Snr;
    CSR_RATE                                    Rate;
    CSR_RCPI                                    RcpiMeasurement;
    CSR_RSNI                                    RsniMeasurement;
    CSR_NATURAL16                               MsduFragmentNumber;
} CSR_MA_PACKET_INDICATION;

typedef struct CSR_MA_PACKET_REQUEST
{
    CSR_DATAREF                                 Data;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RATE                                    TransmitRate;
    CSR_CLIENT_TAG                              HostTag;
    CSR_PRIORITY                                Priority;
} CSR_MA_PACKET_REQUEST;

typedef struct CSR_MA_SNIFFDATA_INDICATION
{
    CSR_DATAREF                                 Data;
    CSR_DATAREF                                 Dummydataref2;
    CSR_TSF_TIME                                Timestamp;
    CSR_MICROSECONDS16                          Duration;
    CSR_RATE                                    Rate;
    CSR_ANTENNA_ID                              AntennaId;
    CSR_DECIBELS                                Rssi;
    CSR_DECIBELS                                Snr;
    CSR_HERTZ_DELTA                             FrequencyOffset;
    CSR_SNIFFER_RECEPTION_STATUS                ReceptionStatus;
} CSR_MA_SNIFFDATA_INDICATION;

typedef struct CSR_MA_UNITDATA_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              Da;
    CSR_MACADDRESS                              Sa;
    CSR_TRANSMISSION_STATUS                     TransmissionStatus;
    CSR_PRIORITY                                ProvidedPriority;
    CSR_SERVICE_CLASS                           ProvidedServiceClass;
    CSR_CLIENT_TAG                              ProvidedHostTag;
    CSR_RATE                                    Rate;
} CSR_MA_UNITDATA_CONFIRM;

typedef struct CSR_MA_UNITDATA_INDICATION
{
    CSR_DATAREF                                 Data;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              Da;
    CSR_MACADDRESS                              Sa;
    CSR_ROUTING_INFORMATION                     RoutingInformation;
    CSR_RECEPTION_STATUS                        ReceptionStatus;
    CSR_PRIORITY                                Priority;
    CSR_SERVICE_CLASS                           ServiceClass;
    CSR_DECIBELS                                Rssi;
    CSR_DECIBELS                                Snr;
    CSR_RATE                                    Rate;
} CSR_MA_UNITDATA_INDICATION;

typedef struct CSR_MLME_ADDBA_REQUEST
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerQstaAddress;
    CSR_DIALOG_TOKEN                            DialogToken;
    CSR_PRIORITY                                Tid;
    CSR_BLOCK_ACK_POLICY                        BlockAckPolicy;
    CSR_NATURAL16                               BufferSize;
    CSR_TIME_UNITS                              BlockAckTimeout;
    CSR_TIME_UNITS                              AddbaFailureTimeout;
    CSR_SEQUENCE_NUMBER                         BlockAckStartingSequenceControl;
} CSR_MLME_ADDBA_REQUEST;

typedef struct CSR_MLME_ASSOCIATE_CONFIRM
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 ExchangedFrames;
    CSR_RESULT_CODE                             ResultCode;
    CSR_CAPABILITY_INFORMATION                  CapabilityInformation;
    CSR_ASSOCIATION_ID                          AssociationId;
    CSR_RCPI                                    RcpiRequest;
    CSR_RSNI                                    RsniRequest;
    CSR_RCPI                                    RcpiResponse;
    CSR_RSNI                                    RsniResponse;
} CSR_MLME_ASSOCIATE_CONFIRM;

typedef struct CSR_MLME_ASSOCIATE_INDICATION
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerStaAddress;
    CSR_CAPABILITY_INFORMATION                  CapabilityInformation;
    CSR_BEACON_PERIODS                          ListenInterval;
    CSR_RCPI                                    RcpiRequest;
    CSR_RSNI                                    RsniRequest;
} CSR_MLME_ASSOCIATE_INDICATION;

typedef struct CSR_MLME_ASSOCIATE_RESPONSE
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerStaAddress;
    CSR_RESULT_CODE                             ResultCode;
    CSR_CAPABILITY_INFORMATION                  CapabilityInformation;
    CSR_ASSOCIATION_ID                          AssociationId;
    CSR_RCPI                                    RcpiRequest;
    CSR_RSNI                                    RsniRequest;
} CSR_MLME_ASSOCIATE_RESPONSE;

typedef struct CSR_MLME_AUTONOMOUS_SCAN_INDICATION
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_AUTONOMOUS_SCAN_ID                      AutonomousScanId;
    CSR_BSS_TYPE                                BssType;
    CSR_MACADDRESS                              Bssid;
    CSR_TIME_UNITS                              BeaconPeriod;
    CSR_TSF_TIME                                Timestamp;
    CSR_TSF_TIME                                LocalTime;
    CSR_CHANNEL_NUMBER                          Channel;
    CSR_MEGAHERTZ                               ChannelFrequency;
    CSR_CAPABILITY_INFORMATION                  CapabilityInformation;
    CSR_DECIBELS                                Rssi;
    CSR_DECIBELS                                Snr;
    CSR_REPORTED_FRAME                          ReportedFrameInformation;
    CSR_RCPI                                    RcpiMeasurement;
    CSR_RSNI                                    RsniMeasurement;
} CSR_MLME_AUTONOMOUS_SCAN_INDICATION;

typedef struct CSR_MLME_DELTS_CONFIRM
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
    CSR_MACADDRESS                              NonapQstaAddress;
    CSR_TS_INFO                                 TsInfo;
} CSR_MLME_DELTS_CONFIRM;

typedef struct CSR_MLME_DELTS_INDICATION
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              NonapQstaAddress;
    CSR_TS_INFO                                 TsInfo;
    CSR_REASON_CODE                             ReasonCode;
} CSR_MLME_DELTS_INDICATION;

typedef struct CSR_MLME_DELTS_REQUEST
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              NonapQstaAddress;
    CSR_TS_INFO                                 TsInfo;
    CSR_REASON_CODE                             ReasonCode;
} CSR_MLME_DELTS_REQUEST;

typedef struct CSR_MLME_HL_SYNC_INDICATION
{
    CSR_DATAREF                                 Dummydataref1;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              GroupAddress;
    CSR_MACADDRESS                              SourceAddress;
    CSR_SEQUENCE_NUMBER                         SequenceNumber;
} CSR_MLME_HL_SYNC_INDICATION;

typedef struct CSR_MLME_LINKMEASURE_CONFIRM
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
    CSR_DIALOG_TOKEN                            DialogToken;
    CSR_DECIBELS                                TransmitPower;
    CSR_DECIBELS                                LinkMargin;
    CSR_ANTENNA_ID                              ReceiveAntennaId;
    CSR_ANTENNA_ID                              TransmitAntennaId;
    CSR_RCPI                                    RcpiRequest;
    CSR_RSNI                                    RsniRequest;
    CSR_RCPI                                    RcpiReport;
    CSR_RSNI                                    RsniReport;
} CSR_MLME_LINKMEASURE_CONFIRM;

typedef struct CSR_MLME_REASSOCIATE_CONFIRM
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 ExchangedFrames;
    CSR_RESULT_CODE                             ResultCode;
    CSR_CAPABILITY_INFORMATION                  CapabilityInformation;
    CSR_ASSOCIATION_ID                          AssociationId;
    CSR_RCPI                                    RcpiRequest;
    CSR_RSNI                                    RsniRequest;
    CSR_RCPI                                    RcpiResponse;
    CSR_RSNI                                    RsniResponse;
} CSR_MLME_REASSOCIATE_CONFIRM;

typedef struct CSR_MLME_REASSOCIATE_INDICATION
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerStaAddress;
    CSR_MACADDRESS                              CurrentApAddress;
    CSR_CAPABILITY_INFORMATION                  CapabilityInformation;
    CSR_BEACON_PERIODS                          ListenInterval;
    CSR_RCPI                                    RcpiRequest;
    CSR_RSNI                                    RsniRequest;
} CSR_MLME_REASSOCIATE_INDICATION;

typedef struct CSR_MLME_REASSOCIATE_RESPONSE
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerStaAddress;
    CSR_RESULT_CODE                             ResultCode;
    CSR_CAPABILITY_INFORMATION                  CapabilityInformation;
    CSR_ASSOCIATION_ID                          AssociationId;
    CSR_RCPI                                    RcpiRequest;
    CSR_RSNI                                    RsniRequest;
} CSR_MLME_REASSOCIATE_RESPONSE;

typedef struct CSR_MLME_SCAN_INDICATION
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_IFINTERFACE                             Ifindex;
    CSR_BSS_TYPE                                BssType;
    CSR_MACADDRESS                              Bssid;
    CSR_TIME_UNITS                              BeaconPeriod;
    CSR_TSF_TIME                                Timestamp;
    CSR_TSF_TIME                                LocalTime;
    CSR_CHANNEL_NUMBER                          Channel;
    CSR_MEGAHERTZ                               ChannelFrequency;
    CSR_CAPABILITY_INFORMATION                  CapabilityInformation;
    CSR_DECIBELS                                Rssi;
    CSR_DECIBELS                                Snr;
    CSR_REPORTED_FRAME                          ReportedFrameInformation;
    CSR_RCPI                                    RcpiMeasurement;
    CSR_RSNI                                    RsniMeasurement;
} CSR_MLME_SCAN_INDICATION;

typedef struct CSR_MLME_TPCADAPT_CONFIRM
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_RESULT_CODE                             ResultCode;
    CSR_DIALOG_TOKEN                            DialogToken;
    CSR_RATE                                    RequestRate;
    CSR_DECIBELS                                RequestTransmitPower;
    CSR_DECIBELS                                RequestLinkMargin;
    CSR_RATE                                    ReportRate;
    CSR_DECIBELS                                ReportTransmitPower;
    CSR_DECIBELS                                ReportLinkMargin;
} CSR_MLME_TPCADAPT_CONFIRM;

typedef struct CSR_MLME_TPCADAPT_REQUEST
{
    CSR_DATAREF                                 InformationElements;
    CSR_DATAREF                                 Dummydataref2;
    CSR_MACADDRESS                              PeerMacAddress;
    CSR_DIALOG_TOKEN                            DialogToken;
    CSR_RATE                                    TransmitRate;
    CSR_TIME_UNITS                              TpcadaptFailureTimeout;
} CSR_MLME_TPCADAPT_REQUEST;

typedef struct CSR_SIGNAL_PRIMITIVE
{
    CSR_SIGNAL_PRIMITIVE_HEADER                 SignalPrimitiveHeader;
    union
    {
        CSR_MA_UNITDATA_REQUEST                     MaUnitdataRequest;
        CSR_MA_UNITDATA_CONFIRM                     MaUnitdataConfirm;
        CSR_MA_UNITDATA_INDICATION                  MaUnitdataIndication;
        CSR_MA_SNIFFDATA_INDICATION                 MaSniffdataIndication;
        CSR_MA_UNITDATA_CANCEL_REQUEST              MaUnitdataCancelRequest;
        CSR_MA_PACKET_REQUEST                       MaPacketRequest;
        CSR_MA_PACKET_CONFIRM                       MaPacketConfirm;
        CSR_MA_PACKET_INDICATION                    MaPacketIndication;
        CSR_MLME_RESET_REQUEST                      MlmeResetRequest;
        CSR_MLME_RESET_CONFIRM                      MlmeResetConfirm;
        CSR_MLME_GET_REQUEST                        MlmeGetRequest;
        CSR_MLME_GET_CONFIRM                        MlmeGetConfirm;
        CSR_MLME_SET_REQUEST                        MlmeSetRequest;
        CSR_MLME_SET_CONFIRM                        MlmeSetConfirm;
        CSR_MLME_GET_NEXT_REQUEST                   MlmeGetNextRequest;
        CSR_MLME_GET_NEXT_CONFIRM                   MlmeGetNextConfirm;
        CSR_MLME_POWERMGT_REQUEST                   MlmePowermgtRequest;
        CSR_MLME_POWERMGT_CONFIRM                   MlmePowermgtConfirm;
        CSR_MLME_SCAN_REQUEST                       MlmeScanRequest;
        CSR_MLME_SCAN_CONFIRM                       MlmeScanConfirm;
        CSR_MLME_SCAN_INDICATION                    MlmeScanIndication;
        CSR_MLME_JOIN_REQUEST                       MlmeJoinRequest;
        CSR_MLME_JOIN_CONFIRM                       MlmeJoinConfirm;
        CSR_MLME_AUTHENTICATE_REQUEST               MlmeAuthenticateRequest;
        CSR_MLME_AUTHENTICATE_CONFIRM               MlmeAuthenticateConfirm;
        CSR_MLME_AUTHENTICATE_RESPONSE              MlmeAuthenticateResponse;
        CSR_MLME_AUTHENTICATE_INDICATION            MlmeAuthenticateIndication;
        CSR_MLME_DEAUTHENTICATE_REQUEST             MlmeDeauthenticateRequest;
        CSR_MLME_DEAUTHENTICATE_CONFIRM             MlmeDeauthenticateConfirm;
        CSR_MLME_DEAUTHENTICATE_INDICATION          MlmeDeauthenticateIndication;
        CSR_MLME_ASSOCIATE_REQUEST                  MlmeAssociateRequest;
        CSR_MLME_ASSOCIATE_CONFIRM                  MlmeAssociateConfirm;
        CSR_MLME_ASSOCIATE_RESPONSE                 MlmeAssociateResponse;
        CSR_MLME_ASSOCIATE_INDICATION               MlmeAssociateIndication;
        CSR_MLME_REASSOCIATE_REQUEST                MlmeReassociateRequest;
        CSR_MLME_REASSOCIATE_CONFIRM                MlmeReassociateConfirm;
        CSR_MLME_REASSOCIATE_RESPONSE               MlmeReassociateResponse;
        CSR_MLME_REASSOCIATE_INDICATION             MlmeReassociateIndication;
        CSR_MLME_DISASSOCIATE_REQUEST               MlmeDisassociateRequest;
        CSR_MLME_DISASSOCIATE_CONFIRM               MlmeDisassociateConfirm;
        CSR_MLME_DISASSOCIATE_INDICATION            MlmeDisassociateIndication;
        CSR_MLME_START_REQUEST                      MlmeStartRequest;
        CSR_MLME_START_CONFIRM                      MlmeStartConfirm;
        CSR_MLME_ADDTS_REQUEST                      MlmeAddtsRequest;
        CSR_MLME_ADDTS_CONFIRM                      MlmeAddtsConfirm;
        CSR_MLME_ADDTS_RESPONSE                     MlmeAddtsResponse;
        CSR_MLME_ADDTS_INDICATION                   MlmeAddtsIndication;
        CSR_MLME_DELTS_REQUEST                      MlmeDeltsRequest;
        CSR_MLME_DELTS_CONFIRM                      MlmeDeltsConfirm;
        CSR_MLME_DELTS_INDICATION                   MlmeDeltsIndication;
        CSR_MLME_DLS_REQUEST                        MlmeDlsRequest;
        CSR_MLME_DLS_CONFIRM                        MlmeDlsConfirm;
        CSR_MLME_DLS_INDICATION                     MlmeDlsIndication;
        CSR_MLME_DLSTEARDOWN_REQUEST                MlmeDlsteardownRequest;
        CSR_MLME_DLSTEARDOWN_CONFIRM                MlmeDlsteardownConfirm;
        CSR_MLME_DLSTEARDOWN_INDICATION             MlmeDlsteardownIndication;
        CSR_MLME_HL_SYNC_REQUEST                    MlmeHlSyncRequest;
        CSR_MLME_HL_SYNC_CONFIRM                    MlmeHlSyncConfirm;
        CSR_MLME_HL_SYNC_INDICATION                 MlmeHlSyncIndication;
        CSR_MLME_ADDBA_REQUEST                      MlmeAddbaRequest;
        CSR_MLME_ADDBA_CONFIRM                      MlmeAddbaConfirm;
        CSR_MLME_ADDBA_RESPONSE                     MlmeAddbaResponse;
        CSR_MLME_ADDBA_INDICATION                   MlmeAddbaIndication;
        CSR_MLME_DELBA_REQUEST                      MlmeDelbaRequest;
        CSR_MLME_DELBA_CONFIRM                      MlmeDelbaConfirm;
        CSR_MLME_DELBA_INDICATION                   MlmeDelbaIndication;
        CSR_MLME_SCHEDULE_REQUEST                   MlmeScheduleRequest;
        CSR_MLME_SCHEDULE_CONFIRM                   MlmeScheduleConfirm;
        CSR_MLME_SCHEDULE_INDICATION                MlmeScheduleIndication;
        CSR_MLME_MREQUEST_REQUEST                   MlmeMrequestRequest;
        CSR_MLME_MREQUEST_CONFIRM                   MlmeMrequestConfirm;
        CSR_MLME_MREQUEST_INDICATION                MlmeMrequestIndication;
        CSR_MLME_MEASURE_REQUEST                    MlmeMeasureRequest;
        CSR_MLME_MEASURE_CONFIRM                    MlmeMeasureConfirm;
        CSR_MLME_MREPORT_REQUEST                    MlmeMreportRequest;
        CSR_MLME_MREPORT_CONFIRM                    MlmeMreportConfirm;
        CSR_MLME_MREPORT_INDICATION                 MlmeMreportIndication;
        CSR_MLME_CHANNELSWITCH_REQUEST              MlmeChannelswitchRequest;
        CSR_MLME_CHANNELSWITCH_CONFIRM              MlmeChannelswitchConfirm;
        CSR_MLME_CHANNELSWITCH_RESPONSE             MlmeChannelswitchResponse;
        CSR_MLME_CHANNELSWITCH_INDICATION           MlmeChannelswitchIndication;
        CSR_MLME_TPCADAPT_REQUEST                   MlmeTpcadaptRequest;
        CSR_MLME_TPCADAPT_CONFIRM                   MlmeTpcadaptConfirm;
        CSR_MLME_SETKEYS_REQUEST                    MlmeSetkeysRequest;
        CSR_MLME_SETKEYS_CONFIRM                    MlmeSetkeysConfirm;
        CSR_MLME_DELETEKEYS_REQUEST                 MlmeDeletekeysRequest;
        CSR_MLME_DELETEKEYS_CONFIRM                 MlmeDeletekeysConfirm;
        CSR_MLME_MICHAELMICFAILURE_INDICATION       MlmeMichaelmicfailureIndication;
        CSR_MLME_EAPOL_REQUEST                      MlmeEapolRequest;
        CSR_MLME_EAPOL_CONFIRM                      MlmeEapolConfirm;
        CSR_MLME_STAKEYESTABLISHED_INDICATION       MlmeStakeyestablishedIndication;
        CSR_MLME_SETPROTECTION_REQUEST              MlmeSetprotectionRequest;
        CSR_MLME_SETPROTECTION_CONFIRM              MlmeSetprotectionConfirm;
        CSR_MLME_PROTECTEDFRAMEDROPPED_INDICATION   MlmeProtectedframedroppedIndication;
        CSR_MLME_SNIFFJOIN_REQUEST                  MlmeSniffjoinRequest;
        CSR_MLME_SNIFFJOIN_CONFIRM                  MlmeSniffjoinConfirm;
        CSR_MLME_CONNECTED_INDICATION               MlmeConnectedIndication;
        CSR_MLME_SCAN_CANCEL_REQUEST                MlmeScanCancelRequest;
        CSR_MLME_LINKMEASURE_REQUEST                MlmeLinkmeasureRequest;
        CSR_MLME_LINKMEASURE_CONFIRM                MlmeLinkmeasureConfirm;
        CSR_MLME_HL_SYNC_CANCEL_REQUEST             MlmeHlSyncCancelRequest;
        CSR_MLME_HL_SYNC_CANCEL_CONFIRM             MlmeHlSyncCancelConfirm;
        CSR_MLME_ADD_PERIODIC_REQUEST               MlmeAddPeriodicRequest;
        CSR_MLME_ADD_PERIODIC_CONFIRM               MlmeAddPeriodicConfirm;
        CSR_MLME_DEL_PERIODIC_REQUEST               MlmeDelPeriodicRequest;
        CSR_MLME_DEL_PERIODIC_CONFIRM               MlmeDelPeriodicConfirm;
        CSR_MLME_ADD_AUTONOMOUS_SCAN_REQUEST        MlmeAddAutonomousScanRequest;
        CSR_MLME_ADD_AUTONOMOUS_SCAN_CONFIRM        MlmeAddAutonomousScanConfirm;
        CSR_MLME_DEL_AUTONOMOUS_SCAN_REQUEST        MlmeDelAutonomousScanRequest;
        CSR_MLME_DEL_AUTONOMOUS_SCAN_CONFIRM        MlmeDelAutonomousScanConfirm;
        CSR_MLME_AUTONOMOUS_SCAN_INDICATION         MlmeAutonomousScanIndication;
        CSR_MLME_AUTONOMOUS_SCAN_RESULTS_REQUEST    MlmeAutonomousScanResultsRequest;
        CSR_MLME_AUTONOMOUS_SCAN_RESULTS_CONFIRM    MlmeAutonomousScanResultsConfirm;
        CSR_MLME_AUTONOMOUS_SCAN_RESULTS_INDICATION MlmeAutonomousScanResultsIndication;
        CSR_MLME_SET_UNITDATA_FILTER_REQUEST        MlmeSetUnitdataFilterRequest;
        CSR_MLME_SET_UNITDATA_FILTER_CONFIRM        MlmeSetUnitdataFilterConfirm;
        CSR_MLME_FT_JOIN_REQUEST                    MlmeFtJoinRequest;
        CSR_MLME_FT_JOIN_CONFIRM                    MlmeFtJoinConfirm;
        CSR_MLME_RESOURCE_REQUEST_REQUEST           MlmeResourceRequestRequest;
        CSR_MLME_RESOURCE_REQUEST_CONFIRM           MlmeResourceRequestConfirm;
        CSR_MLME_RESOURCE_REQUEST_RESPONSE          MlmeResourceRequestResponse;
        CSR_MLME_RESOURCE_REQUEST_INDICATION        MlmeResourceRequestIndication;
        CSR_MLME_RESOURCE_REQUEST_LOCAL_REQUEST     MlmeResourceRequestLocalRequest;
        CSR_MLME_RESOURCE_REQUEST_LOCAL_CONFIRM     MlmeResourceRequestLocalConfirm;
        CSR_MLME_REMOTE_REQUEST_REQUEST             MlmeRemoteRequestRequest;
        CSR_MLME_REMOTE_REQUEST_CONFIRM             MlmeRemoteRequestConfirm;
        CSR_MLME_REMOTE_REQUEST_INDICATION          MlmeRemoteRequestIndication;
        CSR_MLME_PAUSE_AUTONOMOUS_SCAN_REQUEST      MlmePauseAutonomousScanRequest;
        CSR_MLME_PAUSE_AUTONOMOUS_SCAN_CONFIRM      MlmePauseAutonomousScanConfirm;
        CSR_MLME_NEIGHBORREPREQ_REQUEST             MlmeNeighborrepreqRequest;
        CSR_MLME_NEIGHBORREPREQ_CONFIRM             MlmeNeighborrepreqConfirm;
        CSR_MLME_NEIGHBORREPREQ_INDICATION          MlmeNeighborrepreqIndication;
        CSR_MLME_NEIGHBORREPRESP_REQUEST            MlmeNeighborreprespRequest;
        CSR_MLME_NEIGHBORREPRESP_CONFIRM            MlmeNeighborreprespConfirm;
        CSR_MLME_NEIGHBORREPRESP_INDICATION         MlmeNeighborreprespIndication;
        CSR_MLME_AUTONOMOUS_SCAN_DONE_INDICATION    MlmeAutonomousScanDoneIndication;
        CSR_MLME_ADD_TRIGGERED_GET_REQUEST          MlmeAddTriggeredGetRequest;
        CSR_MLME_ADD_TRIGGERED_GET_CONFIRM          MlmeAddTriggeredGetConfirm;
        CSR_MLME_DEL_TRIGGERED_GET_REQUEST          MlmeDelTriggeredGetRequest;
        CSR_MLME_DEL_TRIGGERED_GET_CONFIRM          MlmeDelTriggeredGetConfirm;
        CSR_MLME_TRIGGERED_GET_INDICATION           MlmeTriggeredGetIndication;
        CSR_MLME_VSPECIFIC_REQUEST                  MlmeVspecificRequest;
        CSR_MLME_VSPECIFIC_CONFIRM                  MlmeVspecificConfirm;
        CSR_MLME_VSPECIFIC_INDICATION               MlmeVspecificIndication;
        CSR_MLME_ADD_WDS_REQUEST                    MlmeAddWdsRequest;
        CSR_MLME_ADD_WDS_CONFIRM                    MlmeAddWdsConfirm;
        CSR_MLME_DEL_WDS_REQUEST                    MlmeDelWdsRequest;
        CSR_MLME_DEL_WDS_CONFIRM                    MlmeDelWdsConfirm;
        CSR_MLME_ADD_BLACKOUT_REQUEST               MlmeAddBlackoutRequest;
        CSR_MLME_ADD_BLACKOUT_CONFIRM               MlmeAddBlackoutConfirm;
        CSR_MLME_DEL_BLACKOUT_REQUEST               MlmeDelBlackoutRequest;
        CSR_MLME_DEL_BLACKOUT_CONFIRM               MlmeDelBlackoutConfirm;
        CSR_MLME_SAQUERY_REQUEST                    MlmeSaqueryRequest;
        CSR_MLME_SAQUERY_CONFIRM                    MlmeSaqueryConfirm;
        CSR_MLME_SAQUERY_RESPONSE                   MlmeSaqueryResponse;
        CSR_MLME_SAQUERY_INDICATION                 MlmeSaqueryIndication;
        CSR_MLME_ADD_RX_TRIGGER_REQUEST             MlmeAddRxTriggerRequest;
        CSR_MLME_ADD_RX_TRIGGER_CONFIRM             MlmeAddRxTriggerConfirm;
        CSR_MLME_DEL_RX_TRIGGER_REQUEST             MlmeDelRxTriggerRequest;
        CSR_MLME_DEL_RX_TRIGGER_CONFIRM             MlmeDelRxTriggerConfirm;
        CSR_DS_UNITDATA_REQUEST                     DsUnitdataRequest;
        CSR_DS_UNITDATA_RESPONSE                    DsUnitdataResponse;
        CSR_DS_UNITDATA_INDICATION                  DsUnitdataIndication;
        CSR_DS_UNITDATA_CANCEL_INDICATION           DsUnitdataCancelIndication;
        CSR_DS_STA_NOTIFY_REQUEST                   DsStaNotifyRequest;
        CSR_DEBUG_STRING_INDICATION                 DebugStringIndication;
        CSR_DEBUG_WORD16_INDICATION                 DebugWord16Indication;
        CSR_DEBUG_GENERIC_REQUEST                   DebugGenericRequest;
        CSR_DEBUG_GENERIC_CONFIRM                   DebugGenericConfirm;
        CSR_DEBUG_GENERIC_INDICATION                DebugGenericIndication;
    } u;
} CSR_SIGNAL;

#define SIG_FILTER_SIZE 11

CsrUint32 SigGetFilterPos(CsrUint16 aSigID);

#endif
