/* This is an autogenerated file from hip_pack_gen.pl */

#include "driver/signals.h"
#include "driver/unifi.h"
#include "driver/conversions.h"


/*
 * ---------------------------------------------------------------------------
 *  get_packed_struct_size
 *
 *      Examine a buffer containing a UniFi signal in wire-format.
 *      The first two bytes contain the signal ID, decode the signal ID and
 *      return the size, in  bytes, of the signal, not including any bulk
 *      data.
 * 
 *  Arguments:
 *      buf     Pointer to buffer to decode.
 *
 *  Returns:
 *      -CSR_EINVAL if the signal ID is not recognised, otherwise the
 *      number of bytes occupied by the signal in the buffer. This is useful
 *      for stepping past the signal to the object in the buffer.
 * ---------------------------------------------------------------------------
 */
CsrInt32
get_packed_struct_size(const CsrUint8 *buf)
{
    CsrInt32 size = 0;
    CsrUint16 sig_id;

    sig_id = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(buf);

    size += SIZEOF_UINT16;
    size += SIZEOF_UINT16;
    size += SIZEOF_UINT16;
    switch (sig_id)
    {
      case CSR_MLME_AUTHENTICATE_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADD_AUTONOMOUS_SCAN_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_DELBA_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADD_BLACKOUT_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_SETPROTECTION_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_SNIFFJOIN_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_DLS_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_DEAUTHENTICATE_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        break;
      case CSR_DEBUG_WORD16_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_REASSOCIATE_RESPONSE_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MA_PACKET_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT64;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_MREPORT_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_REMOTE_REQUEST_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        break;
      case CSR_MLME_DEL_RX_TRIGGER_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_CHANNELSWITCH_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_SCAN_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT32;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_DELETEKEYS_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MA_UNITDATA_CANCEL_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT32;
        break;
      case CSR_MLME_HL_SYNC_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        break;
      case CSR_MLME_SET_UNITDATA_FILTER_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_MICHAELMICFAILURE_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_AUTONOMOUS_SCAN_RESULTS_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_DEL_TRIGGERED_GET_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_MREQUEST_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_DEL_WDS_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_RESET_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_START_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        break;
      case CSR_MLME_SCAN_CANCEL_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_ASSOCIATE_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_AUTONOMOUS_SCAN_RESULTS_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_RESOURCE_REQUEST_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        break;
      case CSR_MLME_DEL_RX_TRIGGER_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_AUTHENTICATE_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADDTS_RESPONSE_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        break;
      case CSR_MLME_DEL_BLACKOUT_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_MREQUEST_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_PAUSE_AUTONOMOUS_SCAN_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_START_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT32;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MA_PACKET_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT32;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_SAQUERY_RESPONSE_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_ASSOCIATE_RESPONSE_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_DEL_AUTONOMOUS_SCAN_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADDTS_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        break;
      case CSR_MLME_RESOURCE_REQUEST_LOCAL_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        break;
      case CSR_MLME_MEASURE_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_POWERMGT_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_RESOURCE_REQUEST_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        break;
      case CSR_MLME_ADD_PERIODIC_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_SCHEDULE_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        break;
      case CSR_MLME_GET_NEXT_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_AUTHENTICATE_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_NEIGHBORREPREQ_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_DELETEKEYS_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        break;
      case CSR_MLME_DELBA_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_HL_SYNC_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADD_AUTONOMOUS_SCAN_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT32;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_DISASSOCIATE_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_SET_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_DEL_AUTONOMOUS_SCAN_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_MREPORT_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_RESOURCE_REQUEST_LOCAL_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_DEL_PERIODIC_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_SETKEYS_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 32/8;
        break;
      case CSR_MA_SNIFFDATA_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT64;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT32;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_HL_SYNC_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += 48/8;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADDBA_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_DLSTEARDOWN_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_FT_JOIN_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT64;
        size += SIZEOF_UINT64;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT32;
        break;
      case CSR_MLME_POWERMGT_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_DISASSOCIATE_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_TPCADAPT_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_LINKMEASURE_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_PROTECTEDFRAMEDROPPED_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += 48/8;
        break;
      case CSR_MLME_NEIGHBORREPRESP_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_VSPECIFIC_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_VSPECIFIC_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        break;
      case CSR_MLME_MEASURE_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_ASSOCIATE_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_SAQUERY_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_AUTONOMOUS_SCAN_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT64;
        size += SIZEOF_UINT64;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_DEL_PERIODIC_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_SCHEDULE_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_NEIGHBORREPREQ_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_SETKEYS_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_DS_UNITDATA_RESPONSE_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT32;
        break;
      case CSR_MLME_DEL_BLACKOUT_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_DEBUG_GENERIC_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADDBA_RESPONSE_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_CONNECTED_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        break;
      case CSR_MLME_NEIGHBORREPRESP_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_CHANNELSWITCH_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_TRIGGERED_GET_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_GET_NEXT_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADDTS_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_AUTONOMOUS_SCAN_RESULTS_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_DEBUG_GENERIC_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_SET_UNITDATA_FILTER_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT32;
        break;
      case CSR_MLME_SAQUERY_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_CHANNELSWITCH_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_DS_UNITDATA_CANCEL_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT32;
        break;
      case CSR_MLME_DLSTEARDOWN_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += 48/8;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_EAPOL_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT32;
        break;
      case CSR_MLME_SAQUERY_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MA_UNITDATA_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT32;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_TPCADAPT_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_DS_UNITDATA_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT32;
        break;
      case CSR_MLME_REMOTE_REQUEST_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADD_TRIGGERED_GET_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_RESOURCE_REQUEST_RESPONSE_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_SETPROTECTION_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_SNIFFJOIN_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_REASSOCIATE_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_DEL_TRIGGERED_GET_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_DEBUG_GENERIC_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_DEAUTHENTICATE_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_MREQUEST_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_DELTS_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT32;
        break;
      case CSR_MLME_DELBA_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_NEIGHBORREPRESP_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADD_WDS_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_ASSOCIATE_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADD_RX_TRIGGER_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_REMOTE_REQUEST_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        break;
      case CSR_MLME_HL_SYNC_CANCEL_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        break;
      case CSR_MLME_REASSOCIATE_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_SCAN_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT64;
        size += SIZEOF_UINT64;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_AUTONOMOUS_SCAN_DONE_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_DS_STA_NOTIFY_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_DLS_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_DLSTEARDOWN_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += 48/8;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADD_TRIGGERED_GET_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_GET_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_DEAUTHENTICATE_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_AUTHENTICATE_RESPONSE_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADD_RX_TRIGGER_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_VSPECIFIC_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        break;
      case CSR_MLME_SCHEDULE_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_DISASSOCIATE_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADD_BLACKOUT_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT32;
        size += SIZEOF_UINT32;
        size += SIZEOF_UINT32;
        size += 48/8;
        break;
      case CSR_MLME_RESET_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_DS_UNITDATA_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_NEIGHBORREPREQ_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADD_WDS_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        break;
      case CSR_MLME_MREPORT_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_DEL_WDS_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        break;
      case CSR_MLME_ADDBA_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_JOIN_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_DLS_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_RESOURCE_REQUEST_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_STAKEYESTABLISHED_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += 48/8;
        break;
      case CSR_MLME_PAUSE_AUTONOMOUS_SCAN_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_REASSOCIATE_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_GET_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MA_UNITDATA_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT32;
        break;
      case CSR_MLME_ADDTS_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADD_PERIODIC_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT32;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_DELTS_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT32;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_EAPOL_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT32;
        break;
      case CSR_MLME_HL_SYNC_CANCEL_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_DELTS_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT32;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_LINKMEASURE_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_SCAN_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_CHANNELSWITCH_RESPONSE_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_DEBUG_STRING_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_FT_JOIN_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_JOIN_REQUEST_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT64;
        size += SIZEOF_UINT64;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT32;
        break;
      case CSR_MLME_SET_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADDBA_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
      case CSR_MA_PACKET_CONFIRM_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT32;
        break;
      case CSR_MA_UNITDATA_INDICATION_ID:
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += 48/8;
        size += 48/8;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        size += SIZEOF_UINT16;
        break;
    default:
        size = -CSR_EINVAL;
    }
    return size;
} /* get_packed_struct_size() */


/*
 * ---------------------------------------------------------------------------
 *  read_unpack_signal
 *
 *      Unpack a wire-format signal into a host-native structure.
 *      This function handles any necessary conversions for endianness and
 *      places no restrictions on packing or alignment for the structure
 *      definition.
 * 
 *  Arguments:
 *      ptr             Signal buffer to unpack.
 *      sig             Pointer to destination structure to populate.
 *
 *  Returns:
 *      0 on success,
 *      -CSR_EINVAL if the ID of signal was not recognised.
 * ---------------------------------------------------------------------------
 */
CsrInt32
read_unpack_signal(const CsrUint8 *ptr, CSR_SIGNAL *sig)
{
    CsrInt32 index = 0;

    sig->SignalPrimitiveHeader.SignalId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
    index += SIZEOF_UINT16;

    sig->SignalPrimitiveHeader.ReceiverProcessId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
    index += SIZEOF_UINT16;

    sig->SignalPrimitiveHeader.SenderProcessId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
    index += SIZEOF_UINT16;

    switch (sig->SignalPrimitiveHeader.SignalId)
    {
      case CSR_MLME_AUTHENTICATE_REQUEST_ID:
        sig->u.MlmeAuthenticateRequest.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAuthenticateRequest.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAuthenticateRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAuthenticateRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeAuthenticateRequest.PeerStaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeAuthenticateRequest.AuthenticationType = (CSR_AUTHENTICATION_TYPE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAuthenticateRequest.AuthenticationFailureTimeout = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADD_AUTONOMOUS_SCAN_CONFIRM_ID:
        sig->u.MlmeAddAutonomousScanConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddAutonomousScanConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddAutonomousScanConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddAutonomousScanConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddAutonomousScanConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddAutonomousScanConfirm.AutonomousScanId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_DELBA_REQUEST_ID:
        sig->u.MlmeDelbaRequest.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelbaRequest.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelbaRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelbaRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeDelbaRequest.PeerQstaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeDelbaRequest.Direction = (CSR_INITIATOR) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelbaRequest.Tid = (CSR_PRIORITY) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelbaRequest.ReasonCode = (CSR_REASON_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADD_BLACKOUT_CONFIRM_ID:
        sig->u.MlmeAddBlackoutConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddBlackoutConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddBlackoutConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddBlackoutConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddBlackoutConfirm.BlackoutId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddBlackoutConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_SETPROTECTION_CONFIRM_ID:
        sig->u.MlmeSetprotectionConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetprotectionConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetprotectionConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetprotectionConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetprotectionConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_SNIFFJOIN_CONFIRM_ID:
        sig->u.MlmeSniffjoinConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSniffjoinConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSniffjoinConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSniffjoinConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSniffjoinConfirm.Resultcode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_DLS_REQUEST_ID:
        sig->u.MlmeDlsRequest.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDlsRequest.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDlsRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDlsRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeDlsRequest.PeerMacAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeDlsRequest.CapabilityInformation = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDlsRequest.DlsTimeoutValue = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDlsRequest.DlsResponseTimeout = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_DEAUTHENTICATE_REQUEST_ID:
        sig->u.MlmeDeauthenticateRequest.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDeauthenticateRequest.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDeauthenticateRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDeauthenticateRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeDeauthenticateRequest.PeerStaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeDeauthenticateRequest.ReasonCode = (CSR_REASON_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_DEBUG_WORD16_INDICATION_ID:
        sig->u.DebugWord16Indication.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugWord16Indication.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugWord16Indication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugWord16Indication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugWord16Indication.DebugWords[0] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugWord16Indication.DebugWords[1] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugWord16Indication.DebugWords[2] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugWord16Indication.DebugWords[3] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugWord16Indication.DebugWords[4] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugWord16Indication.DebugWords[5] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugWord16Indication.DebugWords[6] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugWord16Indication.DebugWords[7] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugWord16Indication.DebugWords[8] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugWord16Indication.DebugWords[9] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugWord16Indication.DebugWords[10] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugWord16Indication.DebugWords[11] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugWord16Indication.DebugWords[12] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugWord16Indication.DebugWords[13] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugWord16Indication.DebugWords[14] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugWord16Indication.DebugWords[15] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_REASSOCIATE_RESPONSE_ID:
        sig->u.MlmeReassociateResponse.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeReassociateResponse.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeReassociateResponse.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeReassociateResponse.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeReassociateResponse.PeerStaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeReassociateResponse.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeReassociateResponse.CapabilityInformation = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeReassociateResponse.AssociationId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeReassociateResponse.RcpiRequest = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeReassociateResponse.RsniRequest = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MA_PACKET_INDICATION_ID:
        sig->u.MaPacketIndication.Data.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaPacketIndication.Data.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaPacketIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaPacketIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MaPacketIndication.LocalTime.x, &ptr[index], 64/8);
        index += 64/8;
        sig->u.MaPacketIndication.Channel = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaPacketIndication.ReceptionStatus = (CSR_RECEPTION_STATUS) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaPacketIndication.Rssi = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaPacketIndication.Snr = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaPacketIndication.Rate = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaPacketIndication.RcpiMeasurement = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaPacketIndication.RsniMeasurement = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaPacketIndication.MsduFragmentNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_MREPORT_CONFIRM_ID:
        sig->u.MlmeMreportConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMreportConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMreportConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMreportConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMreportConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_REMOTE_REQUEST_INDICATION_ID:
        sig->u.MlmeRemoteRequestIndication.ContentOfFtActionFrame.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeRemoteRequestIndication.ContentOfFtActionFrame.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeRemoteRequestIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeRemoteRequestIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeRemoteRequestIndication.PeerMacAddress.x, &ptr[index], 48/8);
        index += 48/8;
        break;
      case CSR_MLME_DEL_RX_TRIGGER_REQUEST_ID:
        sig->u.MlmeDelRxTriggerRequest.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelRxTriggerRequest.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelRxTriggerRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelRxTriggerRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelRxTriggerRequest.TriggerId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_CHANNELSWITCH_REQUEST_ID:
        sig->u.MlmeChannelswitchRequest.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeChannelswitchRequest.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeChannelswitchRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeChannelswitchRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeChannelswitchRequest.Mode = (CSR_CHANNEL_SWITCH_MODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeChannelswitchRequest.ChannelNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeChannelswitchRequest.SecondaryChannelOffset = (CSR_CHANNEL_OFFSET) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeChannelswitchRequest.ChannelSwitchCount = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_SCAN_REQUEST_ID:
        sig->u.MlmeScanRequest.ChannelList.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScanRequest.ChannelList.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScanRequest.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScanRequest.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScanRequest.Ifindex = (CSR_IFINTERFACE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScanRequest.BssType = (CSR_BSS_TYPE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeScanRequest.Da.x, &ptr[index], 48/8);
        index += 48/8;
        CsrMemCpy(sig->u.MlmeScanRequest.Bssid.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeScanRequest.ScanType = (CSR_SCAN_TYPE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScanRequest.ProbeDelay = COAL_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT32;
        sig->u.MlmeScanRequest.MinChannelTime = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScanRequest.MaxChannelTime = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_DELETEKEYS_CONFIRM_ID:
        sig->u.MlmeDeletekeysConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDeletekeysConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDeletekeysConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDeletekeysConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDeletekeysConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MA_UNITDATA_CANCEL_REQUEST_ID:
        sig->u.MaUnitdataCancelRequest.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaUnitdataCancelRequest.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaUnitdataCancelRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaUnitdataCancelRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaUnitdataCancelRequest.HostTag = COAL_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT32;
        break;
      case CSR_MLME_HL_SYNC_REQUEST_ID:
        sig->u.MlmeHlSyncRequest.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeHlSyncRequest.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeHlSyncRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeHlSyncRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeHlSyncRequest.GroupAddress.x, &ptr[index], 48/8);
        index += 48/8;
        break;
      case CSR_MLME_SET_UNITDATA_FILTER_CONFIRM_ID:
        sig->u.MlmeSetUnitdataFilterConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetUnitdataFilterConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetUnitdataFilterConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetUnitdataFilterConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetUnitdataFilterConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_MICHAELMICFAILURE_INDICATION_ID:
        sig->u.MlmeMichaelmicfailureIndication.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMichaelmicfailureIndication.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMichaelmicfailureIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMichaelmicfailureIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMichaelmicfailureIndication.Count = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeMichaelmicfailureIndication.Address.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeMichaelmicfailureIndication.KeyType = (CSR_KEY_TYPE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMichaelmicfailureIndication.KeyId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMichaelmicfailureIndication.Tsc[0] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMichaelmicfailureIndication.Tsc[1] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMichaelmicfailureIndication.Tsc[2] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMichaelmicfailureIndication.Tsc[3] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_AUTONOMOUS_SCAN_RESULTS_REQUEST_ID:
        sig->u.MlmeAutonomousScanResultsRequest.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanResultsRequest.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanResultsRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanResultsRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanResultsRequest.AutonomousScanId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_DEL_TRIGGERED_GET_REQUEST_ID:
        sig->u.MlmeDelTriggeredGetRequest.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelTriggeredGetRequest.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelTriggeredGetRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelTriggeredGetRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelTriggeredGetRequest.TriggeredId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_MREQUEST_CONFIRM_ID:
        sig->u.MlmeMrequestConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMrequestConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMrequestConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMrequestConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMrequestConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_DEL_WDS_CONFIRM_ID:
        sig->u.MlmeDelWdsConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelWdsConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelWdsConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelWdsConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelWdsConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_RESET_REQUEST_ID:
        sig->u.MlmeResetRequest.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeResetRequest.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeResetRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeResetRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeResetRequest.StaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeResetRequest.SetDefaultMib = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_START_CONFIRM_ID:
        sig->u.MlmeStartConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeStartConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeStartConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeStartConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeStartConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeStartConfirm.Bssid.x, &ptr[index], 48/8);
        index += 48/8;
        break;
      case CSR_MLME_SCAN_CANCEL_REQUEST_ID:
        sig->u.MlmeScanCancelRequest.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScanCancelRequest.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScanCancelRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScanCancelRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_ASSOCIATE_INDICATION_ID:
        sig->u.MlmeAssociateIndication.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAssociateIndication.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAssociateIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAssociateIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeAssociateIndication.PeerStaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeAssociateIndication.CapabilityInformation = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAssociateIndication.ListenInterval = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAssociateIndication.RcpiRequest = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAssociateIndication.RsniRequest = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_AUTONOMOUS_SCAN_RESULTS_CONFIRM_ID:
        sig->u.MlmeAutonomousScanResultsConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanResultsConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanResultsConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanResultsConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanResultsConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanResultsConfirm.AutonomousScanId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_RESOURCE_REQUEST_REQUEST_ID:
        sig->u.MlmeResourceRequestRequest.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeResourceRequestRequest.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeResourceRequestRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeResourceRequestRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeResourceRequestRequest.PeerMacAddress.x, &ptr[index], 48/8);
        index += 48/8;
        break;
      case CSR_MLME_DEL_RX_TRIGGER_CONFIRM_ID:
        sig->u.MlmeDelRxTriggerConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelRxTriggerConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelRxTriggerConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelRxTriggerConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelRxTriggerConfirm.TriggerId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelRxTriggerConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_AUTHENTICATE_CONFIRM_ID:
        sig->u.MlmeAuthenticateConfirm.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAuthenticateConfirm.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAuthenticateConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAuthenticateConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeAuthenticateConfirm.PeerStaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeAuthenticateConfirm.AuthenticationType = (CSR_AUTHENTICATION_TYPE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAuthenticateConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADDTS_RESPONSE_ID:
        sig->u.MlmeAddtsResponse.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddtsResponse.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddtsResponse.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddtsResponse.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddtsResponse.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddtsResponse.DialogToken = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeAddtsResponse.NonapQstaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        break;
      case CSR_MLME_DEL_BLACKOUT_CONFIRM_ID:
        sig->u.MlmeDelBlackoutConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelBlackoutConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelBlackoutConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelBlackoutConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelBlackoutConfirm.BlackoutId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelBlackoutConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_MREQUEST_INDICATION_ID:
        sig->u.MlmeMrequestIndication.MeasurementRequestSet.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMrequestIndication.MeasurementRequestSet.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMrequestIndication.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMrequestIndication.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeMrequestIndication.PeerMacAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeMrequestIndication.DialogToken = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMrequestIndication.NumberOfRepetitions = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMrequestIndication.MeasurementCategory = (CSR_MEASUREMENT_CATEGORY) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_PAUSE_AUTONOMOUS_SCAN_CONFIRM_ID:
        sig->u.MlmePauseAutonomousScanConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmePauseAutonomousScanConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmePauseAutonomousScanConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmePauseAutonomousScanConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmePauseAutonomousScanConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmePauseAutonomousScanConfirm.AutonomousScanId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_START_REQUEST_ID:
        sig->u.MlmeStartRequest.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeStartRequest.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeStartRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeStartRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeStartRequest.Ifindex = (CSR_IFINTERFACE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeStartRequest.BeaconPeriod = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeStartRequest.Channel = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeStartRequest.ProbeDelay = COAL_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT32;
        sig->u.MlmeStartRequest.CapabilityInformation = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeStartRequest.BluetoothAmp = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MA_PACKET_REQUEST_ID:
        sig->u.MaPacketRequest.Data.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaPacketRequest.Data.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaPacketRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaPacketRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaPacketRequest.TransmitRate = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaPacketRequest.HostTag = COAL_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT32;
        sig->u.MaPacketRequest.Priority = (CSR_PRIORITY) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_SAQUERY_RESPONSE_ID:
        sig->u.MlmeSaqueryResponse.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryResponse.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryResponse.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryResponse.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeSaqueryResponse.PeerStaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeSaqueryResponse.TransactionId[0] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryResponse.TransactionId[1] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryResponse.TransactionId[2] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryResponse.TransactionId[3] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryResponse.TransactionId[4] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryResponse.TransactionId[5] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryResponse.TransactionId[6] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryResponse.TransactionId[7] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_ASSOCIATE_RESPONSE_ID:
        sig->u.MlmeAssociateResponse.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAssociateResponse.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAssociateResponse.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAssociateResponse.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeAssociateResponse.PeerStaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeAssociateResponse.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAssociateResponse.CapabilityInformation = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAssociateResponse.AssociationId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAssociateResponse.RcpiRequest = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAssociateResponse.RsniRequest = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_DEL_AUTONOMOUS_SCAN_REQUEST_ID:
        sig->u.MlmeDelAutonomousScanRequest.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelAutonomousScanRequest.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelAutonomousScanRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelAutonomousScanRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelAutonomousScanRequest.AutonomousScanId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADDTS_INDICATION_ID:
        sig->u.MlmeAddtsIndication.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddtsIndication.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddtsIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddtsIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddtsIndication.DialogToken = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeAddtsIndication.NonapQstaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        break;
      case CSR_MLME_RESOURCE_REQUEST_LOCAL_REQUEST_ID:
        sig->u.MlmeResourceRequestLocalRequest.ResourceDescriptors.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeResourceRequestLocalRequest.ResourceDescriptors.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeResourceRequestLocalRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeResourceRequestLocalRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeResourceRequestLocalRequest.MacAddress.x, &ptr[index], 48/8);
        index += 48/8;
        break;
      case CSR_MLME_MEASURE_CONFIRM_ID:
        sig->u.MlmeMeasureConfirm.MeasurementReportSet.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMeasureConfirm.MeasurementReportSet.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMeasureConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMeasureConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMeasureConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMeasureConfirm.DialogToken = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_POWERMGT_CONFIRM_ID:
        sig->u.MlmePowermgtConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmePowermgtConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmePowermgtConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmePowermgtConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmePowermgtConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_RESOURCE_REQUEST_INDICATION_ID:
        sig->u.MlmeResourceRequestIndication.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeResourceRequestIndication.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeResourceRequestIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeResourceRequestIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeResourceRequestIndication.PeerMacAddress.x, &ptr[index], 48/8);
        index += 48/8;
        break;
      case CSR_MLME_ADD_PERIODIC_CONFIRM_ID:
        sig->u.MlmeAddPeriodicConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddPeriodicConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddPeriodicConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddPeriodicConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddPeriodicConfirm.PeriodicId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddPeriodicConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_SCHEDULE_REQUEST_ID:
        sig->u.MlmeScheduleRequest.ScheduleElement.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScheduleRequest.ScheduleElement.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScheduleRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScheduleRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeScheduleRequest.NonapQstaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        break;
      case CSR_MLME_GET_NEXT_CONFIRM_ID:
        sig->u.MlmeGetNextConfirm.MibAttributeValue.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeGetNextConfirm.MibAttributeValue.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeGetNextConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeGetNextConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeGetNextConfirm.Status = (CSR_MIB_STATUS) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeGetNextConfirm.ErrorIndex = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_AUTHENTICATE_INDICATION_ID:
        sig->u.MlmeAuthenticateIndication.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAuthenticateIndication.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAuthenticateIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAuthenticateIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeAuthenticateIndication.PeerStaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeAuthenticateIndication.AuthenticationType = (CSR_AUTHENTICATION_TYPE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_NEIGHBORREPREQ_INDICATION_ID:
        sig->u.MlmeNeighborrepreqIndication.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeNeighborrepreqIndication.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeNeighborrepreqIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeNeighborrepreqIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeNeighborrepreqIndication.PeerStaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeNeighborrepreqIndication.DialogToken = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_DELETEKEYS_REQUEST_ID:
        sig->u.MlmeDeletekeysRequest.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDeletekeysRequest.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDeletekeysRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDeletekeysRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDeletekeysRequest.KeyId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDeletekeysRequest.KeyType = (CSR_KEY_TYPE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeDeletekeysRequest.Address.x, &ptr[index], 48/8);
        index += 48/8;
        break;
      case CSR_MLME_DELBA_CONFIRM_ID:
        sig->u.MlmeDelbaConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelbaConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelbaConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelbaConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeDelbaConfirm.PeerQstaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeDelbaConfirm.Direction = (CSR_INITIATOR) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelbaConfirm.Tid = (CSR_PRIORITY) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelbaConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_HL_SYNC_CONFIRM_ID:
        sig->u.MlmeHlSyncConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeHlSyncConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeHlSyncConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeHlSyncConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeHlSyncConfirm.GroupAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeHlSyncConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADD_AUTONOMOUS_SCAN_REQUEST_ID:
        sig->u.MlmeAddAutonomousScanRequest.ChannelList.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddAutonomousScanRequest.ChannelList.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddAutonomousScanRequest.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddAutonomousScanRequest.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddAutonomousScanRequest.AutonomousScanId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddAutonomousScanRequest.Ifindex = (CSR_IFINTERFACE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddAutonomousScanRequest.ChannelStartingFactor = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddAutonomousScanRequest.BssType = (CSR_BSS_TYPE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeAddAutonomousScanRequest.Bssid.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeAddAutonomousScanRequest.ScanType = (CSR_SCAN_TYPE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddAutonomousScanRequest.ProbeDelay = COAL_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT32;
        sig->u.MlmeAddAutonomousScanRequest.MinChannelTime = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddAutonomousScanRequest.MaxChannelTime = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_DISASSOCIATE_CONFIRM_ID:
        sig->u.MlmeDisassociateConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDisassociateConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDisassociateConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDisassociateConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDisassociateConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_SET_REQUEST_ID:
        sig->u.MlmeSetRequest.MibAttributeValue.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetRequest.MibAttributeValue.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_DEL_AUTONOMOUS_SCAN_CONFIRM_ID:
        sig->u.MlmeDelAutonomousScanConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelAutonomousScanConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelAutonomousScanConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelAutonomousScanConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelAutonomousScanConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelAutonomousScanConfirm.AutonomousScanId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_MREPORT_INDICATION_ID:
        sig->u.MlmeMreportIndication.MeasurementReportSet.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMreportIndication.MeasurementReportSet.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMreportIndication.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMreportIndication.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeMreportIndication.PeerMacAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeMreportIndication.DialogToken = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMreportIndication.MeasurementCategory = (CSR_MEASUREMENT_CATEGORY) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_RESOURCE_REQUEST_LOCAL_CONFIRM_ID:
        sig->u.MlmeResourceRequestLocalConfirm.ResourceDescriptors.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeResourceRequestLocalConfirm.ResourceDescriptors.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeResourceRequestLocalConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeResourceRequestLocalConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeResourceRequestLocalConfirm.MacAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeResourceRequestLocalConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_DEL_PERIODIC_REQUEST_ID:
        sig->u.MlmeDelPeriodicRequest.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelPeriodicRequest.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelPeriodicRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelPeriodicRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelPeriodicRequest.PeriodicId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_SETKEYS_REQUEST_ID:
        sig->u.MlmeSetkeysRequest.Key.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetkeysRequest.Key.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetkeysRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetkeysRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetkeysRequest.Length = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetkeysRequest.KeyId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetkeysRequest.KeyType = (CSR_KEY_TYPE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeSetkeysRequest.Address.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeSetkeysRequest.SequenceNumber[0] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetkeysRequest.SequenceNumber[1] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetkeysRequest.SequenceNumber[2] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetkeysRequest.SequenceNumber[3] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetkeysRequest.SequenceNumber[4] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetkeysRequest.SequenceNumber[5] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetkeysRequest.SequenceNumber[6] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetkeysRequest.SequenceNumber[7] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetkeysRequest.AuthenticatorSupplicantOrInitiatorPeer = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(&sig->u.MlmeSetkeysRequest.CipherSuiteSelector, &ptr[index], 32/8);
        index += 32/8;
        break;
      case CSR_MA_SNIFFDATA_INDICATION_ID:
        sig->u.MaSniffdataIndication.Data.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaSniffdataIndication.Data.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaSniffdataIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaSniffdataIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MaSniffdataIndication.Timestamp.x, &ptr[index], 64/8);
        index += 64/8;
        sig->u.MaSniffdataIndication.Duration = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaSniffdataIndication.Rate = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaSniffdataIndication.AntennaId = (CSR_ANTENNA_ID) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaSniffdataIndication.Rssi = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaSniffdataIndication.Snr = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaSniffdataIndication.FrequencyOffset = COAL_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT32;
        sig->u.MaSniffdataIndication.ReceptionStatus = (CSR_SNIFFER_RECEPTION_STATUS) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_HL_SYNC_INDICATION_ID:
        sig->u.MlmeHlSyncIndication.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeHlSyncIndication.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeHlSyncIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeHlSyncIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeHlSyncIndication.GroupAddress.x, &ptr[index], 48/8);
        index += 48/8;
        CsrMemCpy(sig->u.MlmeHlSyncIndication.SourceAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeHlSyncIndication.SequenceNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADDBA_REQUEST_ID:
        sig->u.MlmeAddbaRequest.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaRequest.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeAddbaRequest.PeerQstaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeAddbaRequest.DialogToken = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaRequest.Tid = (CSR_PRIORITY) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaRequest.BlockAckPolicy = (CSR_BLOCK_ACK_POLICY) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaRequest.BufferSize = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaRequest.BlockAckTimeout = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaRequest.AddbaFailureTimeout = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaRequest.BlockAckStartingSequenceControl = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_DLSTEARDOWN_INDICATION_ID:
        sig->u.MlmeDlsteardownIndication.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDlsteardownIndication.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDlsteardownIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDlsteardownIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeDlsteardownIndication.PeerMacAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeDlsteardownIndication.ReasonCode = (CSR_REASON_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_FT_JOIN_REQUEST_ID:
        sig->u.MlmeFtJoinRequest.ScanInformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeFtJoinRequest.ScanInformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeFtJoinRequest.StaInformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeFtJoinRequest.StaInformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeFtJoinRequest.Ifindex = (CSR_IFINTERFACE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeFtJoinRequest.Bssid.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeFtJoinRequest.BeaconPeriod = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeFtJoinRequest.Timestamp.x, &ptr[index], 64/8);
        index += 64/8;
        CsrMemCpy(sig->u.MlmeFtJoinRequest.LocalTime.x, &ptr[index], 64/8);
        index += 64/8;
        sig->u.MlmeFtJoinRequest.Channel = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeFtJoinRequest.CapabilityInformation = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeFtJoinRequest.JoinFailureTimeout = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeFtJoinRequest.ProbeDelay = COAL_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT32;
        break;
      case CSR_MLME_POWERMGT_REQUEST_ID:
        sig->u.MlmePowermgtRequest.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmePowermgtRequest.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmePowermgtRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmePowermgtRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmePowermgtRequest.PowerManagementMode = (CSR_POWER_MANAGEMENT_MODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmePowermgtRequest.WakeUp = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmePowermgtRequest.ReceiveDtims = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmePowermgtRequest.ListenInterval = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_DISASSOCIATE_REQUEST_ID:
        sig->u.MlmeDisassociateRequest.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDisassociateRequest.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDisassociateRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDisassociateRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeDisassociateRequest.PeerStaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeDisassociateRequest.ReasonCode = (CSR_REASON_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_TPCADAPT_CONFIRM_ID:
        sig->u.MlmeTpcadaptConfirm.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeTpcadaptConfirm.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeTpcadaptConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeTpcadaptConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeTpcadaptConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeTpcadaptConfirm.DialogToken = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeTpcadaptConfirm.RequestRate = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeTpcadaptConfirm.RequestTransmitPower = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeTpcadaptConfirm.RequestLinkMargin = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeTpcadaptConfirm.ReportRate = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeTpcadaptConfirm.ReportTransmitPower = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeTpcadaptConfirm.ReportLinkMargin = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_LINKMEASURE_CONFIRM_ID:
        sig->u.MlmeLinkmeasureConfirm.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeLinkmeasureConfirm.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeLinkmeasureConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeLinkmeasureConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeLinkmeasureConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeLinkmeasureConfirm.DialogToken = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeLinkmeasureConfirm.TransmitPower = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeLinkmeasureConfirm.LinkMargin = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeLinkmeasureConfirm.ReceiveAntennaId = (CSR_ANTENNA_ID) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeLinkmeasureConfirm.TransmitAntennaId = (CSR_ANTENNA_ID) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeLinkmeasureConfirm.RcpiRequest = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeLinkmeasureConfirm.RsniRequest = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeLinkmeasureConfirm.RcpiReport = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeLinkmeasureConfirm.RsniReport = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_PROTECTEDFRAMEDROPPED_INDICATION_ID:
        sig->u.MlmeProtectedframedroppedIndication.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeProtectedframedroppedIndication.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeProtectedframedroppedIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeProtectedframedroppedIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeProtectedframedroppedIndication.Address1.x, &ptr[index], 48/8);
        index += 48/8;
        CsrMemCpy(sig->u.MlmeProtectedframedroppedIndication.Address2.x, &ptr[index], 48/8);
        index += 48/8;
        break;
      case CSR_MLME_NEIGHBORREPRESP_INDICATION_ID:
        sig->u.MlmeNeighborreprespIndication.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeNeighborreprespIndication.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeNeighborreprespIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeNeighborreprespIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeNeighborreprespIndication.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeNeighborreprespIndication.DialogToken = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_VSPECIFIC_CONFIRM_ID:
        sig->u.MlmeVspecificConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeVspecificConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeVspecificConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeVspecificConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeVspecificConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_VSPECIFIC_INDICATION_ID:
        sig->u.MlmeVspecificIndication.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeVspecificIndication.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeVspecificIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeVspecificIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeVspecificIndication.PeerMacAddress.x, &ptr[index], 48/8);
        index += 48/8;
        break;
      case CSR_MLME_MEASURE_REQUEST_ID:
        sig->u.MlmeMeasureRequest.MeasurementRequestSet.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMeasureRequest.MeasurementRequestSet.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMeasureRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMeasureRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMeasureRequest.DialogToken = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_ASSOCIATE_CONFIRM_ID:
        sig->u.MlmeAssociateConfirm.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAssociateConfirm.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAssociateConfirm.ExchangedFrames.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAssociateConfirm.ExchangedFrames.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAssociateConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAssociateConfirm.CapabilityInformation = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAssociateConfirm.AssociationId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAssociateConfirm.RcpiRequest = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAssociateConfirm.RsniRequest = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAssociateConfirm.RcpiResponse = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAssociateConfirm.RsniResponse = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_SAQUERY_CONFIRM_ID:
        sig->u.MlmeSaqueryConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeSaqueryConfirm.PeerStaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeSaqueryConfirm.TransactionId[0] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryConfirm.TransactionId[1] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryConfirm.TransactionId[2] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryConfirm.TransactionId[3] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryConfirm.TransactionId[4] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryConfirm.TransactionId[5] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryConfirm.TransactionId[6] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryConfirm.TransactionId[7] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_AUTONOMOUS_SCAN_INDICATION_ID:
        sig->u.MlmeAutonomousScanIndication.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanIndication.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanIndication.AutonomousScanId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanIndication.BssType = (CSR_BSS_TYPE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeAutonomousScanIndication.Bssid.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeAutonomousScanIndication.BeaconPeriod = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeAutonomousScanIndication.Timestamp.x, &ptr[index], 64/8);
        index += 64/8;
        CsrMemCpy(sig->u.MlmeAutonomousScanIndication.LocalTime.x, &ptr[index], 64/8);
        index += 64/8;
        sig->u.MlmeAutonomousScanIndication.Channel = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanIndication.ChannelFrequency = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanIndication.CapabilityInformation = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanIndication.Rssi = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanIndication.Snr = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanIndication.ReportedFrameInformation = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanIndication.RcpiMeasurement = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanIndication.RsniMeasurement = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_DEL_PERIODIC_CONFIRM_ID:
        sig->u.MlmeDelPeriodicConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelPeriodicConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelPeriodicConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelPeriodicConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelPeriodicConfirm.PeriodicId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelPeriodicConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_SCHEDULE_INDICATION_ID:
        sig->u.MlmeScheduleIndication.ScheduleElement.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScheduleIndication.ScheduleElement.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScheduleIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScheduleIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_NEIGHBORREPREQ_REQUEST_ID:
        sig->u.MlmeNeighborrepreqRequest.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeNeighborrepreqRequest.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeNeighborrepreqRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeNeighborrepreqRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeNeighborrepreqRequest.DialogToken = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_SETKEYS_CONFIRM_ID:
        sig->u.MlmeSetkeysConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetkeysConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetkeysConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetkeysConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetkeysConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_DS_UNITDATA_RESPONSE_ID:
        sig->u.DsUnitdataResponse.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DsUnitdataResponse.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DsUnitdataResponse.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DsUnitdataResponse.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.DsUnitdataResponse.Da.x, &ptr[index], 48/8);
        index += 48/8;
        CsrMemCpy(sig->u.DsUnitdataResponse.Sa.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.DsUnitdataResponse.TransmissionStatus = (CSR_TRANSMISSION_STATUS) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DsUnitdataResponse.RoutingInformation = (CSR_ROUTING_INFORMATION) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DsUnitdataResponse.ProvidedPriority = (CSR_PRIORITY) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DsUnitdataResponse.ProvidedServiceClass = (CSR_SERVICE_CLASS) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DsUnitdataResponse.ProvidedHostTag = COAL_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT32;
        break;
      case CSR_MLME_DEL_BLACKOUT_REQUEST_ID:
        sig->u.MlmeDelBlackoutRequest.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelBlackoutRequest.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelBlackoutRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelBlackoutRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelBlackoutRequest.BlackoutId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_DEBUG_GENERIC_CONFIRM_ID:
        sig->u.DebugGenericConfirm.DebugVariable.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericConfirm.DebugVariable.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericConfirm.DebugWords[0] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericConfirm.DebugWords[1] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericConfirm.DebugWords[2] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericConfirm.DebugWords[3] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericConfirm.DebugWords[4] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericConfirm.DebugWords[5] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericConfirm.DebugWords[6] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericConfirm.DebugWords[7] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADDBA_RESPONSE_ID:
        sig->u.MlmeAddbaResponse.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaResponse.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaResponse.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaResponse.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeAddbaResponse.PeerQstaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeAddbaResponse.DialogToken = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaResponse.Tid = (CSR_PRIORITY) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaResponse.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaResponse.BlockAckPolicy = (CSR_BLOCK_ACK_POLICY) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaResponse.BufferSize = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaResponse.BlockAckTimeout = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_CONNECTED_INDICATION_ID:
        sig->u.MlmeConnectedIndication.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeConnectedIndication.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeConnectedIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeConnectedIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeConnectedIndication.ConnectionStatus = (CSR_CONNECTION_STATUS) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeConnectedIndication.PeerMacAddress.x, &ptr[index], 48/8);
        index += 48/8;
        break;
      case CSR_MLME_NEIGHBORREPRESP_REQUEST_ID:
        sig->u.MlmeNeighborreprespRequest.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeNeighborreprespRequest.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeNeighborreprespRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeNeighborreprespRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeNeighborreprespRequest.PeerStaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeNeighborreprespRequest.DialogToken = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_CHANNELSWITCH_CONFIRM_ID:
        sig->u.MlmeChannelswitchConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeChannelswitchConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeChannelswitchConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeChannelswitchConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeChannelswitchConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_TRIGGERED_GET_INDICATION_ID:
        sig->u.MlmeTriggeredGetIndication.MibAttributeValue.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeTriggeredGetIndication.MibAttributeValue.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeTriggeredGetIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeTriggeredGetIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeTriggeredGetIndication.Status = (CSR_MIB_STATUS) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeTriggeredGetIndication.ErrorIndex = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeTriggeredGetIndication.TriggeredId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_GET_NEXT_REQUEST_ID:
        sig->u.MlmeGetNextRequest.MibAttribute.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeGetNextRequest.MibAttribute.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeGetNextRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeGetNextRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADDTS_CONFIRM_ID:
        sig->u.MlmeAddtsConfirm.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddtsConfirm.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddtsConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddtsConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddtsConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddtsConfirm.DialogToken = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_AUTONOMOUS_SCAN_RESULTS_INDICATION_ID:
        sig->u.MlmeAutonomousScanResultsIndication.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanResultsIndication.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanResultsIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanResultsIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanResultsIndication.AutonomousScanId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeAutonomousScanResultsIndication.Bssid.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeAutonomousScanResultsIndication.Channel = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanResultsIndication.ChannelFrequency = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanResultsIndication.Rssi = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanResultsIndication.Snr = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_DEBUG_GENERIC_REQUEST_ID:
        sig->u.DebugGenericRequest.DebugVariable.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericRequest.DebugVariable.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericRequest.DebugWords[0] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericRequest.DebugWords[1] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericRequest.DebugWords[2] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericRequest.DebugWords[3] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericRequest.DebugWords[4] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericRequest.DebugWords[5] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericRequest.DebugWords[6] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericRequest.DebugWords[7] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_SET_UNITDATA_FILTER_REQUEST_ID:
        sig->u.MlmeSetUnitdataFilterRequest.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetUnitdataFilterRequest.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetUnitdataFilterRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetUnitdataFilterRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetUnitdataFilterRequest.UnitDataFilterMode = (CSR_UNIT_DATA_FILTER_MODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetUnitdataFilterRequest.ArpFilterAddress = COAL_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT32;
        break;
      case CSR_MLME_SAQUERY_REQUEST_ID:
        sig->u.MlmeSaqueryRequest.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryRequest.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeSaqueryRequest.PeerStaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeSaqueryRequest.TransactionId[0] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryRequest.TransactionId[1] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryRequest.TransactionId[2] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryRequest.TransactionId[3] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryRequest.TransactionId[4] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryRequest.TransactionId[5] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryRequest.TransactionId[6] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryRequest.TransactionId[7] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_CHANNELSWITCH_INDICATION_ID:
        sig->u.MlmeChannelswitchIndication.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeChannelswitchIndication.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeChannelswitchIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeChannelswitchIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeChannelswitchIndication.PeerMacAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeChannelswitchIndication.Mode = (CSR_CHANNEL_SWITCH_MODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeChannelswitchIndication.ChannelNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeChannelswitchIndication.SecondaryChannelOffset = (CSR_CHANNEL_OFFSET) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeChannelswitchIndication.ChannelSwitchCount = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_DS_UNITDATA_CANCEL_INDICATION_ID:
        sig->u.DsUnitdataCancelIndication.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DsUnitdataCancelIndication.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DsUnitdataCancelIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DsUnitdataCancelIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DsUnitdataCancelIndication.HostTag = COAL_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT32;
        break;
      case CSR_MLME_DLSTEARDOWN_CONFIRM_ID:
        sig->u.MlmeDlsteardownConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDlsteardownConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDlsteardownConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDlsteardownConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeDlsteardownConfirm.PeerMacAddress1.x, &ptr[index], 48/8);
        index += 48/8;
        CsrMemCpy(sig->u.MlmeDlsteardownConfirm.PeerMacAddress2.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeDlsteardownConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_EAPOL_REQUEST_ID:
        sig->u.MlmeEapolRequest.Data.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeEapolRequest.Data.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeEapolRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeEapolRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeEapolRequest.Sa.x, &ptr[index], 48/8);
        index += 48/8;
        CsrMemCpy(sig->u.MlmeEapolRequest.Da.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeEapolRequest.Priority = (CSR_PRIORITY) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeEapolRequest.HostTag = COAL_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT32;
        break;
      case CSR_MLME_SAQUERY_INDICATION_ID:
        sig->u.MlmeSaqueryIndication.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryIndication.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeSaqueryIndication.PeerStaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeSaqueryIndication.TransactionId[0] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryIndication.TransactionId[1] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryIndication.TransactionId[2] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryIndication.TransactionId[3] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryIndication.TransactionId[4] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryIndication.TransactionId[5] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryIndication.TransactionId[6] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSaqueryIndication.TransactionId[7] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MA_UNITDATA_CONFIRM_ID:
        sig->u.MaUnitdataConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaUnitdataConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaUnitdataConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaUnitdataConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MaUnitdataConfirm.Da.x, &ptr[index], 48/8);
        index += 48/8;
        CsrMemCpy(sig->u.MaUnitdataConfirm.Sa.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MaUnitdataConfirm.TransmissionStatus = (CSR_TRANSMISSION_STATUS) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaUnitdataConfirm.ProvidedPriority = (CSR_PRIORITY) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaUnitdataConfirm.ProvidedServiceClass = (CSR_SERVICE_CLASS) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaUnitdataConfirm.ProvidedHostTag = COAL_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT32;
        sig->u.MaUnitdataConfirm.Rate = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_TPCADAPT_REQUEST_ID:
        sig->u.MlmeTpcadaptRequest.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeTpcadaptRequest.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeTpcadaptRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeTpcadaptRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeTpcadaptRequest.PeerMacAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeTpcadaptRequest.DialogToken = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeTpcadaptRequest.TransmitRate = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeTpcadaptRequest.TpcadaptFailureTimeout = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_DS_UNITDATA_INDICATION_ID:
        sig->u.DsUnitdataIndication.Data.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DsUnitdataIndication.Data.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DsUnitdataIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DsUnitdataIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.DsUnitdataIndication.Da.x, &ptr[index], 48/8);
        index += 48/8;
        CsrMemCpy(sig->u.DsUnitdataIndication.Sa.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.DsUnitdataIndication.RoutingInformation = (CSR_ROUTING_INFORMATION) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DsUnitdataIndication.ReceptionStatus = (CSR_RECEPTION_STATUS) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DsUnitdataIndication.Priority = (CSR_PRIORITY) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DsUnitdataIndication.ServiceClass = (CSR_SERVICE_CLASS) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DsUnitdataIndication.HostTag = COAL_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT32;
        break;
      case CSR_MLME_REMOTE_REQUEST_CONFIRM_ID:
        sig->u.MlmeRemoteRequestConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeRemoteRequestConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeRemoteRequestConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeRemoteRequestConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeRemoteRequestConfirm.PeerMacAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeRemoteRequestConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADD_TRIGGERED_GET_CONFIRM_ID:
        sig->u.MlmeAddTriggeredGetConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddTriggeredGetConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddTriggeredGetConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddTriggeredGetConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddTriggeredGetConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddTriggeredGetConfirm.TriggeredId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_RESOURCE_REQUEST_RESPONSE_ID:
        sig->u.MlmeResourceRequestResponse.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeResourceRequestResponse.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeResourceRequestResponse.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeResourceRequestResponse.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeResourceRequestResponse.PeerMacAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeResourceRequestResponse.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_SETPROTECTION_REQUEST_ID:
        sig->u.MlmeSetprotectionRequest.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetprotectionRequest.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetprotectionRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetprotectionRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeSetprotectionRequest.Address.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeSetprotectionRequest.ProtectType = (CSR_PROTECT_TYPE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetprotectionRequest.KeyType = (CSR_KEY_TYPE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_SNIFFJOIN_REQUEST_ID:
        sig->u.MlmeSniffjoinRequest.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSniffjoinRequest.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSniffjoinRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSniffjoinRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSniffjoinRequest.Ifindex = (CSR_IFINTERFACE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSniffjoinRequest.Channel = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSniffjoinRequest.ChannelStartingFactor = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_REASSOCIATE_INDICATION_ID:
        sig->u.MlmeReassociateIndication.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeReassociateIndication.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeReassociateIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeReassociateIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeReassociateIndication.PeerStaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        CsrMemCpy(sig->u.MlmeReassociateIndication.CurrentApAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeReassociateIndication.CapabilityInformation = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeReassociateIndication.ListenInterval = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeReassociateIndication.RcpiRequest = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeReassociateIndication.RsniRequest = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_DEL_TRIGGERED_GET_CONFIRM_ID:
        sig->u.MlmeDelTriggeredGetConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelTriggeredGetConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelTriggeredGetConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelTriggeredGetConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelTriggeredGetConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelTriggeredGetConfirm.TriggeredId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_DEBUG_GENERIC_INDICATION_ID:
        sig->u.DebugGenericIndication.DebugVariable.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericIndication.DebugVariable.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericIndication.DebugWords[0] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericIndication.DebugWords[1] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericIndication.DebugWords[2] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericIndication.DebugWords[3] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericIndication.DebugWords[4] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericIndication.DebugWords[5] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericIndication.DebugWords[6] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugGenericIndication.DebugWords[7] = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_DEAUTHENTICATE_INDICATION_ID:
        sig->u.MlmeDeauthenticateIndication.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDeauthenticateIndication.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDeauthenticateIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDeauthenticateIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeDeauthenticateIndication.PeerStaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeDeauthenticateIndication.ReasonCode = (CSR_REASON_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_MREQUEST_REQUEST_ID:
        sig->u.MlmeMrequestRequest.MeasurementRequestSet.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMrequestRequest.MeasurementRequestSet.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMrequestRequest.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMrequestRequest.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeMrequestRequest.PeerMacAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeMrequestRequest.DialogToken = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMrequestRequest.NumberOfRepetitions = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMrequestRequest.MeasurementCategory = (CSR_MEASUREMENT_CATEGORY) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_DELTS_CONFIRM_ID:
        sig->u.MlmeDeltsConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDeltsConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDeltsConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDeltsConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDeltsConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeDeltsConfirm.NonapQstaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeDeltsConfirm.TsInfo = COAL_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT32;
        break;
      case CSR_MLME_DELBA_INDICATION_ID:
        sig->u.MlmeDelbaIndication.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelbaIndication.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelbaIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelbaIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeDelbaIndication.PeerQstaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeDelbaIndication.Direction = (CSR_INITIATOR) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelbaIndication.Tid = (CSR_PRIORITY) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelbaIndication.ReasonCode = (CSR_REASON_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_NEIGHBORREPRESP_CONFIRM_ID:
        sig->u.MlmeNeighborreprespConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeNeighborreprespConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeNeighborreprespConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeNeighborreprespConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeNeighborreprespConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeNeighborreprespConfirm.DialogToken = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADD_WDS_CONFIRM_ID:
        sig->u.MlmeAddWdsConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddWdsConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddWdsConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddWdsConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddWdsConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_ASSOCIATE_REQUEST_ID:
        sig->u.MlmeAssociateRequest.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAssociateRequest.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAssociateRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAssociateRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeAssociateRequest.PeerStaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeAssociateRequest.AssociateFailureTimeout = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAssociateRequest.CapabilityInformation = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAssociateRequest.ListenInterval = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADD_RX_TRIGGER_REQUEST_ID:
        sig->u.MlmeAddRxTriggerRequest.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddRxTriggerRequest.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddRxTriggerRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddRxTriggerRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddRxTriggerRequest.TriggerId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddRxTriggerRequest.Priority = (CSR_PRIORITY) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_REMOTE_REQUEST_REQUEST_ID:
        sig->u.MlmeRemoteRequestRequest.ContentOfFtActionFrame.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeRemoteRequestRequest.ContentOfFtActionFrame.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeRemoteRequestRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeRemoteRequestRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeRemoteRequestRequest.PeerMacAddress.x, &ptr[index], 48/8);
        index += 48/8;
        break;
      case CSR_MLME_HL_SYNC_CANCEL_REQUEST_ID:
        sig->u.MlmeHlSyncCancelRequest.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeHlSyncCancelRequest.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeHlSyncCancelRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeHlSyncCancelRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeHlSyncCancelRequest.GroupAddress.x, &ptr[index], 48/8);
        index += 48/8;
        break;
      case CSR_MLME_REASSOCIATE_REQUEST_ID:
        sig->u.MlmeReassociateRequest.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeReassociateRequest.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeReassociateRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeReassociateRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeReassociateRequest.NewApAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeReassociateRequest.ReassociateFailureTimeout = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeReassociateRequest.CapabilityInformation = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeReassociateRequest.ListenInterval = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_SCAN_INDICATION_ID:
        sig->u.MlmeScanIndication.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScanIndication.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScanIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScanIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScanIndication.Ifindex = (CSR_IFINTERFACE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScanIndication.BssType = (CSR_BSS_TYPE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeScanIndication.Bssid.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeScanIndication.BeaconPeriod = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeScanIndication.Timestamp.x, &ptr[index], 64/8);
        index += 64/8;
        CsrMemCpy(sig->u.MlmeScanIndication.LocalTime.x, &ptr[index], 64/8);
        index += 64/8;
        sig->u.MlmeScanIndication.Channel = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScanIndication.ChannelFrequency = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScanIndication.CapabilityInformation = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScanIndication.Rssi = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScanIndication.Snr = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScanIndication.ReportedFrameInformation = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScanIndication.RcpiMeasurement = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScanIndication.RsniMeasurement = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_AUTONOMOUS_SCAN_DONE_INDICATION_ID:
        sig->u.MlmeAutonomousScanDoneIndication.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanDoneIndication.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanDoneIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanDoneIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanDoneIndication.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAutonomousScanDoneIndication.AutonomousScanId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_DS_STA_NOTIFY_REQUEST_ID:
        sig->u.DsStaNotifyRequest.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DsStaNotifyRequest.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DsStaNotifyRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DsStaNotifyRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.DsStaNotifyRequest.StaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.DsStaNotifyRequest.UpdateType = (CSR_UPDATE_TYPE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_DLS_INDICATION_ID:
        sig->u.MlmeDlsIndication.SupportedRates.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDlsIndication.SupportedRates.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDlsIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDlsIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeDlsIndication.PeerMacAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeDlsIndication.CapabilityInformation = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDlsIndication.DlsTimeoutValue = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDlsIndication.DlsResponseTimeout = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_DLSTEARDOWN_REQUEST_ID:
        sig->u.MlmeDlsteardownRequest.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDlsteardownRequest.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDlsteardownRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDlsteardownRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeDlsteardownRequest.PeerMacAddress1.x, &ptr[index], 48/8);
        index += 48/8;
        CsrMemCpy(sig->u.MlmeDlsteardownRequest.PeerMacAddress2.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeDlsteardownRequest.ReasonCode = (CSR_REASON_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADD_TRIGGERED_GET_REQUEST_ID:
        sig->u.MlmeAddTriggeredGetRequest.MibAttribute.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddTriggeredGetRequest.MibAttribute.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddTriggeredGetRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddTriggeredGetRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddTriggeredGetRequest.TriggeredId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_GET_CONFIRM_ID:
        sig->u.MlmeGetConfirm.MibAttributeValue.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeGetConfirm.MibAttributeValue.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeGetConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeGetConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeGetConfirm.Status = (CSR_MIB_STATUS) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeGetConfirm.ErrorIndex = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_DEAUTHENTICATE_CONFIRM_ID:
        sig->u.MlmeDeauthenticateConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDeauthenticateConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDeauthenticateConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDeauthenticateConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeDeauthenticateConfirm.PeerStaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeDeauthenticateConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_AUTHENTICATE_RESPONSE_ID:
        sig->u.MlmeAuthenticateResponse.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAuthenticateResponse.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAuthenticateResponse.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAuthenticateResponse.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeAuthenticateResponse.PeerStaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeAuthenticateResponse.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADD_RX_TRIGGER_CONFIRM_ID:
        sig->u.MlmeAddRxTriggerConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddRxTriggerConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddRxTriggerConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddRxTriggerConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddRxTriggerConfirm.TriggerId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddRxTriggerConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_VSPECIFIC_REQUEST_ID:
        sig->u.MlmeVspecificRequest.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeVspecificRequest.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeVspecificRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeVspecificRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeVspecificRequest.PeerMacAddress.x, &ptr[index], 48/8);
        index += 48/8;
        break;
      case CSR_MLME_SCHEDULE_CONFIRM_ID:
        sig->u.MlmeScheduleConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScheduleConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScheduleConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScheduleConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScheduleConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_DISASSOCIATE_INDICATION_ID:
        sig->u.MlmeDisassociateIndication.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDisassociateIndication.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDisassociateIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDisassociateIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeDisassociateIndication.PeerStaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeDisassociateIndication.ReasonCode = (CSR_REASON_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADD_BLACKOUT_REQUEST_ID:
        sig->u.MlmeAddBlackoutRequest.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddBlackoutRequest.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddBlackoutRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddBlackoutRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddBlackoutRequest.BlackoutId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddBlackoutRequest.BlackoutType = (CSR_BLACKOUT_TYPE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddBlackoutRequest.BlackoutSource = (CSR_BLACKOUT_SOURCE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddBlackoutRequest.BlackoutStartReference = COAL_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT32;
        sig->u.MlmeAddBlackoutRequest.BlackoutPeriod = COAL_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT32;
        sig->u.MlmeAddBlackoutRequest.BlackoutDuration = COAL_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT32;
        CsrMemCpy(sig->u.MlmeAddBlackoutRequest.PeerStaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        break;
      case CSR_MLME_RESET_CONFIRM_ID:
        sig->u.MlmeResetConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeResetConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeResetConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeResetConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeResetConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_DS_UNITDATA_REQUEST_ID:
        sig->u.DsUnitdataRequest.Data.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DsUnitdataRequest.Data.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DsUnitdataRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DsUnitdataRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.DsUnitdataRequest.Da.x, &ptr[index], 48/8);
        index += 48/8;
        CsrMemCpy(sig->u.DsUnitdataRequest.Sa.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.DsUnitdataRequest.RoutingInformation = (CSR_ROUTING_INFORMATION) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DsUnitdataRequest.Priority = (CSR_PRIORITY) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DsUnitdataRequest.ServiceClass = (CSR_SERVICE_CLASS) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DsUnitdataRequest.SourceType = (CSR_SOURCE_TYPE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_NEIGHBORREPREQ_CONFIRM_ID:
        sig->u.MlmeNeighborrepreqConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeNeighborrepreqConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeNeighborrepreqConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeNeighborrepreqConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeNeighborrepreqConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeNeighborrepreqConfirm.DialogToken = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADD_WDS_REQUEST_ID:
        sig->u.MlmeAddWdsRequest.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddWdsRequest.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddWdsRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddWdsRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeAddWdsRequest.WdsApMacAddress.x, &ptr[index], 48/8);
        index += 48/8;
        break;
      case CSR_MLME_MREPORT_REQUEST_ID:
        sig->u.MlmeMreportRequest.MeasurementReportSet.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMreportRequest.MeasurementReportSet.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMreportRequest.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMreportRequest.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeMreportRequest.PeerMacAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeMreportRequest.DialogToken = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeMreportRequest.MeasurementCategory = (CSR_MEASUREMENT_CATEGORY) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_DEL_WDS_REQUEST_ID:
        sig->u.MlmeDelWdsRequest.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelWdsRequest.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelWdsRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDelWdsRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeDelWdsRequest.WdsApMacAddress.x, &ptr[index], 48/8);
        index += 48/8;
        break;
      case CSR_MLME_ADDBA_CONFIRM_ID:
        sig->u.MlmeAddbaConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeAddbaConfirm.PeerQstaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeAddbaConfirm.DialogToken = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaConfirm.Tid = (CSR_PRIORITY) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaConfirm.BlockAckPolicy = (CSR_BLOCK_ACK_POLICY) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaConfirm.BufferSize = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaConfirm.BlockAckTimeout = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_JOIN_CONFIRM_ID:
        sig->u.MlmeJoinConfirm.BeaconFrame.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeJoinConfirm.BeaconFrame.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeJoinConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeJoinConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeJoinConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_DLS_CONFIRM_ID:
        sig->u.MlmeDlsConfirm.SupportedRates.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDlsConfirm.SupportedRates.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDlsConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDlsConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeDlsConfirm.PeerMacAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeDlsConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDlsConfirm.CapabilityInformation = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDlsConfirm.DlsTimeoutValue = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_RESOURCE_REQUEST_CONFIRM_ID:
        sig->u.MlmeResourceRequestConfirm.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeResourceRequestConfirm.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeResourceRequestConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeResourceRequestConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeResourceRequestConfirm.PeerMacAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeResourceRequestConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_STAKEYESTABLISHED_INDICATION_ID:
        sig->u.MlmeStakeyestablishedIndication.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeStakeyestablishedIndication.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeStakeyestablishedIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeStakeyestablishedIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeStakeyestablishedIndication.Address1.x, &ptr[index], 48/8);
        index += 48/8;
        CsrMemCpy(sig->u.MlmeStakeyestablishedIndication.Address2.x, &ptr[index], 48/8);
        index += 48/8;
        break;
      case CSR_MLME_PAUSE_AUTONOMOUS_SCAN_REQUEST_ID:
        sig->u.MlmePauseAutonomousScanRequest.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmePauseAutonomousScanRequest.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmePauseAutonomousScanRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmePauseAutonomousScanRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmePauseAutonomousScanRequest.AutonomousScanId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmePauseAutonomousScanRequest.Pause = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_REASSOCIATE_CONFIRM_ID:
        sig->u.MlmeReassociateConfirm.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeReassociateConfirm.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeReassociateConfirm.ExchangedFrames.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeReassociateConfirm.ExchangedFrames.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeReassociateConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeReassociateConfirm.CapabilityInformation = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeReassociateConfirm.AssociationId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeReassociateConfirm.RcpiRequest = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeReassociateConfirm.RsniRequest = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeReassociateConfirm.RcpiResponse = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeReassociateConfirm.RsniResponse = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_GET_REQUEST_ID:
        sig->u.MlmeGetRequest.MibAttribute.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeGetRequest.MibAttribute.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeGetRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeGetRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MA_UNITDATA_REQUEST_ID:
        sig->u.MaUnitdataRequest.Data.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaUnitdataRequest.Data.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaUnitdataRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaUnitdataRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MaUnitdataRequest.Da.x, &ptr[index], 48/8);
        index += 48/8;
        CsrMemCpy(sig->u.MaUnitdataRequest.Sa.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MaUnitdataRequest.RoutingInformation = (CSR_ROUTING_INFORMATION) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaUnitdataRequest.Priority = (CSR_PRIORITY) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaUnitdataRequest.ServiceClass = (CSR_SERVICE_CLASS) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaUnitdataRequest.HostTag = COAL_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT32;
        break;
      case CSR_MLME_ADDTS_REQUEST_ID:
        sig->u.MlmeAddtsRequest.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddtsRequest.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddtsRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddtsRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddtsRequest.DialogToken = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddtsRequest.AddtsFailureTimeout = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADD_PERIODIC_REQUEST_ID:
        sig->u.MlmeAddPeriodicRequest.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddPeriodicRequest.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddPeriodicRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddPeriodicRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddPeriodicRequest.PeriodicId = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddPeriodicRequest.MaximumLatency = COAL_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT32;
        sig->u.MlmeAddPeriodicRequest.PeriodicSchedulingMode = (CSR_PERIODIC_SCHEDULING_MODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddPeriodicRequest.WakeHost = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddPeriodicRequest.Tid = (CSR_PRIORITY) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_DELTS_INDICATION_ID:
        sig->u.MlmeDeltsIndication.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDeltsIndication.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDeltsIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDeltsIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeDeltsIndication.NonapQstaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeDeltsIndication.TsInfo = COAL_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT32;
        sig->u.MlmeDeltsIndication.ReasonCode = (CSR_REASON_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_EAPOL_CONFIRM_ID:
        sig->u.MlmeEapolConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeEapolConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeEapolConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeEapolConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeEapolConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeEapolConfirm.ProvidedPriority = (CSR_PRIORITY) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeEapolConfirm.ProvidedHostTag = COAL_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT32;
        break;
      case CSR_MLME_HL_SYNC_CANCEL_CONFIRM_ID:
        sig->u.MlmeHlSyncCancelConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeHlSyncCancelConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeHlSyncCancelConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeHlSyncCancelConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeHlSyncCancelConfirm.GroupAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeHlSyncCancelConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_DELTS_REQUEST_ID:
        sig->u.MlmeDeltsRequest.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDeltsRequest.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDeltsRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeDeltsRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeDeltsRequest.NonapQstaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeDeltsRequest.TsInfo = COAL_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT32;
        sig->u.MlmeDeltsRequest.ReasonCode = (CSR_REASON_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_LINKMEASURE_REQUEST_ID:
        sig->u.MlmeLinkmeasureRequest.InformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeLinkmeasureRequest.InformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeLinkmeasureRequest.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeLinkmeasureRequest.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeLinkmeasureRequest.PeerMacAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeLinkmeasureRequest.DialogToken = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeLinkmeasureRequest.TransmitPower = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeLinkmeasureRequest.MaxTransmitPower = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_SCAN_CONFIRM_ID:
        sig->u.MlmeScanConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScanConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScanConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScanConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeScanConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_CHANNELSWITCH_RESPONSE_ID:
        sig->u.MlmeChannelswitchResponse.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeChannelswitchResponse.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeChannelswitchResponse.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeChannelswitchResponse.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeChannelswitchResponse.Mode = (CSR_CHANNEL_SWITCH_MODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeChannelswitchResponse.ChannelNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeChannelswitchResponse.SecondaryChannelOffset = (CSR_CHANNEL_OFFSET) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeChannelswitchResponse.ChannelSwitchCount = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_DEBUG_STRING_INDICATION_ID:
        sig->u.DebugStringIndication.DebugMessage.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugStringIndication.DebugMessage.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugStringIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.DebugStringIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_FT_JOIN_CONFIRM_ID:
        sig->u.MlmeFtJoinConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeFtJoinConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeFtJoinConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeFtJoinConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeFtJoinConfirm.ResultCode = (CSR_RESULT_CODE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_JOIN_REQUEST_ID:
        sig->u.MlmeJoinRequest.ScanInformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeJoinRequest.ScanInformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeJoinRequest.StaInformationElements.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeJoinRequest.StaInformationElements.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeJoinRequest.Ifindex = (CSR_IFINTERFACE) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeJoinRequest.Bssid.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeJoinRequest.BeaconPeriod = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeJoinRequest.Timestamp.x, &ptr[index], 64/8);
        index += 64/8;
        CsrMemCpy(sig->u.MlmeJoinRequest.LocalTime.x, &ptr[index], 64/8);
        index += 64/8;
        sig->u.MlmeJoinRequest.Channel = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeJoinRequest.CapabilityInformation = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeJoinRequest.JoinFailureTimeout = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeJoinRequest.ProbeDelay = COAL_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT32;
        break;
      case CSR_MLME_SET_CONFIRM_ID:
        sig->u.MlmeSetConfirm.MibAttributeValue.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetConfirm.MibAttributeValue.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetConfirm.Status = (CSR_MIB_STATUS) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeSetConfirm.ErrorIndex = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MLME_ADDBA_INDICATION_ID:
        sig->u.MlmeAddbaIndication.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaIndication.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MlmeAddbaIndication.PeerQstaAddress.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MlmeAddbaIndication.DialogToken = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaIndication.Tid = (CSR_PRIORITY) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaIndication.BlockAckPolicy = (CSR_BLOCK_ACK_POLICY) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaIndication.BufferSize = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MlmeAddbaIndication.BlockAckTimeout = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;
      case CSR_MA_PACKET_CONFIRM_ID:
        sig->u.MaPacketConfirm.Dummydataref1.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaPacketConfirm.Dummydataref1.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaPacketConfirm.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaPacketConfirm.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaPacketConfirm.TransmissionStatus = (CSR_TRANSMISSION_STATUS) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaPacketConfirm.RetryCount = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaPacketConfirm.Rate = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaPacketConfirm.HostTag = COAL_GET_UINT32_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT32;
        break;
      case CSR_MA_UNITDATA_INDICATION_ID:
        sig->u.MaUnitdataIndication.Data.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaUnitdataIndication.Data.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaUnitdataIndication.Dummydataref2.SlotNumber = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaUnitdataIndication.Dummydataref2.DataLength = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        CsrMemCpy(sig->u.MaUnitdataIndication.Da.x, &ptr[index], 48/8);
        index += 48/8;
        CsrMemCpy(sig->u.MaUnitdataIndication.Sa.x, &ptr[index], 48/8);
        index += 48/8;
        sig->u.MaUnitdataIndication.RoutingInformation = (CSR_ROUTING_INFORMATION) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaUnitdataIndication.ReceptionStatus = (CSR_RECEPTION_STATUS) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaUnitdataIndication.Priority = (CSR_PRIORITY) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaUnitdataIndication.ServiceClass = (CSR_SERVICE_CLASS) COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaUnitdataIndication.Rssi = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaUnitdataIndication.Snr = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        sig->u.MaUnitdataIndication.Rate = COAL_GET_UINT16_FROM_LITTLE_ENDIAN(ptr + index);
        index += SIZEOF_UINT16;
        break;

      default:
        return -CSR_EINVAL;
    }
    return 0;
} /* read_unpack_signal() */


/*
 * ---------------------------------------------------------------------------
 *  write_pack
 *
 *      Convert a signal structure, in host-native format, to the
 *      little-endian wire format specified in the UniFi Host Interface
 *      Protocol Specification.
 * 
 *  Arguments:
 *      sig             Pointer to signal structure to pack.
 *      ptr             Destination buffer to pack into.
 *      sig_len         Returns the length of the packed signal, i.e. the
 *                      number of bytes written to ptr.
 *
 *  Returns:
 *      0 on success,
 *      -CSR_EINVAL if the ID of signal was not recognised.
 * ---------------------------------------------------------------------------
 */
CsrInt32
write_pack(const CSR_SIGNAL *sig, CsrUint8 *ptr, CsrUint16 *sig_len)
{
    CsrInt16 index = 0;

    COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->SignalPrimitiveHeader.SignalId, ptr+index);
    index += SIZEOF_UINT16;

    COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->SignalPrimitiveHeader.ReceiverProcessId, ptr+index);
    index += SIZEOF_UINT16;

    COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->SignalPrimitiveHeader.SenderProcessId, ptr+index);
    index += SIZEOF_UINT16;

    switch (sig->SignalPrimitiveHeader.SignalId)
    {
    case CSR_MLME_AUTHENTICATE_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAuthenticateRequest.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAuthenticateRequest.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAuthenticateRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAuthenticateRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeAuthenticateRequest.PeerStaAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAuthenticateRequest.AuthenticationType, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAuthenticateRequest.AuthenticationFailureTimeout, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_ADD_AUTONOMOUS_SCAN_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanConfirm.AutonomousScanId, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_DELBA_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelbaRequest.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelbaRequest.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelbaRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelbaRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeDelbaRequest.PeerQstaAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelbaRequest.Direction, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelbaRequest.Tid, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelbaRequest.ReasonCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_ADD_BLACKOUT_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutConfirm.BlackoutId, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_SETPROTECTION_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetprotectionConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetprotectionConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetprotectionConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetprotectionConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetprotectionConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_SNIFFJOIN_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSniffjoinConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSniffjoinConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSniffjoinConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSniffjoinConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSniffjoinConfirm.Resultcode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_DLS_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsRequest.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsRequest.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeDlsRequest.PeerMacAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsRequest.CapabilityInformation, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsRequest.DlsTimeoutValue, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsRequest.DlsResponseTimeout, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_DEAUTHENTICATE_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeauthenticateRequest.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeauthenticateRequest.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeauthenticateRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeauthenticateRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeDeauthenticateRequest.PeerStaAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeauthenticateRequest.ReasonCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_DEBUG_WORD16_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[0], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[1], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[2], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[3], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[4], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[5], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[6], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[7], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[8], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[9], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[10], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[11], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[12], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[13], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[14], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugWord16Indication.DebugWords[15], ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_REASSOCIATE_RESPONSE_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateResponse.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateResponse.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateResponse.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateResponse.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeReassociateResponse.PeerStaAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateResponse.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateResponse.CapabilityInformation, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateResponse.AssociationId, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateResponse.RcpiRequest, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateResponse.RsniRequest, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MA_PACKET_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketIndication.Data.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketIndication.Data.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MaPacketIndication.LocalTime.x, 64/8);
        index += 64/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketIndication.Channel, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketIndication.ReceptionStatus, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketIndication.Rssi, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketIndication.Snr, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketIndication.Rate, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketIndication.RcpiMeasurement, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketIndication.RsniMeasurement, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketIndication.MsduFragmentNumber, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_MREPORT_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMreportConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMreportConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMreportConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMreportConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMreportConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_REMOTE_REQUEST_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeRemoteRequestIndication.ContentOfFtActionFrame.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeRemoteRequestIndication.ContentOfFtActionFrame.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeRemoteRequestIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeRemoteRequestIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeRemoteRequestIndication.PeerMacAddress.x, 48/8);
        index += 48/8;
        break;
    case CSR_MLME_DEL_RX_TRIGGER_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelRxTriggerRequest.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelRxTriggerRequest.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelRxTriggerRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelRxTriggerRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelRxTriggerRequest.TriggerId, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_CHANNELSWITCH_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeChannelswitchRequest.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeChannelswitchRequest.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeChannelswitchRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeChannelswitchRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeChannelswitchRequest.Mode, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeChannelswitchRequest.ChannelNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeChannelswitchRequest.SecondaryChannelOffset, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeChannelswitchRequest.ChannelSwitchCount, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_SCAN_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanRequest.ChannelList.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanRequest.ChannelList.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanRequest.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanRequest.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanRequest.Ifindex, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanRequest.BssType, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeScanRequest.Da.x, 48/8);
        index += 48/8;
        CsrMemCpy(ptr+index, sig->u.MlmeScanRequest.Bssid.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanRequest.ScanType, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MlmeScanRequest.ProbeDelay, ptr+index);
        index += SIZEOF_UINT32;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanRequest.MinChannelTime, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanRequest.MaxChannelTime, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_DELETEKEYS_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeletekeysConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeletekeysConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeletekeysConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeletekeysConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeletekeysConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MA_UNITDATA_CANCEL_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaUnitdataCancelRequest.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaUnitdataCancelRequest.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaUnitdataCancelRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaUnitdataCancelRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MaUnitdataCancelRequest.HostTag, ptr+index);
        index += SIZEOF_UINT32;
        break;
    case CSR_MLME_HL_SYNC_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncRequest.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncRequest.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeHlSyncRequest.GroupAddress.x, 48/8);
        index += 48/8;
        break;
    case CSR_MLME_SET_UNITDATA_FILTER_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetUnitdataFilterConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetUnitdataFilterConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetUnitdataFilterConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetUnitdataFilterConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetUnitdataFilterConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_MICHAELMICFAILURE_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMichaelmicfailureIndication.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMichaelmicfailureIndication.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMichaelmicfailureIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMichaelmicfailureIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMichaelmicfailureIndication.Count, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeMichaelmicfailureIndication.Address.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMichaelmicfailureIndication.KeyType, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMichaelmicfailureIndication.KeyId, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMichaelmicfailureIndication.Tsc[0], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMichaelmicfailureIndication.Tsc[1], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMichaelmicfailureIndication.Tsc[2], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMichaelmicfailureIndication.Tsc[3], ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_AUTONOMOUS_SCAN_RESULTS_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanResultsRequest.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanResultsRequest.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanResultsRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanResultsRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanResultsRequest.AutonomousScanId, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_DEL_TRIGGERED_GET_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTriggeredGetRequest.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTriggeredGetRequest.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTriggeredGetRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTriggeredGetRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTriggeredGetRequest.TriggeredId, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_MREQUEST_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMrequestConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMrequestConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMrequestConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMrequestConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMrequestConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_DEL_WDS_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelWdsConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelWdsConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelWdsConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelWdsConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelWdsConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_RESET_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResetRequest.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResetRequest.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResetRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResetRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeResetRequest.StaAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResetRequest.SetDefaultMib, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_START_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeStartConfirm.Bssid.x, 48/8);
        index += 48/8;
        break;
    case CSR_MLME_SCAN_CANCEL_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanCancelRequest.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanCancelRequest.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanCancelRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanCancelRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_ASSOCIATE_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateIndication.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateIndication.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeAssociateIndication.PeerStaAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateIndication.CapabilityInformation, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateIndication.ListenInterval, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateIndication.RcpiRequest, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateIndication.RsniRequest, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_AUTONOMOUS_SCAN_RESULTS_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanResultsConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanResultsConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanResultsConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanResultsConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanResultsConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanResultsConfirm.AutonomousScanId, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_RESOURCE_REQUEST_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResourceRequestRequest.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResourceRequestRequest.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResourceRequestRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResourceRequestRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeResourceRequestRequest.PeerMacAddress.x, 48/8);
        index += 48/8;
        break;
    case CSR_MLME_DEL_RX_TRIGGER_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelRxTriggerConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelRxTriggerConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelRxTriggerConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelRxTriggerConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelRxTriggerConfirm.TriggerId, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelRxTriggerConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_AUTHENTICATE_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAuthenticateConfirm.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAuthenticateConfirm.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAuthenticateConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAuthenticateConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeAuthenticateConfirm.PeerStaAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAuthenticateConfirm.AuthenticationType, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAuthenticateConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_ADDTS_RESPONSE_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddtsResponse.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddtsResponse.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddtsResponse.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddtsResponse.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddtsResponse.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddtsResponse.DialogToken, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeAddtsResponse.NonapQstaAddress.x, 48/8);
        index += 48/8;
        break;
    case CSR_MLME_DEL_BLACKOUT_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelBlackoutConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelBlackoutConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelBlackoutConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelBlackoutConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelBlackoutConfirm.BlackoutId, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelBlackoutConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_MREQUEST_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMrequestIndication.MeasurementRequestSet.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMrequestIndication.MeasurementRequestSet.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMrequestIndication.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMrequestIndication.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeMrequestIndication.PeerMacAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMrequestIndication.DialogToken, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMrequestIndication.NumberOfRepetitions, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMrequestIndication.MeasurementCategory, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_PAUSE_AUTONOMOUS_SCAN_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePauseAutonomousScanConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePauseAutonomousScanConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePauseAutonomousScanConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePauseAutonomousScanConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePauseAutonomousScanConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePauseAutonomousScanConfirm.AutonomousScanId, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_START_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartRequest.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartRequest.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartRequest.Ifindex, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartRequest.BeaconPeriod, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartRequest.Channel, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MlmeStartRequest.ProbeDelay, ptr+index);
        index += SIZEOF_UINT32;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartRequest.CapabilityInformation, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStartRequest.BluetoothAmp, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MA_PACKET_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketRequest.Data.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketRequest.Data.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketRequest.TransmitRate, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MaPacketRequest.HostTag, ptr+index);
        index += SIZEOF_UINT32;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketRequest.Priority, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_SAQUERY_RESPONSE_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryResponse.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryResponse.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryResponse.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryResponse.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeSaqueryResponse.PeerStaAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryResponse.TransactionId[0], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryResponse.TransactionId[1], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryResponse.TransactionId[2], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryResponse.TransactionId[3], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryResponse.TransactionId[4], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryResponse.TransactionId[5], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryResponse.TransactionId[6], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryResponse.TransactionId[7], ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_ASSOCIATE_RESPONSE_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateResponse.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateResponse.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateResponse.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateResponse.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeAssociateResponse.PeerStaAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateResponse.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateResponse.CapabilityInformation, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateResponse.AssociationId, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateResponse.RcpiRequest, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateResponse.RsniRequest, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_DEL_AUTONOMOUS_SCAN_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelAutonomousScanRequest.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelAutonomousScanRequest.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelAutonomousScanRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelAutonomousScanRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelAutonomousScanRequest.AutonomousScanId, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_ADDTS_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddtsIndication.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddtsIndication.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddtsIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddtsIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddtsIndication.DialogToken, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeAddtsIndication.NonapQstaAddress.x, 48/8);
        index += 48/8;
        break;
    case CSR_MLME_RESOURCE_REQUEST_LOCAL_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResourceRequestLocalRequest.ResourceDescriptors.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResourceRequestLocalRequest.ResourceDescriptors.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResourceRequestLocalRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResourceRequestLocalRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeResourceRequestLocalRequest.MacAddress.x, 48/8);
        index += 48/8;
        break;
    case CSR_MLME_MEASURE_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMeasureConfirm.MeasurementReportSet.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMeasureConfirm.MeasurementReportSet.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMeasureConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMeasureConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMeasureConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMeasureConfirm.DialogToken, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_POWERMGT_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePowermgtConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePowermgtConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePowermgtConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePowermgtConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePowermgtConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_RESOURCE_REQUEST_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResourceRequestIndication.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResourceRequestIndication.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResourceRequestIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResourceRequestIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeResourceRequestIndication.PeerMacAddress.x, 48/8);
        index += 48/8;
        break;
    case CSR_MLME_ADD_PERIODIC_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddPeriodicConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddPeriodicConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddPeriodicConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddPeriodicConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddPeriodicConfirm.PeriodicId, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddPeriodicConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_SCHEDULE_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScheduleRequest.ScheduleElement.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScheduleRequest.ScheduleElement.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScheduleRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScheduleRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeScheduleRequest.NonapQstaAddress.x, 48/8);
        index += 48/8;
        break;
    case CSR_MLME_GET_NEXT_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetNextConfirm.MibAttributeValue.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetNextConfirm.MibAttributeValue.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetNextConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetNextConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetNextConfirm.Status, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetNextConfirm.ErrorIndex, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_AUTHENTICATE_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAuthenticateIndication.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAuthenticateIndication.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAuthenticateIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAuthenticateIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeAuthenticateIndication.PeerStaAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAuthenticateIndication.AuthenticationType, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_NEIGHBORREPREQ_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborrepreqIndication.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborrepreqIndication.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborrepreqIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborrepreqIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeNeighborrepreqIndication.PeerStaAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborrepreqIndication.DialogToken, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_DELETEKEYS_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeletekeysRequest.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeletekeysRequest.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeletekeysRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeletekeysRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeletekeysRequest.KeyId, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeletekeysRequest.KeyType, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeDeletekeysRequest.Address.x, 48/8);
        index += 48/8;
        break;
    case CSR_MLME_DELBA_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelbaConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelbaConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelbaConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelbaConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeDelbaConfirm.PeerQstaAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelbaConfirm.Direction, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelbaConfirm.Tid, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelbaConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_HL_SYNC_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeHlSyncConfirm.GroupAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_ADD_AUTONOMOUS_SCAN_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanRequest.ChannelList.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanRequest.ChannelList.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanRequest.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanRequest.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanRequest.AutonomousScanId, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanRequest.Ifindex, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanRequest.ChannelStartingFactor, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanRequest.BssType, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeAddAutonomousScanRequest.Bssid.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanRequest.ScanType, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanRequest.ProbeDelay, ptr+index);
        index += SIZEOF_UINT32;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanRequest.MinChannelTime, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddAutonomousScanRequest.MaxChannelTime, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_DISASSOCIATE_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDisassociateConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDisassociateConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDisassociateConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDisassociateConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDisassociateConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_SET_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetRequest.MibAttributeValue.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetRequest.MibAttributeValue.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_DEL_AUTONOMOUS_SCAN_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelAutonomousScanConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelAutonomousScanConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelAutonomousScanConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelAutonomousScanConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelAutonomousScanConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelAutonomousScanConfirm.AutonomousScanId, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_MREPORT_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMreportIndication.MeasurementReportSet.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMreportIndication.MeasurementReportSet.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMreportIndication.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMreportIndication.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeMreportIndication.PeerMacAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMreportIndication.DialogToken, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMreportIndication.MeasurementCategory, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_RESOURCE_REQUEST_LOCAL_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResourceRequestLocalConfirm.ResourceDescriptors.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResourceRequestLocalConfirm.ResourceDescriptors.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResourceRequestLocalConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResourceRequestLocalConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeResourceRequestLocalConfirm.MacAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResourceRequestLocalConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_DEL_PERIODIC_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelPeriodicRequest.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelPeriodicRequest.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelPeriodicRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelPeriodicRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelPeriodicRequest.PeriodicId, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_SETKEYS_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.Key.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.Key.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.Length, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.KeyId, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.KeyType, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeSetkeysRequest.Address.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.SequenceNumber[0], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.SequenceNumber[1], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.SequenceNumber[2], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.SequenceNumber[3], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.SequenceNumber[4], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.SequenceNumber[5], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.SequenceNumber[6], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.SequenceNumber[7], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysRequest.AuthenticatorSupplicantOrInitiatorPeer, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, &sig->u.MlmeSetkeysRequest.CipherSuiteSelector, 32/8);
        index += 32/8;
        break;
    case CSR_MA_SNIFFDATA_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaSniffdataIndication.Data.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaSniffdataIndication.Data.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaSniffdataIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaSniffdataIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MaSniffdataIndication.Timestamp.x, 64/8);
        index += 64/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaSniffdataIndication.Duration, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaSniffdataIndication.Rate, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaSniffdataIndication.AntennaId, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaSniffdataIndication.Rssi, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaSniffdataIndication.Snr, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MaSniffdataIndication.FrequencyOffset, ptr+index);
        index += SIZEOF_UINT32;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaSniffdataIndication.ReceptionStatus, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_HL_SYNC_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncIndication.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncIndication.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeHlSyncIndication.GroupAddress.x, 48/8);
        index += 48/8;
        CsrMemCpy(ptr+index, sig->u.MlmeHlSyncIndication.SourceAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncIndication.SequenceNumber, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_ADDBA_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaRequest.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaRequest.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeAddbaRequest.PeerQstaAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaRequest.DialogToken, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaRequest.Tid, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaRequest.BlockAckPolicy, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaRequest.BufferSize, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaRequest.BlockAckTimeout, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaRequest.AddbaFailureTimeout, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaRequest.BlockAckStartingSequenceControl, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_DLSTEARDOWN_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsteardownIndication.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsteardownIndication.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsteardownIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsteardownIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeDlsteardownIndication.PeerMacAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsteardownIndication.ReasonCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_FT_JOIN_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeFtJoinRequest.ScanInformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeFtJoinRequest.ScanInformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeFtJoinRequest.StaInformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeFtJoinRequest.StaInformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeFtJoinRequest.Ifindex, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeFtJoinRequest.Bssid.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeFtJoinRequest.BeaconPeriod, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeFtJoinRequest.Timestamp.x, 64/8);
        index += 64/8;
        CsrMemCpy(ptr+index, sig->u.MlmeFtJoinRequest.LocalTime.x, 64/8);
        index += 64/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeFtJoinRequest.Channel, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeFtJoinRequest.CapabilityInformation, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeFtJoinRequest.JoinFailureTimeout, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MlmeFtJoinRequest.ProbeDelay, ptr+index);
        index += SIZEOF_UINT32;
        break;
    case CSR_MLME_POWERMGT_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePowermgtRequest.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePowermgtRequest.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePowermgtRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePowermgtRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePowermgtRequest.PowerManagementMode, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePowermgtRequest.WakeUp, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePowermgtRequest.ReceiveDtims, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePowermgtRequest.ListenInterval, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_DISASSOCIATE_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDisassociateRequest.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDisassociateRequest.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDisassociateRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDisassociateRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeDisassociateRequest.PeerStaAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDisassociateRequest.ReasonCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_TPCADAPT_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTpcadaptConfirm.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTpcadaptConfirm.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTpcadaptConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTpcadaptConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTpcadaptConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTpcadaptConfirm.DialogToken, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTpcadaptConfirm.RequestRate, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTpcadaptConfirm.RequestTransmitPower, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTpcadaptConfirm.RequestLinkMargin, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTpcadaptConfirm.ReportRate, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTpcadaptConfirm.ReportTransmitPower, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTpcadaptConfirm.ReportLinkMargin, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_LINKMEASURE_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeLinkmeasureConfirm.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeLinkmeasureConfirm.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeLinkmeasureConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeLinkmeasureConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeLinkmeasureConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeLinkmeasureConfirm.DialogToken, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeLinkmeasureConfirm.TransmitPower, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeLinkmeasureConfirm.LinkMargin, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeLinkmeasureConfirm.ReceiveAntennaId, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeLinkmeasureConfirm.TransmitAntennaId, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeLinkmeasureConfirm.RcpiRequest, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeLinkmeasureConfirm.RsniRequest, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeLinkmeasureConfirm.RcpiReport, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeLinkmeasureConfirm.RsniReport, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_PROTECTEDFRAMEDROPPED_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeProtectedframedroppedIndication.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeProtectedframedroppedIndication.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeProtectedframedroppedIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeProtectedframedroppedIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeProtectedframedroppedIndication.Address1.x, 48/8);
        index += 48/8;
        CsrMemCpy(ptr+index, sig->u.MlmeProtectedframedroppedIndication.Address2.x, 48/8);
        index += 48/8;
        break;
    case CSR_MLME_NEIGHBORREPRESP_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborreprespIndication.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborreprespIndication.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborreprespIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborreprespIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborreprespIndication.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborreprespIndication.DialogToken, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_VSPECIFIC_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeVspecificConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeVspecificConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeVspecificConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeVspecificConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeVspecificConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_VSPECIFIC_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeVspecificIndication.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeVspecificIndication.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeVspecificIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeVspecificIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeVspecificIndication.PeerMacAddress.x, 48/8);
        index += 48/8;
        break;
    case CSR_MLME_MEASURE_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMeasureRequest.MeasurementRequestSet.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMeasureRequest.MeasurementRequestSet.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMeasureRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMeasureRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMeasureRequest.DialogToken, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_ASSOCIATE_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateConfirm.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateConfirm.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateConfirm.ExchangedFrames.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateConfirm.ExchangedFrames.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateConfirm.CapabilityInformation, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateConfirm.AssociationId, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateConfirm.RcpiRequest, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateConfirm.RsniRequest, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateConfirm.RcpiResponse, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateConfirm.RsniResponse, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_SAQUERY_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeSaqueryConfirm.PeerStaAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryConfirm.TransactionId[0], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryConfirm.TransactionId[1], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryConfirm.TransactionId[2], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryConfirm.TransactionId[3], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryConfirm.TransactionId[4], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryConfirm.TransactionId[5], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryConfirm.TransactionId[6], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryConfirm.TransactionId[7], ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_AUTONOMOUS_SCAN_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanIndication.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanIndication.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanIndication.AutonomousScanId, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanIndication.BssType, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeAutonomousScanIndication.Bssid.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanIndication.BeaconPeriod, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeAutonomousScanIndication.Timestamp.x, 64/8);
        index += 64/8;
        CsrMemCpy(ptr+index, sig->u.MlmeAutonomousScanIndication.LocalTime.x, 64/8);
        index += 64/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanIndication.Channel, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanIndication.ChannelFrequency, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanIndication.CapabilityInformation, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanIndication.Rssi, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanIndication.Snr, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanIndication.ReportedFrameInformation, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanIndication.RcpiMeasurement, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanIndication.RsniMeasurement, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_DEL_PERIODIC_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelPeriodicConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelPeriodicConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelPeriodicConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelPeriodicConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelPeriodicConfirm.PeriodicId, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelPeriodicConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_SCHEDULE_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScheduleIndication.ScheduleElement.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScheduleIndication.ScheduleElement.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScheduleIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScheduleIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_NEIGHBORREPREQ_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborrepreqRequest.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborrepreqRequest.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborrepreqRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborrepreqRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborrepreqRequest.DialogToken, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_SETKEYS_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetkeysConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_DS_UNITDATA_RESPONSE_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsUnitdataResponse.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsUnitdataResponse.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsUnitdataResponse.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsUnitdataResponse.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.DsUnitdataResponse.Da.x, 48/8);
        index += 48/8;
        CsrMemCpy(ptr+index, sig->u.DsUnitdataResponse.Sa.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsUnitdataResponse.TransmissionStatus, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsUnitdataResponse.RoutingInformation, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsUnitdataResponse.ProvidedPriority, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsUnitdataResponse.ProvidedServiceClass, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.DsUnitdataResponse.ProvidedHostTag, ptr+index);
        index += SIZEOF_UINT32;
        break;
    case CSR_MLME_DEL_BLACKOUT_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelBlackoutRequest.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelBlackoutRequest.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelBlackoutRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelBlackoutRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelBlackoutRequest.BlackoutId, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_DEBUG_GENERIC_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericConfirm.DebugVariable.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericConfirm.DebugVariable.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericConfirm.DebugWords[0], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericConfirm.DebugWords[1], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericConfirm.DebugWords[2], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericConfirm.DebugWords[3], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericConfirm.DebugWords[4], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericConfirm.DebugWords[5], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericConfirm.DebugWords[6], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericConfirm.DebugWords[7], ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_ADDBA_RESPONSE_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaResponse.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaResponse.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaResponse.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaResponse.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeAddbaResponse.PeerQstaAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaResponse.DialogToken, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaResponse.Tid, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaResponse.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaResponse.BlockAckPolicy, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaResponse.BufferSize, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaResponse.BlockAckTimeout, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_CONNECTED_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConnectedIndication.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConnectedIndication.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConnectedIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConnectedIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeConnectedIndication.ConnectionStatus, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeConnectedIndication.PeerMacAddress.x, 48/8);
        index += 48/8;
        break;
    case CSR_MLME_NEIGHBORREPRESP_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborreprespRequest.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborreprespRequest.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborreprespRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborreprespRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeNeighborreprespRequest.PeerStaAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborreprespRequest.DialogToken, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_CHANNELSWITCH_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeChannelswitchConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeChannelswitchConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeChannelswitchConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeChannelswitchConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeChannelswitchConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_TRIGGERED_GET_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTriggeredGetIndication.MibAttributeValue.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTriggeredGetIndication.MibAttributeValue.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTriggeredGetIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTriggeredGetIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTriggeredGetIndication.Status, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTriggeredGetIndication.ErrorIndex, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTriggeredGetIndication.TriggeredId, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_GET_NEXT_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetNextRequest.MibAttribute.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetNextRequest.MibAttribute.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetNextRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetNextRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_ADDTS_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddtsConfirm.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddtsConfirm.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddtsConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddtsConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddtsConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddtsConfirm.DialogToken, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_AUTONOMOUS_SCAN_RESULTS_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanResultsIndication.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanResultsIndication.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanResultsIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanResultsIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanResultsIndication.AutonomousScanId, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeAutonomousScanResultsIndication.Bssid.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanResultsIndication.Channel, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanResultsIndication.ChannelFrequency, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanResultsIndication.Rssi, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanResultsIndication.Snr, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_DEBUG_GENERIC_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericRequest.DebugVariable.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericRequest.DebugVariable.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericRequest.DebugWords[0], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericRequest.DebugWords[1], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericRequest.DebugWords[2], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericRequest.DebugWords[3], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericRequest.DebugWords[4], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericRequest.DebugWords[5], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericRequest.DebugWords[6], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericRequest.DebugWords[7], ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_SET_UNITDATA_FILTER_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetUnitdataFilterRequest.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetUnitdataFilterRequest.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetUnitdataFilterRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetUnitdataFilterRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetUnitdataFilterRequest.UnitDataFilterMode, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MlmeSetUnitdataFilterRequest.ArpFilterAddress, ptr+index);
        index += SIZEOF_UINT32;
        break;
    case CSR_MLME_SAQUERY_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryRequest.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryRequest.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeSaqueryRequest.PeerStaAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryRequest.TransactionId[0], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryRequest.TransactionId[1], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryRequest.TransactionId[2], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryRequest.TransactionId[3], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryRequest.TransactionId[4], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryRequest.TransactionId[5], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryRequest.TransactionId[6], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryRequest.TransactionId[7], ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_CHANNELSWITCH_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeChannelswitchIndication.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeChannelswitchIndication.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeChannelswitchIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeChannelswitchIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeChannelswitchIndication.PeerMacAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeChannelswitchIndication.Mode, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeChannelswitchIndication.ChannelNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeChannelswitchIndication.SecondaryChannelOffset, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeChannelswitchIndication.ChannelSwitchCount, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_DS_UNITDATA_CANCEL_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsUnitdataCancelIndication.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsUnitdataCancelIndication.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsUnitdataCancelIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsUnitdataCancelIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.DsUnitdataCancelIndication.HostTag, ptr+index);
        index += SIZEOF_UINT32;
        break;
    case CSR_MLME_DLSTEARDOWN_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsteardownConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsteardownConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsteardownConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsteardownConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeDlsteardownConfirm.PeerMacAddress1.x, 48/8);
        index += 48/8;
        CsrMemCpy(ptr+index, sig->u.MlmeDlsteardownConfirm.PeerMacAddress2.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsteardownConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_EAPOL_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeEapolRequest.Data.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeEapolRequest.Data.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeEapolRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeEapolRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeEapolRequest.Sa.x, 48/8);
        index += 48/8;
        CsrMemCpy(ptr+index, sig->u.MlmeEapolRequest.Da.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeEapolRequest.Priority, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MlmeEapolRequest.HostTag, ptr+index);
        index += SIZEOF_UINT32;
        break;
    case CSR_MLME_SAQUERY_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryIndication.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryIndication.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeSaqueryIndication.PeerStaAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryIndication.TransactionId[0], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryIndication.TransactionId[1], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryIndication.TransactionId[2], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryIndication.TransactionId[3], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryIndication.TransactionId[4], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryIndication.TransactionId[5], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryIndication.TransactionId[6], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSaqueryIndication.TransactionId[7], ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MA_UNITDATA_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaUnitdataConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaUnitdataConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaUnitdataConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaUnitdataConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MaUnitdataConfirm.Da.x, 48/8);
        index += 48/8;
        CsrMemCpy(ptr+index, sig->u.MaUnitdataConfirm.Sa.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaUnitdataConfirm.TransmissionStatus, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaUnitdataConfirm.ProvidedPriority, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaUnitdataConfirm.ProvidedServiceClass, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MaUnitdataConfirm.ProvidedHostTag, ptr+index);
        index += SIZEOF_UINT32;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaUnitdataConfirm.Rate, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_TPCADAPT_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTpcadaptRequest.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTpcadaptRequest.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTpcadaptRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTpcadaptRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeTpcadaptRequest.PeerMacAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTpcadaptRequest.DialogToken, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTpcadaptRequest.TransmitRate, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeTpcadaptRequest.TpcadaptFailureTimeout, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_DS_UNITDATA_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsUnitdataIndication.Data.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsUnitdataIndication.Data.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsUnitdataIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsUnitdataIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.DsUnitdataIndication.Da.x, 48/8);
        index += 48/8;
        CsrMemCpy(ptr+index, sig->u.DsUnitdataIndication.Sa.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsUnitdataIndication.RoutingInformation, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsUnitdataIndication.ReceptionStatus, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsUnitdataIndication.Priority, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsUnitdataIndication.ServiceClass, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.DsUnitdataIndication.HostTag, ptr+index);
        index += SIZEOF_UINT32;
        break;
    case CSR_MLME_REMOTE_REQUEST_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeRemoteRequestConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeRemoteRequestConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeRemoteRequestConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeRemoteRequestConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeRemoteRequestConfirm.PeerMacAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeRemoteRequestConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_ADD_TRIGGERED_GET_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTriggeredGetConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTriggeredGetConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTriggeredGetConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTriggeredGetConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTriggeredGetConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTriggeredGetConfirm.TriggeredId, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_RESOURCE_REQUEST_RESPONSE_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResourceRequestResponse.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResourceRequestResponse.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResourceRequestResponse.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResourceRequestResponse.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeResourceRequestResponse.PeerMacAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResourceRequestResponse.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_SETPROTECTION_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetprotectionRequest.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetprotectionRequest.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetprotectionRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetprotectionRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeSetprotectionRequest.Address.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetprotectionRequest.ProtectType, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetprotectionRequest.KeyType, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_SNIFFJOIN_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSniffjoinRequest.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSniffjoinRequest.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSniffjoinRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSniffjoinRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSniffjoinRequest.Ifindex, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSniffjoinRequest.Channel, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSniffjoinRequest.ChannelStartingFactor, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_REASSOCIATE_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateIndication.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateIndication.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeReassociateIndication.PeerStaAddress.x, 48/8);
        index += 48/8;
        CsrMemCpy(ptr+index, sig->u.MlmeReassociateIndication.CurrentApAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateIndication.CapabilityInformation, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateIndication.ListenInterval, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateIndication.RcpiRequest, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateIndication.RsniRequest, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_DEL_TRIGGERED_GET_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTriggeredGetConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTriggeredGetConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTriggeredGetConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTriggeredGetConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTriggeredGetConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelTriggeredGetConfirm.TriggeredId, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_DEBUG_GENERIC_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericIndication.DebugVariable.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericIndication.DebugVariable.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericIndication.DebugWords[0], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericIndication.DebugWords[1], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericIndication.DebugWords[2], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericIndication.DebugWords[3], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericIndication.DebugWords[4], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericIndication.DebugWords[5], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericIndication.DebugWords[6], ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugGenericIndication.DebugWords[7], ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_DEAUTHENTICATE_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeauthenticateIndication.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeauthenticateIndication.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeauthenticateIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeauthenticateIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeDeauthenticateIndication.PeerStaAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeauthenticateIndication.ReasonCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_MREQUEST_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMrequestRequest.MeasurementRequestSet.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMrequestRequest.MeasurementRequestSet.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMrequestRequest.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMrequestRequest.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeMrequestRequest.PeerMacAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMrequestRequest.DialogToken, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMrequestRequest.NumberOfRepetitions, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMrequestRequest.MeasurementCategory, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_DELTS_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeltsConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeltsConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeltsConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeltsConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeltsConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeDeltsConfirm.NonapQstaAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MlmeDeltsConfirm.TsInfo, ptr+index);
        index += SIZEOF_UINT32;
        break;
    case CSR_MLME_DELBA_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelbaIndication.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelbaIndication.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelbaIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelbaIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeDelbaIndication.PeerQstaAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelbaIndication.Direction, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelbaIndication.Tid, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelbaIndication.ReasonCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_NEIGHBORREPRESP_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborreprespConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborreprespConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborreprespConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborreprespConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborreprespConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborreprespConfirm.DialogToken, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_ADD_WDS_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddWdsConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddWdsConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddWdsConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddWdsConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddWdsConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_ASSOCIATE_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateRequest.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateRequest.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeAssociateRequest.PeerStaAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateRequest.AssociateFailureTimeout, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateRequest.CapabilityInformation, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAssociateRequest.ListenInterval, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_ADD_RX_TRIGGER_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddRxTriggerRequest.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddRxTriggerRequest.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddRxTriggerRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddRxTriggerRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddRxTriggerRequest.TriggerId, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddRxTriggerRequest.Priority, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_REMOTE_REQUEST_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeRemoteRequestRequest.ContentOfFtActionFrame.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeRemoteRequestRequest.ContentOfFtActionFrame.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeRemoteRequestRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeRemoteRequestRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeRemoteRequestRequest.PeerMacAddress.x, 48/8);
        index += 48/8;
        break;
    case CSR_MLME_HL_SYNC_CANCEL_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncCancelRequest.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncCancelRequest.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncCancelRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncCancelRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeHlSyncCancelRequest.GroupAddress.x, 48/8);
        index += 48/8;
        break;
    case CSR_MLME_REASSOCIATE_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateRequest.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateRequest.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeReassociateRequest.NewApAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateRequest.ReassociateFailureTimeout, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateRequest.CapabilityInformation, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateRequest.ListenInterval, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_SCAN_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanIndication.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanIndication.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanIndication.Ifindex, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanIndication.BssType, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeScanIndication.Bssid.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanIndication.BeaconPeriod, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeScanIndication.Timestamp.x, 64/8);
        index += 64/8;
        CsrMemCpy(ptr+index, sig->u.MlmeScanIndication.LocalTime.x, 64/8);
        index += 64/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanIndication.Channel, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanIndication.ChannelFrequency, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanIndication.CapabilityInformation, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanIndication.Rssi, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanIndication.Snr, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanIndication.ReportedFrameInformation, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanIndication.RcpiMeasurement, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanIndication.RsniMeasurement, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_AUTONOMOUS_SCAN_DONE_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanDoneIndication.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanDoneIndication.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanDoneIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanDoneIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanDoneIndication.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAutonomousScanDoneIndication.AutonomousScanId, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_DS_STA_NOTIFY_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsStaNotifyRequest.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsStaNotifyRequest.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsStaNotifyRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsStaNotifyRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.DsStaNotifyRequest.StaAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsStaNotifyRequest.UpdateType, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_DLS_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsIndication.SupportedRates.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsIndication.SupportedRates.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeDlsIndication.PeerMacAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsIndication.CapabilityInformation, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsIndication.DlsTimeoutValue, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsIndication.DlsResponseTimeout, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_DLSTEARDOWN_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsteardownRequest.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsteardownRequest.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsteardownRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsteardownRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeDlsteardownRequest.PeerMacAddress1.x, 48/8);
        index += 48/8;
        CsrMemCpy(ptr+index, sig->u.MlmeDlsteardownRequest.PeerMacAddress2.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsteardownRequest.ReasonCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_ADD_TRIGGERED_GET_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTriggeredGetRequest.MibAttribute.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTriggeredGetRequest.MibAttribute.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTriggeredGetRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTriggeredGetRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddTriggeredGetRequest.TriggeredId, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_GET_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetConfirm.MibAttributeValue.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetConfirm.MibAttributeValue.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetConfirm.Status, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetConfirm.ErrorIndex, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_DEAUTHENTICATE_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeauthenticateConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeauthenticateConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeauthenticateConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeauthenticateConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeDeauthenticateConfirm.PeerStaAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeauthenticateConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_AUTHENTICATE_RESPONSE_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAuthenticateResponse.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAuthenticateResponse.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAuthenticateResponse.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAuthenticateResponse.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeAuthenticateResponse.PeerStaAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAuthenticateResponse.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_ADD_RX_TRIGGER_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddRxTriggerConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddRxTriggerConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddRxTriggerConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddRxTriggerConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddRxTriggerConfirm.TriggerId, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddRxTriggerConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_VSPECIFIC_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeVspecificRequest.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeVspecificRequest.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeVspecificRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeVspecificRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeVspecificRequest.PeerMacAddress.x, 48/8);
        index += 48/8;
        break;
    case CSR_MLME_SCHEDULE_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScheduleConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScheduleConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScheduleConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScheduleConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScheduleConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_DISASSOCIATE_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDisassociateIndication.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDisassociateIndication.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDisassociateIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDisassociateIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeDisassociateIndication.PeerStaAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDisassociateIndication.ReasonCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_ADD_BLACKOUT_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutRequest.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutRequest.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutRequest.BlackoutId, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutRequest.BlackoutType, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutRequest.BlackoutSource, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutRequest.BlackoutStartReference, ptr+index);
        index += SIZEOF_UINT32;
        COAL_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutRequest.BlackoutPeriod, ptr+index);
        index += SIZEOF_UINT32;
        COAL_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MlmeAddBlackoutRequest.BlackoutDuration, ptr+index);
        index += SIZEOF_UINT32;
        CsrMemCpy(ptr+index, sig->u.MlmeAddBlackoutRequest.PeerStaAddress.x, 48/8);
        index += 48/8;
        break;
    case CSR_MLME_RESET_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResetConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResetConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResetConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResetConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResetConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_DS_UNITDATA_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsUnitdataRequest.Data.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsUnitdataRequest.Data.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsUnitdataRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsUnitdataRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.DsUnitdataRequest.Da.x, 48/8);
        index += 48/8;
        CsrMemCpy(ptr+index, sig->u.DsUnitdataRequest.Sa.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsUnitdataRequest.RoutingInformation, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsUnitdataRequest.Priority, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsUnitdataRequest.ServiceClass, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DsUnitdataRequest.SourceType, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_NEIGHBORREPREQ_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborrepreqConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborrepreqConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborrepreqConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborrepreqConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborrepreqConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeNeighborrepreqConfirm.DialogToken, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_ADD_WDS_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddWdsRequest.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddWdsRequest.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddWdsRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddWdsRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeAddWdsRequest.WdsApMacAddress.x, 48/8);
        index += 48/8;
        break;
    case CSR_MLME_MREPORT_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMreportRequest.MeasurementReportSet.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMreportRequest.MeasurementReportSet.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMreportRequest.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMreportRequest.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeMreportRequest.PeerMacAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMreportRequest.DialogToken, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeMreportRequest.MeasurementCategory, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_DEL_WDS_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelWdsRequest.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelWdsRequest.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelWdsRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDelWdsRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeDelWdsRequest.WdsApMacAddress.x, 48/8);
        index += 48/8;
        break;
    case CSR_MLME_ADDBA_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeAddbaConfirm.PeerQstaAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaConfirm.DialogToken, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaConfirm.Tid, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaConfirm.BlockAckPolicy, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaConfirm.BufferSize, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaConfirm.BlockAckTimeout, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_JOIN_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeJoinConfirm.BeaconFrame.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeJoinConfirm.BeaconFrame.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeJoinConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeJoinConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeJoinConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_DLS_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsConfirm.SupportedRates.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsConfirm.SupportedRates.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeDlsConfirm.PeerMacAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsConfirm.CapabilityInformation, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDlsConfirm.DlsTimeoutValue, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_RESOURCE_REQUEST_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResourceRequestConfirm.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResourceRequestConfirm.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResourceRequestConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResourceRequestConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeResourceRequestConfirm.PeerMacAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeResourceRequestConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_STAKEYESTABLISHED_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStakeyestablishedIndication.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStakeyestablishedIndication.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStakeyestablishedIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeStakeyestablishedIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeStakeyestablishedIndication.Address1.x, 48/8);
        index += 48/8;
        CsrMemCpy(ptr+index, sig->u.MlmeStakeyestablishedIndication.Address2.x, 48/8);
        index += 48/8;
        break;
    case CSR_MLME_PAUSE_AUTONOMOUS_SCAN_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePauseAutonomousScanRequest.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePauseAutonomousScanRequest.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePauseAutonomousScanRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePauseAutonomousScanRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePauseAutonomousScanRequest.AutonomousScanId, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmePauseAutonomousScanRequest.Pause, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_REASSOCIATE_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateConfirm.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateConfirm.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateConfirm.ExchangedFrames.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateConfirm.ExchangedFrames.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateConfirm.CapabilityInformation, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateConfirm.AssociationId, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateConfirm.RcpiRequest, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateConfirm.RsniRequest, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateConfirm.RcpiResponse, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeReassociateConfirm.RsniResponse, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_GET_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetRequest.MibAttribute.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetRequest.MibAttribute.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeGetRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MA_UNITDATA_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaUnitdataRequest.Data.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaUnitdataRequest.Data.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaUnitdataRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaUnitdataRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MaUnitdataRequest.Da.x, 48/8);
        index += 48/8;
        CsrMemCpy(ptr+index, sig->u.MaUnitdataRequest.Sa.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaUnitdataRequest.RoutingInformation, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaUnitdataRequest.Priority, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaUnitdataRequest.ServiceClass, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MaUnitdataRequest.HostTag, ptr+index);
        index += SIZEOF_UINT32;
        break;
    case CSR_MLME_ADDTS_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddtsRequest.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddtsRequest.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddtsRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddtsRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddtsRequest.DialogToken, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddtsRequest.AddtsFailureTimeout, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_ADD_PERIODIC_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddPeriodicRequest.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddPeriodicRequest.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddPeriodicRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddPeriodicRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddPeriodicRequest.PeriodicId, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MlmeAddPeriodicRequest.MaximumLatency, ptr+index);
        index += SIZEOF_UINT32;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddPeriodicRequest.PeriodicSchedulingMode, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddPeriodicRequest.WakeHost, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddPeriodicRequest.Tid, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_DELTS_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeltsIndication.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeltsIndication.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeltsIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeltsIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeDeltsIndication.NonapQstaAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MlmeDeltsIndication.TsInfo, ptr+index);
        index += SIZEOF_UINT32;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeltsIndication.ReasonCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_EAPOL_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeEapolConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeEapolConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeEapolConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeEapolConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeEapolConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeEapolConfirm.ProvidedPriority, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MlmeEapolConfirm.ProvidedHostTag, ptr+index);
        index += SIZEOF_UINT32;
        break;
    case CSR_MLME_HL_SYNC_CANCEL_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncCancelConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncCancelConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncCancelConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncCancelConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeHlSyncCancelConfirm.GroupAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeHlSyncCancelConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_DELTS_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeltsRequest.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeltsRequest.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeltsRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeltsRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeDeltsRequest.NonapQstaAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MlmeDeltsRequest.TsInfo, ptr+index);
        index += SIZEOF_UINT32;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeDeltsRequest.ReasonCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_LINKMEASURE_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeLinkmeasureRequest.InformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeLinkmeasureRequest.InformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeLinkmeasureRequest.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeLinkmeasureRequest.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeLinkmeasureRequest.PeerMacAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeLinkmeasureRequest.DialogToken, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeLinkmeasureRequest.TransmitPower, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeLinkmeasureRequest.MaxTransmitPower, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_SCAN_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeScanConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_CHANNELSWITCH_RESPONSE_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeChannelswitchResponse.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeChannelswitchResponse.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeChannelswitchResponse.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeChannelswitchResponse.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeChannelswitchResponse.Mode, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeChannelswitchResponse.ChannelNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeChannelswitchResponse.SecondaryChannelOffset, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeChannelswitchResponse.ChannelSwitchCount, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_DEBUG_STRING_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugStringIndication.DebugMessage.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugStringIndication.DebugMessage.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugStringIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.DebugStringIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_FT_JOIN_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeFtJoinConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeFtJoinConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeFtJoinConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeFtJoinConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeFtJoinConfirm.ResultCode, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_JOIN_REQUEST_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeJoinRequest.ScanInformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeJoinRequest.ScanInformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeJoinRequest.StaInformationElements.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeJoinRequest.StaInformationElements.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeJoinRequest.Ifindex, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeJoinRequest.Bssid.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeJoinRequest.BeaconPeriod, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeJoinRequest.Timestamp.x, 64/8);
        index += 64/8;
        CsrMemCpy(ptr+index, sig->u.MlmeJoinRequest.LocalTime.x, 64/8);
        index += 64/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeJoinRequest.Channel, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeJoinRequest.CapabilityInformation, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeJoinRequest.JoinFailureTimeout, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MlmeJoinRequest.ProbeDelay, ptr+index);
        index += SIZEOF_UINT32;
        break;
    case CSR_MLME_SET_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetConfirm.MibAttributeValue.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetConfirm.MibAttributeValue.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetConfirm.Status, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeSetConfirm.ErrorIndex, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MLME_ADDBA_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaIndication.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaIndication.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MlmeAddbaIndication.PeerQstaAddress.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaIndication.DialogToken, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaIndication.Tid, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaIndication.BlockAckPolicy, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaIndication.BufferSize, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MlmeAddbaIndication.BlockAckTimeout, ptr+index);
        index += SIZEOF_UINT16;
        break;
    case CSR_MA_PACKET_CONFIRM_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketConfirm.Dummydataref1.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketConfirm.Dummydataref1.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketConfirm.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketConfirm.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketConfirm.TransmissionStatus, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketConfirm.RetryCount, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaPacketConfirm.Rate, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT32_TO_LITTLE_ENDIAN(sig->u.MaPacketConfirm.HostTag, ptr+index);
        index += SIZEOF_UINT32;
        break;
    case CSR_MA_UNITDATA_INDICATION_ID:
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaUnitdataIndication.Data.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaUnitdataIndication.Data.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaUnitdataIndication.Dummydataref2.SlotNumber, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaUnitdataIndication.Dummydataref2.DataLength, ptr+index);
        index += SIZEOF_UINT16;
        CsrMemCpy(ptr+index, sig->u.MaUnitdataIndication.Da.x, 48/8);
        index += 48/8;
        CsrMemCpy(ptr+index, sig->u.MaUnitdataIndication.Sa.x, 48/8);
        index += 48/8;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaUnitdataIndication.RoutingInformation, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaUnitdataIndication.ReceptionStatus, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaUnitdataIndication.Priority, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaUnitdataIndication.ServiceClass, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaUnitdataIndication.Rssi, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaUnitdataIndication.Snr, ptr+index);
        index += SIZEOF_UINT16;
        COAL_COPY_UINT16_TO_LITTLE_ENDIAN(sig->u.MaUnitdataIndication.Rate, ptr+index);
        index += SIZEOF_UINT16;
        break;

      default:
        return -CSR_EINVAL;
    }

    *sig_len = index;

    return 0;
} /* write_pack() */

