/*
 * Copyright (C) 2005-2009 by Cambridge Silicon Radio Ltd.
 *
 * Refer to LICENSE.txt included with this source code for details on
 * the license terms.
 *
 */
#include "driver/unifi.h"


struct sig_name {
    CsrInt16 id;
    const CsrInt8 *name;
};

static const struct sig_name Unifi_signal_names[] = {
    { CSR_MA_UNITDATA_REQUEST_ID, "CSR_MA_UNITDATA_REQUEST_ID" },
    { CSR_MA_UNITDATA_INDICATION_ID, "CSR_MA_UNITDATA_INDICATION_ID" },
    { CSR_MA_UNITDATA_CONFIRM_ID, "CSR_MA_UNITDATA_CONFIRM_ID" },
    { CSR_MA_UNITDATA_STATUS_INDICATION_DEPRECATED_ID, "CSR_MA_UNITDATA_STATUS_INDICATION_DEPRECATED_ID" },
    { CSR_MA_SNIFFDATA_INDICATION_ID, "CSR_MA_SNIFFDATA_INDICATION_ID" },
    { CSR_MA_UNITDATA_CANCEL_REQUEST_ID, "CSR_MA_UNITDATA_CANCEL_REQUEST_ID" },
    { CSR_MLME_RESET_REQUEST_ID, "CSR_MLME_RESET_REQUEST_ID" },
    { CSR_MLME_RESET_CONFIRM_ID, "CSR_MLME_RESET_CONFIRM_ID" },
    { CSR_MLME_GET_REQUEST_ID, "CSR_MLME_GET_REQUEST_ID" },
    { CSR_MLME_GET_CONFIRM_ID, "CSR_MLME_GET_CONFIRM_ID" },
    { CSR_MLME_SET_REQUEST_ID, "CSR_MLME_SET_REQUEST_ID" },
    { CSR_MLME_SET_CONFIRM_ID, "CSR_MLME_SET_CONFIRM_ID" },
    { CSR_MLME_GET_NEXT_REQUEST_ID, "CSR_MLME_GET_NEXT_REQUEST_ID" },
    { CSR_MLME_GET_NEXT_CONFIRM_ID, "CSR_MLME_GET_NEXT_CONFIRM_ID" },
    { CSR_MLME_POWERMGT_REQUEST_ID, "CSR_MLME_POWERMGT_REQUEST_ID" },
    { CSR_MLME_POWERMGT_CONFIRM_ID, "CSR_MLME_POWERMGT_CONFIRM_ID" },
    { CSR_MLME_SCAN_REQUEST_ID, "CSR_MLME_SCAN_REQUEST_ID" },
    { CSR_MLME_SCAN_CONFIRM_ID, "CSR_MLME_SCAN_CONFIRM_ID" },
    { CSR_MLME_SCAN_INDICATION_ID, "CSR_MLME_SCAN_INDICATION_ID" },
    { CSR_MLME_JOIN_REQUEST_ID, "CSR_MLME_JOIN_REQUEST_ID" },
    { CSR_MLME_JOIN_CONFIRM_ID, "CSR_MLME_JOIN_CONFIRM_ID" },
    { CSR_MLME_AUTHENTICATE_REQUEST_ID, "CSR_MLME_AUTHENTICATE_REQUEST_ID" },
    { CSR_MLME_AUTHENTICATE_CONFIRM_ID, "CSR_MLME_AUTHENTICATE_CONFIRM_ID" },
    { CSR_MLME_AUTHENTICATE_RESPONSE_ID, "CSR_MLME_AUTHENTICATE_RESPONSE_ID" },
    { CSR_MLME_AUTHENTICATE_INDICATION_ID, "CSR_MLME_AUTHENTICATE_INDICATION_ID" },
    { CSR_MLME_DEAUTHENTICATE_REQUEST_ID, "CSR_MLME_DEAUTHENTICATE_REQUEST_ID" },
    { CSR_MLME_DEAUTHENTICATE_CONFIRM_ID, "CSR_MLME_DEAUTHENTICATE_CONFIRM_ID" },
    { CSR_MLME_DEAUTHENTICATE_INDICATION_ID, "CSR_MLME_DEAUTHENTICATE_INDICATION_ID" },
    { CSR_MLME_ASSOCIATE_REQUEST_ID, "CSR_MLME_ASSOCIATE_REQUEST_ID" },
    { CSR_MLME_ASSOCIATE_CONFIRM_ID, "CSR_MLME_ASSOCIATE_CONFIRM_ID" },
    { CSR_MLME_ASSOCIATE_RESPONSE_ID, "CSR_MLME_ASSOCIATE_RESPONSE_ID" },
    { CSR_MLME_ASSOCIATE_INDICATION_ID, "CSR_MLME_ASSOCIATE_INDICATION_ID" },
    { CSR_MLME_REASSOCIATE_REQUEST_ID, "CSR_MLME_REASSOCIATE_REQUEST_ID" },
    { CSR_MLME_REASSOCIATE_CONFIRM_ID, "CSR_MLME_REASSOCIATE_CONFIRM_ID" },
    { CSR_MLME_REASSOCIATE_RESPONSE_ID, "CSR_MLME_REASSOCIATE_RESPONSE_ID" },
    { CSR_MLME_REASSOCIATE_INDICATION_ID, "CSR_MLME_REASSOCIATE_INDICATION_ID" },
    { CSR_MLME_DISASSOCIATE_REQUEST_ID, "CSR_MLME_DISASSOCIATE_REQUEST_ID" },
    { CSR_MLME_DISASSOCIATE_CONFIRM_ID, "CSR_MLME_DISASSOCIATE_CONFIRM_ID" },
    { CSR_MLME_DISASSOCIATE_INDICATION_ID, "CSR_MLME_DISASSOCIATE_INDICATION_ID" },
    { CSR_MLME_START_REQUEST_ID, "CSR_MLME_START_REQUEST_ID" },
    { CSR_MLME_START_CONFIRM_ID, "CSR_MLME_START_CONFIRM_ID" },
    { CSR_MLME_ADDTS_REQUEST_ID, "CSR_MLME_ADDTS_REQUEST_ID" },
    { CSR_MLME_ADDTS_CONFIRM_ID, "CSR_MLME_ADDTS_CONFIRM_ID" },
    { CSR_MLME_ADDTS_RESPONSE_ID, "CSR_MLME_ADDTS_RESPONSE_ID" },
    { CSR_MLME_ADDTS_INDICATION_ID, "CSR_MLME_ADDTS_INDICATION_ID" },
    { CSR_MLME_DELTS_REQUEST_ID, "CSR_MLME_DELTS_REQUEST_ID" },
    { CSR_MLME_DELTS_CONFIRM_ID, "CSR_MLME_DELTS_CONFIRM_ID" },
    { CSR_MLME_DELTS_INDICATION_ID, "CSR_MLME_DELTS_INDICATION_ID" },
    { CSR_MLME_DLS_REQUEST_ID, "CSR_MLME_DLS_REQUEST_ID" },
    { CSR_MLME_DLS_CONFIRM_ID, "CSR_MLME_DLS_CONFIRM_ID" },
    { CSR_MLME_DLS_INDICATION_ID, "CSR_MLME_DLS_INDICATION_ID" },
    { CSR_MLME_DLSTEARDOWN_REQUEST_ID, "CSR_MLME_DLSTEARDOWN_REQUEST_ID" },
    { CSR_MLME_DLSTEARDOWN_CONFIRM_ID, "CSR_MLME_DLSTEARDOWN_CONFIRM_ID" },
    { CSR_MLME_DLSTEARDOWN_INDICATION_ID, "CSR_MLME_DLSTEARDOWN_INDICATION_ID" },
    { CSR_MLME_HL_SYNC_REQUEST_ID, "CSR_MLME_HL_SYNC_REQUEST_ID" },
    { CSR_MLME_HL_SYNC_CONFIRM_ID, "CSR_MLME_HL_SYNC_CONFIRM_ID" },
    { CSR_MLME_HL_SYNC_INDICATION_ID, "CSR_MLME_HL_SYNC_INDICATION_ID" },
    { CSR_MLME_ADDBA_REQUEST_ID, "CSR_MLME_ADDBA_REQUEST_ID" },
    { CSR_MLME_ADDBA_CONFIRM_ID, "CSR_MLME_ADDBA_CONFIRM_ID" },
    { CSR_MLME_ADDBA_RESPONSE_ID, "CSR_MLME_ADDBA_RESPONSE_ID" },
    { CSR_MLME_ADDBA_INDICATION_ID, "CSR_MLME_ADDBA_INDICATION_ID" },
    { CSR_MLME_DELBA_REQUEST_ID, "CSR_MLME_DELBA_REQUEST_ID" },
    { CSR_MLME_DELBA_CONFIRM_ID, "CSR_MLME_DELBA_CONFIRM_ID" },
    { CSR_MLME_DELBA_INDICATION_ID, "CSR_MLME_DELBA_INDICATION_ID" },
    { CSR_MLME_SCHEDULE_REQUEST_ID, "CSR_MLME_SCHEDULE_REQUEST_ID" },
    { CSR_MLME_SCHEDULE_CONFIRM_ID, "CSR_MLME_SCHEDULE_CONFIRM_ID" },
    { CSR_MLME_SCHEDULE_INDICATION_ID, "CSR_MLME_SCHEDULE_INDICATION_ID" },
    { CSR_MLME_MREQUEST_REQUEST_ID, "CSR_MLME_MREQUEST_REQUEST_ID" },
    { CSR_MLME_MREQUEST_CONFIRM_ID, "CSR_MLME_MREQUEST_CONFIRM_ID" },
    { CSR_MLME_MREQUEST_INDICATION_ID, "CSR_MLME_MREQUEST_INDICATION_ID" },
    { CSR_MLME_MEASURE_REQUEST_ID, "CSR_MLME_MEASURE_REQUEST_ID" },
    { CSR_MLME_MEASURE_CONFIRM_ID, "CSR_MLME_MEASURE_CONFIRM_ID" },
    { CSR_MLME_MREPORT_REQUEST_ID, "CSR_MLME_MREPORT_REQUEST_ID" },
    { CSR_MLME_MREPORT_CONFIRM_ID, "CSR_MLME_MREPORT_CONFIRM_ID" },
    { CSR_MLME_MREPORT_INDICATION_ID, "CSR_MLME_MREPORT_INDICATION_ID" },
    { CSR_MLME_CHANNELSWITCH_REQUEST_ID, "CSR_MLME_CHANNELSWITCH_REQUEST_ID" },
    { CSR_MLME_CHANNELSWITCH_CONFIRM_ID, "CSR_MLME_CHANNELSWITCH_CONFIRM_ID" },
    { CSR_MLME_CHANNELSWITCH_RESPONSE_ID, "CSR_MLME_CHANNELSWITCH_RESPONSE_ID" },
    { CSR_MLME_CHANNELSWITCH_INDICATION_ID, "CSR_MLME_CHANNELSWITCH_INDICATION_ID" },
    { CSR_MLME_TPCADAPT_REQUEST_ID, "CSR_MLME_TPCADAPT_REQUEST_ID" },
    { CSR_MLME_TPCADAPT_CONFIRM_ID, "CSR_MLME_TPCADAPT_CONFIRM_ID" },
    { CSR_MLME_SETKEYS_REQUEST_ID, "CSR_MLME_SETKEYS_REQUEST_ID" },
    { CSR_MLME_SETKEYS_CONFIRM_ID, "CSR_MLME_SETKEYS_CONFIRM_ID" },
    { CSR_MLME_DELETEKEYS_REQUEST_ID, "CSR_MLME_DELETEKEYS_REQUEST_ID" },
    { CSR_MLME_DELETEKEYS_CONFIRM_ID, "CSR_MLME_DELETEKEYS_CONFIRM_ID" },
    { CSR_MLME_MICHAELMICFAILURE_INDICATION_ID, "CSR_MLME_MICHAELMICFAILURE_INDICATION_ID" },
    { CSR_MLME_EAPOL_REQUEST_ID, "CSR_MLME_EAPOL_REQUEST_ID" },
    { CSR_MLME_EAPOL_CONFIRM_ID, "CSR_MLME_EAPOL_CONFIRM_ID" },
    { CSR_MLME_STAKEYESTABLISHED_INDICATION_ID, "CSR_MLME_STAKEYESTABLISHED_INDICATION_ID" },
    { CSR_MLME_SETPROTECTION_REQUEST_ID, "CSR_MLME_SETPROTECTION_REQUEST_ID" },
    { CSR_MLME_SETPROTECTION_CONFIRM_ID, "CSR_MLME_SETPROTECTION_CONFIRM_ID" },
    { CSR_MLME_PROTECTEDFRAMEDROPPED_INDICATION_ID, "CSR_MLME_PROTECTEDFRAMEDROPPED_INDICATION_ID" },
    { CSR_MLME_SNIFFJOIN_REQUEST_ID, "CSR_MLME_SNIFFJOIN_REQUEST_ID" },
    { CSR_MLME_SNIFFJOIN_CONFIRM_ID, "CSR_MLME_SNIFFJOIN_CONFIRM_ID" },
    { CSR_MLME_CONNECTED_INDICATION_ID, "CSR_MLME_CONNECTED_INDICATION_ID" },
    { CSR_MLME_SCAN_CANCEL_REQUEST_ID, "CSR_MLME_SCAN_CANCEL_REQUEST_ID" },
    { CSR_MLME_LINKMEASURE_REQUEST_ID, "CSR_MLME_LINKMEASURE_REQUEST_ID" },
    { CSR_MLME_LINKMEASURE_CONFIRM_ID, "CSR_MLME_LINKMEASURE_CONFIRM_ID" },
    { CSR_MLME_HL_SYNC_CANCEL_REQUEST_ID, "CSR_MLME_HL_SYNC_CANCEL_REQUEST_ID" },
    { CSR_MLME_HL_SYNC_CANCEL_CONFIRM_ID, "CSR_MLME_HL_SYNC_CANCEL_CONFIRM_ID" },
    { CSR_MLME_ADD_PERIODIC_REQUEST_ID, "CSR_MLME_ADD_PERIODIC_REQUEST_ID" },
    { CSR_MLME_ADD_PERIODIC_CONFIRM_ID, "CSR_MLME_ADD_PERIODIC_CONFIRM_ID" },
    { CSR_MLME_DEL_PERIODIC_REQUEST_ID, "CSR_MLME_DEL_PERIODIC_REQUEST_ID" },
    { CSR_MLME_DEL_PERIODIC_CONFIRM_ID, "CSR_MLME_DEL_PERIODIC_CONFIRM_ID" },
    { CSR_MLME_ADD_AUTONOMOUS_SCAN_REQUEST_ID, "CSR_MLME_ADD_AUTONOMOUS_SCAN_REQUEST_ID" },
    { CSR_MLME_ADD_AUTONOMOUS_SCAN_CONFIRM_ID, "CSR_MLME_ADD_AUTONOMOUS_SCAN_CONFIRM_ID" },
    { CSR_MLME_DEL_AUTONOMOUS_SCAN_REQUEST_ID, "CSR_MLME_DEL_AUTONOMOUS_SCAN_REQUEST_ID" },
    { CSR_MLME_DEL_AUTONOMOUS_SCAN_CONFIRM_ID, "CSR_MLME_DEL_AUTONOMOUS_SCAN_CONFIRM_ID" },
    { CSR_MLME_AUTONOMOUS_SCAN_INDICATION_ID, "CSR_MLME_AUTONOMOUS_SCAN_INDICATION_ID" },
    { CSR_MLME_AUTONOMOUS_SCAN_RESULTS_REQUEST_ID, "CSR_MLME_AUTONOMOUS_SCAN_RESULTS_REQUEST_ID" },
    { CSR_MLME_AUTONOMOUS_SCAN_RESULTS_CONFIRM_ID, "CSR_MLME_AUTONOMOUS_SCAN_RESULTS_CONFIRM_ID" },
    { CSR_MLME_AUTONOMOUS_SCAN_RESULTS_INDICATION_ID, "CSR_MLME_AUTONOMOUS_SCAN_RESULTS_INDICATION_ID" },
    { CSR_MLME_SET_UNITDATA_FILTER_REQUEST_ID, "CSR_MLME_SET_UNITDATA_FILTER_REQUEST_ID" },
    { CSR_MLME_SET_UNITDATA_FILTER_CONFIRM_ID, "CSR_MLME_SET_UNITDATA_FILTER_CONFIRM_ID" },
    { CSR_MLME_FT_JOIN_REQUEST_ID, "CSR_MLME_FT_JOIN_REQUEST_ID" },
    { CSR_MLME_FT_JOIN_CONFIRM_ID, "CSR_MLME_FT_JOIN_CONFIRM_ID" },
    { CSR_MLME_RESOURCE_REQUEST_REQUEST_ID, "CSR_MLME_RESOURCE_REQUEST_REQUEST_ID" },
    { CSR_MLME_RESOURCE_REQUEST_CONFIRM_ID, "CSR_MLME_RESOURCE_REQUEST_CONFIRM_ID" },
    { CSR_MLME_RESOURCE_REQUEST_RESPONSE_ID, "CSR_MLME_RESOURCE_REQUEST_RESPONSE_ID" },
    { CSR_MLME_RESOURCE_REQUEST_INDICATION_ID, "CSR_MLME_RESOURCE_REQUEST_INDICATION_ID" },
    { CSR_MLME_RESOURCE_REQUEST_LOCAL_REQUEST_ID, "CSR_MLME_RESOURCE_REQUEST_LOCAL_REQUEST_ID" },
    { CSR_MLME_RESOURCE_REQUEST_LOCAL_CONFIRM_ID, "CSR_MLME_RESOURCE_REQUEST_LOCAL_CONFIRM_ID" },
    { CSR_MLME_REMOTE_REQUEST_REQUEST_ID, "CSR_MLME_REMOTE_REQUEST_REQUEST_ID" },
    { CSR_MLME_REMOTE_REQUEST_CONFIRM_ID, "CSR_MLME_REMOTE_REQUEST_CONFIRM_ID" },
    { CSR_MLME_REMOTE_REQUEST_INDICATION_ID, "CSR_MLME_REMOTE_REQUEST_INDICATION_ID" },
    { CSR_MLME_PAUSE_AUTONOMOUS_SCAN_REQUEST_ID, "CSR_MLME_PAUSE_AUTONOMOUS_SCAN_REQUEST_ID" },
    { CSR_MLME_PAUSE_AUTONOMOUS_SCAN_CONFIRM_ID, "CSR_MLME_PAUSE_AUTONOMOUS_SCAN_CONFIRM_ID" },
    { CSR_MLME_NEIGHBORREPREQ_REQUEST_ID, "CSR_MLME_NEIGHBORREPREQ_REQUEST_ID" },
    { CSR_MLME_NEIGHBORREPREQ_CONFIRM_ID, "CSR_MLME_NEIGHBORREPREQ_CONFIRM_ID" },
    { CSR_MLME_NEIGHBORREPREQ_INDICATION_ID, "CSR_MLME_NEIGHBORREPREQ_INDICATION_ID" },
    { CSR_MLME_NEIGHBORREPRESP_REQUEST_ID, "CSR_MLME_NEIGHBORREPRESP_REQUEST_ID" },
    { CSR_MLME_NEIGHBORREPRESP_CONFIRM_ID, "CSR_MLME_NEIGHBORREPRESP_CONFIRM_ID" },
    { CSR_MLME_NEIGHBORREPRESP_INDICATION_ID, "CSR_MLME_NEIGHBORREPRESP_INDICATION_ID" },
    { CSR_MLME_AUTONOMOUS_SCAN_DONE_INDICATION_ID, "CSR_MLME_AUTONOMOUS_SCAN_DONE_INDICATION_ID" },
    { CSR_MLME_ADD_TRIGGERED_GET_REQUEST_ID, "CSR_MLME_ADD_TRIGGERED_GET_REQUEST_ID" },
    { CSR_MLME_ADD_TRIGGERED_GET_CONFIRM_ID, "CSR_MLME_ADD_TRIGGERED_GET_CONFIRM_ID" },
    { CSR_MLME_DEL_TRIGGERED_GET_REQUEST_ID, "CSR_MLME_DEL_TRIGGERED_GET_REQUEST_ID" },
    { CSR_MLME_DEL_TRIGGERED_GET_CONFIRM_ID, "CSR_MLME_DEL_TRIGGERED_GET_CONFIRM_ID" },
    { CSR_MLME_TRIGGERED_GET_INDICATION_ID, "CSR_MLME_TRIGGERED_GET_INDICATION_ID" },
    { CSR_MLME_VSPECIFIC_REQUEST_ID, "CSR_MLME_VSPECIFIC_REQUEST_ID" },
    { CSR_MLME_VSPECIFIC_CONFIRM_ID, "CSR_MLME_VSPECIFIC_CONFIRM_ID" },
    { CSR_MLME_VSPECIFIC_INDICATION_ID, "CSR_MLME_VSPECIFIC_INDICATION_ID" },
    { CSR_MLME_ADD_WDS_REQUEST_ID, "CSR_MLME_ADD_WDS_REQUEST_ID" },
    { CSR_MLME_ADD_WDS_CONFIRM_ID, "CSR_MLME_ADD_WDS_CONFIRM_ID" },
    { CSR_MLME_DEL_WDS_REQUEST_ID, "CSR_MLME_DEL_WDS_REQUEST_ID" },
    { CSR_MLME_DEL_WDS_CONFIRM_ID, "CSR_MLME_DEL_WDS_CONFIRM_ID" },
    { CSR_MLME_ADD_BLACKOUT_REQUEST_ID, "CSR_MLME_ADD_BLACKOUT_REQUEST_ID" },
    { CSR_MLME_ADD_BLACKOUT_CONFIRM_ID, "CSR_MLME_ADD_BLACKOUT_CONFIRM_ID" },
    { CSR_MLME_DEL_BLACKOUT_REQUEST_ID, "CSR_MLME_DEL_BLACKOUT_REQUEST_ID" },
    { CSR_MLME_DEL_BLACKOUT_CONFIRM_ID, "CSR_MLME_DEL_BLACKOUT_CONFIRM_ID" },

    /* 0x03xx */
    { CSR_MLME_SAQUERY_REQUEST_ID, "CSR_MLME_SAQUERY_REQUEST_ID" },
    { CSR_MLME_SAQUERY_CONFIRM_ID, "CSR_MLME_SAQUERY_CONFIRM_ID" },
    { CSR_MLME_SAQUERY_RESPONSE_ID, "CSR_MLME_SAQUERY_RESPONSE_ID" },
    { CSR_MLME_SAQUERY_INDICATION_ID, "CSR_MLME_SAQUERY_INDICATION_ID" },

    /* 0x04xx */
    { CSR_DS_UNITDATA_REQUEST_ID, "CSR_DS_UNITDATA_REQUEST_ID" },
    { CSR_DS_UNITDATA_RESPONSE_ID, "CSR_DS_UNITDATA_RESPONSE_ID" },
    { CSR_DS_UNITDATA_INDICATION_ID, "CSR_DS_UNITDATA_INDICATION_ID" },
    { CSR_DS_UNITDATA_CANCEL_INDICATION_ID, "CSR_DS_UNITDATA_CANCEL_INDICATION_ID" },
    { CSR_DS_STA_NOTIFY_REQUEST_ID, "CSR_DS_STA_NOTIFY_REQUEST_ID" },

    /* 0x08xx */
    { CSR_DEBUG_STRING_INDICATION_ID, "CSR_DEBUG_STRING_INDICATION_ID" },
    { CSR_DEBUG_WORD16_INDICATION_ID, "CSR_DEBUG_WORD16_INDICATION_ID" },
    { CSR_DEBUG_GENERIC_REQUEST_ID, "CSR_DEBUG_GENERIC_REQUEST_ID" },
    { CSR_DEBUG_GENERIC_CONFIRM_ID, "CSR_DEBUG_GENERIC_CONFIRM_ID" },
    { CSR_DEBUG_GENERIC_INDICATION_ID, "CSR_DEBUG_GENERIC_INDICATION_ID" },
    { 0, NULL }
};

static const CsrInt8 *
lookup_something(const struct sig_name *n, CsrInt16 id)
{
    for (; n->name; n++) {
        if (n->id == id) {
            return n->name;
        }
    }

    /* not found */
    return "UNKNOWN";
} /* lookup_something() */


const CsrInt8 *
lookup_signal_name(CsrUint16 id)
{
    return lookup_something(Unifi_signal_names, id);
}


static const struct sig_name Unifi_bulkcmd_names[] = {
    {  0, "SignalCmd" },
    {  1, "CopyToHost" },
    {  2, "CopyToHostAck" },
    {  3, "CopyFromHost" },
    {  4, "CopyFromHostAck" } ,
    {  5, "ClearSlot" },
    {  6, "CopyOverlay" },
    {  7, "CopyOverlayAck" },
    {  8, "CopyFromHostAndClearSlot" },
    { 15, "Padding" },
    { -1, NULL }
};


const CsrInt8 *
lookup_bulkcmd_name(CsrUint16 id)
{
    return lookup_something(Unifi_bulkcmd_names, id);
}
