/* This is an autogenerated file */
/* Tag: noCheckHeader */
/*    Copyright (C) Cambridge Silicon Radio Ltd 2009. All rights reserved. */
/* */
/*   Refer to LICENSE.txt included with this source for details on the */
/*   license terms. */

#ifndef HIP_XML_TYPES_H
#define HIP_XML_TYPES_H

#ifdef __cplusplus
extern "C" {
#endif

typedef enum AntennaId
{
    AntennaId_AntennaUnknown                                = 0x0000,
    AntennaId_Antenna1                                      = 0x0001,
    AntennaId_Antenna2                                      = 0x0002,
    AntennaId_AntennaMultiple                               = 0x00ff
} AntennaId;

typedef enum AuthenticationType
{
    AuthenticationType_OpenSystem                           = 0x0000,
    AuthenticationType_SharedKey                            = 0x0001,
    AuthenticationType_FastBssTransition                    = 0x0002
} AuthenticationType;

typedef enum BssType
{
    BssType_Infrastructure                                  = 0x0000,
    BssType_Independent                                     = 0x0001,
    BssType_AnyBss                                          = 0x0002
} BssType;

typedef enum BlackoutSource
{
    BlackoutSource_Dot11Local                               = 0x0001,
    BlackoutSource_Dot11Remote                              = 0x0002,
    BlackoutSource_OtherRadio                               = 0x0004
} BlackoutSource;

typedef enum BlackoutType
{
    BlackoutType_LocalDeviceOnly                            = 0x0001,
    BlackoutType_SpecifiedPeer                              = 0x0002,
    BlackoutType_CurrentChannel                             = 0x0004
} BlackoutType;

typedef enum BlockAckPolicy
{
    BlockAckPolicy_Delayed                                  = 0x0000,
    BlockAckPolicy_Immediate                                = 0x0001
} BlockAckPolicy;

typedef enum BootLoaderOperation
{
    BootLoaderOperation_BootLoaderIdle                      = 0x00,
    BootLoaderOperation_BootLoaderRestart                   = 0x01,
    BootLoaderOperation_BootLoaderPatch                     = 0x02,
    BootLoaderOperation_BootLoaderImage0                    = 0x10,
    BootLoaderOperation_BootLoaderImage1                    = 0x11,
    BootLoaderOperation_BootLoaderImage2                    = 0x12,
    BootLoaderOperation_BootLoaderImage3                    = 0x13
} BootLoaderOperation;

typedef enum ChannelOffset
{
    ChannelOffset_Scn                                       = 0x0000,
    ChannelOffset_Sca                                       = 0x0001,
    ChannelOffset_Scb                                       = 0x0003
} ChannelOffset;

typedef enum ChannelSwitchMode
{
    ChannelSwitchMode_Continue                              = 0x0000,
    ChannelSwitchMode_PauseUntilSwitch                      = 0x0001
} ChannelSwitchMode;

typedef enum CoexistenceDirection
{
    CoexistenceDirection_CoexistenceNone                    = 0x0000,
    CoexistenceDirection_CoexistenceDot11Input              = 0x0001,
    CoexistenceDirection_CoexistenceDot11Output             = 0x0002
} CoexistenceDirection;

typedef enum ConnectionStatus
{
    ConnectionStatus_Disconnected                           = 0x0000,
    ConnectionStatus_Connected                              = 0x0001
} ConnectionStatus;

typedef enum Initiator
{
    Initiator_Recipient                                     = 0x0000,
    Initiator_Originator                                    = 0x0001
} Initiator;

typedef enum Interface
{
    Interface_Index2G4                                      = 0x0001,
    Interface_Index5G                                       = 0x0002
} Interface;

typedef enum KeyType
{
    KeyType_Group                                           = 0x0000,
    KeyType_Pairwise                                        = 0x0001,
    KeyType_STAKey                                          = 0x0002,
    KeyType_Igtk                                            = 0x0003
} KeyType;

typedef enum LinkMarginCategory
{
    LinkMarginCategory_Ulm                                  = 0x0001,
    LinkMarginCategory_Dlm                                  = 0x0002,
    LinkMarginCategory_All                                  = 0xffff
} LinkMarginCategory;

typedef enum LoaderOperation
{
    LoaderOperation_LoaderIdle                              = 0x0000,
    LoaderOperation_LoaderCopy                              = 0x0001
} LoaderOperation;

typedef enum MibStatus
{
    MibStatus_Successful                                    = 0x0000,
    MibStatus_InvalidParameters                             = 0x0001,
    MibStatus_WriteOnly                                     = 0x0002,
    MibStatus_ReadOnly                                      = 0x0003
} MibStatus;

typedef enum MeasurementCategory
{
    MeasurementCategory_SpectrumManagement                  = 0x0000,
    MeasurementCategory_RadioMeasurement                    = 0x0005,
    MeasurementCategory_CcxMeasurement                      = 0x0006
} MeasurementCategory;

typedef enum MemorySpace
{
    MemorySpace_None                                        = 0x00,
    MemorySpace_SharedDataMemory                            = 0x01,
    MemorySpace_ExternalFlashMemory                         = 0x02,
    MemorySpace_ExternalSram                                = 0x03,
    MemorySpace_Registers                                   = 0x04,
    MemorySpace_PhyProcessorDataMemory                      = 0x10,
    MemorySpace_PhyProcessorProgramMemory                   = 0x11,
    MemorySpace_PhyProcessorRom                             = 0x12,
    MemorySpace_MacProcessorDataMemory                      = 0x20,
    MemorySpace_MacProcessorProgramMemory                   = 0x21,
    MemorySpace_MacProcessorRom                             = 0x22,
    MemorySpace_BtProcessorDataMemory                       = 0x30,
    MemorySpace_BtProcessorProgramMemory                    = 0x31,
    MemorySpace_BtProcessorRom                              = 0x32
} MemorySpace;

typedef enum NeighborReportRequestType
{
    NeighborReportRequestType_Basic                         = 0x0000,
    NeighborReportRequestType_TbttOffset                    = 0x0001
} NeighborReportRequestType;

typedef enum PeriodicSchedulingMode
{
    PeriodicSchedulingMode_PeriodicSchedulePsPoll           = 0x0001,
    PeriodicSchedulingMode_PeriodicSchedulePmBit            = 0x0002,
    PeriodicSchedulingMode_PeriodicScheduleUapsd            = 0x0004,
    PeriodicSchedulingMode_PeriodicScheduleSapsd            = 0x0008
} PeriodicSchedulingMode;

typedef enum PowerManagementMode
{
    PowerManagementMode_ActiveMode                          = 0x0000,
    PowerManagementMode_PowerSave                           = 0x0001,
    PowerManagementMode_FastPowerSave                       = 0x0002
} PowerManagementMode;

typedef enum Priority
{
    Priority_QoSUP0                                         = 0x0000,
    Priority_QoSUP1                                         = 0x0001,
    Priority_QoSUP2                                         = 0x0002,
    Priority_QoSUP3                                         = 0x0003,
    Priority_QoSUP4                                         = 0x0004,
    Priority_QoSUP5                                         = 0x0005,
    Priority_QoSUP6                                         = 0x0006,
    Priority_QoSUP7                                         = 0x0007,
    Priority_QoSTSID0                                       = 0x0008,
    Priority_QoSTSID1                                       = 0x0009,
    Priority_QoSTSID2                                       = 0x000a,
    Priority_QoSTSID3                                       = 0x000b,
    Priority_QoSTSID4                                       = 0x000c,
    Priority_QoSTSID5                                       = 0x000d,
    Priority_QoSTSID6                                       = 0x000e,
    Priority_QoSTSID7                                       = 0x000f,
    Priority_Contention                                     = 0x8000,
    Priority_ContentionFree                                 = 0x8001
} Priority;

typedef enum Processor
{
    Processor_Default                                       = 0x0,
    Processor_Phy                                           = 0x1,
    Processor_Mac                                           = 0x2,
    Processor_Host                                          = 0x3
} Processor;

typedef enum ProtectType
{
    ProtectType_None                                        = 0x0000,
    ProtectType_Rx                                          = 0x0001,
    ProtectType_Tx                                          = 0x0002,
    ProtectType_RxTx                                        = 0x0003,
    ProtectType_RxMmpdu                                     = 0x0004,
    ProtectType_TxMmpdu                                     = 0x0005,
    ProtectType_RxTxMmpdu                                   = 0x0006
} ProtectType;

typedef enum ReasonCode
{
    ReasonCode_UnspecifiedReason                            = 0x0001,
    ReasonCode_AuthenticationNotValid                       = 0x0002,
    ReasonCode_DeauthenticatedLeaveBss                      = 0x0003,
    ReasonCode_DisassociatedInactivity                      = 0x0004,
    ReasonCode_ApOverload                                   = 0x0005,
    ReasonCode_Class2FrameError                             = 0x0006,
    ReasonCode_Class3FrameError                             = 0x0007,
    ReasonCode_DisassociatedLeaveBss                        = 0x0008,
    ReasonCode_AssociationNotAuthenticated                  = 0x0009,
    ReasonCode_DisassociatedPowerCapability                 = 0x000a,
    ReasonCode_DisassociatedSupportedChannels               = 0x000b,
    ReasonCode_InvalidInformationElement                    = 0x000d,
    ReasonCode_MichaelMicFailure                            = 0x000e,
    ReasonCode_FourwayHandshakeTimeout                      = 0x000f,
    ReasonCode_GroupKeyUpdateTimeout                        = 0x0010,
    ReasonCode_HandshakeElementDifferent                    = 0x0011,
    ReasonCode_InvalidGroupCipher                           = 0x0012,
    ReasonCode_InvalidPairwiseCipher                        = 0x0013,
    ReasonCode_InvalidAkmp                                  = 0x0014,
    ReasonCode_UnsupportedRsnIEVersion                      = 0x0015,
    ReasonCode_InvalidRsnIECapabilities                     = 0x0016,
    ReasonCode_Dot1XAuthFailed                              = 0x0017,
    ReasonCode_CipherRejectedByPolicy                       = 0x0018,
    ReasonCode_ServiceChangePrecludesTs                     = 0x001F,
    ReasonCode_QoSUnspecifiedReason                         = 0x0020,
    ReasonCode_QoSInsufficientBandwidth                     = 0x0021,
    ReasonCode_QoSExcessiveNotAck                           = 0x0022,
    ReasonCode_QoSTXOPLimitExceeded                         = 0x0023,
    ReasonCode_QstaLeaving                                  = 0x0024,
    ReasonCode_EndBa                                        = 0x0025,
    ReasonCode_EndDls                                       = 0x0025,
    ReasonCode_EndTs                                        = 0x0025,
    ReasonCode_UnknownDls                                   = 0x0026,
    ReasonCode_UnknownBa                                    = 0x0026,
    ReasonCode_UnknownTs                                    = 0x0026,
    ReasonCode_Timeout                                      = 0x0027,
    ReasonCode_STAKeyMismatch                               = 0x002d,
    ReasonCode_UnicastKeyNegotiationTimeout                 = 0xf019,
    ReasonCode_MulticastKeyAnnouncementTimeout              = 0xf01a,
    ReasonCode_IncompatibleUnicastKeyNegotiationIe          = 0xf01b,
    ReasonCode_InvalidMulticastcipher                       = 0xf01c,
    ReasonCode_InvalidUnicastcipher                         = 0xf01d,
    ReasonCode_UnsupportedWapiIEversion                     = 0xf01e,
    ReasonCode_InvalidWapiCapabilityIe                      = 0xf01f,
    ReasonCode_Waicertificateauthenticationfailed           = 0xf020
} ReasonCode;

typedef enum ReceptionStatus
{
    ReceptionStatus_RxSuccess                               = 0x0000,
    ReceptionStatus_RxFailure                               = 0x0001
} ReceptionStatus;

typedef enum ResultCode
{
    ResultCode_Success                                      = 0x0000,
    ResultCode_UnspecifiedFailure                           = 0x0001,
    ResultCode_RefusedCapabilitiesMismatch                  = 0x000a,
    ResultCode_ReassociationDeniedNoAssociation             = 0x000b,
    ResultCode_RefusedExternalReason                        = 0x000c,
    ResultCode_RefusedAuthenticationMismatch                = 0x000d,
    ResultCode_RefusedInvalidAuthenticationSequenceNumber   = 0x000e,
    ResultCode_RefusedChallengeFailure                      = 0x000f,
    ResultCode_RefusedAuthenticationTimeout                 = 0x0010,
    ResultCode_RefusedApOutOfMemory                         = 0x0011,
    ResultCode_RefusedBasicRatesMismatch                    = 0x0012,
    ResultCode_RefusedShortPreambleRequired                 = 0x0013,
    ResultCode_RefusedPbccModulationRequired                = 0x0014,
    ResultCode_RefusedChannelAgilityRequired                = 0x0015,
    ResultCode_RefusedSpectrumManagementRequired            = 0x0016,
    ResultCode_RefusedPowerCapabilityUnacceptable           = 0x0017,
    ResultCode_RefusedSupportedChannelsUnacceptable         = 0x0018,
    ResultCode_RefusedShortSlotRequired                     = 0x0019,
    ResultCode_RefusedDsssOFDMRequired                      = 0x001a,
    ResultCode_RefusedNoHtSupport                           = 0x001b,
    ResultCode_R0KhUnreachable                              = 0x001c,
    ResultCode_RefusedPcoTransitionSupport                  = 0x001d,
    ResultCode_AssociationRequestRejectedTemporarily        = 0x001e,
    ResultCode_RobustManagementFramePolicyViolation         = 0x001f,
    ResultCode_Failure                                      = 0x0020,
    ResultCode_RefusedApBandwidthInsufficient               = 0x0021,
    ResultCode_RefusedPoorOperatingChannel                  = 0x0022,
    ResultCode_RefusedQosRequired                           = 0x0023,
    ResultCode_RefusedReasonUnspecified                     = 0x0025,
    ResultCode_Refused                                      = 0x0025,
    ResultCode_InvalidParameters                            = 0x0026,
    ResultCode_RejectedWithSuggestedTspecChanges            = 0x0027,
    ResultCode_RejectedInvalidIe                            = 0x0028,
    ResultCode_RejectedInvalidGroupCipher                   = 0x0029,
    ResultCode_RejectedInvalidPairwiseCipher                = 0x002a,
    ResultCode_RejectedInvalidAkmp                          = 0x002b,
    ResultCode_RejectedUnsupportedRsnVersion                = 0x002c,
    ResultCode_RejectedInvalidRsnCapability                 = 0x002d,
    ResultCode_RejectedSecurityPolicy                       = 0x002e,
    ResultCode_RejectedForDelayPeriod                       = 0x002f,
    ResultCode_NotAllowed                                   = 0x0030,
    ResultCode_NotPresent                                   = 0x0031,
    ResultCode_NotQsta                                      = 0x0032,
    ResultCode_RejectedListenIntervalTooLarge               = 0x0033,
    ResultCode_InvalidFtActionFrameCount                    = 0x0034,
    ResultCode_InvalidPmkid                                 = 0x0035,
    ResultCode_InvalidMdie                                  = 0x0036,
    ResultCode_InvalidFtie                                  = 0x0037,
    ResultCode_UnspecifiedQosFailure                        = 0x00c8,
    ResultCode_WrongPolicy                                  = 0x00c9,
    ResultCode_InsufficientBandwidth                        = 0x00ca,
    ResultCode_InvalidTspecParameters                       = 0x00cb,
    ResultCode_Timeout                                      = 0x8000,
    ResultCode_TooManySimultaneousRequests                  = 0x8001,
    ResultCode_BssAlreadyStartedOrJoined                    = 0x8002,
    ResultCode_NotSupported                                 = 0x8003,
    ResultCode_TransmissionFailure                          = 0x8004,
    ResultCode_RefusedNotAuthenticated                      = 0x8005,
    ResultCode_ResetRequiredBeforeStart                     = 0x8006,
    ResultCode_LmInfoUnavailable                            = 0x8007,
    ResultCode_InvalidUnicastcipher                         = 0xf02f,
    ResultCode_InvalidMulticastcipher                       = 0xf030,
    ResultCode_UnsupportedWapiIEversion                     = 0xf031,
    ResultCode_InvalidWapiCapabilityIe                      = 0xf032
} ResultCode;

typedef enum RoutingInformation
{
    RoutingInformation_NullRt                               = 0x0000
} RoutingInformation;

typedef enum ScanType
{
    ScanType_ActiveScan                                     = 0x0000,
    ScanType_PassiveScan                                    = 0x0001
} ScanType;

typedef enum ServiceClass
{
    ServiceClass_ReorderableMulticast                       = 0x0000,
    ServiceClass_StrictlyOrdered                            = 0x0001,
    ServiceClass_QoSAck                                     = 0x0002,
    ServiceClass_QoSNoAck                                   = 0x0003,
    ServiceClass_QoSLocalMulticast                          = 0x0004
} ServiceClass;

typedef enum SnifferReceptionStatus
{
    SnifferReceptionStatus_Success                          = 0x0000,
    SnifferReceptionStatus_UnsupportedModulation            = 0x0001,
    SnifferReceptionStatus_BadFcs                           = 0x0002,
    SnifferReceptionStatus_BadSignal                        = 0x0003
} SnifferReceptionStatus;

typedef enum SourceType
{
    SourceType_ScrAp                                        = 0x0000,
    SourceType_ScrPortal                                    = 0x0001
} SourceType;

typedef enum SymbolId
{
    SymbolId_SltEnd                                         = 0x0000,
    SymbolId_SltPCISlotConfig                               = 0x0001,
    SymbolId_SltSDIOSlotConfig                              = 0x0002,
    SymbolId_SltBuildIdNumber                               = 0x0003,
    SymbolId_SltBuildIdString                               = 0x0004,
    SymbolId_SltPersistentStoreDb                           = 0x0005,
    SymbolId_SltResetVectorPhy                              = 0x0006,
    SymbolId_SltResetVectorMac                              = 0x0007,
    SymbolId_SltSDIOLoaderControl                           = 0x0008,
    SymbolId_SltTestCmd                                     = 0x0009,
    SymbolId_SltTestAliveCounter                            = 0x000a,
    SymbolId_SltTestParameters                              = 0x000b,
    SymbolId_SltTestResults                                 = 0x000c,
    SymbolId_SltTestVersion                                 = 0x000d,
    SymbolId_SltMIBPSIDRanges                               = 0x000e,
    SymbolId_SltKipTable                                    = 0x000f,
    SymbolId_SltPanicDataPhy                                = 0x0010,
    SymbolId_SltPanicDataMac                                = 0x0011,
    SymbolId_SltBootLoaderControl                           = 0x0012
} SymbolId;

typedef enum TransmissionStatus
{
    TransmissionStatus_Successful                           = 0x0000,
    TransmissionStatus_RetryLimit                           = 0x0001,
    TransmissionStatus_TxLifetime                           = 0x0002,
    TransmissionStatus_NoBss                                = 0x0003,
    TransmissionStatus_ExcessiveDataLength                  = 0x0004,
    TransmissionStatus_NonNullSourceRouting                 = 0x0005,
    TransmissionStatus_UnsupportedPriority                  = 0x0006,
    TransmissionStatus_UnavailablePriority                  = 0x0007,
    TransmissionStatus_UnsupportedServiceClass              = 0x0008,
    TransmissionStatus_UnavailableServiceClass              = 0x0009,
    TransmissionStatus_UnavailableKeyMapping                = 0x000a,
    TransmissionStatus_TxEdcaTimeout                        = 0x000b,
    TransmissionStatus_BlockAckTimeout                      = 0x000c
} TransmissionStatus;

typedef enum UnitDataFilterMode
{
    UnitDataFilterMode_OptOut                               = 0x0000,
    UnitDataFilterMode_OptIn                                = 0x0003
} UnitDataFilterMode;

typedef enum UpdateType
{
    UpdateType_Add                                          = 0x0000,
    UpdateType_Move                                         = 0x0001,
    UpdateType_Delete                                       = 0x0002
} UpdateType;

typedef enum ZeroBit
{
    ZeroBit_Default                                         = 0
} ZeroBit;





typedef CsrUint16 AssociationId;

typedef CsrUint16 AutonomousScanId;

typedef CsrUint16 BeaconPeriods;

typedef CsrUint16 BlackoutId;

typedef CsrUint8 BufferHandleValue;

typedef CsrUint16 CapabilityInformation;

typedef CsrUint8 ChannelNumberValue;

typedef CsrUint16 ChannelStartingFactor;

typedef CsrUint32 CipherSuiteSelector;

typedef CsrUint32 ClientTag;

typedef CsrUint16 DataLength;

typedef CsrInt16 Decibels;

typedef CsrUint8 DialogTokenValue;

typedef CsrInt32 HertzDelta;

typedef CsrUint32 Ipv4Address;

typedef struct unifi_MACAddress
{
    CsrUint8 data[6];
} unifi_MACAddress;

typedef CsrUint16 Megahertz;

typedef struct MemoryOffset
{
    CsrUint8 data[3];
} MemoryOffset;

typedef CsrUint16 Microseconds16;

typedef CsrUint32 Microseconds32;

typedef CsrUint32 Natural32;

typedef CsrUint32 PciPointer;

typedef CsrUint8 PhyType;

typedef CsrUint16 PeriodicId;

typedef CsrUint8 RcpiValue;

typedef CsrUint8 RsniValue;

typedef CsrUint16 Seconds;

typedef CsrUint16 SimplePointer;

typedef CsrUint16 SlotNumber;

typedef struct TsfTime
{
    CsrUint8 data[8];
} TsfTime;

typedef struct TsInfoValue
{
    CsrUint8 data[3];
} TsInfoValue;

typedef CsrUint16 TimeUnits;

typedef CsrUint16 TriggerId;

typedef CsrUint16 TriggeredId;

typedef CsrUint16 BufferHandle;

typedef CsrUint16 ChannelNumber;

typedef CsrUint16 DialogToken;

typedef CsrUint16 ProcessId;

typedef CsrUint16 Rcpi;

typedef CsrUint16 Rsni;

typedef CsrUint16 Rate;

typedef CsrUint16 ReportedFrame;

typedef CsrUint16 SequenceNumber;

typedef CsrUint32 TsInfo;





    typedef struct DataReference
{
    SlotNumber                     slotNumber;
    DataLength                     dataLength;
} DataReference;


#ifdef __cplusplus
}
#endif

#endif /* HIP_XML_TYPES_H */
