/* This is an autogenerated file */
/* Tag: noCheckHeader */
/*    Copyright (C) Cambridge Silicon Radio Ltd 2009. All rights reserved. */
/* */
/*   Refer to LICENSE.txt included with this source for details on the */
/*   license terms. */

#ifndef SME_XML_SIGNALS_H
#define SME_XML_SIGNALS_H

#ifdef __cplusplus
extern "C" {
#endif

#define UNIFI_DBG_CMD_REQ_ID                                         0x1901
#define UNIFI_BT_WIFI_ACTIVE_REQ_ID                                  0x7001
#define UNIFI_BT_WIFI_INACTIVE_REQ_ID                                0x7002
#define UNIFI_BT_BT_ACTIVE_IND_ID                                    0x7003
#define UNIFI_BT_BT_INACTIVE_IND_ID                                  0x7004
#define UNIFI_BT_ACTIVE_WIFI_CHANNEL_REQ_ID                          0x7005
#define UNIFI_BT_ACL_START_IND_ID                                    0x7006
#define UNIFI_BT_ACL_CHANGE_IND_ID                                   0x7007
#define UNIFI_BT_ACL_CHANNEL_TYPES_IND_ID                            0x7008
#define UNIFI_BT_ACL_STOP_IND_ID                                     0x7009
#define UNIFI_BT_SCO_START_IND_ID                                    0x700A
#define UNIFI_BT_SCO_CHANGE_IND_ID                                   0x700B
#define UNIFI_BT_SCO_STOP_IND_ID                                     0x700C
#define UNIFI_SYS_WIFI_ON_REQ_ID                                     0x8001
#define UNIFI_SYS_WIFI_ON_IND_ID                                     0x8002
#define UNIFI_SYS_WIFI_ON_RSP_ID                                     0x8003
#define UNIFI_SYS_WIFI_ON_CFM_ID                                     0x8004
#define UNIFI_SYS_WIFI_OFF_REQ_ID                                    0x8005
#define UNIFI_SYS_WIFI_OFF_IND_ID                                    0x8006
#define UNIFI_SYS_WIFI_OFF_RSP_ID                                    0x8007
#define UNIFI_SYS_WIFI_OFF_CFM_ID                                    0x8008
#define UNIFI_SYS_SUSPEND_IND_ID                                     0x8009
#define UNIFI_SYS_SUSPEND_RSP_ID                                     0x800A
#define UNIFI_SYS_RESUME_IND_ID                                      0x800B
#define UNIFI_SYS_RESUME_RSP_ID                                      0x800C
#define UNIFI_SYS_QOS_CONTROL_REQ_ID                                 0x800D
#define UNIFI_SYS_QOS_CONTROL_CFM_ID                                 0x800E
#define UNIFI_SYS_PORT_CONFIGURE_REQ_ID                              0x800F
#define UNIFI_SYS_PORT_CONFIGURE_CFM_ID                              0x8010
#define UNIFI_SYS_CONFIGURE_POWER_MODE_REQ_ID                        0x8011
#define UNIFI_SYS_TRAFFIC_CONFIG_REQ_ID                              0x8012
#define UNIFI_SYS_TRAFFIC_SAMPLE_IND_ID                              0x8013
#define UNIFI_SYS_TRAFFIC_PROTOCOL_IND_ID                            0x8014
#define UNIFI_SYS_IP_CONFIGURED_IND_ID                               0x8015
#define UNIFI_SYS_MEDIA_STATUS_REQ_ID                                0x8016
#define UNIFI_SYS_MULTICAST_ADDRESS_IND_ID                           0x8017
#define UNIFI_SYS_MULTICAST_ADDRESS_RSP_ID                           0x8018
#define UNIFI_SYS_TCLAS_ADD_REQ_ID                                   0x8019
#define UNIFI_SYS_TCLAS_ADD_CFM_ID                                   0x801A
#define UNIFI_SYS_TCLAS_DEL_REQ_ID                                   0x801B
#define UNIFI_SYS_TCLAS_DEL_CFM_ID                                   0x801C
#define UNIFI_SYS_TRAFFIC_CLASSIFICATION_REQ_ID                      0x801D
#define UNIFI_SYS_M4_TRANSMIT_REQ_ID                                 0x801E
#define UNIFI_SYS_M4_TRANSMITTED_IND_ID                              0x801F
#define UNIFI_SYS_HIP_REQ_ID                                         0x8020
#define UNIFI_SYS_HIP_IND_ID                                         0x8021
#define UNIFI_SYS_MA_UNITDATA_SUBSCRIBE_REQ_ID                       0x8022
#define UNIFI_SYS_MA_UNITDATA_SUBSCRIBE_CFM_ID                       0x8023
#define UNIFI_SYS_MA_UNITDATA_UNSUBSCRIBE_REQ_ID                     0x8024
#define UNIFI_SYS_MA_UNITDATA_UNSUBSCRIBE_CFM_ID                     0x8025
#define UNIFI_SYS_CAPABILITIES_REQ_ID                                0x8026
#define UNIFI_SYS_CAPABILITIES_CFM_ID                                0x8027
#define UNIFI_SYS_MA_UNITDATA_REQ_ID                                 0x8028
#define UNIFI_SYS_MA_UNITDATA_CFM_ID                                 0x8029
#define UNIFI_SYS_MA_UNITDATA_RSP_ID                                 0x802A
#define UNIFI_SYS_MA_UNITDATA_IND_ID                                 0x802B
#define UNIFI_SYS_EAPOL_REQ_ID                                       0x802C
#define UNIFI_SYS_EAPOL_CFM_ID                                       0x802D
#define UNIFI_MGT_WIFI_ON_REQ_ID                                     0x9001
#define UNIFI_MGT_WIFI_ON_CFM_ID                                     0x9002
#define UNIFI_MGT_WIFI_OFF_REQ_ID                                    0x9003
#define UNIFI_MGT_WIFI_OFF_CFM_ID                                    0x9004
#define UNIFI_MGT_WIFI_OFF_IND_ID                                    0x9005
#define UNIFI_MGT_WIFI_FLIGHTMODE_REQ_ID                             0x9006
#define UNIFI_MGT_WIFI_FLIGHTMODE_CFM_ID                             0x9007
#define UNIFI_MGT_SET_VALUE_REQ_ID                                   0x9008
#define UNIFI_MGT_SET_VALUE_CFM_ID                                   0x9009
#define UNIFI_MGT_GET_VALUE_REQ_ID                                   0x900A
#define UNIFI_MGT_GET_VALUE_CFM_ID                                   0x900B
#define UNIFI_MGT_MIB_SET_REQ_ID                                     0x900C
#define UNIFI_MGT_MIB_SET_CFM_ID                                     0x900D
#define UNIFI_MGT_MIB_GET_REQ_ID                                     0x900E
#define UNIFI_MGT_MIB_GET_CFM_ID                                     0x900F
#define UNIFI_MGT_MIB_GET_NEXT_REQ_ID                                0x9010
#define UNIFI_MGT_MIB_GET_NEXT_CFM_ID                                0x9011
#define UNIFI_MGT_SCAN_FULL_REQ_ID                                   0x9012
#define UNIFI_MGT_SCAN_FULL_CFM_ID                                   0x9013
#define UNIFI_MGT_SCAN_RESULTS_GET_REQ_ID                            0x9014
#define UNIFI_MGT_SCAN_RESULTS_GET_CFM_ID                            0x9015
#define UNIFI_MGT_SCAN_RESULT_IND_ID                                 0x9016
#define UNIFI_MGT_CONNECT_REQ_ID                                     0x9017
#define UNIFI_MGT_CONNECT_CFM_ID                                     0x9018
#define UNIFI_MGT_MEDIA_STATUS_IND_ID                                0x9019
#define UNIFI_MGT_CONNECTION_QUALITY_IND_ID                          0x901A
#define UNIFI_MGT_DISCONNECT_REQ_ID                                  0x901B
#define UNIFI_MGT_DISCONNECT_CFM_ID                                  0x901C
#define UNIFI_MGT_MULTICAST_ADDRESS_REQ_ID                           0x901D
#define UNIFI_MGT_MULTICAST_ADDRESS_CFM_ID                           0x901E
#define UNIFI_MGT_MIC_FAILURE_IND_ID                                 0x901F
#define UNIFI_MGT_PMKID_CANDIDATE_LIST_IND_ID                        0x9020
#define UNIFI_MGT_PMKID_REQ_ID                                       0x9021
#define UNIFI_MGT_PMKID_CFM_ID                                       0x9022
#define UNIFI_MGT_KEY_REQ_ID                                         0x9023
#define UNIFI_MGT_KEY_CFM_ID                                         0x9024
#define UNIFI_MGT_PACKET_FILTER_SET_REQ_ID                           0x9025
#define UNIFI_MGT_PACKET_FILTER_SET_CFM_ID                           0x9026
#define UNIFI_MGT_TSPEC_REQ_ID                                       0x9027
#define UNIFI_MGT_TSPEC_CFM_ID                                       0x9028
#define UNIFI_MGT_TSPEC_IND_ID                                       0x9029
#define UNIFI_MGT_SCAN_RESULTS_FLUSH_REQ_ID                          0x902A
#define UNIFI_MGT_SCAN_RESULTS_FLUSH_CFM_ID                          0x902B
#define UNIFI_MGT_BLACKLIST_REQ_ID                                   0x902C
#define UNIFI_MGT_BLACKLIST_CFM_ID                                   0x902D
#define UNIFI_MGT_ROAM_START_IND_ID                                  0x902E
#define UNIFI_MGT_ROAM_COMPLETE_IND_ID                               0x902F
#define UNIFI_MGT_ASSOCIATION_START_IND_ID                           0x9030
#define UNIFI_MGT_ASSOCIATION_COMPLETE_IND_ID                        0x9031
#define UNIFI_MGT_IBSS_STATION_IND_ID                                0x9032
#define UNIFI_MGT_EVENT_MASK_SET_REQ_ID                              0x9033
#define UNIFI_MGT_EVENT_MASK_SET_CFM_ID                              0x9034
#define UNIFI_MGT_RESTRICTED_ACCESS_ENABLE_REQ_ID                    0x9035
#define UNIFI_MGT_RESTRICTED_ACCESS_ENABLE_CFM_ID                    0x9036
#define UNIFI_MGT_RESTRICTED_ACCESS_DISABLE_REQ_ID                   0x9037
#define UNIFI_MGT_RESTRICTED_ACCESS_DISABLE_CFM_ID                   0x9038


/* -------------------------- unifi_bt_acl_change_ind -------------------------- */
typedef struct UnifiBtAclChangeInd_Evt
{
    FsmEvent                        common;
    unifi_MACAddress                aclHandle;
    unifi_BtDeviceRole              role;
    unifi_BtDeviceMode              mode;
} UnifiBtAclChangeInd_Evt;

#define send_unifi_bt_acl_change_ind(context, pid, p_aclHandle, p_role, p_mode) \
{ \
    UnifiBtAclChangeInd_Evt *evt = (UnifiBtAclChangeInd_Evt*) CsrPmalloc(sizeof(UnifiBtAclChangeInd_Evt)); \
    evt->aclHandle            = p_aclHandle; \
    evt->role                 = p_role; \
    evt->mode                 = p_mode; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_BT_ACL_CHANGE_IND_ID); \
}

#define send_unifi_bt_acl_change_ind_external(context, pid, p_aclHandle, p_role, p_mode) \
{ \
    UnifiBtAclChangeInd_Evt *evt = (UnifiBtAclChangeInd_Evt*) CsrPmalloc(sizeof(UnifiBtAclChangeInd_Evt)); \
    evt->aclHandle            = p_aclHandle; \
    evt->role                 = p_role; \
    evt->mode                 = p_mode; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_BT_ACL_CHANGE_IND_ID); \
}

/* -------------------------- unifi_bt_acl_channel_types_ind -------------------------- */
typedef struct UnifiBtAclChannelTypesInd_Evt
{
    FsmEvent                        common;
    unifi_MACAddress                aclHandle;
    CsrUint16                       logicalChannelTypeMask;
    CsrUint8                        numberOfGuaranteedLogicalChannels;
} UnifiBtAclChannelTypesInd_Evt;

#define send_unifi_bt_acl_channel_types_ind(context, pid, p_aclHandle, p_logicalChannelTypeMask, p_numberOfGuaranteedLogicalChannels) \
{ \
    UnifiBtAclChannelTypesInd_Evt *evt = (UnifiBtAclChannelTypesInd_Evt*) CsrPmalloc(sizeof(UnifiBtAclChannelTypesInd_Evt)); \
    evt->aclHandle            = p_aclHandle; \
    evt->logicalChannelTypeMask = p_logicalChannelTypeMask; \
    evt->numberOfGuaranteedLogicalChannels = p_numberOfGuaranteedLogicalChannels; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_BT_ACL_CHANNEL_TYPES_IND_ID); \
}

#define send_unifi_bt_acl_channel_types_ind_external(context, pid, p_aclHandle, p_logicalChannelTypeMask, p_numberOfGuaranteedLogicalChannels) \
{ \
    UnifiBtAclChannelTypesInd_Evt *evt = (UnifiBtAclChannelTypesInd_Evt*) CsrPmalloc(sizeof(UnifiBtAclChannelTypesInd_Evt)); \
    evt->aclHandle            = p_aclHandle; \
    evt->logicalChannelTypeMask = p_logicalChannelTypeMask; \
    evt->numberOfGuaranteedLogicalChannels = p_numberOfGuaranteedLogicalChannels; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_BT_ACL_CHANNEL_TYPES_IND_ID); \
}

/* -------------------------- unifi_bt_acl_start_ind -------------------------- */
typedef struct UnifiBtAclStartInd_Evt
{
    FsmEvent                        common;
    unifi_MACAddress                aclHandle;
    unifi_BtDeviceRole              role;
    unifi_BtDeviceMode              mode;
} UnifiBtAclStartInd_Evt;

#define send_unifi_bt_acl_start_ind(context, pid, p_aclHandle, p_role, p_mode) \
{ \
    UnifiBtAclStartInd_Evt *evt = (UnifiBtAclStartInd_Evt*) CsrPmalloc(sizeof(UnifiBtAclStartInd_Evt)); \
    evt->aclHandle            = p_aclHandle; \
    evt->role                 = p_role; \
    evt->mode                 = p_mode; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_BT_ACL_START_IND_ID); \
}

#define send_unifi_bt_acl_start_ind_external(context, pid, p_aclHandle, p_role, p_mode) \
{ \
    UnifiBtAclStartInd_Evt *evt = (UnifiBtAclStartInd_Evt*) CsrPmalloc(sizeof(UnifiBtAclStartInd_Evt)); \
    evt->aclHandle            = p_aclHandle; \
    evt->role                 = p_role; \
    evt->mode                 = p_mode; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_BT_ACL_START_IND_ID); \
}

/* -------------------------- unifi_bt_acl_stop_ind -------------------------- */
typedef struct UnifiBtAclStopInd_Evt
{
    FsmEvent                        common;
    unifi_MACAddress                aclHandle;
} UnifiBtAclStopInd_Evt;

#define send_unifi_bt_acl_stop_ind(context, pid, p_aclHandle) \
{ \
    UnifiBtAclStopInd_Evt *evt = (UnifiBtAclStopInd_Evt*) CsrPmalloc(sizeof(UnifiBtAclStopInd_Evt)); \
    evt->aclHandle            = p_aclHandle; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_BT_ACL_STOP_IND_ID); \
}

#define send_unifi_bt_acl_stop_ind_external(context, pid, p_aclHandle) \
{ \
    UnifiBtAclStopInd_Evt *evt = (UnifiBtAclStopInd_Evt*) CsrPmalloc(sizeof(UnifiBtAclStopInd_Evt)); \
    evt->aclHandle            = p_aclHandle; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_BT_ACL_STOP_IND_ID); \
}

/* -------------------------- unifi_bt_active_wifi_channel_req -------------------------- */
typedef struct UnifiBtActiveWifiChannelReq_Evt
{
    FsmEvent                        common;
    CsrUint16                       channelMhz;
    CsrUint16                       bandwidthMhz;
} UnifiBtActiveWifiChannelReq_Evt;

#define send_unifi_bt_active_wifi_channel_req(context, pid, p_channelMhz, p_bandwidthMhz) \
{ \
    UnifiBtActiveWifiChannelReq_Evt *evt = (UnifiBtActiveWifiChannelReq_Evt*) CsrPmalloc(sizeof(UnifiBtActiveWifiChannelReq_Evt)); \
    evt->channelMhz           = p_channelMhz; \
    evt->bandwidthMhz         = p_bandwidthMhz; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_BT_ACTIVE_WIFI_CHANNEL_REQ_ID); \
}

#define send_unifi_bt_active_wifi_channel_req_external(context, pid, p_channelMhz, p_bandwidthMhz) \
{ \
    UnifiBtActiveWifiChannelReq_Evt *evt = (UnifiBtActiveWifiChannelReq_Evt*) CsrPmalloc(sizeof(UnifiBtActiveWifiChannelReq_Evt)); \
    evt->channelMhz           = p_channelMhz; \
    evt->bandwidthMhz         = p_bandwidthMhz; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_BT_ACTIVE_WIFI_CHANNEL_REQ_ID); \
}

/* -------------------------- unifi_bt_bt_active_ind -------------------------- */
typedef struct UnifiBtBtActiveInd_Evt
{
    FsmEvent                        common;
} UnifiBtBtActiveInd_Evt;

#define send_unifi_bt_bt_active_ind(context, pid) \
{ \
    UnifiBtBtActiveInd_Evt *evt = (UnifiBtBtActiveInd_Evt*) CsrPmalloc(sizeof(UnifiBtBtActiveInd_Evt)); \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_BT_BT_ACTIVE_IND_ID); \
}

#define send_unifi_bt_bt_active_ind_external(context, pid) \
{ \
    UnifiBtBtActiveInd_Evt *evt = (UnifiBtBtActiveInd_Evt*) CsrPmalloc(sizeof(UnifiBtBtActiveInd_Evt)); \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_BT_BT_ACTIVE_IND_ID); \
}

/* -------------------------- unifi_bt_bt_inactive_ind -------------------------- */
typedef struct UnifiBtBtInactiveInd_Evt
{
    FsmEvent                        common;
} UnifiBtBtInactiveInd_Evt;

#define send_unifi_bt_bt_inactive_ind(context, pid) \
{ \
    UnifiBtBtInactiveInd_Evt *evt = (UnifiBtBtInactiveInd_Evt*) CsrPmalloc(sizeof(UnifiBtBtInactiveInd_Evt)); \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_BT_BT_INACTIVE_IND_ID); \
}

#define send_unifi_bt_bt_inactive_ind_external(context, pid) \
{ \
    UnifiBtBtInactiveInd_Evt *evt = (UnifiBtBtInactiveInd_Evt*) CsrPmalloc(sizeof(UnifiBtBtInactiveInd_Evt)); \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_BT_BT_INACTIVE_IND_ID); \
}

/* -------------------------- unifi_bt_sco_change_ind -------------------------- */
typedef struct UnifiBtScoChangeInd_Evt
{
    FsmEvent                        common;
    unifi_MACAddress                aclHandle;
    CsrUint16                       scoHandle;
    CsrUint16                       periodSlots;
    CsrUint16                       durationMinSlots;
    CsrUint16                       durationMaxSlots;
} UnifiBtScoChangeInd_Evt;

#define send_unifi_bt_sco_change_ind(context, pid, p_aclHandle, p_scoHandle, p_periodSlots, p_durationMinSlots, p_durationMaxSlots) \
{ \
    UnifiBtScoChangeInd_Evt *evt = (UnifiBtScoChangeInd_Evt*) CsrPmalloc(sizeof(UnifiBtScoChangeInd_Evt)); \
    evt->aclHandle            = p_aclHandle; \
    evt->scoHandle            = p_scoHandle; \
    evt->periodSlots          = p_periodSlots; \
    evt->durationMinSlots     = p_durationMinSlots; \
    evt->durationMaxSlots     = p_durationMaxSlots; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_BT_SCO_CHANGE_IND_ID); \
}

#define send_unifi_bt_sco_change_ind_external(context, pid, p_aclHandle, p_scoHandle, p_periodSlots, p_durationMinSlots, p_durationMaxSlots) \
{ \
    UnifiBtScoChangeInd_Evt *evt = (UnifiBtScoChangeInd_Evt*) CsrPmalloc(sizeof(UnifiBtScoChangeInd_Evt)); \
    evt->aclHandle            = p_aclHandle; \
    evt->scoHandle            = p_scoHandle; \
    evt->periodSlots          = p_periodSlots; \
    evt->durationMinSlots     = p_durationMinSlots; \
    evt->durationMaxSlots     = p_durationMaxSlots; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_BT_SCO_CHANGE_IND_ID); \
}

/* -------------------------- unifi_bt_sco_start_ind -------------------------- */
typedef struct UnifiBtScoStartInd_Evt
{
    FsmEvent                        common;
    unifi_MACAddress                aclHandle;
    CsrUint16                       scoHandle;
    CsrUint16                       periodSlots;
    CsrUint16                       durationMinSlots;
    CsrUint16                       durationMaxSlots;
} UnifiBtScoStartInd_Evt;

#define send_unifi_bt_sco_start_ind(context, pid, p_aclHandle, p_scoHandle, p_periodSlots, p_durationMinSlots, p_durationMaxSlots) \
{ \
    UnifiBtScoStartInd_Evt *evt = (UnifiBtScoStartInd_Evt*) CsrPmalloc(sizeof(UnifiBtScoStartInd_Evt)); \
    evt->aclHandle            = p_aclHandle; \
    evt->scoHandle            = p_scoHandle; \
    evt->periodSlots          = p_periodSlots; \
    evt->durationMinSlots     = p_durationMinSlots; \
    evt->durationMaxSlots     = p_durationMaxSlots; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_BT_SCO_START_IND_ID); \
}

#define send_unifi_bt_sco_start_ind_external(context, pid, p_aclHandle, p_scoHandle, p_periodSlots, p_durationMinSlots, p_durationMaxSlots) \
{ \
    UnifiBtScoStartInd_Evt *evt = (UnifiBtScoStartInd_Evt*) CsrPmalloc(sizeof(UnifiBtScoStartInd_Evt)); \
    evt->aclHandle            = p_aclHandle; \
    evt->scoHandle            = p_scoHandle; \
    evt->periodSlots          = p_periodSlots; \
    evt->durationMinSlots     = p_durationMinSlots; \
    evt->durationMaxSlots     = p_durationMaxSlots; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_BT_SCO_START_IND_ID); \
}

/* -------------------------- unifi_bt_sco_stop_ind -------------------------- */
typedef struct UnifiBtScoStopInd_Evt
{
    FsmEvent                        common;
    unifi_MACAddress                aclHandle;
    CsrUint16                       scoHandle;
} UnifiBtScoStopInd_Evt;

#define send_unifi_bt_sco_stop_ind(context, pid, p_aclHandle, p_scoHandle) \
{ \
    UnifiBtScoStopInd_Evt *evt = (UnifiBtScoStopInd_Evt*) CsrPmalloc(sizeof(UnifiBtScoStopInd_Evt)); \
    evt->aclHandle            = p_aclHandle; \
    evt->scoHandle            = p_scoHandle; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_BT_SCO_STOP_IND_ID); \
}

#define send_unifi_bt_sco_stop_ind_external(context, pid, p_aclHandle, p_scoHandle) \
{ \
    UnifiBtScoStopInd_Evt *evt = (UnifiBtScoStopInd_Evt*) CsrPmalloc(sizeof(UnifiBtScoStopInd_Evt)); \
    evt->aclHandle            = p_aclHandle; \
    evt->scoHandle            = p_scoHandle; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_BT_SCO_STOP_IND_ID); \
}

/* -------------------------- unifi_bt_wifi_active_req -------------------------- */
typedef struct UnifiBtWifiActiveReq_Evt
{
    FsmEvent                        common;
} UnifiBtWifiActiveReq_Evt;

#define send_unifi_bt_wifi_active_req(context, pid) \
{ \
    UnifiBtWifiActiveReq_Evt *evt = (UnifiBtWifiActiveReq_Evt*) CsrPmalloc(sizeof(UnifiBtWifiActiveReq_Evt)); \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_BT_WIFI_ACTIVE_REQ_ID); \
}

#define send_unifi_bt_wifi_active_req_external(context, pid) \
{ \
    UnifiBtWifiActiveReq_Evt *evt = (UnifiBtWifiActiveReq_Evt*) CsrPmalloc(sizeof(UnifiBtWifiActiveReq_Evt)); \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_BT_WIFI_ACTIVE_REQ_ID); \
}

/* -------------------------- unifi_bt_wifi_inactive_req -------------------------- */
typedef struct UnifiBtWifiInactiveReq_Evt
{
    FsmEvent                        common;
} UnifiBtWifiInactiveReq_Evt;

#define send_unifi_bt_wifi_inactive_req(context, pid) \
{ \
    UnifiBtWifiInactiveReq_Evt *evt = (UnifiBtWifiInactiveReq_Evt*) CsrPmalloc(sizeof(UnifiBtWifiInactiveReq_Evt)); \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_BT_WIFI_INACTIVE_REQ_ID); \
}

#define send_unifi_bt_wifi_inactive_req_external(context, pid) \
{ \
    UnifiBtWifiInactiveReq_Evt *evt = (UnifiBtWifiInactiveReq_Evt*) CsrPmalloc(sizeof(UnifiBtWifiInactiveReq_Evt)); \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_BT_WIFI_INACTIVE_REQ_ID); \
}

/* -------------------------- unifi_dbg_cmd_req -------------------------- */
typedef struct UnifiDbgCmdReq_Evt
{
    FsmEvent                        common;
    char*                           command;
} UnifiDbgCmdReq_Evt;

#define send_unifi_dbg_cmd_req(context, pid, p_command) \
{ \
    UnifiDbgCmdReq_Evt *evt = (UnifiDbgCmdReq_Evt*) CsrPmalloc(sizeof(UnifiDbgCmdReq_Evt)); \
    evt->command              = p_command; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_DBG_CMD_REQ_ID); \
}

#define send_unifi_dbg_cmd_req_external(context, pid, p_command) \
{ \
    UnifiDbgCmdReq_Evt *evt = (UnifiDbgCmdReq_Evt*) CsrPmalloc(sizeof(UnifiDbgCmdReq_Evt)); \
    evt->command              = p_command; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_DBG_CMD_REQ_ID); \
}

/* -------------------------- unifi_mgt_association_complete_ind -------------------------- */
typedef struct UnifiMgtAssociationCompleteInd_Evt
{
    FsmEvent                        common;
    CsrUint16                       appHandlesCount;
    void*                          *appHandles;
    unifi_Status                    status;
    unifi_ConnectionInfo            connectionInfo;
    unifi_IEEE80211Reason           deauthReason;
} UnifiMgtAssociationCompleteInd_Evt;

#define send_unifi_mgt_association_complete_ind(context, pid, p_appHandlesCount, p_appHandles, p_status, p_connectionInfo, p_deauthReason) \
{ \
    UnifiMgtAssociationCompleteInd_Evt *evt = (UnifiMgtAssociationCompleteInd_Evt*) CsrPmalloc(sizeof(UnifiMgtAssociationCompleteInd_Evt)); \
    evt->appHandlesCount      = p_appHandlesCount; \
    evt->appHandles           = p_appHandles; \
    evt->status               = p_status; \
    evt->connectionInfo       = p_connectionInfo; \
    evt->deauthReason         = p_deauthReason; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_ASSOCIATION_COMPLETE_IND_ID); \
}

#define send_unifi_mgt_association_complete_ind_external(context, pid, p_appHandlesCount, p_appHandles, p_status, p_connectionInfo, p_deauthReason) \
{ \
    UnifiMgtAssociationCompleteInd_Evt *evt = (UnifiMgtAssociationCompleteInd_Evt*) CsrPmalloc(sizeof(UnifiMgtAssociationCompleteInd_Evt)); \
    evt->appHandlesCount      = p_appHandlesCount; \
    evt->appHandles           = p_appHandles; \
    evt->status               = p_status; \
    evt->connectionInfo       = p_connectionInfo; \
    evt->deauthReason         = p_deauthReason; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_ASSOCIATION_COMPLETE_IND_ID); \
}

/* -------------------------- unifi_mgt_association_start_ind -------------------------- */
typedef struct UnifiMgtAssociationStartInd_Evt
{
    FsmEvent                        common;
    CsrUint16                       appHandlesCount;
    void*                          *appHandles;
    unifi_MACAddress                address;
    unifi_SSID                      ssid;
} UnifiMgtAssociationStartInd_Evt;

#define send_unifi_mgt_association_start_ind(context, pid, p_appHandlesCount, p_appHandles, p_address, p_ssid) \
{ \
    UnifiMgtAssociationStartInd_Evt *evt = (UnifiMgtAssociationStartInd_Evt*) CsrPmalloc(sizeof(UnifiMgtAssociationStartInd_Evt)); \
    evt->appHandlesCount      = p_appHandlesCount; \
    evt->appHandles           = p_appHandles; \
    evt->address              = p_address; \
    evt->ssid                 = p_ssid; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_ASSOCIATION_START_IND_ID); \
}

#define send_unifi_mgt_association_start_ind_external(context, pid, p_appHandlesCount, p_appHandles, p_address, p_ssid) \
{ \
    UnifiMgtAssociationStartInd_Evt *evt = (UnifiMgtAssociationStartInd_Evt*) CsrPmalloc(sizeof(UnifiMgtAssociationStartInd_Evt)); \
    evt->appHandlesCount      = p_appHandlesCount; \
    evt->appHandles           = p_appHandles; \
    evt->address              = p_address; \
    evt->ssid                 = p_ssid; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_ASSOCIATION_START_IND_ID); \
}

/* -------------------------- unifi_mgt_blacklist_req -------------------------- */
typedef struct UnifiMgtBlacklistReq_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_ListAction                action;
    CsrUint8                        setAddressCount;
    unifi_MACAddress               *setAddresses;
} UnifiMgtBlacklistReq_Evt;

#define send_unifi_mgt_blacklist_req(context, pid, p_appHandle, p_action, p_setAddressCount, p_setAddresses) \
{ \
    UnifiMgtBlacklistReq_Evt *evt = (UnifiMgtBlacklistReq_Evt*) CsrPmalloc(sizeof(UnifiMgtBlacklistReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->action               = p_action; \
    evt->setAddressCount      = p_setAddressCount; \
    evt->setAddresses         = p_setAddresses; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_BLACKLIST_REQ_ID); \
}

#define send_unifi_mgt_blacklist_req_external(context, pid, p_appHandle, p_action, p_setAddressCount, p_setAddresses) \
{ \
    UnifiMgtBlacklistReq_Evt *evt = (UnifiMgtBlacklistReq_Evt*) CsrPmalloc(sizeof(UnifiMgtBlacklistReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->action               = p_action; \
    evt->setAddressCount      = p_setAddressCount; \
    evt->setAddresses         = p_setAddresses; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_BLACKLIST_REQ_ID); \
}

/* -------------------------- unifi_mgt_blacklist_cfm -------------------------- */
typedef struct UnifiMgtBlacklistCfm_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_Status                    status;
    unifi_ListAction                action;
    CsrUint8                        getAddressCount;
    unifi_MACAddress               *getAddresses;
} UnifiMgtBlacklistCfm_Evt;

#define send_unifi_mgt_blacklist_cfm(context, pid, p_appHandle, p_status, p_action, p_getAddressCount, p_getAddresses) \
{ \
    UnifiMgtBlacklistCfm_Evt *evt = (UnifiMgtBlacklistCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtBlacklistCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    evt->action               = p_action; \
    evt->getAddressCount      = p_getAddressCount; \
    evt->getAddresses         = p_getAddresses; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_BLACKLIST_CFM_ID); \
}

#define send_unifi_mgt_blacklist_cfm_external(context, pid, p_appHandle, p_status, p_action, p_getAddressCount, p_getAddresses) \
{ \
    UnifiMgtBlacklistCfm_Evt *evt = (UnifiMgtBlacklistCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtBlacklistCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    evt->action               = p_action; \
    evt->getAddressCount      = p_getAddressCount; \
    evt->getAddresses         = p_getAddresses; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_BLACKLIST_CFM_ID); \
}

/* -------------------------- unifi_mgt_connect_req -------------------------- */
typedef struct UnifiMgtConnectReq_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_ConnectionConfig          connectionConfig;
} UnifiMgtConnectReq_Evt;

#define send_unifi_mgt_connect_req(context, pid, p_appHandle, p_connectionConfig) \
{ \
    UnifiMgtConnectReq_Evt *evt = (UnifiMgtConnectReq_Evt*) CsrPmalloc(sizeof(UnifiMgtConnectReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->connectionConfig     = p_connectionConfig; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_CONNECT_REQ_ID); \
}

#define send_unifi_mgt_connect_req_external(context, pid, p_appHandle, p_connectionConfig) \
{ \
    UnifiMgtConnectReq_Evt *evt = (UnifiMgtConnectReq_Evt*) CsrPmalloc(sizeof(UnifiMgtConnectReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->connectionConfig     = p_connectionConfig; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_CONNECT_REQ_ID); \
}

/* -------------------------- unifi_mgt_connect_cfm -------------------------- */
typedef struct UnifiMgtConnectCfm_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_Status                    status;
} UnifiMgtConnectCfm_Evt;

#define send_unifi_mgt_connect_cfm(context, pid, p_appHandle, p_status) \
{ \
    UnifiMgtConnectCfm_Evt *evt = (UnifiMgtConnectCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtConnectCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_CONNECT_CFM_ID); \
}

#define send_unifi_mgt_connect_cfm_external(context, pid, p_appHandle, p_status) \
{ \
    UnifiMgtConnectCfm_Evt *evt = (UnifiMgtConnectCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtConnectCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_CONNECT_CFM_ID); \
}

/* -------------------------- unifi_mgt_connection_quality_ind -------------------------- */
typedef struct UnifiMgtConnectionQualityInd_Evt
{
    FsmEvent                        common;
    CsrUint16                       appHandlesCount;
    void*                          *appHandles;
    unifi_LinkQuality               linkQuality;
} UnifiMgtConnectionQualityInd_Evt;

#define send_unifi_mgt_connection_quality_ind(context, pid, p_appHandlesCount, p_appHandles, p_linkQuality) \
{ \
    UnifiMgtConnectionQualityInd_Evt *evt = (UnifiMgtConnectionQualityInd_Evt*) CsrPmalloc(sizeof(UnifiMgtConnectionQualityInd_Evt)); \
    evt->appHandlesCount      = p_appHandlesCount; \
    evt->appHandles           = p_appHandles; \
    evt->linkQuality          = p_linkQuality; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_CONNECTION_QUALITY_IND_ID); \
}

#define send_unifi_mgt_connection_quality_ind_external(context, pid, p_appHandlesCount, p_appHandles, p_linkQuality) \
{ \
    UnifiMgtConnectionQualityInd_Evt *evt = (UnifiMgtConnectionQualityInd_Evt*) CsrPmalloc(sizeof(UnifiMgtConnectionQualityInd_Evt)); \
    evt->appHandlesCount      = p_appHandlesCount; \
    evt->appHandles           = p_appHandles; \
    evt->linkQuality          = p_linkQuality; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_CONNECTION_QUALITY_IND_ID); \
}

/* -------------------------- unifi_mgt_disconnect_req -------------------------- */
typedef struct UnifiMgtDisconnectReq_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
} UnifiMgtDisconnectReq_Evt;

#define send_unifi_mgt_disconnect_req(context, pid, p_appHandle) \
{ \
    UnifiMgtDisconnectReq_Evt *evt = (UnifiMgtDisconnectReq_Evt*) CsrPmalloc(sizeof(UnifiMgtDisconnectReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_DISCONNECT_REQ_ID); \
}

#define send_unifi_mgt_disconnect_req_external(context, pid, p_appHandle) \
{ \
    UnifiMgtDisconnectReq_Evt *evt = (UnifiMgtDisconnectReq_Evt*) CsrPmalloc(sizeof(UnifiMgtDisconnectReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_DISCONNECT_REQ_ID); \
}

/* -------------------------- unifi_mgt_disconnect_cfm -------------------------- */
typedef struct UnifiMgtDisconnectCfm_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_Status                    status;
} UnifiMgtDisconnectCfm_Evt;

#define send_unifi_mgt_disconnect_cfm(context, pid, p_appHandle, p_status) \
{ \
    UnifiMgtDisconnectCfm_Evt *evt = (UnifiMgtDisconnectCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtDisconnectCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_DISCONNECT_CFM_ID); \
}

#define send_unifi_mgt_disconnect_cfm_external(context, pid, p_appHandle, p_status) \
{ \
    UnifiMgtDisconnectCfm_Evt *evt = (UnifiMgtDisconnectCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtDisconnectCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_DISCONNECT_CFM_ID); \
}

/* -------------------------- unifi_mgt_event_mask_set_req -------------------------- */
typedef struct UnifiMgtEventMaskSetReq_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    CsrUint32                       indMask;
} UnifiMgtEventMaskSetReq_Evt;

#define send_unifi_mgt_event_mask_set_req(context, pid, p_appHandle, p_indMask) \
{ \
    UnifiMgtEventMaskSetReq_Evt *evt = (UnifiMgtEventMaskSetReq_Evt*) CsrPmalloc(sizeof(UnifiMgtEventMaskSetReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->indMask              = p_indMask; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_EVENT_MASK_SET_REQ_ID); \
}

#define send_unifi_mgt_event_mask_set_req_external(context, pid, p_appHandle, p_indMask) \
{ \
    UnifiMgtEventMaskSetReq_Evt *evt = (UnifiMgtEventMaskSetReq_Evt*) CsrPmalloc(sizeof(UnifiMgtEventMaskSetReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->indMask              = p_indMask; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_EVENT_MASK_SET_REQ_ID); \
}

/* -------------------------- unifi_mgt_event_mask_set_cfm -------------------------- */
typedef struct UnifiMgtEventMaskSetCfm_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_Status                    status;
} UnifiMgtEventMaskSetCfm_Evt;

#define send_unifi_mgt_event_mask_set_cfm(context, pid, p_appHandle, p_status) \
{ \
    UnifiMgtEventMaskSetCfm_Evt *evt = (UnifiMgtEventMaskSetCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtEventMaskSetCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_EVENT_MASK_SET_CFM_ID); \
}

#define send_unifi_mgt_event_mask_set_cfm_external(context, pid, p_appHandle, p_status) \
{ \
    UnifiMgtEventMaskSetCfm_Evt *evt = (UnifiMgtEventMaskSetCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtEventMaskSetCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_EVENT_MASK_SET_CFM_ID); \
}

/* -------------------------- unifi_mgt_get_value_req -------------------------- */
typedef struct UnifiMgtGetValueReq_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_AppValueId                appValueId;
} UnifiMgtGetValueReq_Evt;

#define send_unifi_mgt_get_value_req(context, pid, p_appHandle, p_appValueId) \
{ \
    UnifiMgtGetValueReq_Evt *evt = (UnifiMgtGetValueReq_Evt*) CsrPmalloc(sizeof(UnifiMgtGetValueReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->appValueId           = p_appValueId; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_GET_VALUE_REQ_ID); \
}

#define send_unifi_mgt_get_value_req_external(context, pid, p_appHandle, p_appValueId) \
{ \
    UnifiMgtGetValueReq_Evt *evt = (UnifiMgtGetValueReq_Evt*) CsrPmalloc(sizeof(UnifiMgtGetValueReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->appValueId           = p_appValueId; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_GET_VALUE_REQ_ID); \
}

/* -------------------------- unifi_mgt_get_value_cfm -------------------------- */
typedef struct UnifiMgtGetValueCfm_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_Status                    status;
    unifi_AppValue                  appValue;
} UnifiMgtGetValueCfm_Evt;

#define send_unifi_mgt_get_value_cfm(context, pid, p_appHandle, p_status, p_appValue) \
{ \
    UnifiMgtGetValueCfm_Evt *evt = (UnifiMgtGetValueCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtGetValueCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    evt->appValue             = p_appValue; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_GET_VALUE_CFM_ID); \
}

#define send_unifi_mgt_get_value_cfm_external(context, pid, p_appHandle, p_status, p_appValue) \
{ \
    UnifiMgtGetValueCfm_Evt *evt = (UnifiMgtGetValueCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtGetValueCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    evt->appValue             = p_appValue; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_GET_VALUE_CFM_ID); \
}

/* -------------------------- unifi_mgt_ibss_station_ind -------------------------- */
typedef struct UnifiMgtIbssStationInd_Evt
{
    FsmEvent                        common;
    CsrUint16                       appHandlesCount;
    void*                          *appHandles;
    unifi_MACAddress                address;
    CsrBool                         isconnected;
} UnifiMgtIbssStationInd_Evt;

#define send_unifi_mgt_ibss_station_ind(context, pid, p_appHandlesCount, p_appHandles, p_address, p_isconnected) \
{ \
    UnifiMgtIbssStationInd_Evt *evt = (UnifiMgtIbssStationInd_Evt*) CsrPmalloc(sizeof(UnifiMgtIbssStationInd_Evt)); \
    evt->appHandlesCount      = p_appHandlesCount; \
    evt->appHandles           = p_appHandles; \
    evt->address              = p_address; \
    evt->isconnected          = p_isconnected; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_IBSS_STATION_IND_ID); \
}

#define send_unifi_mgt_ibss_station_ind_external(context, pid, p_appHandlesCount, p_appHandles, p_address, p_isconnected) \
{ \
    UnifiMgtIbssStationInd_Evt *evt = (UnifiMgtIbssStationInd_Evt*) CsrPmalloc(sizeof(UnifiMgtIbssStationInd_Evt)); \
    evt->appHandlesCount      = p_appHandlesCount; \
    evt->appHandles           = p_appHandles; \
    evt->address              = p_address; \
    evt->isconnected          = p_isconnected; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_IBSS_STATION_IND_ID); \
}

/* -------------------------- unifi_mgt_key_req -------------------------- */
typedef struct UnifiMgtKeyReq_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_ListAction                action;
    unifi_Key                       key;
} UnifiMgtKeyReq_Evt;

#define send_unifi_mgt_key_req(context, pid, p_appHandle, p_action, p_key) \
{ \
    UnifiMgtKeyReq_Evt *evt = (UnifiMgtKeyReq_Evt*) CsrPmalloc(sizeof(UnifiMgtKeyReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->action               = p_action; \
    evt->key                  = p_key; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_KEY_REQ_ID); \
}

#define send_unifi_mgt_key_req_external(context, pid, p_appHandle, p_action, p_key) \
{ \
    UnifiMgtKeyReq_Evt *evt = (UnifiMgtKeyReq_Evt*) CsrPmalloc(sizeof(UnifiMgtKeyReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->action               = p_action; \
    evt->key                  = p_key; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_KEY_REQ_ID); \
}

/* -------------------------- unifi_mgt_key_cfm -------------------------- */
typedef struct UnifiMgtKeyCfm_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_Status                    status;
    unifi_ListAction                action;
} UnifiMgtKeyCfm_Evt;

#define send_unifi_mgt_key_cfm(context, pid, p_appHandle, p_status, p_action) \
{ \
    UnifiMgtKeyCfm_Evt *evt = (UnifiMgtKeyCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtKeyCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    evt->action               = p_action; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_KEY_CFM_ID); \
}

#define send_unifi_mgt_key_cfm_external(context, pid, p_appHandle, p_status, p_action) \
{ \
    UnifiMgtKeyCfm_Evt *evt = (UnifiMgtKeyCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtKeyCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    evt->action               = p_action; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_KEY_CFM_ID); \
}

/* -------------------------- unifi_mgt_media_status_ind -------------------------- */
typedef struct UnifiMgtMediaStatusInd_Evt
{
    FsmEvent                        common;
    CsrUint16                       appHandlesCount;
    void*                          *appHandles;
    unifi_MediaStatus               mediaStatus;
    unifi_ConnectionInfo            connectionInfo;
    unifi_IEEE80211Reason           disassocReason;
    unifi_IEEE80211Reason           deauthReason;
} UnifiMgtMediaStatusInd_Evt;

#define send_unifi_mgt_media_status_ind(context, pid, p_appHandlesCount, p_appHandles, p_mediaStatus, p_connectionInfo, p_disassocReason, p_deauthReason) \
{ \
    UnifiMgtMediaStatusInd_Evt *evt = (UnifiMgtMediaStatusInd_Evt*) CsrPmalloc(sizeof(UnifiMgtMediaStatusInd_Evt)); \
    evt->appHandlesCount      = p_appHandlesCount; \
    evt->appHandles           = p_appHandles; \
    evt->mediaStatus          = p_mediaStatus; \
    evt->connectionInfo       = p_connectionInfo; \
    evt->disassocReason       = p_disassocReason; \
    evt->deauthReason         = p_deauthReason; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_MEDIA_STATUS_IND_ID); \
}

#define send_unifi_mgt_media_status_ind_external(context, pid, p_appHandlesCount, p_appHandles, p_mediaStatus, p_connectionInfo, p_disassocReason, p_deauthReason) \
{ \
    UnifiMgtMediaStatusInd_Evt *evt = (UnifiMgtMediaStatusInd_Evt*) CsrPmalloc(sizeof(UnifiMgtMediaStatusInd_Evt)); \
    evt->appHandlesCount      = p_appHandlesCount; \
    evt->appHandles           = p_appHandles; \
    evt->mediaStatus          = p_mediaStatus; \
    evt->connectionInfo       = p_connectionInfo; \
    evt->disassocReason       = p_disassocReason; \
    evt->deauthReason         = p_deauthReason; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_MEDIA_STATUS_IND_ID); \
}

/* -------------------------- unifi_mgt_mib_get_req -------------------------- */
typedef struct UnifiMgtMibGetReq_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    CsrUint16                       mibAttributeLength;
    CsrUint8                       *mibAttribute;
} UnifiMgtMibGetReq_Evt;

#define send_unifi_mgt_mib_get_req(context, pid, p_appHandle, p_mibAttributeLength, p_mibAttribute) \
{ \
    UnifiMgtMibGetReq_Evt *evt = (UnifiMgtMibGetReq_Evt*) CsrPmalloc(sizeof(UnifiMgtMibGetReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->mibAttributeLength   = p_mibAttributeLength; \
    evt->mibAttribute         = p_mibAttribute; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_MIB_GET_REQ_ID); \
}

#define send_unifi_mgt_mib_get_req_external(context, pid, p_appHandle, p_mibAttributeLength, p_mibAttribute) \
{ \
    UnifiMgtMibGetReq_Evt *evt = (UnifiMgtMibGetReq_Evt*) CsrPmalloc(sizeof(UnifiMgtMibGetReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->mibAttributeLength   = p_mibAttributeLength; \
    evt->mibAttribute         = p_mibAttribute; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_MIB_GET_REQ_ID); \
}

/* -------------------------- unifi_mgt_mib_get_cfm -------------------------- */
typedef struct UnifiMgtMibGetCfm_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_Status                    status;
    CsrUint16                       mibAttributeLength;
    CsrUint8                       *mibAttribute;
} UnifiMgtMibGetCfm_Evt;

#define send_unifi_mgt_mib_get_cfm(context, pid, p_appHandle, p_status, p_mibAttributeLength, p_mibAttribute) \
{ \
    UnifiMgtMibGetCfm_Evt *evt = (UnifiMgtMibGetCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtMibGetCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    evt->mibAttributeLength   = p_mibAttributeLength; \
    evt->mibAttribute         = p_mibAttribute; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_MIB_GET_CFM_ID); \
}

#define send_unifi_mgt_mib_get_cfm_external(context, pid, p_appHandle, p_status, p_mibAttributeLength, p_mibAttribute) \
{ \
    UnifiMgtMibGetCfm_Evt *evt = (UnifiMgtMibGetCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtMibGetCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    evt->mibAttributeLength   = p_mibAttributeLength; \
    evt->mibAttribute         = p_mibAttribute; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_MIB_GET_CFM_ID); \
}

/* -------------------------- unifi_mgt_mib_get_next_req -------------------------- */
typedef struct UnifiMgtMibGetNextReq_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    CsrUint16                       mibAttributeLength;
    CsrUint8                       *mibAttribute;
} UnifiMgtMibGetNextReq_Evt;

#define send_unifi_mgt_mib_get_next_req(context, pid, p_appHandle, p_mibAttributeLength, p_mibAttribute) \
{ \
    UnifiMgtMibGetNextReq_Evt *evt = (UnifiMgtMibGetNextReq_Evt*) CsrPmalloc(sizeof(UnifiMgtMibGetNextReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->mibAttributeLength   = p_mibAttributeLength; \
    evt->mibAttribute         = p_mibAttribute; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_MIB_GET_NEXT_REQ_ID); \
}

#define send_unifi_mgt_mib_get_next_req_external(context, pid, p_appHandle, p_mibAttributeLength, p_mibAttribute) \
{ \
    UnifiMgtMibGetNextReq_Evt *evt = (UnifiMgtMibGetNextReq_Evt*) CsrPmalloc(sizeof(UnifiMgtMibGetNextReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->mibAttributeLength   = p_mibAttributeLength; \
    evt->mibAttribute         = p_mibAttribute; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_MIB_GET_NEXT_REQ_ID); \
}

/* -------------------------- unifi_mgt_mib_get_next_cfm -------------------------- */
typedef struct UnifiMgtMibGetNextCfm_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_Status                    status;
    CsrUint16                       mibAttributeLength;
    CsrUint8                       *mibAttribute;
} UnifiMgtMibGetNextCfm_Evt;

#define send_unifi_mgt_mib_get_next_cfm(context, pid, p_appHandle, p_status, p_mibAttributeLength, p_mibAttribute) \
{ \
    UnifiMgtMibGetNextCfm_Evt *evt = (UnifiMgtMibGetNextCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtMibGetNextCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    evt->mibAttributeLength   = p_mibAttributeLength; \
    evt->mibAttribute         = p_mibAttribute; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_MIB_GET_NEXT_CFM_ID); \
}

#define send_unifi_mgt_mib_get_next_cfm_external(context, pid, p_appHandle, p_status, p_mibAttributeLength, p_mibAttribute) \
{ \
    UnifiMgtMibGetNextCfm_Evt *evt = (UnifiMgtMibGetNextCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtMibGetNextCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    evt->mibAttributeLength   = p_mibAttributeLength; \
    evt->mibAttribute         = p_mibAttribute; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_MIB_GET_NEXT_CFM_ID); \
}

/* -------------------------- unifi_mgt_mib_set_req -------------------------- */
typedef struct UnifiMgtMibSetReq_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    CsrUint16                       mibAttributeLength;
    CsrUint8                       *mibAttribute;
} UnifiMgtMibSetReq_Evt;

#define send_unifi_mgt_mib_set_req(context, pid, p_appHandle, p_mibAttributeLength, p_mibAttribute) \
{ \
    UnifiMgtMibSetReq_Evt *evt = (UnifiMgtMibSetReq_Evt*) CsrPmalloc(sizeof(UnifiMgtMibSetReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->mibAttributeLength   = p_mibAttributeLength; \
    evt->mibAttribute         = p_mibAttribute; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_MIB_SET_REQ_ID); \
}

#define send_unifi_mgt_mib_set_req_external(context, pid, p_appHandle, p_mibAttributeLength, p_mibAttribute) \
{ \
    UnifiMgtMibSetReq_Evt *evt = (UnifiMgtMibSetReq_Evt*) CsrPmalloc(sizeof(UnifiMgtMibSetReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->mibAttributeLength   = p_mibAttributeLength; \
    evt->mibAttribute         = p_mibAttribute; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_MIB_SET_REQ_ID); \
}

/* -------------------------- unifi_mgt_mib_set_cfm -------------------------- */
typedef struct UnifiMgtMibSetCfm_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_Status                    status;
} UnifiMgtMibSetCfm_Evt;

#define send_unifi_mgt_mib_set_cfm(context, pid, p_appHandle, p_status) \
{ \
    UnifiMgtMibSetCfm_Evt *evt = (UnifiMgtMibSetCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtMibSetCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_MIB_SET_CFM_ID); \
}

#define send_unifi_mgt_mib_set_cfm_external(context, pid, p_appHandle, p_status) \
{ \
    UnifiMgtMibSetCfm_Evt *evt = (UnifiMgtMibSetCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtMibSetCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_MIB_SET_CFM_ID); \
}

/* -------------------------- unifi_mgt_mic_failure_ind -------------------------- */
typedef struct UnifiMgtMicFailureInd_Evt
{
    FsmEvent                        common;
    CsrUint16                       appHandlesCount;
    void*                          *appHandles;
    CsrBool                         secondFailure;
    CsrUint16                       count;
    unifi_MACAddress                address;
    unifi_KeyType                   keyType;
    CsrUint16                       keyId;
    CsrUint16                       tsc[4];
} UnifiMgtMicFailureInd_Evt;

#define send_unifi_mgt_mic_failure_ind(context, pid, p_appHandlesCount, p_appHandles, p_secondFailure, p_count, p_address, p_keyType, p_keyId, p_tsc) \
{ \
    UnifiMgtMicFailureInd_Evt *evt = (UnifiMgtMicFailureInd_Evt*) CsrPmalloc(sizeof(UnifiMgtMicFailureInd_Evt)); \
    evt->appHandlesCount      = p_appHandlesCount; \
    evt->appHandles           = p_appHandles; \
    evt->secondFailure        = p_secondFailure; \
    evt->count                = p_count; \
    evt->address              = p_address; \
    evt->keyType              = p_keyType; \
    evt->keyId                = p_keyId; \
    CsrMemCpy(evt->tsc, p_tsc, 4); \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_MIC_FAILURE_IND_ID); \
}

#define send_unifi_mgt_mic_failure_ind_external(context, pid, p_appHandlesCount, p_appHandles, p_secondFailure, p_count, p_address, p_keyType, p_keyId, p_tsc) \
{ \
    UnifiMgtMicFailureInd_Evt *evt = (UnifiMgtMicFailureInd_Evt*) CsrPmalloc(sizeof(UnifiMgtMicFailureInd_Evt)); \
    evt->appHandlesCount      = p_appHandlesCount; \
    evt->appHandles           = p_appHandles; \
    evt->secondFailure        = p_secondFailure; \
    evt->count                = p_count; \
    evt->address              = p_address; \
    evt->keyType              = p_keyType; \
    evt->keyId                = p_keyId; \
    CsrMemCpy(evt->tsc, p_tsc, 4); \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_MIC_FAILURE_IND_ID); \
}

/* -------------------------- unifi_mgt_multicast_address_req -------------------------- */
typedef struct UnifiMgtMulticastAddressReq_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_ListAction                action;
    CsrUint8                        setAddressesCount;
    unifi_MACAddress               *setAddresses;
} UnifiMgtMulticastAddressReq_Evt;

#define send_unifi_mgt_multicast_address_req(context, pid, p_appHandle, p_action, p_setAddressesCount, p_setAddresses) \
{ \
    UnifiMgtMulticastAddressReq_Evt *evt = (UnifiMgtMulticastAddressReq_Evt*) CsrPmalloc(sizeof(UnifiMgtMulticastAddressReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->action               = p_action; \
    evt->setAddressesCount    = p_setAddressesCount; \
    evt->setAddresses         = p_setAddresses; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_MULTICAST_ADDRESS_REQ_ID); \
}

#define send_unifi_mgt_multicast_address_req_external(context, pid, p_appHandle, p_action, p_setAddressesCount, p_setAddresses) \
{ \
    UnifiMgtMulticastAddressReq_Evt *evt = (UnifiMgtMulticastAddressReq_Evt*) CsrPmalloc(sizeof(UnifiMgtMulticastAddressReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->action               = p_action; \
    evt->setAddressesCount    = p_setAddressesCount; \
    evt->setAddresses         = p_setAddresses; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_MULTICAST_ADDRESS_REQ_ID); \
}

/* -------------------------- unifi_mgt_multicast_address_cfm -------------------------- */
typedef struct UnifiMgtMulticastAddressCfm_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_Status                    status;
    unifi_ListAction                action;
    CsrUint8                        getAddressesCount;
    unifi_MACAddress               *getAddresses;
} UnifiMgtMulticastAddressCfm_Evt;

#define send_unifi_mgt_multicast_address_cfm(context, pid, p_appHandle, p_status, p_action, p_getAddressesCount, p_getAddresses) \
{ \
    UnifiMgtMulticastAddressCfm_Evt *evt = (UnifiMgtMulticastAddressCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtMulticastAddressCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    evt->action               = p_action; \
    evt->getAddressesCount    = p_getAddressesCount; \
    evt->getAddresses         = p_getAddresses; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_MULTICAST_ADDRESS_CFM_ID); \
}

#define send_unifi_mgt_multicast_address_cfm_external(context, pid, p_appHandle, p_status, p_action, p_getAddressesCount, p_getAddresses) \
{ \
    UnifiMgtMulticastAddressCfm_Evt *evt = (UnifiMgtMulticastAddressCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtMulticastAddressCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    evt->action               = p_action; \
    evt->getAddressesCount    = p_getAddressesCount; \
    evt->getAddresses         = p_getAddresses; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_MULTICAST_ADDRESS_CFM_ID); \
}

/* -------------------------- unifi_mgt_packet_filter_set_req -------------------------- */
typedef struct UnifiMgtPacketFilterSetReq_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    CsrUint16                       filterLength;
    CsrUint8                       *filter;
    unifi_PacketFilterMode          mode;
    unifi_IPV4Address               arpFilterAddress;
} UnifiMgtPacketFilterSetReq_Evt;

#define send_unifi_mgt_packet_filter_set_req(context, pid, p_appHandle, p_filterLength, p_filter, p_mode, p_arpFilterAddress) \
{ \
    UnifiMgtPacketFilterSetReq_Evt *evt = (UnifiMgtPacketFilterSetReq_Evt*) CsrPmalloc(sizeof(UnifiMgtPacketFilterSetReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->filterLength         = p_filterLength; \
    evt->filter               = p_filter; \
    evt->mode                 = p_mode; \
    evt->arpFilterAddress     = p_arpFilterAddress; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_PACKET_FILTER_SET_REQ_ID); \
}

#define send_unifi_mgt_packet_filter_set_req_external(context, pid, p_appHandle, p_filterLength, p_filter, p_mode, p_arpFilterAddress) \
{ \
    UnifiMgtPacketFilterSetReq_Evt *evt = (UnifiMgtPacketFilterSetReq_Evt*) CsrPmalloc(sizeof(UnifiMgtPacketFilterSetReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->filterLength         = p_filterLength; \
    evt->filter               = p_filter; \
    evt->mode                 = p_mode; \
    evt->arpFilterAddress     = p_arpFilterAddress; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_PACKET_FILTER_SET_REQ_ID); \
}

/* -------------------------- unifi_mgt_packet_filter_set_cfm -------------------------- */
typedef struct UnifiMgtPacketFilterSetCfm_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_Status                    status;
} UnifiMgtPacketFilterSetCfm_Evt;

#define send_unifi_mgt_packet_filter_set_cfm(context, pid, p_appHandle, p_status) \
{ \
    UnifiMgtPacketFilterSetCfm_Evt *evt = (UnifiMgtPacketFilterSetCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtPacketFilterSetCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_PACKET_FILTER_SET_CFM_ID); \
}

#define send_unifi_mgt_packet_filter_set_cfm_external(context, pid, p_appHandle, p_status) \
{ \
    UnifiMgtPacketFilterSetCfm_Evt *evt = (UnifiMgtPacketFilterSetCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtPacketFilterSetCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_PACKET_FILTER_SET_CFM_ID); \
}

/* -------------------------- unifi_mgt_pmkid_req -------------------------- */
typedef struct UnifiMgtPmkidReq_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_ListAction                action;
    CsrUint8                        setPmkidsCount;
    unifi_Pmkid                    *setPmkids;
} UnifiMgtPmkidReq_Evt;

#define send_unifi_mgt_pmkid_req(context, pid, p_appHandle, p_action, p_setPmkidsCount, p_setPmkids) \
{ \
    UnifiMgtPmkidReq_Evt *evt = (UnifiMgtPmkidReq_Evt*) CsrPmalloc(sizeof(UnifiMgtPmkidReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->action               = p_action; \
    evt->setPmkidsCount       = p_setPmkidsCount; \
    evt->setPmkids            = p_setPmkids; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_PMKID_REQ_ID); \
}

#define send_unifi_mgt_pmkid_req_external(context, pid, p_appHandle, p_action, p_setPmkidsCount, p_setPmkids) \
{ \
    UnifiMgtPmkidReq_Evt *evt = (UnifiMgtPmkidReq_Evt*) CsrPmalloc(sizeof(UnifiMgtPmkidReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->action               = p_action; \
    evt->setPmkidsCount       = p_setPmkidsCount; \
    evt->setPmkids            = p_setPmkids; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_PMKID_REQ_ID); \
}

/* -------------------------- unifi_mgt_pmkid_cfm -------------------------- */
typedef struct UnifiMgtPmkidCfm_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_Status                    status;
    unifi_ListAction                action;
    CsrUint8                        getPmkidsCount;
    unifi_Pmkid                    *getPmkids;
} UnifiMgtPmkidCfm_Evt;

#define send_unifi_mgt_pmkid_cfm(context, pid, p_appHandle, p_status, p_action, p_getPmkidsCount, p_getPmkids) \
{ \
    UnifiMgtPmkidCfm_Evt *evt = (UnifiMgtPmkidCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtPmkidCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    evt->action               = p_action; \
    evt->getPmkidsCount       = p_getPmkidsCount; \
    evt->getPmkids            = p_getPmkids; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_PMKID_CFM_ID); \
}

#define send_unifi_mgt_pmkid_cfm_external(context, pid, p_appHandle, p_status, p_action, p_getPmkidsCount, p_getPmkids) \
{ \
    UnifiMgtPmkidCfm_Evt *evt = (UnifiMgtPmkidCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtPmkidCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    evt->action               = p_action; \
    evt->getPmkidsCount       = p_getPmkidsCount; \
    evt->getPmkids            = p_getPmkids; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_PMKID_CFM_ID); \
}

/* -------------------------- unifi_mgt_pmkid_candidate_list_ind -------------------------- */
typedef struct UnifiMgtPmkidCandidateListInd_Evt
{
    FsmEvent                        common;
    CsrUint16                       appHandlesCount;
    void*                          *appHandles;
    CsrUint8                        pmkidCandidatesCount;
    unifi_PmkidCandidate           *pmkidCandidates;
} UnifiMgtPmkidCandidateListInd_Evt;

#define send_unifi_mgt_pmkid_candidate_list_ind(context, pid, p_appHandlesCount, p_appHandles, p_pmkidCandidatesCount, p_pmkidCandidates) \
{ \
    UnifiMgtPmkidCandidateListInd_Evt *evt = (UnifiMgtPmkidCandidateListInd_Evt*) CsrPmalloc(sizeof(UnifiMgtPmkidCandidateListInd_Evt)); \
    evt->appHandlesCount      = p_appHandlesCount; \
    evt->appHandles           = p_appHandles; \
    evt->pmkidCandidatesCount = p_pmkidCandidatesCount; \
    evt->pmkidCandidates      = p_pmkidCandidates; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_PMKID_CANDIDATE_LIST_IND_ID); \
}

#define send_unifi_mgt_pmkid_candidate_list_ind_external(context, pid, p_appHandlesCount, p_appHandles, p_pmkidCandidatesCount, p_pmkidCandidates) \
{ \
    UnifiMgtPmkidCandidateListInd_Evt *evt = (UnifiMgtPmkidCandidateListInd_Evt*) CsrPmalloc(sizeof(UnifiMgtPmkidCandidateListInd_Evt)); \
    evt->appHandlesCount      = p_appHandlesCount; \
    evt->appHandles           = p_appHandles; \
    evt->pmkidCandidatesCount = p_pmkidCandidatesCount; \
    evt->pmkidCandidates      = p_pmkidCandidates; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_PMKID_CANDIDATE_LIST_IND_ID); \
}

/* -------------------------- unifi_mgt_restricted_access_disable_req -------------------------- */
typedef struct UnifiMgtRestrictedAccessDisableReq_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
} UnifiMgtRestrictedAccessDisableReq_Evt;

#define send_unifi_mgt_restricted_access_disable_req(context, pid, p_appHandle) \
{ \
    UnifiMgtRestrictedAccessDisableReq_Evt *evt = (UnifiMgtRestrictedAccessDisableReq_Evt*) CsrPmalloc(sizeof(UnifiMgtRestrictedAccessDisableReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_RESTRICTED_ACCESS_DISABLE_REQ_ID); \
}

#define send_unifi_mgt_restricted_access_disable_req_external(context, pid, p_appHandle) \
{ \
    UnifiMgtRestrictedAccessDisableReq_Evt *evt = (UnifiMgtRestrictedAccessDisableReq_Evt*) CsrPmalloc(sizeof(UnifiMgtRestrictedAccessDisableReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_RESTRICTED_ACCESS_DISABLE_REQ_ID); \
}

/* -------------------------- unifi_mgt_restricted_access_disable_cfm -------------------------- */
typedef struct UnifiMgtRestrictedAccessDisableCfm_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_Status                    status;
} UnifiMgtRestrictedAccessDisableCfm_Evt;

#define send_unifi_mgt_restricted_access_disable_cfm(context, pid, p_appHandle, p_status) \
{ \
    UnifiMgtRestrictedAccessDisableCfm_Evt *evt = (UnifiMgtRestrictedAccessDisableCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtRestrictedAccessDisableCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_RESTRICTED_ACCESS_DISABLE_CFM_ID); \
}

#define send_unifi_mgt_restricted_access_disable_cfm_external(context, pid, p_appHandle, p_status) \
{ \
    UnifiMgtRestrictedAccessDisableCfm_Evt *evt = (UnifiMgtRestrictedAccessDisableCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtRestrictedAccessDisableCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_RESTRICTED_ACCESS_DISABLE_CFM_ID); \
}

/* -------------------------- unifi_mgt_restricted_access_enable_req -------------------------- */
typedef struct UnifiMgtRestrictedAccessEnableReq_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
} UnifiMgtRestrictedAccessEnableReq_Evt;

#define send_unifi_mgt_restricted_access_enable_req(context, pid, p_appHandle) \
{ \
    UnifiMgtRestrictedAccessEnableReq_Evt *evt = (UnifiMgtRestrictedAccessEnableReq_Evt*) CsrPmalloc(sizeof(UnifiMgtRestrictedAccessEnableReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_RESTRICTED_ACCESS_ENABLE_REQ_ID); \
}

#define send_unifi_mgt_restricted_access_enable_req_external(context, pid, p_appHandle) \
{ \
    UnifiMgtRestrictedAccessEnableReq_Evt *evt = (UnifiMgtRestrictedAccessEnableReq_Evt*) CsrPmalloc(sizeof(UnifiMgtRestrictedAccessEnableReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_RESTRICTED_ACCESS_ENABLE_REQ_ID); \
}

/* -------------------------- unifi_mgt_restricted_access_enable_cfm -------------------------- */
typedef struct UnifiMgtRestrictedAccessEnableCfm_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_Status                    status;
} UnifiMgtRestrictedAccessEnableCfm_Evt;

#define send_unifi_mgt_restricted_access_enable_cfm(context, pid, p_appHandle, p_status) \
{ \
    UnifiMgtRestrictedAccessEnableCfm_Evt *evt = (UnifiMgtRestrictedAccessEnableCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtRestrictedAccessEnableCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_RESTRICTED_ACCESS_ENABLE_CFM_ID); \
}

#define send_unifi_mgt_restricted_access_enable_cfm_external(context, pid, p_appHandle, p_status) \
{ \
    UnifiMgtRestrictedAccessEnableCfm_Evt *evt = (UnifiMgtRestrictedAccessEnableCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtRestrictedAccessEnableCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_RESTRICTED_ACCESS_ENABLE_CFM_ID); \
}

/* -------------------------- unifi_mgt_roam_complete_ind -------------------------- */
typedef struct UnifiMgtRoamCompleteInd_Evt
{
    FsmEvent                        common;
    CsrUint16                       appHandlesCount;
    void*                          *appHandles;
    unifi_Status                    status;
} UnifiMgtRoamCompleteInd_Evt;

#define send_unifi_mgt_roam_complete_ind(context, pid, p_appHandlesCount, p_appHandles, p_status) \
{ \
    UnifiMgtRoamCompleteInd_Evt *evt = (UnifiMgtRoamCompleteInd_Evt*) CsrPmalloc(sizeof(UnifiMgtRoamCompleteInd_Evt)); \
    evt->appHandlesCount      = p_appHandlesCount; \
    evt->appHandles           = p_appHandles; \
    evt->status               = p_status; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_ROAM_COMPLETE_IND_ID); \
}

#define send_unifi_mgt_roam_complete_ind_external(context, pid, p_appHandlesCount, p_appHandles, p_status) \
{ \
    UnifiMgtRoamCompleteInd_Evt *evt = (UnifiMgtRoamCompleteInd_Evt*) CsrPmalloc(sizeof(UnifiMgtRoamCompleteInd_Evt)); \
    evt->appHandlesCount      = p_appHandlesCount; \
    evt->appHandles           = p_appHandles; \
    evt->status               = p_status; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_ROAM_COMPLETE_IND_ID); \
}

/* -------------------------- unifi_mgt_roam_start_ind -------------------------- */
typedef struct UnifiMgtRoamStartInd_Evt
{
    FsmEvent                        common;
    CsrUint16                       appHandlesCount;
    void*                          *appHandles;
    unifi_RoamReason                roamReason;
    unifi_IEEE80211Reason           reason80211;
} UnifiMgtRoamStartInd_Evt;

#define send_unifi_mgt_roam_start_ind(context, pid, p_appHandlesCount, p_appHandles, p_roamReason, p_reason80211) \
{ \
    UnifiMgtRoamStartInd_Evt *evt = (UnifiMgtRoamStartInd_Evt*) CsrPmalloc(sizeof(UnifiMgtRoamStartInd_Evt)); \
    evt->appHandlesCount      = p_appHandlesCount; \
    evt->appHandles           = p_appHandles; \
    evt->roamReason           = p_roamReason; \
    evt->reason80211          = p_reason80211; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_ROAM_START_IND_ID); \
}

#define send_unifi_mgt_roam_start_ind_external(context, pid, p_appHandlesCount, p_appHandles, p_roamReason, p_reason80211) \
{ \
    UnifiMgtRoamStartInd_Evt *evt = (UnifiMgtRoamStartInd_Evt*) CsrPmalloc(sizeof(UnifiMgtRoamStartInd_Evt)); \
    evt->appHandlesCount      = p_appHandlesCount; \
    evt->appHandles           = p_appHandles; \
    evt->roamReason           = p_roamReason; \
    evt->reason80211          = p_reason80211; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_ROAM_START_IND_ID); \
}

/* -------------------------- unifi_mgt_scan_full_req -------------------------- */
typedef struct UnifiMgtScanFullReq_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    CsrUint8                        ssidCount;
    unifi_SSID                     *ssid;
    unifi_MACAddress                bssid;
    CsrBool                         forceScan;
    unifi_BSSType                   bssType;
    unifi_ScanType                  scanType;
    CsrUint16                       channelListCount;
    CsrUint8                       *channelList;
    CsrUint16                       probeIeLength;
    CsrUint8                       *probeIe;
} UnifiMgtScanFullReq_Evt;

#define send_unifi_mgt_scan_full_req(context, pid, p_appHandle, p_ssidCount, p_ssid, p_bssid, p_forceScan, p_bssType, p_scanType, p_channelListCount, p_channelList, p_probeIeLength, p_probeIe) \
{ \
    UnifiMgtScanFullReq_Evt *evt = (UnifiMgtScanFullReq_Evt*) CsrPmalloc(sizeof(UnifiMgtScanFullReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->ssidCount            = p_ssidCount; \
    evt->ssid                 = p_ssid; \
    evt->bssid                = p_bssid; \
    evt->forceScan            = p_forceScan; \
    evt->bssType              = p_bssType; \
    evt->scanType             = p_scanType; \
    evt->channelListCount     = p_channelListCount; \
    evt->channelList          = p_channelList; \
    evt->probeIeLength        = p_probeIeLength; \
    evt->probeIe              = p_probeIe; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_SCAN_FULL_REQ_ID); \
}

#define send_unifi_mgt_scan_full_req_external(context, pid, p_appHandle, p_ssidCount, p_ssid, p_bssid, p_forceScan, p_bssType, p_scanType, p_channelListCount, p_channelList, p_probeIeLength, p_probeIe) \
{ \
    UnifiMgtScanFullReq_Evt *evt = (UnifiMgtScanFullReq_Evt*) CsrPmalloc(sizeof(UnifiMgtScanFullReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->ssidCount            = p_ssidCount; \
    evt->ssid                 = p_ssid; \
    evt->bssid                = p_bssid; \
    evt->forceScan            = p_forceScan; \
    evt->bssType              = p_bssType; \
    evt->scanType             = p_scanType; \
    evt->channelListCount     = p_channelListCount; \
    evt->channelList          = p_channelList; \
    evt->probeIeLength        = p_probeIeLength; \
    evt->probeIe              = p_probeIe; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_SCAN_FULL_REQ_ID); \
}

/* -------------------------- unifi_mgt_scan_full_cfm -------------------------- */
typedef struct UnifiMgtScanFullCfm_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_Status                    status;
} UnifiMgtScanFullCfm_Evt;

#define send_unifi_mgt_scan_full_cfm(context, pid, p_appHandle, p_status) \
{ \
    UnifiMgtScanFullCfm_Evt *evt = (UnifiMgtScanFullCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtScanFullCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_SCAN_FULL_CFM_ID); \
}

#define send_unifi_mgt_scan_full_cfm_external(context, pid, p_appHandle, p_status) \
{ \
    UnifiMgtScanFullCfm_Evt *evt = (UnifiMgtScanFullCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtScanFullCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_SCAN_FULL_CFM_ID); \
}

/* -------------------------- unifi_mgt_scan_result_ind -------------------------- */
typedef struct UnifiMgtScanResultInd_Evt
{
    FsmEvent                        common;
    CsrUint16                       appHandlesCount;
    void*                          *appHandles;
    unifi_ScanResult                result;
} UnifiMgtScanResultInd_Evt;

#define send_unifi_mgt_scan_result_ind(context, pid, p_appHandlesCount, p_appHandles, p_result) \
{ \
    UnifiMgtScanResultInd_Evt *evt = (UnifiMgtScanResultInd_Evt*) CsrPmalloc(sizeof(UnifiMgtScanResultInd_Evt)); \
    evt->appHandlesCount      = p_appHandlesCount; \
    evt->appHandles           = p_appHandles; \
    evt->result               = p_result; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_SCAN_RESULT_IND_ID); \
}

#define send_unifi_mgt_scan_result_ind_external(context, pid, p_appHandlesCount, p_appHandles, p_result) \
{ \
    UnifiMgtScanResultInd_Evt *evt = (UnifiMgtScanResultInd_Evt*) CsrPmalloc(sizeof(UnifiMgtScanResultInd_Evt)); \
    evt->appHandlesCount      = p_appHandlesCount; \
    evt->appHandles           = p_appHandles; \
    evt->result               = p_result; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_SCAN_RESULT_IND_ID); \
}

/* -------------------------- unifi_mgt_scan_results_flush_req -------------------------- */
typedef struct UnifiMgtScanResultsFlushReq_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
} UnifiMgtScanResultsFlushReq_Evt;

#define send_unifi_mgt_scan_results_flush_req(context, pid, p_appHandle) \
{ \
    UnifiMgtScanResultsFlushReq_Evt *evt = (UnifiMgtScanResultsFlushReq_Evt*) CsrPmalloc(sizeof(UnifiMgtScanResultsFlushReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_SCAN_RESULTS_FLUSH_REQ_ID); \
}

#define send_unifi_mgt_scan_results_flush_req_external(context, pid, p_appHandle) \
{ \
    UnifiMgtScanResultsFlushReq_Evt *evt = (UnifiMgtScanResultsFlushReq_Evt*) CsrPmalloc(sizeof(UnifiMgtScanResultsFlushReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_SCAN_RESULTS_FLUSH_REQ_ID); \
}

/* -------------------------- unifi_mgt_scan_results_flush_cfm -------------------------- */
typedef struct UnifiMgtScanResultsFlushCfm_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_Status                    status;
} UnifiMgtScanResultsFlushCfm_Evt;

#define send_unifi_mgt_scan_results_flush_cfm(context, pid, p_appHandle, p_status) \
{ \
    UnifiMgtScanResultsFlushCfm_Evt *evt = (UnifiMgtScanResultsFlushCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtScanResultsFlushCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_SCAN_RESULTS_FLUSH_CFM_ID); \
}

#define send_unifi_mgt_scan_results_flush_cfm_external(context, pid, p_appHandle, p_status) \
{ \
    UnifiMgtScanResultsFlushCfm_Evt *evt = (UnifiMgtScanResultsFlushCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtScanResultsFlushCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_SCAN_RESULTS_FLUSH_CFM_ID); \
}

/* -------------------------- unifi_mgt_scan_results_get_req -------------------------- */
typedef struct UnifiMgtScanResultsGetReq_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
} UnifiMgtScanResultsGetReq_Evt;

#define send_unifi_mgt_scan_results_get_req(context, pid, p_appHandle) \
{ \
    UnifiMgtScanResultsGetReq_Evt *evt = (UnifiMgtScanResultsGetReq_Evt*) CsrPmalloc(sizeof(UnifiMgtScanResultsGetReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_SCAN_RESULTS_GET_REQ_ID); \
}

#define send_unifi_mgt_scan_results_get_req_external(context, pid, p_appHandle) \
{ \
    UnifiMgtScanResultsGetReq_Evt *evt = (UnifiMgtScanResultsGetReq_Evt*) CsrPmalloc(sizeof(UnifiMgtScanResultsGetReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_SCAN_RESULTS_GET_REQ_ID); \
}

/* -------------------------- unifi_mgt_scan_results_get_cfm -------------------------- */
typedef struct UnifiMgtScanResultsGetCfm_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_Status                    status;
    CsrUint16                       scanResultsCount;
    unifi_ScanResult               *scanResults;
} UnifiMgtScanResultsGetCfm_Evt;

#define send_unifi_mgt_scan_results_get_cfm(context, pid, p_appHandle, p_status, p_scanResultsCount, p_scanResults) \
{ \
    UnifiMgtScanResultsGetCfm_Evt *evt = (UnifiMgtScanResultsGetCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtScanResultsGetCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    evt->scanResultsCount     = p_scanResultsCount; \
    evt->scanResults          = p_scanResults; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_SCAN_RESULTS_GET_CFM_ID); \
}

#define send_unifi_mgt_scan_results_get_cfm_external(context, pid, p_appHandle, p_status, p_scanResultsCount, p_scanResults) \
{ \
    UnifiMgtScanResultsGetCfm_Evt *evt = (UnifiMgtScanResultsGetCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtScanResultsGetCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    evt->scanResultsCount     = p_scanResultsCount; \
    evt->scanResults          = p_scanResults; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_SCAN_RESULTS_GET_CFM_ID); \
}

/* -------------------------- unifi_mgt_set_value_req -------------------------- */
typedef struct UnifiMgtSetValueReq_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_AppValue                  appValue;
} UnifiMgtSetValueReq_Evt;

#define send_unifi_mgt_set_value_req(context, pid, p_appHandle, p_appValue) \
{ \
    UnifiMgtSetValueReq_Evt *evt = (UnifiMgtSetValueReq_Evt*) CsrPmalloc(sizeof(UnifiMgtSetValueReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->appValue             = p_appValue; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_SET_VALUE_REQ_ID); \
}

#define send_unifi_mgt_set_value_req_external(context, pid, p_appHandle, p_appValue) \
{ \
    UnifiMgtSetValueReq_Evt *evt = (UnifiMgtSetValueReq_Evt*) CsrPmalloc(sizeof(UnifiMgtSetValueReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->appValue             = p_appValue; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_SET_VALUE_REQ_ID); \
}

/* -------------------------- unifi_mgt_set_value_cfm -------------------------- */
typedef struct UnifiMgtSetValueCfm_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_Status                    status;
    unifi_AppValueId                appValueId;
} UnifiMgtSetValueCfm_Evt;

#define send_unifi_mgt_set_value_cfm(context, pid, p_appHandle, p_status, p_appValueId) \
{ \
    UnifiMgtSetValueCfm_Evt *evt = (UnifiMgtSetValueCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtSetValueCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    evt->appValueId           = p_appValueId; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_SET_VALUE_CFM_ID); \
}

#define send_unifi_mgt_set_value_cfm_external(context, pid, p_appHandle, p_status, p_appValueId) \
{ \
    UnifiMgtSetValueCfm_Evt *evt = (UnifiMgtSetValueCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtSetValueCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    evt->appValueId           = p_appValueId; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_SET_VALUE_CFM_ID); \
}

/* -------------------------- unifi_mgt_tspec_req -------------------------- */
typedef struct UnifiMgtTspecReq_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_ListAction                action;
    CsrUint32                       transactionId;
    CsrBool                         strict;
    CsrUint8                        ctrlMask;
    CsrUint16                       tspecLength;
    CsrUint8                       *tspec;
    CsrUint16                       tclasLength;
    CsrUint8                       *tclas;
} UnifiMgtTspecReq_Evt;

#define send_unifi_mgt_tspec_req(context, pid, p_appHandle, p_action, p_transactionId, p_strict, p_ctrlMask, p_tspecLength, p_tspec, p_tclasLength, p_tclas) \
{ \
    UnifiMgtTspecReq_Evt *evt = (UnifiMgtTspecReq_Evt*) CsrPmalloc(sizeof(UnifiMgtTspecReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->action               = p_action; \
    evt->transactionId        = p_transactionId; \
    evt->strict               = p_strict; \
    evt->ctrlMask             = p_ctrlMask; \
    evt->tspecLength          = p_tspecLength; \
    evt->tspec                = p_tspec; \
    evt->tclasLength          = p_tclasLength; \
    evt->tclas                = p_tclas; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_TSPEC_REQ_ID); \
}

#define send_unifi_mgt_tspec_req_external(context, pid, p_appHandle, p_action, p_transactionId, p_strict, p_ctrlMask, p_tspecLength, p_tspec, p_tclasLength, p_tclas) \
{ \
    UnifiMgtTspecReq_Evt *evt = (UnifiMgtTspecReq_Evt*) CsrPmalloc(sizeof(UnifiMgtTspecReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->action               = p_action; \
    evt->transactionId        = p_transactionId; \
    evt->strict               = p_strict; \
    evt->ctrlMask             = p_ctrlMask; \
    evt->tspecLength          = p_tspecLength; \
    evt->tspec                = p_tspec; \
    evt->tclasLength          = p_tclasLength; \
    evt->tclas                = p_tclas; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_TSPEC_REQ_ID); \
}

/* -------------------------- unifi_mgt_tspec_ind -------------------------- */
typedef struct UnifiMgtTspecInd_Evt
{
    FsmEvent                        common;
    CsrUint16                       appHandlesCount;
    void*                          *appHandles;
    CsrUint32                       transactionId;
    unifi_TspecResultCode           tspecResultCode;
    CsrUint16                       tspecLength;
    CsrUint8                       *tspec;
} UnifiMgtTspecInd_Evt;

#define send_unifi_mgt_tspec_ind(context, pid, p_appHandlesCount, p_appHandles, p_transactionId, p_tspecResultCode, p_tspecLength, p_tspec) \
{ \
    UnifiMgtTspecInd_Evt *evt = (UnifiMgtTspecInd_Evt*) CsrPmalloc(sizeof(UnifiMgtTspecInd_Evt)); \
    evt->appHandlesCount      = p_appHandlesCount; \
    evt->appHandles           = p_appHandles; \
    evt->transactionId        = p_transactionId; \
    evt->tspecResultCode      = p_tspecResultCode; \
    evt->tspecLength          = p_tspecLength; \
    evt->tspec                = p_tspec; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_TSPEC_IND_ID); \
}

#define send_unifi_mgt_tspec_ind_external(context, pid, p_appHandlesCount, p_appHandles, p_transactionId, p_tspecResultCode, p_tspecLength, p_tspec) \
{ \
    UnifiMgtTspecInd_Evt *evt = (UnifiMgtTspecInd_Evt*) CsrPmalloc(sizeof(UnifiMgtTspecInd_Evt)); \
    evt->appHandlesCount      = p_appHandlesCount; \
    evt->appHandles           = p_appHandles; \
    evt->transactionId        = p_transactionId; \
    evt->tspecResultCode      = p_tspecResultCode; \
    evt->tspecLength          = p_tspecLength; \
    evt->tspec                = p_tspec; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_TSPEC_IND_ID); \
}

/* -------------------------- unifi_mgt_tspec_cfm -------------------------- */
typedef struct UnifiMgtTspecCfm_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_Status                    status;
    CsrUint32                       transactionId;
    unifi_TspecResultCode           tspecResultCode;
    CsrUint16                       tspecLength;
    CsrUint8                       *tspec;
} UnifiMgtTspecCfm_Evt;

#define send_unifi_mgt_tspec_cfm(context, pid, p_appHandle, p_status, p_transactionId, p_tspecResultCode, p_tspecLength, p_tspec) \
{ \
    UnifiMgtTspecCfm_Evt *evt = (UnifiMgtTspecCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtTspecCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    evt->transactionId        = p_transactionId; \
    evt->tspecResultCode      = p_tspecResultCode; \
    evt->tspecLength          = p_tspecLength; \
    evt->tspec                = p_tspec; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_TSPEC_CFM_ID); \
}

#define send_unifi_mgt_tspec_cfm_external(context, pid, p_appHandle, p_status, p_transactionId, p_tspecResultCode, p_tspecLength, p_tspec) \
{ \
    UnifiMgtTspecCfm_Evt *evt = (UnifiMgtTspecCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtTspecCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    evt->transactionId        = p_transactionId; \
    evt->tspecResultCode      = p_tspecResultCode; \
    evt->tspecLength          = p_tspecLength; \
    evt->tspec                = p_tspec; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_TSPEC_CFM_ID); \
}

/* -------------------------- unifi_mgt_wifi_flightmode_req -------------------------- */
typedef struct UnifiMgtWifiFlightmodeReq_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_MACAddress                address;
    CsrUint16                       mibFilesCount;
    unifi_DataBlock                *mibFiles;
} UnifiMgtWifiFlightmodeReq_Evt;

#define send_unifi_mgt_wifi_flightmode_req(context, pid, p_appHandle, p_address, p_mibFilesCount, p_mibFiles) \
{ \
    UnifiMgtWifiFlightmodeReq_Evt *evt = (UnifiMgtWifiFlightmodeReq_Evt*) CsrPmalloc(sizeof(UnifiMgtWifiFlightmodeReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->address              = p_address; \
    evt->mibFilesCount        = p_mibFilesCount; \
    evt->mibFiles             = p_mibFiles; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_WIFI_FLIGHTMODE_REQ_ID); \
}

#define send_unifi_mgt_wifi_flightmode_req_external(context, pid, p_appHandle, p_address, p_mibFilesCount, p_mibFiles) \
{ \
    UnifiMgtWifiFlightmodeReq_Evt *evt = (UnifiMgtWifiFlightmodeReq_Evt*) CsrPmalloc(sizeof(UnifiMgtWifiFlightmodeReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->address              = p_address; \
    evt->mibFilesCount        = p_mibFilesCount; \
    evt->mibFiles             = p_mibFiles; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_WIFI_FLIGHTMODE_REQ_ID); \
}

/* -------------------------- unifi_mgt_wifi_flightmode_cfm -------------------------- */
typedef struct UnifiMgtWifiFlightmodeCfm_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_Status                    status;
} UnifiMgtWifiFlightmodeCfm_Evt;

#define send_unifi_mgt_wifi_flightmode_cfm(context, pid, p_appHandle, p_status) \
{ \
    UnifiMgtWifiFlightmodeCfm_Evt *evt = (UnifiMgtWifiFlightmodeCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtWifiFlightmodeCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_WIFI_FLIGHTMODE_CFM_ID); \
}

#define send_unifi_mgt_wifi_flightmode_cfm_external(context, pid, p_appHandle, p_status) \
{ \
    UnifiMgtWifiFlightmodeCfm_Evt *evt = (UnifiMgtWifiFlightmodeCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtWifiFlightmodeCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_WIFI_FLIGHTMODE_CFM_ID); \
}

/* -------------------------- unifi_mgt_wifi_off_req -------------------------- */
typedef struct UnifiMgtWifiOffReq_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
} UnifiMgtWifiOffReq_Evt;

#define send_unifi_mgt_wifi_off_req(context, pid, p_appHandle) \
{ \
    UnifiMgtWifiOffReq_Evt *evt = (UnifiMgtWifiOffReq_Evt*) CsrPmalloc(sizeof(UnifiMgtWifiOffReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_WIFI_OFF_REQ_ID); \
}

#define send_unifi_mgt_wifi_off_req_external(context, pid, p_appHandle) \
{ \
    UnifiMgtWifiOffReq_Evt *evt = (UnifiMgtWifiOffReq_Evt*) CsrPmalloc(sizeof(UnifiMgtWifiOffReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_WIFI_OFF_REQ_ID); \
}

/* -------------------------- unifi_mgt_wifi_off_ind -------------------------- */
typedef struct UnifiMgtWifiOffInd_Evt
{
    FsmEvent                        common;
    CsrUint16                       appHandlesCount;
    void*                          *appHandles;
    unifi_ControlIndication         controlIndication;
} UnifiMgtWifiOffInd_Evt;

#define send_unifi_mgt_wifi_off_ind(context, pid, p_appHandlesCount, p_appHandles, p_controlIndication) \
{ \
    UnifiMgtWifiOffInd_Evt *evt = (UnifiMgtWifiOffInd_Evt*) CsrPmalloc(sizeof(UnifiMgtWifiOffInd_Evt)); \
    evt->appHandlesCount      = p_appHandlesCount; \
    evt->appHandles           = p_appHandles; \
    evt->controlIndication    = p_controlIndication; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_WIFI_OFF_IND_ID); \
}

#define send_unifi_mgt_wifi_off_ind_external(context, pid, p_appHandlesCount, p_appHandles, p_controlIndication) \
{ \
    UnifiMgtWifiOffInd_Evt *evt = (UnifiMgtWifiOffInd_Evt*) CsrPmalloc(sizeof(UnifiMgtWifiOffInd_Evt)); \
    evt->appHandlesCount      = p_appHandlesCount; \
    evt->appHandles           = p_appHandles; \
    evt->controlIndication    = p_controlIndication; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_WIFI_OFF_IND_ID); \
}

/* -------------------------- unifi_mgt_wifi_off_cfm -------------------------- */
typedef struct UnifiMgtWifiOffCfm_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_Status                    status;
} UnifiMgtWifiOffCfm_Evt;

#define send_unifi_mgt_wifi_off_cfm(context, pid, p_appHandle, p_status) \
{ \
    UnifiMgtWifiOffCfm_Evt *evt = (UnifiMgtWifiOffCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtWifiOffCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_WIFI_OFF_CFM_ID); \
}

#define send_unifi_mgt_wifi_off_cfm_external(context, pid, p_appHandle, p_status) \
{ \
    UnifiMgtWifiOffCfm_Evt *evt = (UnifiMgtWifiOffCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtWifiOffCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_WIFI_OFF_CFM_ID); \
}

/* -------------------------- unifi_mgt_wifi_on_req -------------------------- */
typedef struct UnifiMgtWifiOnReq_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_MACAddress                address;
    CsrUint16                       mibFilesCount;
    unifi_DataBlock                *mibFiles;
} UnifiMgtWifiOnReq_Evt;

#define send_unifi_mgt_wifi_on_req(context, pid, p_appHandle, p_address, p_mibFilesCount, p_mibFiles) \
{ \
    UnifiMgtWifiOnReq_Evt *evt = (UnifiMgtWifiOnReq_Evt*) CsrPmalloc(sizeof(UnifiMgtWifiOnReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->address              = p_address; \
    evt->mibFilesCount        = p_mibFilesCount; \
    evt->mibFiles             = p_mibFiles; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_WIFI_ON_REQ_ID); \
}

#define send_unifi_mgt_wifi_on_req_external(context, pid, p_appHandle, p_address, p_mibFilesCount, p_mibFiles) \
{ \
    UnifiMgtWifiOnReq_Evt *evt = (UnifiMgtWifiOnReq_Evt*) CsrPmalloc(sizeof(UnifiMgtWifiOnReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->address              = p_address; \
    evt->mibFilesCount        = p_mibFilesCount; \
    evt->mibFiles             = p_mibFiles; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_WIFI_ON_REQ_ID); \
}

/* -------------------------- unifi_mgt_wifi_on_cfm -------------------------- */
typedef struct UnifiMgtWifiOnCfm_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_Status                    status;
} UnifiMgtWifiOnCfm_Evt;

#define send_unifi_mgt_wifi_on_cfm(context, pid, p_appHandle, p_status) \
{ \
    UnifiMgtWifiOnCfm_Evt *evt = (UnifiMgtWifiOnCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtWifiOnCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_MGT_WIFI_ON_CFM_ID); \
}

#define send_unifi_mgt_wifi_on_cfm_external(context, pid, p_appHandle, p_status) \
{ \
    UnifiMgtWifiOnCfm_Evt *evt = (UnifiMgtWifiOnCfm_Evt*) CsrPmalloc(sizeof(UnifiMgtWifiOnCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_MGT_WIFI_ON_CFM_ID); \
}

/* -------------------------- unifi_sys_capabilities_req -------------------------- */
typedef struct UnifiSysCapabilitiesReq_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
} UnifiSysCapabilitiesReq_Evt;

#define send_unifi_sys_capabilities_req(context, pid, p_appHandle) \
{ \
    UnifiSysCapabilitiesReq_Evt *evt = (UnifiSysCapabilitiesReq_Evt*) CsrPmalloc(sizeof(UnifiSysCapabilitiesReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_CAPABILITIES_REQ_ID); \
}

#define send_unifi_sys_capabilities_req_external(context, pid, p_appHandle) \
{ \
    UnifiSysCapabilitiesReq_Evt *evt = (UnifiSysCapabilitiesReq_Evt*) CsrPmalloc(sizeof(UnifiSysCapabilitiesReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_CAPABILITIES_REQ_ID); \
}

/* -------------------------- unifi_sys_capabilities_cfm -------------------------- */
typedef struct UnifiSysCapabilitiesCfm_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    CsrUint16                       commandQueueSize;
    CsrUint16                       trafficQueueSize;
} UnifiSysCapabilitiesCfm_Evt;

#define send_unifi_sys_capabilities_cfm(context, pid, p_appHandle, p_commandQueueSize, p_trafficQueueSize) \
{ \
    UnifiSysCapabilitiesCfm_Evt *evt = (UnifiSysCapabilitiesCfm_Evt*) CsrPmalloc(sizeof(UnifiSysCapabilitiesCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->commandQueueSize     = p_commandQueueSize; \
    evt->trafficQueueSize     = p_trafficQueueSize; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_CAPABILITIES_CFM_ID); \
}

#define send_unifi_sys_capabilities_cfm_external(context, pid, p_appHandle, p_commandQueueSize, p_trafficQueueSize) \
{ \
    UnifiSysCapabilitiesCfm_Evt *evt = (UnifiSysCapabilitiesCfm_Evt*) CsrPmalloc(sizeof(UnifiSysCapabilitiesCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->commandQueueSize     = p_commandQueueSize; \
    evt->trafficQueueSize     = p_trafficQueueSize; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_CAPABILITIES_CFM_ID); \
}

/* -------------------------- unifi_sys_configure_power_mode_req -------------------------- */
typedef struct UnifiSysConfigurePowerModeReq_Evt
{
    FsmEvent                        common;
    unifi_LowPowerMode              mode;
    CsrBool                         wakeHost;
} UnifiSysConfigurePowerModeReq_Evt;

#define send_unifi_sys_configure_power_mode_req(context, pid, p_mode, p_wakeHost) \
{ \
    UnifiSysConfigurePowerModeReq_Evt *evt = (UnifiSysConfigurePowerModeReq_Evt*) CsrPmalloc(sizeof(UnifiSysConfigurePowerModeReq_Evt)); \
    evt->mode                 = p_mode; \
    evt->wakeHost             = p_wakeHost; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_CONFIGURE_POWER_MODE_REQ_ID); \
}

#define send_unifi_sys_configure_power_mode_req_external(context, pid, p_mode, p_wakeHost) \
{ \
    UnifiSysConfigurePowerModeReq_Evt *evt = (UnifiSysConfigurePowerModeReq_Evt*) CsrPmalloc(sizeof(UnifiSysConfigurePowerModeReq_Evt)); \
    evt->mode                 = p_mode; \
    evt->wakeHost             = p_wakeHost; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_CONFIGURE_POWER_MODE_REQ_ID); \
}

/* -------------------------- unifi_sys_eapol_req -------------------------- */
typedef struct UnifiSysEapolReq_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    CsrUint8                        subscriptionHandle;
    CsrUint16                       frameLength;
    CsrUint8                       *frame;
    unifi_FrameFreeFunction         freeFunction;
} UnifiSysEapolReq_Evt;

#define send_unifi_sys_eapol_req(context, pid, p_appHandle, p_subscriptionHandle, p_frameLength, p_frame, p_freeFunction) \
{ \
    UnifiSysEapolReq_Evt *evt = (UnifiSysEapolReq_Evt*) CsrPmalloc(sizeof(UnifiSysEapolReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->subscriptionHandle   = p_subscriptionHandle; \
    evt->frameLength          = p_frameLength; \
    evt->frame                = p_frame; \
    evt->freeFunction         = p_freeFunction; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_EAPOL_REQ_ID); \
}

#define send_unifi_sys_eapol_req_external(context, pid, p_appHandle, p_subscriptionHandle, p_frameLength, p_frame, p_freeFunction) \
{ \
    UnifiSysEapolReq_Evt *evt = (UnifiSysEapolReq_Evt*) CsrPmalloc(sizeof(UnifiSysEapolReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->subscriptionHandle   = p_subscriptionHandle; \
    evt->frameLength          = p_frameLength; \
    evt->frame                = p_frame; \
    evt->freeFunction         = p_freeFunction; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_EAPOL_REQ_ID); \
}

/* -------------------------- unifi_sys_eapol_cfm -------------------------- */
typedef struct UnifiSysEapolCfm_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_EapolRc                   result;
} UnifiSysEapolCfm_Evt;

#define send_unifi_sys_eapol_cfm(context, pid, p_appHandle, p_result) \
{ \
    UnifiSysEapolCfm_Evt *evt = (UnifiSysEapolCfm_Evt*) CsrPmalloc(sizeof(UnifiSysEapolCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->result               = p_result; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_EAPOL_CFM_ID); \
}

#define send_unifi_sys_eapol_cfm_external(context, pid, p_appHandle, p_result) \
{ \
    UnifiSysEapolCfm_Evt *evt = (UnifiSysEapolCfm_Evt*) CsrPmalloc(sizeof(UnifiSysEapolCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->result               = p_result; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_EAPOL_CFM_ID); \
}

/* -------------------------- unifi_sys_hip_req -------------------------- */
typedef struct UnifiSysHipReq_Evt
{
    FsmEvent                        common;
    CsrUint16                       mlmeCommandLength;
    CsrUint8                       *mlmeCommand;
    CsrUint16                       dataRef1Length;
    CsrUint8                       *dataRef1;
    CsrUint16                       dataRef2Length;
    CsrUint8                       *dataRef2;
} UnifiSysHipReq_Evt;

#define send_unifi_sys_hip_req(context, pid, p_mlmeCommandLength, p_mlmeCommand, p_dataRef1Length, p_dataRef1, p_dataRef2Length, p_dataRef2) \
{ \
    UnifiSysHipReq_Evt *evt = (UnifiSysHipReq_Evt*) CsrPmalloc(sizeof(UnifiSysHipReq_Evt)); \
    evt->mlmeCommandLength    = p_mlmeCommandLength; \
    evt->mlmeCommand          = p_mlmeCommand; \
    evt->dataRef1Length       = p_dataRef1Length; \
    evt->dataRef1             = p_dataRef1; \
    evt->dataRef2Length       = p_dataRef2Length; \
    evt->dataRef2             = p_dataRef2; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_HIP_REQ_ID); \
}

#define send_unifi_sys_hip_req_external(context, pid, p_mlmeCommandLength, p_mlmeCommand, p_dataRef1Length, p_dataRef1, p_dataRef2Length, p_dataRef2) \
{ \
    UnifiSysHipReq_Evt *evt = (UnifiSysHipReq_Evt*) CsrPmalloc(sizeof(UnifiSysHipReq_Evt)); \
    evt->mlmeCommandLength    = p_mlmeCommandLength; \
    evt->mlmeCommand          = p_mlmeCommand; \
    evt->dataRef1Length       = p_dataRef1Length; \
    evt->dataRef1             = p_dataRef1; \
    evt->dataRef2Length       = p_dataRef2Length; \
    evt->dataRef2             = p_dataRef2; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_HIP_REQ_ID); \
}

/* -------------------------- unifi_sys_hip_ind -------------------------- */
typedef struct UnifiSysHipInd_Evt
{
    FsmEvent                        common;
    CsrUint16                       mlmeCommandLength;
    CsrUint8                       *mlmeCommand;
    CsrUint16                       dataRef1Length;
    CsrUint8                       *dataRef1;
    CsrUint16                       dataRef2Length;
    CsrUint8                       *dataRef2;
} UnifiSysHipInd_Evt;

#define send_unifi_sys_hip_ind(context, pid, p_mlmeCommandLength, p_mlmeCommand, p_dataRef1Length, p_dataRef1, p_dataRef2Length, p_dataRef2) \
{ \
    UnifiSysHipInd_Evt *evt = (UnifiSysHipInd_Evt*) CsrPmalloc(sizeof(UnifiSysHipInd_Evt)); \
    evt->mlmeCommandLength    = p_mlmeCommandLength; \
    evt->mlmeCommand          = p_mlmeCommand; \
    evt->dataRef1Length       = p_dataRef1Length; \
    evt->dataRef1             = p_dataRef1; \
    evt->dataRef2Length       = p_dataRef2Length; \
    evt->dataRef2             = p_dataRef2; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_HIP_IND_ID); \
}

#define send_unifi_sys_hip_ind_external(context, pid, p_mlmeCommandLength, p_mlmeCommand, p_dataRef1Length, p_dataRef1, p_dataRef2Length, p_dataRef2) \
{ \
    UnifiSysHipInd_Evt *evt = (UnifiSysHipInd_Evt*) CsrPmalloc(sizeof(UnifiSysHipInd_Evt)); \
    evt->mlmeCommandLength    = p_mlmeCommandLength; \
    evt->mlmeCommand          = p_mlmeCommand; \
    evt->dataRef1Length       = p_dataRef1Length; \
    evt->dataRef1             = p_dataRef1; \
    evt->dataRef2Length       = p_dataRef2Length; \
    evt->dataRef2             = p_dataRef2; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_HIP_IND_ID); \
}

/* -------------------------- unifi_sys_ip_configured_ind -------------------------- */
typedef struct UnifiSysIpConfiguredInd_Evt
{
    FsmEvent                        common;
    CsrBool                         ipConfigured;
} UnifiSysIpConfiguredInd_Evt;

#define send_unifi_sys_ip_configured_ind(context, pid, p_ipConfigured) \
{ \
    UnifiSysIpConfiguredInd_Evt *evt = (UnifiSysIpConfiguredInd_Evt*) CsrPmalloc(sizeof(UnifiSysIpConfiguredInd_Evt)); \
    evt->ipConfigured         = p_ipConfigured; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_IP_CONFIGURED_IND_ID); \
}

#define send_unifi_sys_ip_configured_ind_external(context, pid, p_ipConfigured) \
{ \
    UnifiSysIpConfiguredInd_Evt *evt = (UnifiSysIpConfiguredInd_Evt*) CsrPmalloc(sizeof(UnifiSysIpConfiguredInd_Evt)); \
    evt->ipConfigured         = p_ipConfigured; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_IP_CONFIGURED_IND_ID); \
}

/* -------------------------- unifi_sys_m4_transmit_req -------------------------- */
typedef struct UnifiSysM4TransmitReq_Evt
{
    FsmEvent                        common;
} UnifiSysM4TransmitReq_Evt;

#define send_unifi_sys_m4_transmit_req(context, pid) \
{ \
    UnifiSysM4TransmitReq_Evt *evt = (UnifiSysM4TransmitReq_Evt*) CsrPmalloc(sizeof(UnifiSysM4TransmitReq_Evt)); \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_M4_TRANSMIT_REQ_ID); \
}

#define send_unifi_sys_m4_transmit_req_external(context, pid) \
{ \
    UnifiSysM4TransmitReq_Evt *evt = (UnifiSysM4TransmitReq_Evt*) CsrPmalloc(sizeof(UnifiSysM4TransmitReq_Evt)); \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_M4_TRANSMIT_REQ_ID); \
}

/* -------------------------- unifi_sys_m4_transmitted_ind -------------------------- */
typedef struct UnifiSysM4TransmittedInd_Evt
{
    FsmEvent                        common;
} UnifiSysM4TransmittedInd_Evt;

#define send_unifi_sys_m4_transmitted_ind(context, pid) \
{ \
    UnifiSysM4TransmittedInd_Evt *evt = (UnifiSysM4TransmittedInd_Evt*) CsrPmalloc(sizeof(UnifiSysM4TransmittedInd_Evt)); \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_M4_TRANSMITTED_IND_ID); \
}

#define send_unifi_sys_m4_transmitted_ind_external(context, pid) \
{ \
    UnifiSysM4TransmittedInd_Evt *evt = (UnifiSysM4TransmittedInd_Evt*) CsrPmalloc(sizeof(UnifiSysM4TransmittedInd_Evt)); \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_M4_TRANSMITTED_IND_ID); \
}

/* -------------------------- unifi_sys_ma_unitdata_req -------------------------- */
typedef struct UnifiSysMaUnitdataReq_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    CsrUint8                        subscriptionHandle;
    CsrUint16                       frameLength;
    CsrUint8                       *frame;
    unifi_FrameFreeFunction         freeFunction;
    unifi_Priority                  priority;
    unifi_ServiceClass              serviceClass;
    CsrUint32                       reqIdentifier;
} UnifiSysMaUnitdataReq_Evt;

#define send_unifi_sys_ma_unitdata_req(context, pid, p_appHandle, p_subscriptionHandle, p_frameLength, p_frame, p_freeFunction, p_priority, p_serviceClass, p_reqIdentifier) \
{ \
    UnifiSysMaUnitdataReq_Evt *evt = (UnifiSysMaUnitdataReq_Evt*) CsrPmalloc(sizeof(UnifiSysMaUnitdataReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->subscriptionHandle   = p_subscriptionHandle; \
    evt->frameLength          = p_frameLength; \
    evt->frame                = p_frame; \
    evt->freeFunction         = p_freeFunction; \
    evt->priority             = p_priority; \
    evt->serviceClass         = p_serviceClass; \
    evt->reqIdentifier        = p_reqIdentifier; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_MA_UNITDATA_REQ_ID); \
}

#define send_unifi_sys_ma_unitdata_req_external(context, pid, p_appHandle, p_subscriptionHandle, p_frameLength, p_frame, p_freeFunction, p_priority, p_serviceClass, p_reqIdentifier) \
{ \
    UnifiSysMaUnitdataReq_Evt *evt = (UnifiSysMaUnitdataReq_Evt*) CsrPmalloc(sizeof(UnifiSysMaUnitdataReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->subscriptionHandle   = p_subscriptionHandle; \
    evt->frameLength          = p_frameLength; \
    evt->frame                = p_frame; \
    evt->freeFunction         = p_freeFunction; \
    evt->priority             = p_priority; \
    evt->serviceClass         = p_serviceClass; \
    evt->reqIdentifier        = p_reqIdentifier; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_MA_UNITDATA_REQ_ID); \
}

/* -------------------------- unifi_sys_ma_unitdata_ind -------------------------- */
typedef struct UnifiSysMaUnitdataInd_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    CsrUint8                        subscriptionHandle;
    CsrUint16                       frameLength;
    CsrUint8                       *frame;
    unifi_FrameFreeFunction         freeFunction;
    unifi_ReceptionStatus           receptionStatus;
    unifi_Priority                  priority;
    unifi_ServiceClass              serviceClass;
} UnifiSysMaUnitdataInd_Evt;

#define send_unifi_sys_ma_unitdata_ind(context, pid, p_appHandle, p_subscriptionHandle, p_frameLength, p_frame, p_freeFunction, p_receptionStatus, p_priority, p_serviceClass) \
{ \
    UnifiSysMaUnitdataInd_Evt *evt = (UnifiSysMaUnitdataInd_Evt*) CsrPmalloc(sizeof(UnifiSysMaUnitdataInd_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->subscriptionHandle   = p_subscriptionHandle; \
    evt->frameLength          = p_frameLength; \
    evt->frame                = p_frame; \
    evt->freeFunction         = p_freeFunction; \
    evt->receptionStatus      = p_receptionStatus; \
    evt->priority             = p_priority; \
    evt->serviceClass         = p_serviceClass; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_MA_UNITDATA_IND_ID); \
}

#define send_unifi_sys_ma_unitdata_ind_external(context, pid, p_appHandle, p_subscriptionHandle, p_frameLength, p_frame, p_freeFunction, p_receptionStatus, p_priority, p_serviceClass) \
{ \
    UnifiSysMaUnitdataInd_Evt *evt = (UnifiSysMaUnitdataInd_Evt*) CsrPmalloc(sizeof(UnifiSysMaUnitdataInd_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->subscriptionHandle   = p_subscriptionHandle; \
    evt->frameLength          = p_frameLength; \
    evt->frame                = p_frame; \
    evt->freeFunction         = p_freeFunction; \
    evt->receptionStatus      = p_receptionStatus; \
    evt->priority             = p_priority; \
    evt->serviceClass         = p_serviceClass; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_MA_UNITDATA_IND_ID); \
}

/* -------------------------- unifi_sys_ma_unitdata_rsp -------------------------- */
typedef struct UnifiSysMaUnitdataRsp_Evt
{
    FsmEvent                        common;
    CsrUint8                        subscriptionHandle;
    unifi_Status                    result;
} UnifiSysMaUnitdataRsp_Evt;

#define send_unifi_sys_ma_unitdata_rsp(context, pid, p_subscriptionHandle, p_result) \
{ \
    UnifiSysMaUnitdataRsp_Evt *evt = (UnifiSysMaUnitdataRsp_Evt*) CsrPmalloc(sizeof(UnifiSysMaUnitdataRsp_Evt)); \
    evt->subscriptionHandle   = p_subscriptionHandle; \
    evt->result               = p_result; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_MA_UNITDATA_RSP_ID); \
}

#define send_unifi_sys_ma_unitdata_rsp_external(context, pid, p_subscriptionHandle, p_result) \
{ \
    UnifiSysMaUnitdataRsp_Evt *evt = (UnifiSysMaUnitdataRsp_Evt*) CsrPmalloc(sizeof(UnifiSysMaUnitdataRsp_Evt)); \
    evt->subscriptionHandle   = p_subscriptionHandle; \
    evt->result               = p_result; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_MA_UNITDATA_RSP_ID); \
}

/* -------------------------- unifi_sys_ma_unitdata_cfm -------------------------- */
typedef struct UnifiSysMaUnitdataCfm_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_Status                    result;
    unifi_TransmissionStatus        transmissionStatus;
    unifi_Priority                  providedPriority;
    unifi_ServiceClass              providedServiceClass;
    CsrUint32                       reqIdentifier;
} UnifiSysMaUnitdataCfm_Evt;

#define send_unifi_sys_ma_unitdata_cfm(context, pid, p_appHandle, p_result, p_transmissionStatus, p_providedPriority, p_providedServiceClass, p_reqIdentifier) \
{ \
    UnifiSysMaUnitdataCfm_Evt *evt = (UnifiSysMaUnitdataCfm_Evt*) CsrPmalloc(sizeof(UnifiSysMaUnitdataCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->result               = p_result; \
    evt->transmissionStatus   = p_transmissionStatus; \
    evt->providedPriority     = p_providedPriority; \
    evt->providedServiceClass = p_providedServiceClass; \
    evt->reqIdentifier        = p_reqIdentifier; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_MA_UNITDATA_CFM_ID); \
}

#define send_unifi_sys_ma_unitdata_cfm_external(context, pid, p_appHandle, p_result, p_transmissionStatus, p_providedPriority, p_providedServiceClass, p_reqIdentifier) \
{ \
    UnifiSysMaUnitdataCfm_Evt *evt = (UnifiSysMaUnitdataCfm_Evt*) CsrPmalloc(sizeof(UnifiSysMaUnitdataCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->result               = p_result; \
    evt->transmissionStatus   = p_transmissionStatus; \
    evt->providedPriority     = p_providedPriority; \
    evt->providedServiceClass = p_providedServiceClass; \
    evt->reqIdentifier        = p_reqIdentifier; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_MA_UNITDATA_CFM_ID); \
}

/* -------------------------- unifi_sys_ma_unitdata_subscribe_req -------------------------- */
typedef struct UnifiSysMaUnitdataSubscribeReq_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_Encapsulation             encapsulation;
    CsrUint16                       protocol;
    CsrUint32                       oui;
} UnifiSysMaUnitdataSubscribeReq_Evt;

#define send_unifi_sys_ma_unitdata_subscribe_req(context, pid, p_appHandle, p_encapsulation, p_protocol, p_oui) \
{ \
    UnifiSysMaUnitdataSubscribeReq_Evt *evt = (UnifiSysMaUnitdataSubscribeReq_Evt*) CsrPmalloc(sizeof(UnifiSysMaUnitdataSubscribeReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->encapsulation        = p_encapsulation; \
    evt->protocol             = p_protocol; \
    evt->oui                  = p_oui; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_MA_UNITDATA_SUBSCRIBE_REQ_ID); \
}

#define send_unifi_sys_ma_unitdata_subscribe_req_external(context, pid, p_appHandle, p_encapsulation, p_protocol, p_oui) \
{ \
    UnifiSysMaUnitdataSubscribeReq_Evt *evt = (UnifiSysMaUnitdataSubscribeReq_Evt*) CsrPmalloc(sizeof(UnifiSysMaUnitdataSubscribeReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->encapsulation        = p_encapsulation; \
    evt->protocol             = p_protocol; \
    evt->oui                  = p_oui; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_MA_UNITDATA_SUBSCRIBE_REQ_ID); \
}

/* -------------------------- unifi_sys_ma_unitdata_subscribe_cfm -------------------------- */
typedef struct UnifiSysMaUnitdataSubscribeCfm_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    CsrUint8                        subscriptionHandle;
    unifi_SubscriptionResult        status;
    CsrUint16                       allocOffset;
} UnifiSysMaUnitdataSubscribeCfm_Evt;

#define send_unifi_sys_ma_unitdata_subscribe_cfm(context, pid, p_appHandle, p_subscriptionHandle, p_status, p_allocOffset) \
{ \
    UnifiSysMaUnitdataSubscribeCfm_Evt *evt = (UnifiSysMaUnitdataSubscribeCfm_Evt*) CsrPmalloc(sizeof(UnifiSysMaUnitdataSubscribeCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->subscriptionHandle   = p_subscriptionHandle; \
    evt->status               = p_status; \
    evt->allocOffset          = p_allocOffset; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_MA_UNITDATA_SUBSCRIBE_CFM_ID); \
}

#define send_unifi_sys_ma_unitdata_subscribe_cfm_external(context, pid, p_appHandle, p_subscriptionHandle, p_status, p_allocOffset) \
{ \
    UnifiSysMaUnitdataSubscribeCfm_Evt *evt = (UnifiSysMaUnitdataSubscribeCfm_Evt*) CsrPmalloc(sizeof(UnifiSysMaUnitdataSubscribeCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->subscriptionHandle   = p_subscriptionHandle; \
    evt->status               = p_status; \
    evt->allocOffset          = p_allocOffset; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_MA_UNITDATA_SUBSCRIBE_CFM_ID); \
}

/* -------------------------- unifi_sys_ma_unitdata_unsubscribe_req -------------------------- */
typedef struct UnifiSysMaUnitdataUnsubscribeReq_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    CsrUint8                        subscriptionHandle;
} UnifiSysMaUnitdataUnsubscribeReq_Evt;

#define send_unifi_sys_ma_unitdata_unsubscribe_req(context, pid, p_appHandle, p_subscriptionHandle) \
{ \
    UnifiSysMaUnitdataUnsubscribeReq_Evt *evt = (UnifiSysMaUnitdataUnsubscribeReq_Evt*) CsrPmalloc(sizeof(UnifiSysMaUnitdataUnsubscribeReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->subscriptionHandle   = p_subscriptionHandle; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_MA_UNITDATA_UNSUBSCRIBE_REQ_ID); \
}

#define send_unifi_sys_ma_unitdata_unsubscribe_req_external(context, pid, p_appHandle, p_subscriptionHandle) \
{ \
    UnifiSysMaUnitdataUnsubscribeReq_Evt *evt = (UnifiSysMaUnitdataUnsubscribeReq_Evt*) CsrPmalloc(sizeof(UnifiSysMaUnitdataUnsubscribeReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->subscriptionHandle   = p_subscriptionHandle; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_MA_UNITDATA_UNSUBSCRIBE_REQ_ID); \
}

/* -------------------------- unifi_sys_ma_unitdata_unsubscribe_cfm -------------------------- */
typedef struct UnifiSysMaUnitdataUnsubscribeCfm_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
    unifi_SubscriptionResult        status;
} UnifiSysMaUnitdataUnsubscribeCfm_Evt;

#define send_unifi_sys_ma_unitdata_unsubscribe_cfm(context, pid, p_appHandle, p_status) \
{ \
    UnifiSysMaUnitdataUnsubscribeCfm_Evt *evt = (UnifiSysMaUnitdataUnsubscribeCfm_Evt*) CsrPmalloc(sizeof(UnifiSysMaUnitdataUnsubscribeCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_MA_UNITDATA_UNSUBSCRIBE_CFM_ID); \
}

#define send_unifi_sys_ma_unitdata_unsubscribe_cfm_external(context, pid, p_appHandle, p_status) \
{ \
    UnifiSysMaUnitdataUnsubscribeCfm_Evt *evt = (UnifiSysMaUnitdataUnsubscribeCfm_Evt*) CsrPmalloc(sizeof(UnifiSysMaUnitdataUnsubscribeCfm_Evt)); \
    evt->appHandle            = p_appHandle; \
    evt->status               = p_status; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_MA_UNITDATA_UNSUBSCRIBE_CFM_ID); \
}

/* -------------------------- unifi_sys_media_status_req -------------------------- */
typedef struct UnifiSysMediaStatusReq_Evt
{
    FsmEvent                        common;
    unifi_MediaStatus               mediaStatus;
    CsrUint32                       mediaTypeMask;
} UnifiSysMediaStatusReq_Evt;

#define send_unifi_sys_media_status_req(context, pid, p_mediaStatus, p_mediaTypeMask) \
{ \
    UnifiSysMediaStatusReq_Evt *evt = (UnifiSysMediaStatusReq_Evt*) CsrPmalloc(sizeof(UnifiSysMediaStatusReq_Evt)); \
    evt->mediaStatus          = p_mediaStatus; \
    evt->mediaTypeMask        = p_mediaTypeMask; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_MEDIA_STATUS_REQ_ID); \
}

#define send_unifi_sys_media_status_req_external(context, pid, p_mediaStatus, p_mediaTypeMask) \
{ \
    UnifiSysMediaStatusReq_Evt *evt = (UnifiSysMediaStatusReq_Evt*) CsrPmalloc(sizeof(UnifiSysMediaStatusReq_Evt)); \
    evt->mediaStatus          = p_mediaStatus; \
    evt->mediaTypeMask        = p_mediaTypeMask; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_MEDIA_STATUS_REQ_ID); \
}

/* -------------------------- unifi_sys_multicast_address_ind -------------------------- */
typedef struct UnifiSysMulticastAddressInd_Evt
{
    FsmEvent                        common;
    unifi_ListAction                action;
    CsrUint8                        setAddressesCount;
    unifi_MACAddress               *setAddresses;
} UnifiSysMulticastAddressInd_Evt;

#define send_unifi_sys_multicast_address_ind(context, pid, p_action, p_setAddressesCount, p_setAddresses) \
{ \
    UnifiSysMulticastAddressInd_Evt *evt = (UnifiSysMulticastAddressInd_Evt*) CsrPmalloc(sizeof(UnifiSysMulticastAddressInd_Evt)); \
    evt->action               = p_action; \
    evt->setAddressesCount    = p_setAddressesCount; \
    evt->setAddresses         = p_setAddresses; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_MULTICAST_ADDRESS_IND_ID); \
}

#define send_unifi_sys_multicast_address_ind_external(context, pid, p_action, p_setAddressesCount, p_setAddresses) \
{ \
    UnifiSysMulticastAddressInd_Evt *evt = (UnifiSysMulticastAddressInd_Evt*) CsrPmalloc(sizeof(UnifiSysMulticastAddressInd_Evt)); \
    evt->action               = p_action; \
    evt->setAddressesCount    = p_setAddressesCount; \
    evt->setAddresses         = p_setAddresses; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_MULTICAST_ADDRESS_IND_ID); \
}

/* -------------------------- unifi_sys_multicast_address_rsp -------------------------- */
typedef struct UnifiSysMulticastAddressRsp_Evt
{
    FsmEvent                        common;
    unifi_Status                    status;
    unifi_ListAction                action;
    CsrUint8                        getAddressesCount;
    unifi_MACAddress               *getAddresses;
} UnifiSysMulticastAddressRsp_Evt;

#define send_unifi_sys_multicast_address_rsp(context, pid, p_status, p_action, p_getAddressesCount, p_getAddresses) \
{ \
    UnifiSysMulticastAddressRsp_Evt *evt = (UnifiSysMulticastAddressRsp_Evt*) CsrPmalloc(sizeof(UnifiSysMulticastAddressRsp_Evt)); \
    evt->status               = p_status; \
    evt->action               = p_action; \
    evt->getAddressesCount    = p_getAddressesCount; \
    evt->getAddresses         = p_getAddresses; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_MULTICAST_ADDRESS_RSP_ID); \
}

#define send_unifi_sys_multicast_address_rsp_external(context, pid, p_status, p_action, p_getAddressesCount, p_getAddresses) \
{ \
    UnifiSysMulticastAddressRsp_Evt *evt = (UnifiSysMulticastAddressRsp_Evt*) CsrPmalloc(sizeof(UnifiSysMulticastAddressRsp_Evt)); \
    evt->status               = p_status; \
    evt->action               = p_action; \
    evt->getAddressesCount    = p_getAddressesCount; \
    evt->getAddresses         = p_getAddresses; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_MULTICAST_ADDRESS_RSP_ID); \
}

/* -------------------------- unifi_sys_port_configure_req -------------------------- */
typedef struct UnifiSysPortConfigureReq_Evt
{
    FsmEvent                        common;
    unifi_PortAction                uncontrolledPortAction;
    unifi_PortAction                controlledPortAction;
    unifi_MACAddress                macAddress;
} UnifiSysPortConfigureReq_Evt;

#define send_unifi_sys_port_configure_req(context, pid, p_uncontrolledPortAction, p_controlledPortAction, p_macAddress) \
{ \
    UnifiSysPortConfigureReq_Evt *evt = (UnifiSysPortConfigureReq_Evt*) CsrPmalloc(sizeof(UnifiSysPortConfigureReq_Evt)); \
    evt->uncontrolledPortAction = p_uncontrolledPortAction; \
    evt->controlledPortAction = p_controlledPortAction; \
    evt->macAddress           = p_macAddress; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_PORT_CONFIGURE_REQ_ID); \
}

#define send_unifi_sys_port_configure_req_external(context, pid, p_uncontrolledPortAction, p_controlledPortAction, p_macAddress) \
{ \
    UnifiSysPortConfigureReq_Evt *evt = (UnifiSysPortConfigureReq_Evt*) CsrPmalloc(sizeof(UnifiSysPortConfigureReq_Evt)); \
    evt->uncontrolledPortAction = p_uncontrolledPortAction; \
    evt->controlledPortAction = p_controlledPortAction; \
    evt->macAddress           = p_macAddress; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_PORT_CONFIGURE_REQ_ID); \
}

/* -------------------------- unifi_sys_port_configure_cfm -------------------------- */
typedef struct UnifiSysPortConfigureCfm_Evt
{
    FsmEvent                        common;
    unifi_Status                    status;
    unifi_MACAddress                macAddress;
} UnifiSysPortConfigureCfm_Evt;

#define send_unifi_sys_port_configure_cfm(context, pid, p_status, p_macAddress) \
{ \
    UnifiSysPortConfigureCfm_Evt *evt = (UnifiSysPortConfigureCfm_Evt*) CsrPmalloc(sizeof(UnifiSysPortConfigureCfm_Evt)); \
    evt->status               = p_status; \
    evt->macAddress           = p_macAddress; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_PORT_CONFIGURE_CFM_ID); \
}

#define send_unifi_sys_port_configure_cfm_external(context, pid, p_status, p_macAddress) \
{ \
    UnifiSysPortConfigureCfm_Evt *evt = (UnifiSysPortConfigureCfm_Evt*) CsrPmalloc(sizeof(UnifiSysPortConfigureCfm_Evt)); \
    evt->status               = p_status; \
    evt->macAddress           = p_macAddress; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_PORT_CONFIGURE_CFM_ID); \
}

/* -------------------------- unifi_sys_qos_control_req -------------------------- */
typedef struct UnifiSysQosControlReq_Evt
{
    FsmEvent                        common;
    unifi_QoSControl                control;
} UnifiSysQosControlReq_Evt;

#define send_unifi_sys_qos_control_req(context, pid, p_control) \
{ \
    UnifiSysQosControlReq_Evt *evt = (UnifiSysQosControlReq_Evt*) CsrPmalloc(sizeof(UnifiSysQosControlReq_Evt)); \
    evt->control              = p_control; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_QOS_CONTROL_REQ_ID); \
}

#define send_unifi_sys_qos_control_req_external(context, pid, p_control) \
{ \
    UnifiSysQosControlReq_Evt *evt = (UnifiSysQosControlReq_Evt*) CsrPmalloc(sizeof(UnifiSysQosControlReq_Evt)); \
    evt->control              = p_control; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_QOS_CONTROL_REQ_ID); \
}

/* -------------------------- unifi_sys_qos_control_cfm -------------------------- */
typedef struct UnifiSysQosControlCfm_Evt
{
    FsmEvent                        common;
    unifi_Status                    status;
} UnifiSysQosControlCfm_Evt;

#define send_unifi_sys_qos_control_cfm(context, pid, p_status) \
{ \
    UnifiSysQosControlCfm_Evt *evt = (UnifiSysQosControlCfm_Evt*) CsrPmalloc(sizeof(UnifiSysQosControlCfm_Evt)); \
    evt->status               = p_status; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_QOS_CONTROL_CFM_ID); \
}

#define send_unifi_sys_qos_control_cfm_external(context, pid, p_status) \
{ \
    UnifiSysQosControlCfm_Evt *evt = (UnifiSysQosControlCfm_Evt*) CsrPmalloc(sizeof(UnifiSysQosControlCfm_Evt)); \
    evt->status               = p_status; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_QOS_CONTROL_CFM_ID); \
}

/* -------------------------- unifi_sys_resume_ind -------------------------- */
typedef struct UnifiSysResumeInd_Evt
{
    FsmEvent                        common;
    CsrBool                         powerMaintained;
} UnifiSysResumeInd_Evt;

#define send_unifi_sys_resume_ind(context, pid, p_powerMaintained) \
{ \
    UnifiSysResumeInd_Evt *evt = (UnifiSysResumeInd_Evt*) CsrPmalloc(sizeof(UnifiSysResumeInd_Evt)); \
    evt->powerMaintained      = p_powerMaintained; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_RESUME_IND_ID); \
}

#define send_unifi_sys_resume_ind_external(context, pid, p_powerMaintained) \
{ \
    UnifiSysResumeInd_Evt *evt = (UnifiSysResumeInd_Evt*) CsrPmalloc(sizeof(UnifiSysResumeInd_Evt)); \
    evt->powerMaintained      = p_powerMaintained; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_RESUME_IND_ID); \
}

/* -------------------------- unifi_sys_resume_rsp -------------------------- */
typedef struct UnifiSysResumeRsp_Evt
{
    FsmEvent                        common;
    unifi_Status                    status;
} UnifiSysResumeRsp_Evt;

#define send_unifi_sys_resume_rsp(context, pid, p_status) \
{ \
    UnifiSysResumeRsp_Evt *evt = (UnifiSysResumeRsp_Evt*) CsrPmalloc(sizeof(UnifiSysResumeRsp_Evt)); \
    evt->status               = p_status; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_RESUME_RSP_ID); \
}

#define send_unifi_sys_resume_rsp_external(context, pid, p_status) \
{ \
    UnifiSysResumeRsp_Evt *evt = (UnifiSysResumeRsp_Evt*) CsrPmalloc(sizeof(UnifiSysResumeRsp_Evt)); \
    evt->status               = p_status; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_RESUME_RSP_ID); \
}

/* -------------------------- unifi_sys_suspend_ind -------------------------- */
typedef struct UnifiSysSuspendInd_Evt
{
    FsmEvent                        common;
    CsrBool                         hardSuspend;
    CsrBool                         d3Suspend;
} UnifiSysSuspendInd_Evt;

#define send_unifi_sys_suspend_ind(context, pid, p_hardSuspend, p_d3Suspend) \
{ \
    UnifiSysSuspendInd_Evt *evt = (UnifiSysSuspendInd_Evt*) CsrPmalloc(sizeof(UnifiSysSuspendInd_Evt)); \
    evt->hardSuspend          = p_hardSuspend; \
    evt->d3Suspend            = p_d3Suspend; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_SUSPEND_IND_ID); \
}

#define send_unifi_sys_suspend_ind_external(context, pid, p_hardSuspend, p_d3Suspend) \
{ \
    UnifiSysSuspendInd_Evt *evt = (UnifiSysSuspendInd_Evt*) CsrPmalloc(sizeof(UnifiSysSuspendInd_Evt)); \
    evt->hardSuspend          = p_hardSuspend; \
    evt->d3Suspend            = p_d3Suspend; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_SUSPEND_IND_ID); \
}

/* -------------------------- unifi_sys_suspend_rsp -------------------------- */
typedef struct UnifiSysSuspendRsp_Evt
{
    FsmEvent                        common;
    unifi_Status                    status;
} UnifiSysSuspendRsp_Evt;

#define send_unifi_sys_suspend_rsp(context, pid, p_status) \
{ \
    UnifiSysSuspendRsp_Evt *evt = (UnifiSysSuspendRsp_Evt*) CsrPmalloc(sizeof(UnifiSysSuspendRsp_Evt)); \
    evt->status               = p_status; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_SUSPEND_RSP_ID); \
}

#define send_unifi_sys_suspend_rsp_external(context, pid, p_status) \
{ \
    UnifiSysSuspendRsp_Evt *evt = (UnifiSysSuspendRsp_Evt*) CsrPmalloc(sizeof(UnifiSysSuspendRsp_Evt)); \
    evt->status               = p_status; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_SUSPEND_RSP_ID); \
}

/* -------------------------- unifi_sys_tclas_add_req -------------------------- */
typedef struct UnifiSysTclasAddReq_Evt
{
    FsmEvent                        common;
    CsrUint16                       tclasLength;
    CsrUint8                       *tclas;
} UnifiSysTclasAddReq_Evt;

#define send_unifi_sys_tclas_add_req(context, pid, p_tclasLength, p_tclas) \
{ \
    UnifiSysTclasAddReq_Evt *evt = (UnifiSysTclasAddReq_Evt*) CsrPmalloc(sizeof(UnifiSysTclasAddReq_Evt)); \
    evt->tclasLength          = p_tclasLength; \
    evt->tclas                = p_tclas; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_TCLAS_ADD_REQ_ID); \
}

#define send_unifi_sys_tclas_add_req_external(context, pid, p_tclasLength, p_tclas) \
{ \
    UnifiSysTclasAddReq_Evt *evt = (UnifiSysTclasAddReq_Evt*) CsrPmalloc(sizeof(UnifiSysTclasAddReq_Evt)); \
    evt->tclasLength          = p_tclasLength; \
    evt->tclas                = p_tclas; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_TCLAS_ADD_REQ_ID); \
}

/* -------------------------- unifi_sys_tclas_add_cfm -------------------------- */
typedef struct UnifiSysTclasAddCfm_Evt
{
    FsmEvent                        common;
    unifi_Status                    status;
} UnifiSysTclasAddCfm_Evt;

#define send_unifi_sys_tclas_add_cfm(context, pid, p_status) \
{ \
    UnifiSysTclasAddCfm_Evt *evt = (UnifiSysTclasAddCfm_Evt*) CsrPmalloc(sizeof(UnifiSysTclasAddCfm_Evt)); \
    evt->status               = p_status; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_TCLAS_ADD_CFM_ID); \
}

#define send_unifi_sys_tclas_add_cfm_external(context, pid, p_status) \
{ \
    UnifiSysTclasAddCfm_Evt *evt = (UnifiSysTclasAddCfm_Evt*) CsrPmalloc(sizeof(UnifiSysTclasAddCfm_Evt)); \
    evt->status               = p_status; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_TCLAS_ADD_CFM_ID); \
}

/* -------------------------- unifi_sys_tclas_del_req -------------------------- */
typedef struct UnifiSysTclasDelReq_Evt
{
    FsmEvent                        common;
    CsrUint16                       tclasLength;
    CsrUint8                       *tclas;
} UnifiSysTclasDelReq_Evt;

#define send_unifi_sys_tclas_del_req(context, pid, p_tclasLength, p_tclas) \
{ \
    UnifiSysTclasDelReq_Evt *evt = (UnifiSysTclasDelReq_Evt*) CsrPmalloc(sizeof(UnifiSysTclasDelReq_Evt)); \
    evt->tclasLength          = p_tclasLength; \
    evt->tclas                = p_tclas; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_TCLAS_DEL_REQ_ID); \
}

#define send_unifi_sys_tclas_del_req_external(context, pid, p_tclasLength, p_tclas) \
{ \
    UnifiSysTclasDelReq_Evt *evt = (UnifiSysTclasDelReq_Evt*) CsrPmalloc(sizeof(UnifiSysTclasDelReq_Evt)); \
    evt->tclasLength          = p_tclasLength; \
    evt->tclas                = p_tclas; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_TCLAS_DEL_REQ_ID); \
}

/* -------------------------- unifi_sys_tclas_del_cfm -------------------------- */
typedef struct UnifiSysTclasDelCfm_Evt
{
    FsmEvent                        common;
    unifi_Status                    status;
} UnifiSysTclasDelCfm_Evt;

#define send_unifi_sys_tclas_del_cfm(context, pid, p_status) \
{ \
    UnifiSysTclasDelCfm_Evt *evt = (UnifiSysTclasDelCfm_Evt*) CsrPmalloc(sizeof(UnifiSysTclasDelCfm_Evt)); \
    evt->status               = p_status; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_TCLAS_DEL_CFM_ID); \
}

#define send_unifi_sys_tclas_del_cfm_external(context, pid, p_status) \
{ \
    UnifiSysTclasDelCfm_Evt *evt = (UnifiSysTclasDelCfm_Evt*) CsrPmalloc(sizeof(UnifiSysTclasDelCfm_Evt)); \
    evt->status               = p_status; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_TCLAS_DEL_CFM_ID); \
}

/* -------------------------- unifi_sys_traffic_classification_req -------------------------- */
typedef struct UnifiSysTrafficClassificationReq_Evt
{
    FsmEvent                        common;
    unifi_TrafficType               trafficType;
    CsrUint16                       period;
} UnifiSysTrafficClassificationReq_Evt;

#define send_unifi_sys_traffic_classification_req(context, pid, p_trafficType, p_period) \
{ \
    UnifiSysTrafficClassificationReq_Evt *evt = (UnifiSysTrafficClassificationReq_Evt*) CsrPmalloc(sizeof(UnifiSysTrafficClassificationReq_Evt)); \
    evt->trafficType          = p_trafficType; \
    evt->period               = p_period; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_TRAFFIC_CLASSIFICATION_REQ_ID); \
}

#define send_unifi_sys_traffic_classification_req_external(context, pid, p_trafficType, p_period) \
{ \
    UnifiSysTrafficClassificationReq_Evt *evt = (UnifiSysTrafficClassificationReq_Evt*) CsrPmalloc(sizeof(UnifiSysTrafficClassificationReq_Evt)); \
    evt->trafficType          = p_trafficType; \
    evt->period               = p_period; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_TRAFFIC_CLASSIFICATION_REQ_ID); \
}

/* -------------------------- unifi_sys_traffic_config_req -------------------------- */
typedef struct UnifiSysTrafficConfigReq_Evt
{
    FsmEvent                        common;
    unifi_TrafficConfigType         trafficConfigType;
    unifi_TrafficConfig             config;
} UnifiSysTrafficConfigReq_Evt;

#define send_unifi_sys_traffic_config_req(context, pid, p_trafficConfigType, p_config) \
{ \
    UnifiSysTrafficConfigReq_Evt *evt = (UnifiSysTrafficConfigReq_Evt*) CsrPmalloc(sizeof(UnifiSysTrafficConfigReq_Evt)); \
    evt->trafficConfigType    = p_trafficConfigType; \
    evt->config               = p_config; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_TRAFFIC_CONFIG_REQ_ID); \
}

#define send_unifi_sys_traffic_config_req_external(context, pid, p_trafficConfigType, p_config) \
{ \
    UnifiSysTrafficConfigReq_Evt *evt = (UnifiSysTrafficConfigReq_Evt*) CsrPmalloc(sizeof(UnifiSysTrafficConfigReq_Evt)); \
    evt->trafficConfigType    = p_trafficConfigType; \
    evt->config               = p_config; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_TRAFFIC_CONFIG_REQ_ID); \
}

/* -------------------------- unifi_sys_traffic_protocol_ind -------------------------- */
typedef struct UnifiSysTrafficProtocolInd_Evt
{
    FsmEvent                        common;
    unifi_TrafficPacketType         packetType;
    unifi_ProtocolDirection         direction;
    unifi_MACAddress                srcAddress;
} UnifiSysTrafficProtocolInd_Evt;

#define send_unifi_sys_traffic_protocol_ind(context, pid, p_packetType, p_direction, p_srcAddress) \
{ \
    UnifiSysTrafficProtocolInd_Evt *evt = (UnifiSysTrafficProtocolInd_Evt*) CsrPmalloc(sizeof(UnifiSysTrafficProtocolInd_Evt)); \
    evt->packetType           = p_packetType; \
    evt->direction            = p_direction; \
    evt->srcAddress           = p_srcAddress; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_TRAFFIC_PROTOCOL_IND_ID); \
}

#define send_unifi_sys_traffic_protocol_ind_external(context, pid, p_packetType, p_direction, p_srcAddress) \
{ \
    UnifiSysTrafficProtocolInd_Evt *evt = (UnifiSysTrafficProtocolInd_Evt*) CsrPmalloc(sizeof(UnifiSysTrafficProtocolInd_Evt)); \
    evt->packetType           = p_packetType; \
    evt->direction            = p_direction; \
    evt->srcAddress           = p_srcAddress; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_TRAFFIC_PROTOCOL_IND_ID); \
}

/* -------------------------- unifi_sys_traffic_sample_ind -------------------------- */
typedef struct UnifiSysTrafficSampleInd_Evt
{
    FsmEvent                        common;
    unifi_TrafficStats              stats;
} UnifiSysTrafficSampleInd_Evt;

#define send_unifi_sys_traffic_sample_ind(context, pid, p_stats) \
{ \
    UnifiSysTrafficSampleInd_Evt *evt = (UnifiSysTrafficSampleInd_Evt*) CsrPmalloc(sizeof(UnifiSysTrafficSampleInd_Evt)); \
    evt->stats                = p_stats; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_TRAFFIC_SAMPLE_IND_ID); \
}

#define send_unifi_sys_traffic_sample_ind_external(context, pid, p_stats) \
{ \
    UnifiSysTrafficSampleInd_Evt *evt = (UnifiSysTrafficSampleInd_Evt*) CsrPmalloc(sizeof(UnifiSysTrafficSampleInd_Evt)); \
    evt->stats                = p_stats; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_TRAFFIC_SAMPLE_IND_ID); \
}

/* -------------------------- unifi_sys_wifi_off_req -------------------------- */
typedef struct UnifiSysWifiOffReq_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
} UnifiSysWifiOffReq_Evt;

#define send_unifi_sys_wifi_off_req(context, pid, p_appHandle) \
{ \
    UnifiSysWifiOffReq_Evt *evt = (UnifiSysWifiOffReq_Evt*) CsrPmalloc(sizeof(UnifiSysWifiOffReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_WIFI_OFF_REQ_ID); \
}

#define send_unifi_sys_wifi_off_req_external(context, pid, p_appHandle) \
{ \
    UnifiSysWifiOffReq_Evt *evt = (UnifiSysWifiOffReq_Evt*) CsrPmalloc(sizeof(UnifiSysWifiOffReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_WIFI_OFF_REQ_ID); \
}

/* -------------------------- unifi_sys_wifi_off_ind -------------------------- */
typedef struct UnifiSysWifiOffInd_Evt
{
    FsmEvent                        common;
    unifi_ControlIndication         controlIndication;
} UnifiSysWifiOffInd_Evt;

#define send_unifi_sys_wifi_off_ind(context, pid, p_controlIndication) \
{ \
    UnifiSysWifiOffInd_Evt *evt = (UnifiSysWifiOffInd_Evt*) CsrPmalloc(sizeof(UnifiSysWifiOffInd_Evt)); \
    evt->controlIndication    = p_controlIndication; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_WIFI_OFF_IND_ID); \
}

#define send_unifi_sys_wifi_off_ind_external(context, pid, p_controlIndication) \
{ \
    UnifiSysWifiOffInd_Evt *evt = (UnifiSysWifiOffInd_Evt*) CsrPmalloc(sizeof(UnifiSysWifiOffInd_Evt)); \
    evt->controlIndication    = p_controlIndication; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_WIFI_OFF_IND_ID); \
}

/* -------------------------- unifi_sys_wifi_off_rsp -------------------------- */
typedef struct UnifiSysWifiOffRsp_Evt
{
    FsmEvent                        common;
} UnifiSysWifiOffRsp_Evt;

#define send_unifi_sys_wifi_off_rsp(context, pid) \
{ \
    UnifiSysWifiOffRsp_Evt *evt = (UnifiSysWifiOffRsp_Evt*) CsrPmalloc(sizeof(UnifiSysWifiOffRsp_Evt)); \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_WIFI_OFF_RSP_ID); \
}

#define send_unifi_sys_wifi_off_rsp_external(context, pid) \
{ \
    UnifiSysWifiOffRsp_Evt *evt = (UnifiSysWifiOffRsp_Evt*) CsrPmalloc(sizeof(UnifiSysWifiOffRsp_Evt)); \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_WIFI_OFF_RSP_ID); \
}

/* -------------------------- unifi_sys_wifi_off_cfm -------------------------- */
typedef struct UnifiSysWifiOffCfm_Evt
{
    FsmEvent                        common;
} UnifiSysWifiOffCfm_Evt;

#define send_unifi_sys_wifi_off_cfm(context, pid) \
{ \
    UnifiSysWifiOffCfm_Evt *evt = (UnifiSysWifiOffCfm_Evt*) CsrPmalloc(sizeof(UnifiSysWifiOffCfm_Evt)); \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_WIFI_OFF_CFM_ID); \
}

#define send_unifi_sys_wifi_off_cfm_external(context, pid) \
{ \
    UnifiSysWifiOffCfm_Evt *evt = (UnifiSysWifiOffCfm_Evt*) CsrPmalloc(sizeof(UnifiSysWifiOffCfm_Evt)); \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_WIFI_OFF_CFM_ID); \
}

/* -------------------------- unifi_sys_wifi_on_req -------------------------- */
typedef struct UnifiSysWifiOnReq_Evt
{
    FsmEvent                        common;
    void*                           appHandle;
} UnifiSysWifiOnReq_Evt;

#define send_unifi_sys_wifi_on_req(context, pid, p_appHandle) \
{ \
    UnifiSysWifiOnReq_Evt *evt = (UnifiSysWifiOnReq_Evt*) CsrPmalloc(sizeof(UnifiSysWifiOnReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_WIFI_ON_REQ_ID); \
}

#define send_unifi_sys_wifi_on_req_external(context, pid, p_appHandle) \
{ \
    UnifiSysWifiOnReq_Evt *evt = (UnifiSysWifiOnReq_Evt*) CsrPmalloc(sizeof(UnifiSysWifiOnReq_Evt)); \
    evt->appHandle            = p_appHandle; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_WIFI_ON_REQ_ID); \
}

/* -------------------------- unifi_sys_wifi_on_ind -------------------------- */
typedef struct UnifiSysWifiOnInd_Evt
{
    FsmEvent                        common;
    unifi_Status                    status;
    unifi_DriverVersions            driverVersions;
} UnifiSysWifiOnInd_Evt;

#define send_unifi_sys_wifi_on_ind(context, pid, p_status, p_driverVersions) \
{ \
    UnifiSysWifiOnInd_Evt *evt = (UnifiSysWifiOnInd_Evt*) CsrPmalloc(sizeof(UnifiSysWifiOnInd_Evt)); \
    evt->status               = p_status; \
    evt->driverVersions       = p_driverVersions; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_WIFI_ON_IND_ID); \
}

#define send_unifi_sys_wifi_on_ind_external(context, pid, p_status, p_driverVersions) \
{ \
    UnifiSysWifiOnInd_Evt *evt = (UnifiSysWifiOnInd_Evt*) CsrPmalloc(sizeof(UnifiSysWifiOnInd_Evt)); \
    evt->status               = p_status; \
    evt->driverVersions       = p_driverVersions; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_WIFI_ON_IND_ID); \
}

/* -------------------------- unifi_sys_wifi_on_rsp -------------------------- */
typedef struct UnifiSysWifiOnRsp_Evt
{
    FsmEvent                        common;
    unifi_Status                    status;
    unifi_MACAddress                stationMacAddress;
    unifi_SmeVersions               smeVersions;
} UnifiSysWifiOnRsp_Evt;

#define send_unifi_sys_wifi_on_rsp(context, pid, p_status, p_stationMacAddress, p_smeVersions) \
{ \
    UnifiSysWifiOnRsp_Evt *evt = (UnifiSysWifiOnRsp_Evt*) CsrPmalloc(sizeof(UnifiSysWifiOnRsp_Evt)); \
    evt->status               = p_status; \
    evt->stationMacAddress    = p_stationMacAddress; \
    evt->smeVersions          = p_smeVersions; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_WIFI_ON_RSP_ID); \
}

#define send_unifi_sys_wifi_on_rsp_external(context, pid, p_status, p_stationMacAddress, p_smeVersions) \
{ \
    UnifiSysWifiOnRsp_Evt *evt = (UnifiSysWifiOnRsp_Evt*) CsrPmalloc(sizeof(UnifiSysWifiOnRsp_Evt)); \
    evt->status               = p_status; \
    evt->stationMacAddress    = p_stationMacAddress; \
    evt->smeVersions          = p_smeVersions; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_WIFI_ON_RSP_ID); \
}

/* -------------------------- unifi_sys_wifi_on_cfm -------------------------- */
typedef struct UnifiSysWifiOnCfm_Evt
{
    FsmEvent                        common;
    unifi_Status                    status;
} UnifiSysWifiOnCfm_Evt;

#define send_unifi_sys_wifi_on_cfm(context, pid, p_status) \
{ \
    UnifiSysWifiOnCfm_Evt *evt = (UnifiSysWifiOnCfm_Evt*) CsrPmalloc(sizeof(UnifiSysWifiOnCfm_Evt)); \
    evt->status               = p_status; \
    fsm_send_event(context, (FsmEvent*)evt, pid, UNIFI_SYS_WIFI_ON_CFM_ID); \
}

#define send_unifi_sys_wifi_on_cfm_external(context, pid, p_status) \
{ \
    UnifiSysWifiOnCfm_Evt *evt = (UnifiSysWifiOnCfm_Evt*) CsrPmalloc(sizeof(UnifiSysWifiOnCfm_Evt)); \
    evt->status               = p_status; \
    fsm_send_event_external(context, (FsmEvent*)evt, pid, UNIFI_SYS_WIFI_ON_CFM_ID); \
}





#ifdef __cplusplus
}
#endif

#endif /* SME_XML_SIGNALS_H */
