/* This is an autogenerated file */
/* Tag: noCheckHeader */
/*    Copyright (C) Cambridge Silicon Radio Ltd 2009. All rights reserved. */
/* */
/*   Refer to LICENSE.txt included with this source for details on the */
/*   license terms. */

#ifndef SME_XML_TYPES_H
#define SME_XML_TYPES_H

#ifdef __cplusplus
extern "C" {
#endif

typedef enum unifi_80211NetworkType
{
    unifi_80211DS                                           = 0x00,
    unifi_80211OFDM24                                       = 0x01,
    unifi_80211OFDM5                                        = 0x02,
    unifi_80211Auto                                         = 0x03
} unifi_80211NetworkType;

typedef enum unifi_80211PrivacyMode
{
    unifi_80211PrivacyDisabled                              = 0x00,
    unifi_80211PrivacyEnabled                               = 0x01
} unifi_80211PrivacyMode;

typedef enum unifi_80211dTrustLevel
{
    unifi_TrustStrict                                       = 0x01,
    unifi_TrustAdjunct                                      = 0x02,
    unifi_TrustBSS                                          = 0x03,
    unifi_TrustIBSS                                         = 0x04,
    unifi_TrustMIB                                          = 0x05,
    unifi_TrustDisabled                                     = 0x06
} unifi_80211dTrustLevel;

typedef enum unifi_AppValueId
{
    unifi_StationMACAddressValue                            = 0x00,
    unifi_PermanentMACAddressValue                          = 0x01,
    unifi_CalibrationDataValue                              = 0x02,
    unifi_ConnectionConfigValue                             = 0x03,
    unifi_AdHocConfigValue                                  = 0x04,
    unifi_ConnectionInfoValue                               = 0x05,
    unifi_ConnectionStatsValue                              = 0x06,
    unifi_CoexConfigValue                                   = 0x07,
    unifi_CoexInfoValue                                     = 0x08,
    unifi_ScanConfigValue                                   = 0x09,
    unifi_PowerConfigValue                                  = 0x0A,
    unifi_VersionsValue                                     = 0x0B,
    unifi_SmeConfigValue                                    = 0x0C,
    unifi_HostConfigValue                                   = 0x0D,
    unifi_MibConfigValue                                    = 0x0E,
    unifi_RoamingConfigValue                                = 0x0F,
    unifi_CcxConfigValue                                    = 0x10,
    unifi_RegulatoryDomainInfoValue                         = 0x11,
    unifi_LinkQualityValue                                  = 0x12,
    unifi_CloakedSsidConfigValue                            = 0x13
} unifi_AppValueId;

typedef enum unifi_AuthMode
{
    unifi_80211AuthOpen                                     = 0x0001,
    unifi_80211AuthShared                                   = 0x0002,
    unifi_8021xAuthWPA                                      = 0x0004,
    unifi_8021xAuthWPAPSK                                   = 0x0008,
    unifi_8021xAuthWPA2                                     = 0x0010,
    unifi_8021xAuthWPA2PSK                                  = 0x0020,
    unifi_WAPIAuthWAI                                       = 0x0040,
    unifi_WAPIAuthWAIPSK                                    = 0x0080,
    unifi_8021xAuthOther1x                                  = 0x0100
} unifi_AuthMode;

typedef enum unifi_BSSType
{
    unifi_Infrastructure                                    = 0x00,
    unifi_Adhoc                                             = 0x01,
    unifi_AnyBss                                            = 0x02
} unifi_BSSType;

typedef enum unifi_BasicUsability
{
    unifi_Unusable                                          = 0x00,
    unifi_Poor                                              = 0x01,
    unifi_Satisfactory                                      = 0x02,
    unifi_NotConnected                                      = 0x03
} unifi_BasicUsability;

typedef enum unifi_BtDeviceLogicalChannels
{
    unifi_BtDeviceLogicalChannelNone                        = 0x0000,
    unifi_BtDeviceLogicalChannelData                        = 0x0001,
    unifi_BtDeviceLogicalChannelControl                     = 0x0002,
    unifi_BtDeviceLogicalChannelGarrenteed                  = 0x0004
} unifi_BtDeviceLogicalChannels;

typedef enum unifi_BtDeviceMode
{
    unifi_BtDeviceActive                                    = 0x00,
    unifi_BtDevicePark                                      = 0x01,
    unifi_BtDeviceSniff                                     = 0x02
} unifi_BtDeviceMode;

typedef enum unifi_BtDeviceRole
{
    unifi_BtDeviceMaster                                    = 0x00,
    unifi_BtDeviceSlave                                     = 0x01
} unifi_BtDeviceRole;

typedef enum unifi_CoexDirection
{
    unifi_CoexDirectionDot11Input                           = 0x01,
    unifi_CoexDirectionDot11Output                          = 0x02
} unifi_CoexDirection;

typedef enum unifi_CoexScheme
{
    unifi_CoexSchemeDisabled                                = 0x00,
    unifi_CoexSchemeCSR                                     = 0x01,
    unifi_CoexSchemeCSRChannel                              = 0x02,
    unifi_CoexSchemePTA                                     = 0x03
} unifi_CoexScheme;

typedef enum unifi_ControlIndication
{
    unifi_ControlError                                      = 0x01,
    unifi_ControlExit                                       = 0x02
} unifi_ControlIndication;

typedef enum unifi_D3AutoScanMode
{
    unifi_PSOn                                              = 0x00,
    unifi_PSOff                                             = 0x01,
    unifi_PSAuto                                            = 0x02
} unifi_D3AutoScanMode;

typedef enum unifi_EapolRc
{
    unifi_EapolRcSuccess                                    = 0x0000,
    unifi_EapolRcUnspecifiedFailure                         = 0x0001,
    unifi_EapolRcRefusedCapabilitiesMismatch                = 0x000a,
    unifi_EapolRcReassociationDeniedNoAssociation           = 0x000b,
    unifi_EapolRcRefusedExternalReason                      = 0x000c,
    unifi_EapolRcRefusedAuthenticationMismatch              = 0x000d,
    unifi_EapolRcRefusedInvalidAuthenticationSequenceNumber = 0x000e,
    unifi_EapolRcRefusedChallengeFailure                    = 0x000f,
    unifi_EapolRcRefusedAuthenticationTimeout               = 0x0010,
    unifi_EapolRcRefusedApOutOfMemory                       = 0x0011,
    unifi_EapolRcRefusedBasicRatesMismatch                  = 0x0012,
    unifi_EapolRcRefusedShortPreambleRequired               = 0x0013,
    unifi_EapolRcRefusedPbccModulationRequired              = 0x0014,
    unifi_EapolRcRefusedChannelAgilityRequired              = 0x0015,
    unifi_EapolRcRefusedSpectrumManagementRequired          = 0x0016,
    unifi_EapolRcRefusedPowerCapabilityUnacceptable         = 0x0017,
    unifi_EapolRcRefusedSupportedChannelsUnacceptable       = 0x0018,
    unifi_EapolRcRefusedShortSlotRequired                   = 0x0019,
    unifi_EapolRcRefusedDsssOfdmRequired                    = 0x001a,
    unifi_EapolRcRefusedNoHtSupport                         = 0x001b,
    unifi_EapolRcR0KhUnreachable                            = 0x001c,
    unifi_EapolRcRefusedPcoTransitionSupport                = 0x001d,
    unifi_EapolRcAssociationRequestRejectedTemporarily      = 0x001e,
    unifi_EapolRcRobustManagementFramePolicyViolation       = 0x001f,
    unifi_EapolRcFailure                                    = 0x0020,
    unifi_EapolRcRefusedApBandwidthInsufficient             = 0x0021,
    unifi_EapolRcRefusedPoorOperatingChannel                = 0x0022,
    unifi_EapolRcRefusedQosRequired                         = 0x0023,
    unifi_EapolRcRefused                                    = 0x0025,
    unifi_EapolRcRefusedReasonUnspecified                   = 0x0025,
    unifi_EapolRcInvalidParameters                          = 0x0026,
    unifi_EapolRcRejectedWithSuggestedTspecChanges          = 0x0027,
    unifi_EapolRcRejectedInvalidIe                          = 0x0028,
    unifi_EapolRcRejectedInvalidGroupCipher                 = 0x0029,
    unifi_EapolRcRejectedInvalidPairwiseCipher              = 0x002a,
    unifi_EapolRcRejectedInvalidAkmp                        = 0x002b,
    unifi_EapolRcRejectedUnsupportedRsnVersion              = 0x002c,
    unifi_EapolRcRejectedInvalidRsnCapability               = 0x002d,
    unifi_EapolRcRejectedSecurityPolicy                     = 0x002e,
    unifi_EapolRcRejectedForDelayPeriod                     = 0x002f,
    unifi_EapolRcNotAllowed                                 = 0x0030,
    unifi_EapolRcNotPresent                                 = 0x0031,
    unifi_EapolRcNotQsta                                    = 0x0032,
    unifi_EapolRcRejectedListenIntervalTooLarge             = 0x0033,
    unifi_EapolRcInvalidFtActionFrameCount                  = 0x0034,
    unifi_EapolRcInvalidPmkid                               = 0x0035,
    unifi_EapolRcInvalidMdie                                = 0x0036,
    unifi_EapolRcInvalidFtie                                = 0x0037,
    unifi_EapolRcUnspecifiedQosFailure                      = 0x00c8,
    unifi_EapolRcWrongPolicy                                = 0x00c9,
    unifi_EapolRcInsufficientBandwidth                      = 0x00ca,
    unifi_EapolRcInvalidTspecParameters                     = 0x00cb,
    unifi_EapolRcTimeout                                    = 0x8000,
    unifi_EapolRcTooManySimultaneousRequests                = 0x8001,
    unifi_EapolRcBssAlreadyStartedOrJoined                  = 0x8002,
    unifi_EapolRcNotSupported                               = 0x8003,
    unifi_EapolRcTransmissionFailure                        = 0x8004,
    unifi_EapolRcRefusedNotAuthenticated                    = 0x8005,
    unifi_EapolRcResetRequiredBeforeStart                   = 0x8006,
    unifi_EapolRcLmInfoUnavailable                          = 0x8007,
    unifi_EapolRcInvalidUnicastCipher                       = 0xf02f,
    unifi_EapolRcInvalidMulticastCipher                     = 0xf030,
    unifi_EapolRcUnsupportedWapiIeVersion                   = 0xf031,
    unifi_EapolRcInvalidWapiCapabilityIe                    = 0xf032
} unifi_EapolRc;

typedef enum unifi_Encapsulation
{
    unifi_Ethernet                                          = 0x00,
    unifi_Llc_Snap                                          = 0x01
} unifi_Encapsulation;

typedef enum unifi_EncryptionMode
{
    unifi_EncryptionCipherNone                              = 0x0000,
    unifi_EncryptionCipherPairwiseWep40                     = 0x0001,
    unifi_EncryptionCipherPairwiseWep104                    = 0x0002,
    unifi_EncryptionCipherPairwiseTkip                      = 0x0004,
    unifi_EncryptionCipherPairwiseCcmp                      = 0x0008,
    unifi_EncryptionCipherPairwiseSms4                      = 0x0010,
    unifi_EncryptionCipherGroupWep40                        = 0x0020,
    unifi_EncryptionCipherGroupWep104                       = 0x0040,
    unifi_EncryptionCipherGroupTkip                         = 0x0080,
    unifi_EncryptionCipherGroupCcmp                         = 0x0100,
    unifi_EncryptionCipherGroupSms4                         = 0x0200
} unifi_EncryptionMode;

typedef enum unifi_FirmwareDriverInterface
{
    unifi_UnitDataInterface                                 = 0x00,
    unifi_PacketInterface                                   = 0x01
} unifi_FirmwareDriverInterface;

typedef enum unifi_HostPowerMode
{
    unifi_HostActive                                        = 0x00,
    unifi_HostPowersave                                     = 0x01,
    unifi_HostFullPowersave                                 = 0x02
} unifi_HostPowerMode;

typedef enum unifi_IEEE80211Reason
{
    unifi_IEEE80211ReasonSuccess                            = 0x0000,
    unifi_IEEE80211ReasonUnspecifiedReason                  = 0x0001,
    unifi_IEEE80211ReasonAuthenticationNotValid             = 0x0002,
    unifi_IEEE80211ReasonDeauthenticatedLeaveBss            = 0x0003,
    unifi_IEEE80211ReasonDisassociatedInactivity            = 0x0004,
    unifi_IEEE80211ReasonApOverload                         = 0x0005,
    unifi_IEEE80211ReasonClass2FrameError                   = 0x0006,
    unifi_IEEE80211ReasonClass3FrameError                   = 0x0007,
    unifi_IEEE80211ReasonDisassociatedLeaveBss              = 0x0008,
    unifi_IEEE80211ReasonAssociationNotAuthenticated        = 0x0009,
    unifi_IEEE80211ReasonDisassociatedPowerCapability       = 0x000a,
    unifi_IEEE80211ReasonDisassociatedSupportedChannels     = 0x000b,
    unifi_IEEE80211ReasonInvalidInformationElement          = 0x000d,
    unifi_IEEE80211ReasonMichaelMicFailure                  = 0x000e,
    unifi_IEEE80211ReasonFourwayHandshakeTimeout            = 0x000f,
    unifi_IEEE80211ReasonGroupKeyUpdateTimeout              = 0x0010,
    unifi_IEEE80211ReasonHandshakeElementDifferent          = 0x0011,
    unifi_IEEE80211ReasonInvalidGroupCipher                 = 0x0012,
    unifi_IEEE80211ReasonInvalidPairwiseCipher              = 0x0013,
    unifi_IEEE80211ReasonInvalidAkmp                        = 0x0014,
    unifi_IEEE80211ReasonUnsupportedRsnIEVersion            = 0x0015,
    unifi_IEEE80211ReasonInvalidRsnIECapabilities           = 0x0016,
    unifi_IEEE80211ReasonDot1XAuthFailed                    = 0x0017,
    unifi_IEEE80211ReasonCipherRejectedByPolicy             = 0x0018,
    unifi_IEEE80211ReasonServiceChangePrecludesTs           = 0x001F,
    unifi_IEEE80211ReasonQoSUnspecifiedReason               = 0x0020,
    unifi_IEEE80211ReasonQoSInsufficientBandwidth           = 0x0021,
    unifi_IEEE80211ReasonQoSExcessiveNotAck                 = 0x0022,
    unifi_IEEE80211ReasonQoSTXOPLimitExceeded               = 0x0023,
    unifi_IEEE80211ReasonQstaLeaving                        = 0x0024,
    unifi_IEEE80211ReasonEndDls                             = 0x0025,
    unifi_IEEE80211ReasonEndTs                              = 0x0025,
    unifi_IEEE80211ReasonEndBa                              = 0x0025,
    unifi_IEEE80211ReasonUnknownTs                          = 0x0026,
    unifi_IEEE80211ReasonUnknownDls                         = 0x0026,
    unifi_IEEE80211ReasonUnknownBa                          = 0x0026,
    unifi_IEEE80211ReasonTimeout                            = 0x0027,
    unifi_IEEE80211ReasonSTAKeyMismatch                     = 0x002d,
    unifi_IEEE80211ReasonUnicastKeyNegotiationTimeout       = 0xf019,
    unifi_IEEE80211ReasonMulticastKeyAnnouncementTimeout    = 0xf01a,
    unifi_IEEE80211ReasonIncompatibleUnicastKeyNegotiationIe = 0xf01b,
    unifi_IEEE80211ReasonInvalidMulticastCipher             = 0xf01c,
    unifi_IEEE80211ReasonInvalidUnicastCipher               = 0xf01d,
    unifi_IEEE80211ReasonUnsupportedWapiIeVersion           = 0xf01e,
    unifi_IEEE80211ReasonInvalidWapiCapabilityIe            = 0xf01f,
    unifi_IEEE80211ReasonWaiCertificateAuthenticationFailed = 0xf020
} unifi_IEEE80211Reason;

typedef enum unifi_IEEE80211Result
{
    unifi_IEEE80211ResultSuccess                            = 0x0000,
    unifi_IEEE80211ResultUnspecifiedFailure                 = 0x0001,
    unifi_IEEE80211ResultRefusedCapabilitiesMismatch        = 0x000a,
    unifi_IEEE80211ResultReassociationDeniedNoAssociation   = 0x000b,
    unifi_IEEE80211ResultRefusedExternalReason              = 0x000c,
    unifi_IEEE80211ResultRefusedAuthenticationMismatch      = 0x000d,
    unifi_IEEE80211ResultRefusedInvalidAuthenticationSequenceNumber = 0x000e,
    unifi_IEEE80211ResultRefusedChallengeFailure            = 0x000f,
    unifi_IEEE80211ResultRefusedAuthenticationTimeout       = 0x0010,
    unifi_IEEE80211ResultRefusedApOutOfMemory               = 0x0011,
    unifi_IEEE80211ResultRefusedBasicRatesMismatch          = 0x0012,
    unifi_IEEE80211ResultRefusedShortPreambleRequired       = 0x0013,
    unifi_IEEE80211ResultRefusedPbccModulationRequired      = 0x0014,
    unifi_IEEE80211ResultRefusedChannelAgilityRequired      = 0x0015,
    unifi_IEEE80211ResultRefusedSpectrumManagementRequired  = 0x0016,
    unifi_IEEE80211ResultRefusedPowerCapabilityUnacceptable = 0x0017,
    unifi_IEEE80211ResultRefusedSupportedChannelsUnacceptable = 0x0018,
    unifi_IEEE80211ResultRefusedShortSlotRequired           = 0x0019,
    unifi_IEEE80211ResultRefusedDsssOFDMRequired            = 0x001a,
    unifi_IEEE80211ResultRefusedNoHtSupport                 = 0x001b,
    unifi_IEEE80211ResultR0KhUnreachable                    = 0x001c,
    unifi_IEEE80211ResultRefusedPcoTransitionSupport        = 0x001d,
    unifi_IEEE80211ResultAssociationRequestRejectedTemporarily = 0x001e,
    unifi_IEEE80211ResultRobustManagementFramePolicyViolation = 0x001f,
    unifi_IEEE80211ResultFailure                            = 0x0020,
    unifi_IEEE80211ResultRefusedApBandwidthInsufficient     = 0x0021,
    unifi_IEEE80211ResultRefusedPoorOperatingChannel        = 0x0022,
    unifi_IEEE80211ResultRefusedQosRequired                 = 0x0023,
    unifi_IEEE80211ResultRefused                            = 0x0025,
    unifi_IEEE80211ResultRefusedReasonUnspecified           = 0x0025,
    unifi_IEEE80211ResultInvalidParameters                  = 0x0026,
    unifi_IEEE80211ResultRejectedWithSuggestedTspecChanges  = 0x0027,
    unifi_IEEE80211ResultRejectedInvalidIe                  = 0x0028,
    unifi_IEEE80211ResultRejectedInvalidGroupCipher         = 0x0029,
    unifi_IEEE80211ResultRejectedInvalidPairwiseCipher      = 0x002a,
    unifi_IEEE80211ResultRejectedInvalidAkmp                = 0x002b,
    unifi_IEEE80211ResultRejectedUnsupportedRsnVersion      = 0x002c,
    unifi_IEEE80211ResultRejectedInvalidRsnCapability       = 0x002d,
    unifi_IEEE80211ResultRejectedSecurityPolicy             = 0x002e,
    unifi_IEEE80211ResultRejectedForDelayPeriod             = 0x002f,
    unifi_IEEE80211ResultNotAllowed                         = 0x0030,
    unifi_IEEE80211ResultNotPresent                         = 0x0031,
    unifi_IEEE80211ResultNotQsta                            = 0x0032,
    unifi_IEEE80211ResultRejectedListenIntervalTooLarge     = 0x0033,
    unifi_IEEE80211ResultInvalidFtActionFrameCount          = 0x0034,
    unifi_IEEE80211ResultInvalidPmkid                       = 0x0035,
    unifi_IEEE80211ResultInvalidMdie                        = 0x0036,
    unifi_IEEE80211ResultInvalidFtie                        = 0x0037,
    unifi_IEEE80211ResultUnspecifiedQosFailure              = 0x00c8,
    unifi_IEEE80211ResultWrongPolicy                        = 0x00c9,
    unifi_IEEE80211ResultInsufficientBandwidth              = 0x00ca,
    unifi_IEEE80211ResultInvalidTspecParameters             = 0x00cb,
    unifi_IEEE80211ResultTimeout                            = 0x8000,
    unifi_IEEE80211ResultTooManySimultaneousRequests        = 0x8001,
    unifi_IEEE80211ResultBssAlreadyStartedOrJoined          = 0x8002,
    unifi_IEEE80211ResultNotSupported                       = 0x8003,
    unifi_IEEE80211ResultTransmissionFailure                = 0x8004,
    unifi_IEEE80211ResultRefusedNotAuthenticated            = 0x8005,
    unifi_IEEE80211ResultResetRequiredBeforeStart           = 0x8006,
    unifi_IEEE80211ResultLmInfoUnavailable                  = 0x8007,
    unifi_IEEE80211ResultInvalidUnicastCipher               = 0xf02f,
    unifi_IEEE80211ResultInvalidMulticastCipher             = 0xf030,
    unifi_IEEE80211ResultUnsupportedWapiIeVersion           = 0xf031,
    unifi_IEEE80211ResultInvalidWapiCapabilityIe            = 0xf032
} unifi_IEEE80211Result;

typedef enum unifi_IndicationsMask
{
    unifi_IndNone                                           = 0x00000000,
    unifi_IndWifiOff                                        = 0x00000001,
    unifi_IndScanResult                                     = 0x00000002,
    unifi_IndConnectionQuality                              = 0x00000004,
    unifi_IndMediaStatus                                    = 0x00000008,
    unifi_IndMicFailure                                     = 0x00000010,
    unifi_IndPmkidCandidateList                             = 0x00000020,
    unifi_IndTspec                                          = 0x00000040,
    unifi_IndRoamStart                                      = 0x00000080,
    unifi_IndRoamComplete                                   = 0x00000100,
    unifi_IndAssociationStart                               = 0x00000200,
    unifi_IndAssociationComplete                            = 0x00000400,
    unifi_IndIbssStation                                    = 0x00000800,
    unifi_IndAll                                            = 0x7FFFFFFF
} unifi_IndicationsMask;

typedef enum unifi_KeyType
{
    unifi_GroupKey                                          = 0x00,
    unifi_PairwiseKey                                       = 0x01
} unifi_KeyType;

typedef enum unifi_ListAction
{
    unifi_ListActionGet                                     = 0x00,
    unifi_ListActionAdd                                     = 0x01,
    unifi_ListActionRemove                                  = 0x02,
    unifi_ListActionFlush                                   = 0x03
} unifi_ListAction;

typedef enum unifi_LowPowerMode
{
    unifi_LowPowerDisabled                                  = 0x0000,
    unifi_LowPowerEnabled                                   = 0x0001
} unifi_LowPowerMode;

typedef enum unifi_MediaStatus
{
    unifi_MediaConnected                                    = 0x00,
    unifi_MediaDisconnected                                 = 0x01
} unifi_MediaStatus;

typedef enum unifi_MediaTypeMask
{
    unifi_MediaTypeNone                                     = 0x00000000,
    unifi_MediaType80211                                    = 0x00000001,
    unifi_MediaTypeAmp                                      = 0x00000002
} unifi_MediaTypeMask;

typedef enum unifi_PacketFilterMode
{
    unifi_PacketFilterModeOptOut                            = 0x00,
    unifi_PacketFilterModeOptIn                             = 0x03
} unifi_PacketFilterMode;

typedef enum unifi_PortAction
{
    unifi_8021xPortOpen                                     = 0x0000,
    unifi_8021xPortClosedDiscard                            = 0x0001,
    unifi_8021xPortClosedBlock                              = 0x0002
} unifi_PortAction;

typedef enum unifi_PowerSaveLevel
{
    unifi_PowerSaveLow                                      = 0x00,
    unifi_PowerSaveHigh                                     = 0x01,
    unifi_PowerSaveMed                                      = 0x02,
    unifi_PowerSaveAuto                                     = 0x03
} unifi_PowerSaveLevel;

typedef enum unifi_Priority
{
    unifi_PriorityQosUp0                                    = 0x0000,
    unifi_PriorityQosUp1                                    = 0x0001,
    unifi_PriorityQosUp2                                    = 0x0002,
    unifi_PriorityQosUp3                                    = 0x0003,
    unifi_PriorityQosUp4                                    = 0x0004,
    unifi_PriorityQosUp5                                    = 0x0005,
    unifi_PriorityQosUp6                                    = 0x0006,
    unifi_PriorityQosUp7                                    = 0x0007,
    unifi_PriorityQosTsid0                                  = 0x0008,
    unifi_PriorityQosTsid1                                  = 0x0009,
    unifi_PriorityQosTsid2                                  = 0x000a,
    unifi_PriorityQosTsid3                                  = 0x000b,
    unifi_PriorityQosTsid4                                  = 0x000c,
    unifi_PriorityQosTsid5                                  = 0x000d,
    unifi_PriorityQosTsid6                                  = 0x000e,
    unifi_PriorityQosTsid7                                  = 0x000f,
    unifi_PriorityContention                                = 0x8000,
    unifi_PriorityContentionFree                            = 0x8001
} unifi_Priority;

typedef enum unifi_ProtocolDirection
{
    unifi_TrafficRx                                         = 0x0000,
    unifi_TrafficTx                                         = 0x0001
} unifi_ProtocolDirection;

typedef enum unifi_QoSControl
{
    unifi_QoSOff                                            = 0x0000,
    unifi_QoSWMMOn                                          = 0x0001
} unifi_QoSControl;

typedef enum unifi_RadioIF
{
    unifi_GHZ_2_4                                           = 0x01,
    unifi_GHZ_5_0                                           = 0x02,
    unifi_GHZ_Both                                          = 0x03
} unifi_RadioIF;

typedef enum unifi_ReceptionStatus
{
    unifi_ReceptionStatusRxSuccess                          = 0x0000,
    unifi_ReceptionStatusRxFailure                          = 0x0001
} unifi_ReceptionStatus;

typedef enum unifi_RegulatoryDomain
{
    unifi_RegulatoryDomainOther                             = 0x00,
    unifi_RegulatoryDomainFcc                               = 0x10,
    unifi_RegulatoryDomainIc                                = 0x20,
    unifi_RegulatoryDomainEtsi                              = 0x30,
    unifi_RegulatoryDomainSpain                             = 0x31,
    unifi_RegulatoryDomainFrance                            = 0x32,
    unifi_RegulatoryDomainJapan                             = 0x40,
    unifi_RegulatoryDomainJapanBis                          = 0x41,
    unifi_RegulatoryDomainChina                             = 0x50,
    unifi_RegulatoryDomainChinaBis                          = 0x51,
    unifi_RegulatoryDomainNone                              = 0xFF
} unifi_RegulatoryDomain;

typedef enum unifi_RoamReason
{
    unifi_RoamBeaconLost                                    = 0x00,
    unifi_RoamDisassociated                                 = 0x01,
    unifi_RoamDeauthenticated                               = 0x02,
    unifi_RoamBetterAPFound                                 = 0x03
} unifi_RoamReason;

typedef enum unifi_ScanType
{
    unifi_ScanAll                                           = 0x00,
    unifi_ScanActive                                        = 0x01,
    unifi_ScanPassive                                       = 0x02
} unifi_ScanType;

typedef enum unifi_ServiceClass
{
    unifi_ServiceClassReorderableMulticast                  = 0x0000,
    unifi_ServiceClassStrictlyOrdered                       = 0x0001,
    unifi_ServiceClassQosAck                                = 0x0002,
    unifi_ServiceClassQosNo_Ack                             = 0x0003,
    unifi_ServiceClassQosLocalMulticast                     = 0x0004
} unifi_ServiceClass;

typedef enum unifi_Status
{
    unifi_Success                                           = 0x00,
    unifi_Error                                             = 0x01,
    unifi_NotFound                                          = 0x02,
    unifi_TimedOut                                          = 0x03,
    unifi_Cancelled                                         = 0x04,
    unifi_InvalidParameter                                  = 0x05,
    unifi_NoRoom                                            = 0x06,
    unifi_Unsupported                                       = 0x07,
    unifi_Unavailable                                       = 0x08,
    unifi_WifiOff                                           = 0x09,
    unifi_Restricted                                        = 0x10,
    unifi_SecurityError                                     = 0x11
} unifi_Status;

typedef enum unifi_SubscriptionResult
{
    unifi_SubscriptionResultSuccess                         = 0x00,
    unifi_SubscriptionResultError                           = 0x01,
    unifi_SubscriptionResultErrorProtocolTableFull          = 0x02,
    unifi_SubscriptionResultErrorCouldNotFindEntry          = 0x03,
    unifi_SubscriptionResultErrorUnsupportedEncapsulation   = 0x04,
    unifi_SubscriptionResultErrorUndefinedEntry             = 0x05,
    unifi_SubscriptionResultErrorMediaDisconnected          = 0x06
} unifi_SubscriptionResult;

typedef enum unifi_TrafficConfigType
{
    unifi_TrafficConfigReset                                = 0x0000,
    unifi_TrafficConfigFilter                               = 0x0001,
    unifi_TrafficConfigCLS                                  = 0x0002
} unifi_TrafficConfigType;

typedef enum unifi_TrafficPacketType
{
    unifi_TrafficPacketNone                                 = 0x0000,
    unifi_TrafficPacketEapol                                = 0x0001,
    unifi_TrafficPacketDhcp                                 = 0x0002,
    unifi_TrafficPacketDhcpAck                              = 0x0004,
    unifi_TrafficPacketArp                                  = 0x0008,
    unifi_TrafficPacketAironet                              = 0x0010,
    unifi_TrafficPacketCustom                               = 0x0020,
    unifi_TrafficPacketAll                                  = 0x00FF
} unifi_TrafficPacketType;

typedef enum unifi_TrafficType
{
    unifi_TrafficOccasional                                 = 0x00,
    unifi_TrafficBursty                                     = 0x01,
    unifi_TrafficPeriodic                                   = 0x02,
    unifi_TrafficContinuous                                 = 0x03
} unifi_TrafficType;

typedef enum unifi_TransmissionStatus
{
    unifi_TransmissionStatusSuccessful                      = 0x0000,
    unifi_TransmissionStatusRetryLimit                      = 0x0001,
    unifi_TransmissionStatusTxLifetime                      = 0x0002,
    unifi_TransmissionStatusNoBss                           = 0x0003,
    unifi_TransmissionStatusExcessiveDataLength             = 0x0004,
    unifi_TransmissionStatusNonNullSourceRouting            = 0x0005,
    unifi_TransmissionStatusUnsupportedPriority             = 0x0006,
    unifi_TransmissionStatusUnavailablePriority             = 0x0007,
    unifi_TransmissionStatusUnsupportedServiceClass         = 0x0008,
    unifi_TransmissionStatusUnavailableServiceClass         = 0x0009,
    unifi_TransmissionStatusUnavailableKeyMapping           = 0x000a,
    unifi_TransmissionStatusTxEdcaTimeout                   = 0x000b,
    unifi_TransmissionStatusBlock_AckTimeout                = 0x000c
} unifi_TransmissionStatus;

typedef enum unifi_TspecCtrlMask
{
    unifi_TspecCtrlMask_Strict                              = 0x01,
    unifi_TspecCtrlMask_CCX_Signalling                      = 0x02,
    unifi_TspecCtrlMask_CCX_Voice                           = 0x04
} unifi_TspecCtrlMask;

typedef enum unifi_TspecResultCode
{
    unifi_TspecResultSuccess                                = 0x00,
    unifi_TspecResultUnspecifiedFailure                     = 0x01,
    unifi_TspecResultFailure                                = 0x02,
    unifi_TspecResultRefusedReasonUnspecified               = 0x03,
    unifi_TspecResultRefused                                = 0x04,
    unifi_TspecResultInvalidTspecParameters                 = 0x05,
    unifi_TspecResultInvalidTclasParameters                 = 0x06,
    unifi_TspecResultInsufficientBandwidth                  = 0x07,
    unifi_TspecResultWrongPolicy                            = 0x08,
    unifi_TspecResultRejectedWithSuggestedChanges           = 0x09,
    unifi_TspecResultRejectedForDelayPeriod                 = 0x0A,
    unifi_TspecResultNotAllowed                             = 0x0B,
    unifi_TspecResultNotPresent                             = 0x0C,
    unifi_TspecResultTimeout                                = 0x0D,
    unifi_TspecResultNotSupported                           = 0x0E,
    unifi_TspecResultAcmMismatch                            = 0x0F,
    unifi_TspecResultIeLengthIncorrect                      = 0x10,
    unifi_TspecResultInvalidTransactionID                   = 0x11,
    unifi_TspecResultInstalled                              = 0x12,
    unifi_TspecResultTidAlreadyInstalled                    = 0x13,
    unifi_TspecResultTspecRemotelyDeleted                   = 0x14
} unifi_TspecResultCode;

typedef enum unifi_WmmMode
{
    unifi_WmmDisabled                                       = 0x00,
    unifi_WmmACEnabled                                      = 0x01,
    unifi_WmmPSEnabled                                      = 0x02,
    unifi_WmmSAEnabled                                      = 0x04,
    unifi_WmmEnabled                                        = 0xFF
} unifi_WmmMode;

typedef enum unifi_WmmQosInfoMask
{
    unifi_WmmAcMaxSpAll                                     = 0x00,
    unifi_WmmAcVo                                           = 0x01,
    unifi_WmmAcVi                                           = 0x02,
    unifi_WmmAcBk                                           = 0x04,
    unifi_WmmAcBe                                           = 0x08,
    unifi_WmmAcMaxSpTwo                                     = 0x20,
    unifi_WmmAcMaxSpFour                                    = 0x40,
    unifi_WmmAcMaxSpSix                                     = 0x60
} unifi_WmmQosInfoMask;



#define UNIFI_SAP_API_VERSION_MINOR                        209
#define UNIFI_SAP_API_VERSION_MAJOR                        6
#define UNIFI_SME_APPHANDLE                                0
#define UNIFI_PALDATA_APPHANDLE                            1
#define UNIFI_SIGNAL_STRENGTH_MAX                          10
#define UNIFI_PMKID_LIST_MAX                               10
#define UNIFI_NETWORK_USEFULNESS_MAX                       10
#define UNIFI_WEP128_KEY_MAX_OCTETS                        13
#define UNIFI_PMKID_KEY_SIZE                               16
#define UNIFI_NME_APPHANDLE                                2
#define UNIFI_SCAN_RESULTS_MAX                             25
#define UNIFI_NETWORK_PROVIDER_NAME_MAX_OCTETS             32
#define UNIFI_SSID_MAX_OCTETS                              32
#define UNIFI_MLME_COMMAND_MAX_OCTETS                      32
#define UNIFI_IPADDRESSV4_BIN_OCTETS                       4
#define UNIFI_WEP64_KEY_MAX_OCTETS                         5
#define UNIFI_SSID_LIST_MAX_OCTETS                         5
#define UNIFI_MAC_ADDRESS_BIN_OCTETS                       6
#define UNIFI_PMKID_CANDIDATES_MAX                         8


typedef void (*unifi_FrameFreeFunction)(void *frame);



typedef struct unifi_AdHocConfig
{
    CsrUint16                       atimWindowTu;
    CsrUint16                       beaconPeriodTu;
    CsrUint16                       joinOnlyAttempts;
    CsrUint16                       joinAttemptIntervalMs;
} unifi_AdHocConfig;

typedef struct unifi_CcxConfig
{
    CsrUint8                        keepAliveTimeMs;
    CsrBool                         apRoamingEnabled;
    CsrUint8                        measurementsMask;
    CsrBool                         ccxRadioMgtEnabled;
} unifi_CcxConfig;

typedef struct unifi_ConnectionStats
{
    CsrUint8                        unifiTxDataRate;
    CsrUint8                        unifiRxDataRate;
    CsrUint32                       dot11RetryCount;
    CsrUint32                       dot11MultipleRetryCount;
    CsrUint32                       dot11AckFailureCount;
    CsrUint32                       dot11FrameDuplicateCount;
    CsrUint32                       dot11FcsErrorCount;
    CsrUint32                       dot11RtsSuccessCount;
    CsrUint32                       dot11RtsFailureCount;
    CsrUint32                       dot11FailedCount;
    CsrUint32                       dot11TransmittedFragmentCount;
    CsrUint32                       dot11TransmittedFrameCount;
    CsrUint32                       dot11WEPExcludedCount;
    CsrUint32                       dot11WEPICVErrorCount;
    CsrUint32                       dot11WEPUndecryptableCount;
    CsrUint32                       dot11MulticastReceivedFrameCount;
    CsrUint32                       dot11MulticastTransmittedFrameCount;
    CsrUint32                       dot11ReceivedFragmentCount;
    CsrUint32                       dot11RSNA4WayHandshakeFailures;
    CsrUint32                       dot11RSNATKIPCounterMeasuresInvoked;
    CsrUint32                       dot11RSNAStatsTKIPLocalMICFailures;
    CsrUint32                       dot11RSNAStatsTKIPReplays;
    CsrUint32                       dot11RSNAStatsTKIPICVErrors;
    CsrUint32                       dot11RSNAStatsCCMPReplays;
    CsrUint32                       dot11RSNAStatsCCMPDecryptErrors;
} unifi_ConnectionStats;

typedef struct unifi_DataBlock
{
    CsrUint16                       length;
    CsrUint8                       *data;
} unifi_DataBlock;

typedef struct unifi_DataBlockList
{
    CsrUint16                       numElements;
    unifi_DataBlock                *dataList;
} unifi_DataBlockList;

typedef struct unifi_DriverVersions
{
    CsrUint32                       chipId;
    CsrUint32                       chipVersion;
    CsrUint32                       firmwareBuild;
    CsrUint32                       firmwareHip;
    CsrUint32                       driverBuild;
    CsrUint32                       driverHip;
} unifi_DriverVersions;

typedef struct unifi_IPV4Address
{
    CsrUint8                        a[4];
} unifi_IPV4Address;

typedef struct unifi_LinkQuality
{
    CsrInt16                        unifiRssi;
    CsrInt16                        unifiSnr;
} unifi_LinkQuality;

typedef struct unifi_MibConfig
{
    CsrBool                         unifiFixMaxTxDataRate;
    CsrUint8                        unifiFixTxDataRate;
    CsrUint16                       dot11RtsThreshold;
    CsrUint16                       dot11FragmentationThreshold;
    CsrUint16                       dot11CurrentTxPowerLevel;
} unifi_MibConfig;

typedef struct unifi_Pmkid
{
    unifi_MACAddress                bssid;
    CsrUint8                        pmkid[16];
} unifi_Pmkid;

typedef struct unifi_PmkidCandidate
{
    unifi_MACAddress                bssid;
    CsrBool                         preAuthAllowed;
} unifi_PmkidCandidate;

typedef struct unifi_PmkidList
{
    CsrUint8                        numElements;
    unifi_Pmkid                    *pmkids;
} unifi_PmkidList;

typedef struct unifi_RegulatoryDomainInfo
{
    CsrBool                         dot11MultiDomainCapabilityImplemented;
    CsrBool                         dot11MultiDomainCapabilityEnabled;
    unifi_RegulatoryDomain          currentRegulatoryDomain;
    CsrUint8                        currentCountryCode[2];
} unifi_RegulatoryDomainInfo;

typedef struct unifi_RoamingBandData
{
    CsrInt16                        rssiHighThreshold;
    CsrInt16                        rssiLowThreshold;
    CsrInt16                        snrHighThreshold;
    CsrInt16                        snrLowThreshold;
    CsrUint32                       monitorInterval;
    CsrUint32                       monitorWindow;
    CsrUint8                        dot11RetryRatio;
    CsrUint8                        dot11MultipleRetryRatio;
    CsrUint8                        dot11AckFailureRatio;
    CsrUint8                        dot11FcsErrorRatio;
    CsrUint8                        dot11RtsFailureRatio;
    CsrUint8                        beaconLossThreshold;
} unifi_RoamingBandData;

typedef struct unifi_SSID
{
    CsrUint8                        ssid[32];
    CsrUint8                        length;
} unifi_SSID;

typedef struct unifi_ScanConfigData
{
    CsrUint16                       intervalSeconds;
    CsrUint16                       validitySeconds;
    CsrUint16                       minActiveChannelTimeTu;
    CsrUint16                       maxActiveChannelTimeTu;
    CsrUint16                       minPassiveChannelTimeTu;
    CsrUint16                       maxPassiveChannelTimeTu;
} unifi_ScanConfigData;

typedef struct unifi_SmeConfig
{
    CsrUint8                        connectionQualityRssiChangeTrigger;
    CsrUint8                        connectionQualitySnrChangeTrigger;
    unifi_80211dTrustLevel          trustLevel;
    CsrUint8                        countryCode[2];
    CsrUint8                        wmmModeMask;
    unifi_RadioIF                   ifIndex;
    unifi_FirmwareDriverInterface   firmwareDriverInterface;
    CsrBool                         allowUnicastUseGroupCipher;
    CsrBool                         enableRestrictedAccess;
} unifi_SmeConfig;

typedef struct unifi_SmeVersions
{
    CsrUint32                       firmwarePatch;
    CsrUint32                       smeBuild;
    CsrUint32                       smeVariant;
    CsrUint32                       smeHip;
    char*                           smeIdString;
} unifi_SmeVersions;

typedef struct unifi_TrafficFilter
{
    CsrUint32                       etherType;
    CsrUint8                        ipType;
    CsrUint32                       udpSourcePort;
    CsrUint32                       udpDestPort;
} unifi_TrafficFilter;

typedef struct unifi_TrafficStats
{
    CsrUint32                       rxMeanRate;
    CsrUint32                       rxFramesNum;
    CsrUint32                       txFramesNum;
    CsrUint32                       rxBytesCount;
    CsrUint32                       txBytesCount;
    CsrUint8                        intervals[11];
} unifi_TrafficStats;

typedef struct unifi_TsfTime
{
    CsrUint8                        data[8];
} unifi_TsfTime;

typedef struct unifi_Versions
{
    CsrUint32                       chipId;
    CsrUint32                       chipVersion;
    CsrUint32                       firmwareBuild;
    CsrUint32                       firmwarePatch;
    CsrUint32                       firmwareHip;
    CsrUint32                       driverBuild;
    CsrUint32                       driverHip;
    CsrUint32                       smeBuild;
    CsrUint32                       smeVariant;
    CsrUint32                       smeHip;
    char*                           smeIdString;
} unifi_Versions;

typedef struct unifi_AddressList
{
    CsrUint8                        addressesCount;
    unifi_MACAddress               *addresses;
} unifi_AddressList;

typedef struct unifi_CloakedSsidConfig
{
    CsrUint8                        cloakedSsidsCount;
    unifi_SSID                     *cloakedSsids;
} unifi_CloakedSsidConfig;

typedef struct unifi_CoexConfig
{
    CsrBool                         coexEnable;
    CsrBool                         coexAfhChannelEnable;
    CsrBool                         coexAdvancedEnable;
    CsrBool                         coexEnableSchemeManagement;
    unifi_CoexDirection             coexDirection;
    CsrBool                         coexPeriodicWakeHost;
    CsrUint16                       coexTrafficBurstyLatencyMs;
    CsrUint16                       coexTrafficContinuousLatencyMs;
    CsrUint16                       coexObexBlackoutDurationMs;
    CsrUint16                       coexObexBlackoutPeriodMs;
    CsrUint16                       coexA2dpBlackoutDurationMs;
    CsrUint16                       coexA2dpBlackoutPeriodMs;
} unifi_CoexConfig;

typedef struct unifi_CoexInfo
{
    CsrBool                         hasTrafficData;
    unifi_TrafficType               currentTrafficType;
    CsrUint16                       currentPeriodMs;
    unifi_PowerSaveLevel            currentPowerSave;
    CsrUint16                       currentCoexPeriodMs;
    CsrUint16                       currentCoexLatencyMs;
    CsrBool                         hasBtDevice;
    CsrUint32                       currentBlackoutDurationUs;
    CsrUint32                       currentBlackoutPeriodUs;
    unifi_CoexScheme                currentCoexScheme;
} unifi_CoexInfo;

typedef struct unifi_ConnectionConfig
{
    unifi_SSID                      ssid;
    unifi_MACAddress                bssid;
    unifi_BSSType                   bssType;
    unifi_RadioIF                   ifIndex;
    unifi_80211PrivacyMode          privacyMode;
    CsrUint16                       authModeMask;
    CsrUint16                       encryptionModeMask;
    CsrUint16                       mlmeAssociateReqInformationElementsLength;
    CsrUint8                       *mlmeAssociateReqInformationElements;
    CsrUint8                        wmmQosInfo;
    CsrBool                         adhocJoinOnly;
    CsrUint8                        adhocChannel;
} unifi_ConnectionConfig;

typedef struct unifi_ConnectionInfo
{
    unifi_SSID                      ssid;
    unifi_MACAddress                bssid;
    unifi_80211NetworkType          networkType80211;
    CsrUint8                        channelNumber;
    CsrUint16                       channelFrequency;
    unifi_AuthMode                  authMode;
    unifi_EncryptionMode            pairwiseCipher;
    unifi_EncryptionMode            groupCipher;
    unifi_RadioIF                   ifIndex;
    CsrUint16                       atimWindowTu;
    CsrUint16                       beaconPeriodTu;
    CsrBool                         reassociation;
    CsrUint16                       beaconFrameLength;
    CsrUint8                       *beaconFrame;
    CsrUint16                       associationReqFrameLength;
    CsrUint8                       *associationReqFrame;
    CsrUint16                       associationRspFrameLength;
    CsrUint8                       *associationRspFrame;
    CsrUint16                       assocScanInfoElementsLength;
    CsrUint8                       *assocScanInfoElements;
    CsrUint16                       assocReqCapabilities;
    CsrUint16                       assocReqListenIntervalBeacons;
    unifi_MACAddress                assocReqApAddress;
    CsrUint16                       assocReqInfoElementsLength;
    CsrUint8                       *assocReqInfoElements;
    unifi_IEEE80211Result           assocRspResult;
    CsrUint16                       assocRspCapabilityInfo;
    CsrUint16                       assocRspAssociationId;
    CsrUint16                       assocRspInfoElementsLength;
    CsrUint8                       *assocRspInfoElements;
} unifi_ConnectionInfo;

typedef struct unifi_HostConfig
{
    unifi_HostPowerMode             powerMode;
    CsrUint16                       applicationDataPeriodMs;
} unifi_HostConfig;

typedef struct unifi_Key
{
    unifi_KeyType                   keyType;
    CsrUint8                        keyIndex;
    CsrBool                         wepTxKey;
    CsrUint16                       keyRsc[8];
    CsrBool                         authenticator;
    unifi_MACAddress                address;
    CsrUint8                        keyLength;
    CsrUint8                        key[32];
} unifi_Key;

typedef struct unifi_PowerConfig
{
    unifi_PowerSaveLevel            powerSaveLevel;
    CsrUint16                       listenIntervalBeacons;
    CsrBool                         rxDtims;
    unifi_D3AutoScanMode            d3AutoScanMode;
} unifi_PowerConfig;

typedef struct unifi_RoamingConfig
{
    unifi_RoamingBandData           roamingBands[3];
    CsrUint8                        lowQualHystWindow;
    CsrUint8                        apBlockTimeMs;
    CsrUint8                        roamMonitorPeriodMs;
    CsrUint8                        roamNumMaxTh;
    CsrBool                         disableRoamScans;
    CsrUint8                        reconnectLimit;
    unifi_ScanConfigData            roamScanCfg[3];
} unifi_RoamingConfig;

typedef struct unifi_ScanConfig
{
    unifi_ScanConfigData            scanCfg[4];
    CsrBool                         disableAutonomousScans;
    CsrUint16                       maxResults;
    CsrInt8                         highRSSIThreshold;
    CsrInt8                         lowRSSIThreshold;
    CsrInt8                         deltaRSSIThreshold;
    CsrInt8                         highSNRThreshold;
    CsrInt8                         lowSNRThreshold;
    CsrInt8                         deltaSNRThreshold;
    CsrUint16                       passiveChannelListCount;
    CsrUint8                       *passiveChannelList;
} unifi_ScanConfig;

typedef struct unifi_ScanResult
{
    unifi_SSID                      ssid;
    unifi_MACAddress                bssid;
    CsrInt16                        rssi;
    CsrInt16                        snr;
    unifi_RadioIF                   ifIndex;
    CsrUint16                       beaconPeriodTu;
    unifi_TsfTime                   timeStamp;
    unifi_TsfTime                   localTime;
    CsrUint16                       channelFrequency;
    CsrUint16                       capabilityInformation;
    CsrUint8                        channelNumber;
    unifi_BasicUsability            usability;
    unifi_BSSType                   bssType;
    CsrUint16                       informationElementsLength;
    CsrUint8                       *informationElements;
} unifi_ScanResult;

typedef struct unifi_TrafficConfig
{
    CsrUint16                       packetFilter;
    unifi_TrafficFilter             customFilter;
} unifi_TrafficConfig;

typedef struct unifi_AppValue
{
    unifi_AppValueId                id;
    union {
        unifi_CloakedSsidConfig         cloakedSsids;
        unifi_ScanConfig                scanConfig;
        unifi_RegulatoryDomainInfo      regDomInfo;
        unifi_SmeConfig                 smeConfig;
        unifi_Versions                  versions;
        unifi_CoexConfig                coexConfig;
        unifi_LinkQuality               linkQuality;
        unifi_MACAddress                stationMacAddress;
        unifi_MibConfig                 mibConfig;
        unifi_MACAddress                permanentMacAddress;
        unifi_ConnectionStats           connectionStats;
        unifi_RoamingConfig             roamingConfig;
        unifi_AdHocConfig               adHocConfig;
        unifi_ConnectionInfo            connectionInfo;
        unifi_CoexInfo                  coexInfo;
        unifi_DataBlock                 calibrationData;
        unifi_ConnectionConfig          connectionConfig;
        unifi_CcxConfig                 ccxConfig;
        unifi_PowerConfig               powerConfig;
        unifi_HostConfig                hostConfig;
    } unifi_Value_union;

} unifi_AppValue;





#ifdef __cplusplus
}
#endif

#endif /* SME_XML_TYPES_H */
