/* This is an autogenerated file */
/* Tag: noCheckHeader */

/*    CONFIDENTIAL */
/*    Copyright (C) Cambridge Silicon Radio Ltd 2008. All rights reserved. */

#include "event_pack_unpack/event_pack_unpack.h"
#include "sme_top_level_fsm/sme.h"
#include "smeio/smeio_fsm_events.h"

static void event_to_unifi_mgt_association_complete_ind(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtAssociationCompleteInd_Evt evt;

    evt.appHandlesCount =  event_unpack_CsrUint16(&buffer);
    evt.appHandles = NULL;
    if (evt.appHandlesCount)
    {
        CsrUint16 i1;
        evt.appHandles = (void**)CsrPmalloc(sizeof(void*) * evt.appHandlesCount);
        for(i1 = 0; i1 < evt.appHandlesCount; i1++)
        {
            evt.appHandles = (void*) event_unpack_CsrUint32(&buffer);
        }
    }
    evt.status = (unifi_Status) event_unpack_CsrUint8(&buffer);
    event_unpack_buffer(&buffer, evt.connectionInfo.ssid.ssid, 32);
    evt.connectionInfo.ssid.length =  event_unpack_CsrUint8(&buffer);
    event_unpack_buffer(&buffer, evt.connectionInfo.bssid.data, 6);
    evt.connectionInfo.networkType80211 = (unifi_80211NetworkType) event_unpack_CsrUint8(&buffer);
    evt.connectionInfo.channelNumber =  event_unpack_CsrUint8(&buffer);
    evt.connectionInfo.channelFrequency =  event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.authMode = (unifi_AuthMode) event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.pairwiseCipher = (unifi_EncryptionMode) event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.groupCipher = (unifi_EncryptionMode) event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.ifIndex = (unifi_RadioIF) event_unpack_CsrUint8(&buffer);
    evt.connectionInfo.atimWindowTu =  event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.beaconPeriodTu =  event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.reassociation = (CsrBool) event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.beaconFrameLength =  event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.beaconFrame = NULL;
    if (evt.connectionInfo.beaconFrameLength)
    {
        evt.connectionInfo.beaconFrame = (CsrUint8*)CsrPmalloc(evt.connectionInfo.beaconFrameLength);
        event_unpack_buffer(&buffer, evt.connectionInfo.beaconFrame, evt.connectionInfo.beaconFrameLength);
    }
    evt.connectionInfo.associationReqFrameLength =  event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.associationReqFrame = NULL;
    if (evt.connectionInfo.associationReqFrameLength)
    {
        evt.connectionInfo.associationReqFrame = (CsrUint8*)CsrPmalloc(evt.connectionInfo.associationReqFrameLength);
        event_unpack_buffer(&buffer, evt.connectionInfo.associationReqFrame, evt.connectionInfo.associationReqFrameLength);
    }
    evt.connectionInfo.associationRspFrameLength =  event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.associationRspFrame = NULL;
    if (evt.connectionInfo.associationRspFrameLength)
    {
        evt.connectionInfo.associationRspFrame = (CsrUint8*)CsrPmalloc(evt.connectionInfo.associationRspFrameLength);
        event_unpack_buffer(&buffer, evt.connectionInfo.associationRspFrame, evt.connectionInfo.associationRspFrameLength);
    }
    evt.connectionInfo.assocScanInfoElementsLength =  event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.assocScanInfoElements = NULL;
    if (evt.connectionInfo.assocScanInfoElementsLength)
    {
        evt.connectionInfo.assocScanInfoElements = (CsrUint8*)CsrPmalloc(evt.connectionInfo.assocScanInfoElementsLength);
        event_unpack_buffer(&buffer, evt.connectionInfo.assocScanInfoElements, evt.connectionInfo.assocScanInfoElementsLength);
    }
    evt.connectionInfo.assocReqCapabilities =  event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.assocReqListenIntervalBeacons =  event_unpack_CsrUint16(&buffer);
    event_unpack_buffer(&buffer, evt.connectionInfo.assocReqApAddress.data, 6);
    evt.connectionInfo.assocReqInfoElementsLength =  event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.assocReqInfoElements = NULL;
    if (evt.connectionInfo.assocReqInfoElementsLength)
    {
        evt.connectionInfo.assocReqInfoElements = (CsrUint8*)CsrPmalloc(evt.connectionInfo.assocReqInfoElementsLength);
        event_unpack_buffer(&buffer, evt.connectionInfo.assocReqInfoElements, evt.connectionInfo.assocReqInfoElementsLength);
    }
    evt.connectionInfo.assocRspResult = (unifi_IEEE80211Result) event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.assocRspCapabilityInfo =  event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.assocRspAssociationId =  event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.assocRspInfoElementsLength =  event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.assocRspInfoElements = NULL;
    if (evt.connectionInfo.assocRspInfoElementsLength)
    {
        evt.connectionInfo.assocRspInfoElements = (CsrUint8*)CsrPmalloc(evt.connectionInfo.assocRspInfoElementsLength);
        event_unpack_buffer(&buffer, evt.connectionInfo.assocRspInfoElements, evt.connectionInfo.assocRspInfoElementsLength);
    }
    evt.deauthReason = (unifi_IEEE80211Reason) event_unpack_CsrUint16(&buffer);

    unifi_mgt_association_complete_ind(context, evt.appHandlesCount, evt.appHandles, evt.status, &evt.connectionInfo, evt.deauthReason);

    CsrPfree(evt.appHandles);
    CsrPfree(evt.connectionInfo.beaconFrame);
    CsrPfree(evt.connectionInfo.associationReqFrame);
    CsrPfree(evt.connectionInfo.associationRspFrame);
    CsrPfree(evt.connectionInfo.assocScanInfoElements);
    CsrPfree(evt.connectionInfo.assocReqInfoElements);
    CsrPfree(evt.connectionInfo.assocRspInfoElements);
}

static void event_to_unifi_mgt_association_start_ind(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtAssociationStartInd_Evt evt;

    evt.appHandlesCount =  event_unpack_CsrUint16(&buffer);
    evt.appHandles = NULL;
    if (evt.appHandlesCount)
    {
        CsrUint16 i1;
        evt.appHandles = (void**)CsrPmalloc(sizeof(void*) * evt.appHandlesCount);
        for(i1 = 0; i1 < evt.appHandlesCount; i1++)
        {
            evt.appHandles = (void*) event_unpack_CsrUint32(&buffer);
        }
    }
    event_unpack_buffer(&buffer, evt.address.data, 6);
    event_unpack_buffer(&buffer, evt.ssid.ssid, 32);
    evt.ssid.length =  event_unpack_CsrUint8(&buffer);

    unifi_mgt_association_start_ind(context, evt.appHandlesCount, evt.appHandles, &evt.address, &evt.ssid);

    CsrPfree(evt.appHandles);
}

static void event_to_unifi_mgt_blacklist_cfm(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtBlacklistCfm_Evt evt;

    evt.appHandle = (void*) event_unpack_CsrUint32(&buffer);
    evt.status = (unifi_Status) event_unpack_CsrUint8(&buffer);
    evt.action = (unifi_ListAction) event_unpack_CsrUint8(&buffer);
    evt.getAddressCount =  event_unpack_CsrUint8(&buffer);
    evt.getAddresses = NULL;
    if (evt.getAddressCount)
    {
        CsrUint16 i1;
        evt.getAddresses = (unifi_MACAddress*)CsrPmalloc(sizeof(unifi_MACAddress) * evt.getAddressCount);
        for(i1 = 0; i1 < evt.getAddressCount; i1++)
        {
            event_unpack_buffer(&buffer, evt.getAddresses[i1].data, 6);
        }
    }

    unifi_mgt_blacklist_cfm(context, evt.appHandle, evt.status, evt.action, evt.getAddressCount, evt.getAddresses);

    CsrPfree(evt.getAddresses);
}

static void event_to_unifi_mgt_connect_cfm(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtConnectCfm_Evt evt;

    evt.appHandle = (void*) event_unpack_CsrUint32(&buffer);
    evt.status = (unifi_Status) event_unpack_CsrUint8(&buffer);

    unifi_mgt_connect_cfm(context, evt.appHandle, evt.status);

}

static void event_to_unifi_mgt_connection_quality_ind(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtConnectionQualityInd_Evt evt;

    evt.appHandlesCount =  event_unpack_CsrUint16(&buffer);
    evt.appHandles = NULL;
    if (evt.appHandlesCount)
    {
        CsrUint16 i1;
        evt.appHandles = (void**)CsrPmalloc(sizeof(void*) * evt.appHandlesCount);
        for(i1 = 0; i1 < evt.appHandlesCount; i1++)
        {
            evt.appHandles = (void*) event_unpack_CsrUint32(&buffer);
        }
    }
    evt.linkQuality.unifiRssi =  event_unpack_CsrInt16(&buffer);
    evt.linkQuality.unifiSnr =  event_unpack_CsrInt16(&buffer);

    unifi_mgt_connection_quality_ind(context, evt.appHandlesCount, evt.appHandles, &evt.linkQuality);

    CsrPfree(evt.appHandles);
}

static void event_to_unifi_mgt_disconnect_cfm(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtDisconnectCfm_Evt evt;

    evt.appHandle = (void*) event_unpack_CsrUint32(&buffer);
    evt.status = (unifi_Status) event_unpack_CsrUint8(&buffer);

    unifi_mgt_disconnect_cfm(context, evt.appHandle, evt.status);

}

static void event_to_unifi_mgt_event_mask_set_cfm(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtEventMaskSetCfm_Evt evt;

    evt.appHandle = (void*) event_unpack_CsrUint32(&buffer);
    evt.status = (unifi_Status) event_unpack_CsrUint8(&buffer);

    unifi_mgt_event_mask_set_cfm(context, evt.appHandle, evt.status);

}

static void event_to_unifi_mgt_get_value_cfm(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtGetValueCfm_Evt evt;

    evt.appHandle = (void*) event_unpack_CsrUint32(&buffer);
    evt.status = (unifi_Status) event_unpack_CsrUint8(&buffer);
    evt.appValue.id = (unifi_AppValueId) event_unpack_CsrUint8(&buffer);
    switch(evt.appValue.id)
    {
    case unifi_CloakedSsidConfigValue:
        evt.appValue.unifi_Value_union.cloakedSsids.cloakedSsidsCount =  event_unpack_CsrUint8(&buffer);
        evt.appValue.unifi_Value_union.cloakedSsids.cloakedSsids = NULL;
        if (evt.appValue.unifi_Value_union.cloakedSsids.cloakedSsidsCount)
        {
            CsrUint16 i4;
            evt.appValue.unifi_Value_union.cloakedSsids.cloakedSsids = (unifi_SSID*)CsrPmalloc(sizeof(unifi_SSID) * evt.appValue.unifi_Value_union.cloakedSsids.cloakedSsidsCount);
            for(i4 = 0; i4 < evt.appValue.unifi_Value_union.cloakedSsids.cloakedSsidsCount; i4++)
            {
                event_unpack_buffer(&buffer, evt.appValue.unifi_Value_union.cloakedSsids.cloakedSsids[i4].ssid, 32);
                evt.appValue.unifi_Value_union.cloakedSsids.cloakedSsids[i4].length =  event_unpack_CsrUint8(&buffer);
            }
        }
        break;
    case unifi_ScanConfigValue:
        {
        CsrUint16 i4;
        for(i4 = 0; i4 < 4; i4++)
        {
            evt.appValue.unifi_Value_union.scanConfig.scanCfg[i4].intervalSeconds =  event_unpack_CsrUint16(&buffer);
            evt.appValue.unifi_Value_union.scanConfig.scanCfg[i4].validitySeconds =  event_unpack_CsrUint16(&buffer);
            evt.appValue.unifi_Value_union.scanConfig.scanCfg[i4].minActiveChannelTimeTu =  event_unpack_CsrUint16(&buffer);
            evt.appValue.unifi_Value_union.scanConfig.scanCfg[i4].maxActiveChannelTimeTu =  event_unpack_CsrUint16(&buffer);
            evt.appValue.unifi_Value_union.scanConfig.scanCfg[i4].minPassiveChannelTimeTu =  event_unpack_CsrUint16(&buffer);
            evt.appValue.unifi_Value_union.scanConfig.scanCfg[i4].maxPassiveChannelTimeTu =  event_unpack_CsrUint16(&buffer);
        }
        }
        evt.appValue.unifi_Value_union.scanConfig.disableAutonomousScans = (CsrBool) event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.scanConfig.maxResults =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.scanConfig.highRSSIThreshold =  event_unpack_CsrInt8(&buffer);
        evt.appValue.unifi_Value_union.scanConfig.lowRSSIThreshold =  event_unpack_CsrInt8(&buffer);
        evt.appValue.unifi_Value_union.scanConfig.deltaRSSIThreshold =  event_unpack_CsrInt8(&buffer);
        evt.appValue.unifi_Value_union.scanConfig.highSNRThreshold =  event_unpack_CsrInt8(&buffer);
        evt.appValue.unifi_Value_union.scanConfig.lowSNRThreshold =  event_unpack_CsrInt8(&buffer);
        evt.appValue.unifi_Value_union.scanConfig.deltaSNRThreshold =  event_unpack_CsrInt8(&buffer);
        evt.appValue.unifi_Value_union.scanConfig.passiveChannelListCount =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.scanConfig.passiveChannelList = NULL;
        if (evt.appValue.unifi_Value_union.scanConfig.passiveChannelListCount)
        {
            evt.appValue.unifi_Value_union.scanConfig.passiveChannelList = (CsrUint8*)CsrPmalloc(evt.appValue.unifi_Value_union.scanConfig.passiveChannelListCount);
            event_unpack_buffer(&buffer, evt.appValue.unifi_Value_union.scanConfig.passiveChannelList, evt.appValue.unifi_Value_union.scanConfig.passiveChannelListCount);
        }
        break;
    case unifi_RegulatoryDomainInfoValue:
        evt.appValue.unifi_Value_union.regDomInfo.dot11MultiDomainCapabilityImplemented = (CsrBool) event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.regDomInfo.dot11MultiDomainCapabilityEnabled = (CsrBool) event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.regDomInfo.currentRegulatoryDomain = (unifi_RegulatoryDomain) event_unpack_CsrUint8(&buffer);
        event_unpack_buffer(&buffer, evt.appValue.unifi_Value_union.regDomInfo.currentCountryCode, 2);
        break;
    case unifi_SmeConfigValue:
        evt.appValue.unifi_Value_union.smeConfig.connectionQualityRssiChangeTrigger =  event_unpack_CsrUint8(&buffer);
        evt.appValue.unifi_Value_union.smeConfig.connectionQualitySnrChangeTrigger =  event_unpack_CsrUint8(&buffer);
        evt.appValue.unifi_Value_union.smeConfig.trustLevel = (unifi_80211dTrustLevel) event_unpack_CsrUint8(&buffer);
        event_unpack_buffer(&buffer, evt.appValue.unifi_Value_union.smeConfig.countryCode, 2);
        evt.appValue.unifi_Value_union.smeConfig.wmmModeMask =  event_unpack_CsrUint8(&buffer);
        evt.appValue.unifi_Value_union.smeConfig.ifIndex = (unifi_RadioIF) event_unpack_CsrUint8(&buffer);
        evt.appValue.unifi_Value_union.smeConfig.firmwareDriverInterface = (unifi_FirmwareDriverInterface) event_unpack_CsrUint8(&buffer);
        evt.appValue.unifi_Value_union.smeConfig.allowUnicastUseGroupCipher = (CsrBool) event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.smeConfig.enableRestrictedAccess = (CsrBool) event_unpack_CsrUint16(&buffer);
        break;
    case unifi_VersionsValue:
        evt.appValue.unifi_Value_union.versions.chipId =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.versions.chipVersion =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.versions.firmwareBuild =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.versions.firmwarePatch =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.versions.firmwareHip =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.versions.driverBuild =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.versions.driverHip =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.versions.smeBuild =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.versions.smeVariant =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.versions.smeHip =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.versions.smeIdString = event_unpack_string(&buffer);
        break;
    case unifi_CoexConfigValue:
        evt.appValue.unifi_Value_union.coexConfig.coexEnable = (CsrBool) event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.coexConfig.coexAfhChannelEnable = (CsrBool) event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.coexConfig.coexAdvancedEnable = (CsrBool) event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.coexConfig.coexEnableSchemeManagement = (CsrBool) event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.coexConfig.coexDirection = (unifi_CoexDirection) event_unpack_CsrUint8(&buffer);
        evt.appValue.unifi_Value_union.coexConfig.coexPeriodicWakeHost = (CsrBool) event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.coexConfig.coexTrafficBurstyLatencyMs =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.coexConfig.coexTrafficContinuousLatencyMs =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.coexConfig.coexObexBlackoutDurationMs =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.coexConfig.coexObexBlackoutPeriodMs =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.coexConfig.coexA2dpBlackoutDurationMs =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.coexConfig.coexA2dpBlackoutPeriodMs =  event_unpack_CsrUint16(&buffer);
        break;
    case unifi_LinkQualityValue:
        evt.appValue.unifi_Value_union.linkQuality.unifiRssi =  event_unpack_CsrInt16(&buffer);
        evt.appValue.unifi_Value_union.linkQuality.unifiSnr =  event_unpack_CsrInt16(&buffer);
        break;
    case unifi_StationMACAddressValue:
        event_unpack_buffer(&buffer, evt.appValue.unifi_Value_union.stationMacAddress.data, 6);
        break;
    case unifi_MibConfigValue:
        evt.appValue.unifi_Value_union.mibConfig.unifiFixMaxTxDataRate = (CsrBool) event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.mibConfig.unifiFixTxDataRate =  event_unpack_CsrUint8(&buffer);
        evt.appValue.unifi_Value_union.mibConfig.dot11RtsThreshold =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.mibConfig.dot11FragmentationThreshold =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.mibConfig.dot11CurrentTxPowerLevel =  event_unpack_CsrUint16(&buffer);
        break;
    case unifi_PermanentMACAddressValue:
        event_unpack_buffer(&buffer, evt.appValue.unifi_Value_union.permanentMacAddress.data, 6);
        break;
    case unifi_ConnectionStatsValue:
        evt.appValue.unifi_Value_union.connectionStats.unifiTxDataRate =  event_unpack_CsrUint8(&buffer);
        evt.appValue.unifi_Value_union.connectionStats.unifiRxDataRate =  event_unpack_CsrUint8(&buffer);
        evt.appValue.unifi_Value_union.connectionStats.dot11RetryCount =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.connectionStats.dot11MultipleRetryCount =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.connectionStats.dot11AckFailureCount =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.connectionStats.dot11FrameDuplicateCount =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.connectionStats.dot11FcsErrorCount =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.connectionStats.dot11RtsSuccessCount =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.connectionStats.dot11RtsFailureCount =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.connectionStats.dot11FailedCount =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.connectionStats.dot11TransmittedFragmentCount =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.connectionStats.dot11TransmittedFrameCount =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.connectionStats.dot11WEPExcludedCount =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.connectionStats.dot11WEPICVErrorCount =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.connectionStats.dot11WEPUndecryptableCount =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.connectionStats.dot11MulticastReceivedFrameCount =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.connectionStats.dot11MulticastTransmittedFrameCount =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.connectionStats.dot11ReceivedFragmentCount =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.connectionStats.dot11RSNA4WayHandshakeFailures =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.connectionStats.dot11RSNATKIPCounterMeasuresInvoked =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.connectionStats.dot11RSNAStatsTKIPLocalMICFailures =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.connectionStats.dot11RSNAStatsTKIPReplays =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.connectionStats.dot11RSNAStatsTKIPICVErrors =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.connectionStats.dot11RSNAStatsCCMPReplays =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.connectionStats.dot11RSNAStatsCCMPDecryptErrors =  event_unpack_CsrUint32(&buffer);
        break;
    case unifi_RoamingConfigValue:
        {
        CsrUint16 i4;
        for(i4 = 0; i4 < 3; i4++)
        {
            evt.appValue.unifi_Value_union.roamingConfig.roamingBands[i4].rssiHighThreshold =  event_unpack_CsrInt16(&buffer);
            evt.appValue.unifi_Value_union.roamingConfig.roamingBands[i4].rssiLowThreshold =  event_unpack_CsrInt16(&buffer);
            evt.appValue.unifi_Value_union.roamingConfig.roamingBands[i4].snrHighThreshold =  event_unpack_CsrInt16(&buffer);
            evt.appValue.unifi_Value_union.roamingConfig.roamingBands[i4].snrLowThreshold =  event_unpack_CsrInt16(&buffer);
            evt.appValue.unifi_Value_union.roamingConfig.roamingBands[i4].monitorInterval =  event_unpack_CsrUint32(&buffer);
            evt.appValue.unifi_Value_union.roamingConfig.roamingBands[i4].monitorWindow =  event_unpack_CsrUint32(&buffer);
            evt.appValue.unifi_Value_union.roamingConfig.roamingBands[i4].dot11RetryRatio =  event_unpack_CsrUint8(&buffer);
            evt.appValue.unifi_Value_union.roamingConfig.roamingBands[i4].dot11MultipleRetryRatio =  event_unpack_CsrUint8(&buffer);
            evt.appValue.unifi_Value_union.roamingConfig.roamingBands[i4].dot11AckFailureRatio =  event_unpack_CsrUint8(&buffer);
            evt.appValue.unifi_Value_union.roamingConfig.roamingBands[i4].dot11FcsErrorRatio =  event_unpack_CsrUint8(&buffer);
            evt.appValue.unifi_Value_union.roamingConfig.roamingBands[i4].dot11RtsFailureRatio =  event_unpack_CsrUint8(&buffer);
            evt.appValue.unifi_Value_union.roamingConfig.roamingBands[i4].beaconLossThreshold =  event_unpack_CsrUint8(&buffer);
        }
        }
        evt.appValue.unifi_Value_union.roamingConfig.lowQualHystWindow =  event_unpack_CsrUint8(&buffer);
        evt.appValue.unifi_Value_union.roamingConfig.apBlockTimeMs =  event_unpack_CsrUint8(&buffer);
        evt.appValue.unifi_Value_union.roamingConfig.roamMonitorPeriodMs =  event_unpack_CsrUint8(&buffer);
        evt.appValue.unifi_Value_union.roamingConfig.roamNumMaxTh =  event_unpack_CsrUint8(&buffer);
        evt.appValue.unifi_Value_union.roamingConfig.disableRoamScans = (CsrBool) event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.roamingConfig.reconnectLimit =  event_unpack_CsrUint8(&buffer);
        {
        CsrUint16 i4;
        for(i4 = 0; i4 < 3; i4++)
        {
            evt.appValue.unifi_Value_union.roamingConfig.roamScanCfg[i4].intervalSeconds =  event_unpack_CsrUint16(&buffer);
            evt.appValue.unifi_Value_union.roamingConfig.roamScanCfg[i4].validitySeconds =  event_unpack_CsrUint16(&buffer);
            evt.appValue.unifi_Value_union.roamingConfig.roamScanCfg[i4].minActiveChannelTimeTu =  event_unpack_CsrUint16(&buffer);
            evt.appValue.unifi_Value_union.roamingConfig.roamScanCfg[i4].maxActiveChannelTimeTu =  event_unpack_CsrUint16(&buffer);
            evt.appValue.unifi_Value_union.roamingConfig.roamScanCfg[i4].minPassiveChannelTimeTu =  event_unpack_CsrUint16(&buffer);
            evt.appValue.unifi_Value_union.roamingConfig.roamScanCfg[i4].maxPassiveChannelTimeTu =  event_unpack_CsrUint16(&buffer);
        }
        }
        break;
    case unifi_AdHocConfigValue:
        evt.appValue.unifi_Value_union.adHocConfig.atimWindowTu =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.adHocConfig.beaconPeriodTu =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.adHocConfig.joinOnlyAttempts =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.adHocConfig.joinAttemptIntervalMs =  event_unpack_CsrUint16(&buffer);
        break;
    case unifi_ConnectionInfoValue:
        event_unpack_buffer(&buffer, evt.appValue.unifi_Value_union.connectionInfo.ssid.ssid, 32);
        evt.appValue.unifi_Value_union.connectionInfo.ssid.length =  event_unpack_CsrUint8(&buffer);
        event_unpack_buffer(&buffer, evt.appValue.unifi_Value_union.connectionInfo.bssid.data, 6);
        evt.appValue.unifi_Value_union.connectionInfo.networkType80211 = (unifi_80211NetworkType) event_unpack_CsrUint8(&buffer);
        evt.appValue.unifi_Value_union.connectionInfo.channelNumber =  event_unpack_CsrUint8(&buffer);
        evt.appValue.unifi_Value_union.connectionInfo.channelFrequency =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.connectionInfo.authMode = (unifi_AuthMode) event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.connectionInfo.pairwiseCipher = (unifi_EncryptionMode) event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.connectionInfo.groupCipher = (unifi_EncryptionMode) event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.connectionInfo.ifIndex = (unifi_RadioIF) event_unpack_CsrUint8(&buffer);
        evt.appValue.unifi_Value_union.connectionInfo.atimWindowTu =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.connectionInfo.beaconPeriodTu =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.connectionInfo.reassociation = (CsrBool) event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.connectionInfo.beaconFrameLength =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.connectionInfo.beaconFrame = NULL;
        if (evt.appValue.unifi_Value_union.connectionInfo.beaconFrameLength)
        {
            evt.appValue.unifi_Value_union.connectionInfo.beaconFrame = (CsrUint8*)CsrPmalloc(evt.appValue.unifi_Value_union.connectionInfo.beaconFrameLength);
            event_unpack_buffer(&buffer, evt.appValue.unifi_Value_union.connectionInfo.beaconFrame, evt.appValue.unifi_Value_union.connectionInfo.beaconFrameLength);
        }
        evt.appValue.unifi_Value_union.connectionInfo.associationReqFrameLength =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.connectionInfo.associationReqFrame = NULL;
        if (evt.appValue.unifi_Value_union.connectionInfo.associationReqFrameLength)
        {
            evt.appValue.unifi_Value_union.connectionInfo.associationReqFrame = (CsrUint8*)CsrPmalloc(evt.appValue.unifi_Value_union.connectionInfo.associationReqFrameLength);
            event_unpack_buffer(&buffer, evt.appValue.unifi_Value_union.connectionInfo.associationReqFrame, evt.appValue.unifi_Value_union.connectionInfo.associationReqFrameLength);
        }
        evt.appValue.unifi_Value_union.connectionInfo.associationRspFrameLength =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.connectionInfo.associationRspFrame = NULL;
        if (evt.appValue.unifi_Value_union.connectionInfo.associationRspFrameLength)
        {
            evt.appValue.unifi_Value_union.connectionInfo.associationRspFrame = (CsrUint8*)CsrPmalloc(evt.appValue.unifi_Value_union.connectionInfo.associationRspFrameLength);
            event_unpack_buffer(&buffer, evt.appValue.unifi_Value_union.connectionInfo.associationRspFrame, evt.appValue.unifi_Value_union.connectionInfo.associationRspFrameLength);
        }
        evt.appValue.unifi_Value_union.connectionInfo.assocScanInfoElementsLength =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.connectionInfo.assocScanInfoElements = NULL;
        if (evt.appValue.unifi_Value_union.connectionInfo.assocScanInfoElementsLength)
        {
            evt.appValue.unifi_Value_union.connectionInfo.assocScanInfoElements = (CsrUint8*)CsrPmalloc(evt.appValue.unifi_Value_union.connectionInfo.assocScanInfoElementsLength);
            event_unpack_buffer(&buffer, evt.appValue.unifi_Value_union.connectionInfo.assocScanInfoElements, evt.appValue.unifi_Value_union.connectionInfo.assocScanInfoElementsLength);
        }
        evt.appValue.unifi_Value_union.connectionInfo.assocReqCapabilities =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.connectionInfo.assocReqListenIntervalBeacons =  event_unpack_CsrUint16(&buffer);
        event_unpack_buffer(&buffer, evt.appValue.unifi_Value_union.connectionInfo.assocReqApAddress.data, 6);
        evt.appValue.unifi_Value_union.connectionInfo.assocReqInfoElementsLength =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.connectionInfo.assocReqInfoElements = NULL;
        if (evt.appValue.unifi_Value_union.connectionInfo.assocReqInfoElementsLength)
        {
            evt.appValue.unifi_Value_union.connectionInfo.assocReqInfoElements = (CsrUint8*)CsrPmalloc(evt.appValue.unifi_Value_union.connectionInfo.assocReqInfoElementsLength);
            event_unpack_buffer(&buffer, evt.appValue.unifi_Value_union.connectionInfo.assocReqInfoElements, evt.appValue.unifi_Value_union.connectionInfo.assocReqInfoElementsLength);
        }
        evt.appValue.unifi_Value_union.connectionInfo.assocRspResult = (unifi_IEEE80211Result) event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.connectionInfo.assocRspCapabilityInfo =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.connectionInfo.assocRspAssociationId =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.connectionInfo.assocRspInfoElementsLength =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.connectionInfo.assocRspInfoElements = NULL;
        if (evt.appValue.unifi_Value_union.connectionInfo.assocRspInfoElementsLength)
        {
            evt.appValue.unifi_Value_union.connectionInfo.assocRspInfoElements = (CsrUint8*)CsrPmalloc(evt.appValue.unifi_Value_union.connectionInfo.assocRspInfoElementsLength);
            event_unpack_buffer(&buffer, evt.appValue.unifi_Value_union.connectionInfo.assocRspInfoElements, evt.appValue.unifi_Value_union.connectionInfo.assocRspInfoElementsLength);
        }
        break;
    case unifi_CoexInfoValue:
        evt.appValue.unifi_Value_union.coexInfo.hasTrafficData = (CsrBool) event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.coexInfo.currentTrafficType = (unifi_TrafficType) event_unpack_CsrUint8(&buffer);
        evt.appValue.unifi_Value_union.coexInfo.currentPeriodMs =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.coexInfo.currentPowerSave = (unifi_PowerSaveLevel) event_unpack_CsrUint8(&buffer);
        evt.appValue.unifi_Value_union.coexInfo.currentCoexPeriodMs =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.coexInfo.currentCoexLatencyMs =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.coexInfo.hasBtDevice = (CsrBool) event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.coexInfo.currentBlackoutDurationUs =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.coexInfo.currentBlackoutPeriodUs =  event_unpack_CsrUint32(&buffer);
        evt.appValue.unifi_Value_union.coexInfo.currentCoexScheme = (unifi_CoexScheme) event_unpack_CsrUint8(&buffer);
        break;
    case unifi_CalibrationDataValue:
        evt.appValue.unifi_Value_union.calibrationData.length =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.calibrationData.data = NULL;
        if (evt.appValue.unifi_Value_union.calibrationData.length)
        {
            evt.appValue.unifi_Value_union.calibrationData.data = (CsrUint8*)CsrPmalloc(evt.appValue.unifi_Value_union.calibrationData.length);
            event_unpack_buffer(&buffer, evt.appValue.unifi_Value_union.calibrationData.data, evt.appValue.unifi_Value_union.calibrationData.length);
        }
        break;
    case unifi_ConnectionConfigValue:
        event_unpack_buffer(&buffer, evt.appValue.unifi_Value_union.connectionConfig.ssid.ssid, 32);
        evt.appValue.unifi_Value_union.connectionConfig.ssid.length =  event_unpack_CsrUint8(&buffer);
        event_unpack_buffer(&buffer, evt.appValue.unifi_Value_union.connectionConfig.bssid.data, 6);
        evt.appValue.unifi_Value_union.connectionConfig.bssType = (unifi_BSSType) event_unpack_CsrUint8(&buffer);
        evt.appValue.unifi_Value_union.connectionConfig.ifIndex = (unifi_RadioIF) event_unpack_CsrUint8(&buffer);
        evt.appValue.unifi_Value_union.connectionConfig.privacyMode = (unifi_80211PrivacyMode) event_unpack_CsrUint8(&buffer);
        evt.appValue.unifi_Value_union.connectionConfig.authModeMask =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.connectionConfig.encryptionModeMask =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.connectionConfig.mlmeAssociateReqInformationElementsLength =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.connectionConfig.mlmeAssociateReqInformationElements = NULL;
        if (evt.appValue.unifi_Value_union.connectionConfig.mlmeAssociateReqInformationElementsLength)
        {
            evt.appValue.unifi_Value_union.connectionConfig.mlmeAssociateReqInformationElements = (CsrUint8*)CsrPmalloc(evt.appValue.unifi_Value_union.connectionConfig.mlmeAssociateReqInformationElementsLength);
            event_unpack_buffer(&buffer, evt.appValue.unifi_Value_union.connectionConfig.mlmeAssociateReqInformationElements, evt.appValue.unifi_Value_union.connectionConfig.mlmeAssociateReqInformationElementsLength);
        }
        evt.appValue.unifi_Value_union.connectionConfig.wmmQosInfo =  event_unpack_CsrUint8(&buffer);
        evt.appValue.unifi_Value_union.connectionConfig.adhocJoinOnly = (CsrBool) event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.connectionConfig.adhocChannel =  event_unpack_CsrUint8(&buffer);
        break;
    case unifi_CcxConfigValue:
        evt.appValue.unifi_Value_union.ccxConfig.keepAliveTimeMs =  event_unpack_CsrUint8(&buffer);
        evt.appValue.unifi_Value_union.ccxConfig.apRoamingEnabled = (CsrBool) event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.ccxConfig.measurementsMask =  event_unpack_CsrUint8(&buffer);
        evt.appValue.unifi_Value_union.ccxConfig.ccxRadioMgtEnabled = (CsrBool) event_unpack_CsrUint16(&buffer);
        break;
    case unifi_PowerConfigValue:
        evt.appValue.unifi_Value_union.powerConfig.powerSaveLevel = (unifi_PowerSaveLevel) event_unpack_CsrUint8(&buffer);
        evt.appValue.unifi_Value_union.powerConfig.listenIntervalBeacons =  event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.powerConfig.rxDtims = (CsrBool) event_unpack_CsrUint16(&buffer);
        evt.appValue.unifi_Value_union.powerConfig.d3AutoScanMode = (unifi_D3AutoScanMode) event_unpack_CsrUint8(&buffer);
        break;
    case unifi_HostConfigValue:
        evt.appValue.unifi_Value_union.hostConfig.powerMode = (unifi_HostPowerMode) event_unpack_CsrUint8(&buffer);
        evt.appValue.unifi_Value_union.hostConfig.applicationDataPeriodMs =  event_unpack_CsrUint16(&buffer);
        break;
    default:
        break;
    };

    unifi_mgt_get_value_cfm(context, evt.appHandle, evt.status, &evt.appValue);

    switch(evt.appValue.id)
    {
    case unifi_CloakedSsidConfigValue:
        CsrPfree(evt.appValue.unifi_Value_union.cloakedSsids.cloakedSsids);
        break;
    case unifi_ScanConfigValue:
        CsrPfree(evt.appValue.unifi_Value_union.scanConfig.passiveChannelList);
        break;
    case unifi_VersionsValue:
        CsrPfree(evt.appValue.unifi_Value_union.versions.smeIdString);
        break;
    case unifi_ConnectionInfoValue:
        CsrPfree(evt.appValue.unifi_Value_union.connectionInfo.beaconFrame);
        CsrPfree(evt.appValue.unifi_Value_union.connectionInfo.associationReqFrame);
        CsrPfree(evt.appValue.unifi_Value_union.connectionInfo.associationRspFrame);
        CsrPfree(evt.appValue.unifi_Value_union.connectionInfo.assocScanInfoElements);
        CsrPfree(evt.appValue.unifi_Value_union.connectionInfo.assocReqInfoElements);
        CsrPfree(evt.appValue.unifi_Value_union.connectionInfo.assocRspInfoElements);
        break;
    case unifi_CalibrationDataValue:
        CsrPfree(evt.appValue.unifi_Value_union.calibrationData.data);
        break;
    case unifi_ConnectionConfigValue:
        CsrPfree(evt.appValue.unifi_Value_union.connectionConfig.mlmeAssociateReqInformationElements);
        break;
    default:
        break;
    };
}

static void event_to_unifi_mgt_ibss_station_ind(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtIbssStationInd_Evt evt;

    evt.appHandlesCount =  event_unpack_CsrUint16(&buffer);
    evt.appHandles = NULL;
    if (evt.appHandlesCount)
    {
        CsrUint16 i1;
        evt.appHandles = (void**)CsrPmalloc(sizeof(void*) * evt.appHandlesCount);
        for(i1 = 0; i1 < evt.appHandlesCount; i1++)
        {
            evt.appHandles = (void*) event_unpack_CsrUint32(&buffer);
        }
    }
    event_unpack_buffer(&buffer, evt.address.data, 6);
    evt.isconnected = (CsrBool) event_unpack_CsrUint16(&buffer);

    unifi_mgt_ibss_station_ind(context, evt.appHandlesCount, evt.appHandles, &evt.address, evt.isconnected);

    CsrPfree(evt.appHandles);
}

static void event_to_unifi_mgt_key_cfm(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtKeyCfm_Evt evt;

    evt.appHandle = (void*) event_unpack_CsrUint32(&buffer);
    evt.status = (unifi_Status) event_unpack_CsrUint8(&buffer);
    evt.action = (unifi_ListAction) event_unpack_CsrUint8(&buffer);

    unifi_mgt_key_cfm(context, evt.appHandle, evt.status, evt.action);

}

static void event_to_unifi_mgt_media_status_ind(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtMediaStatusInd_Evt evt;

    evt.appHandlesCount =  event_unpack_CsrUint16(&buffer);
    evt.appHandles = NULL;
    if (evt.appHandlesCount)
    {
        CsrUint16 i1;
        evt.appHandles = (void**)CsrPmalloc(sizeof(void*) * evt.appHandlesCount);
        for(i1 = 0; i1 < evt.appHandlesCount; i1++)
        {
            evt.appHandles = (void*) event_unpack_CsrUint32(&buffer);
        }
    }
    evt.mediaStatus = (unifi_MediaStatus) event_unpack_CsrUint8(&buffer);
    event_unpack_buffer(&buffer, evt.connectionInfo.ssid.ssid, 32);
    evt.connectionInfo.ssid.length =  event_unpack_CsrUint8(&buffer);
    event_unpack_buffer(&buffer, evt.connectionInfo.bssid.data, 6);
    evt.connectionInfo.networkType80211 = (unifi_80211NetworkType) event_unpack_CsrUint8(&buffer);
    evt.connectionInfo.channelNumber =  event_unpack_CsrUint8(&buffer);
    evt.connectionInfo.channelFrequency =  event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.authMode = (unifi_AuthMode) event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.pairwiseCipher = (unifi_EncryptionMode) event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.groupCipher = (unifi_EncryptionMode) event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.ifIndex = (unifi_RadioIF) event_unpack_CsrUint8(&buffer);
    evt.connectionInfo.atimWindowTu =  event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.beaconPeriodTu =  event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.reassociation = (CsrBool) event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.beaconFrameLength =  event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.beaconFrame = NULL;
    if (evt.connectionInfo.beaconFrameLength)
    {
        evt.connectionInfo.beaconFrame = (CsrUint8*)CsrPmalloc(evt.connectionInfo.beaconFrameLength);
        event_unpack_buffer(&buffer, evt.connectionInfo.beaconFrame, evt.connectionInfo.beaconFrameLength);
    }
    evt.connectionInfo.associationReqFrameLength =  event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.associationReqFrame = NULL;
    if (evt.connectionInfo.associationReqFrameLength)
    {
        evt.connectionInfo.associationReqFrame = (CsrUint8*)CsrPmalloc(evt.connectionInfo.associationReqFrameLength);
        event_unpack_buffer(&buffer, evt.connectionInfo.associationReqFrame, evt.connectionInfo.associationReqFrameLength);
    }
    evt.connectionInfo.associationRspFrameLength =  event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.associationRspFrame = NULL;
    if (evt.connectionInfo.associationRspFrameLength)
    {
        evt.connectionInfo.associationRspFrame = (CsrUint8*)CsrPmalloc(evt.connectionInfo.associationRspFrameLength);
        event_unpack_buffer(&buffer, evt.connectionInfo.associationRspFrame, evt.connectionInfo.associationRspFrameLength);
    }
    evt.connectionInfo.assocScanInfoElementsLength =  event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.assocScanInfoElements = NULL;
    if (evt.connectionInfo.assocScanInfoElementsLength)
    {
        evt.connectionInfo.assocScanInfoElements = (CsrUint8*)CsrPmalloc(evt.connectionInfo.assocScanInfoElementsLength);
        event_unpack_buffer(&buffer, evt.connectionInfo.assocScanInfoElements, evt.connectionInfo.assocScanInfoElementsLength);
    }
    evt.connectionInfo.assocReqCapabilities =  event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.assocReqListenIntervalBeacons =  event_unpack_CsrUint16(&buffer);
    event_unpack_buffer(&buffer, evt.connectionInfo.assocReqApAddress.data, 6);
    evt.connectionInfo.assocReqInfoElementsLength =  event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.assocReqInfoElements = NULL;
    if (evt.connectionInfo.assocReqInfoElementsLength)
    {
        evt.connectionInfo.assocReqInfoElements = (CsrUint8*)CsrPmalloc(evt.connectionInfo.assocReqInfoElementsLength);
        event_unpack_buffer(&buffer, evt.connectionInfo.assocReqInfoElements, evt.connectionInfo.assocReqInfoElementsLength);
    }
    evt.connectionInfo.assocRspResult = (unifi_IEEE80211Result) event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.assocRspCapabilityInfo =  event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.assocRspAssociationId =  event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.assocRspInfoElementsLength =  event_unpack_CsrUint16(&buffer);
    evt.connectionInfo.assocRspInfoElements = NULL;
    if (evt.connectionInfo.assocRspInfoElementsLength)
    {
        evt.connectionInfo.assocRspInfoElements = (CsrUint8*)CsrPmalloc(evt.connectionInfo.assocRspInfoElementsLength);
        event_unpack_buffer(&buffer, evt.connectionInfo.assocRspInfoElements, evt.connectionInfo.assocRspInfoElementsLength);
    }
    evt.disassocReason = (unifi_IEEE80211Reason) event_unpack_CsrUint16(&buffer);
    evt.deauthReason = (unifi_IEEE80211Reason) event_unpack_CsrUint16(&buffer);

    unifi_mgt_media_status_ind(context, evt.appHandlesCount, evt.appHandles, evt.mediaStatus, &evt.connectionInfo, evt.disassocReason, evt.deauthReason);

    CsrPfree(evt.appHandles);
    CsrPfree(evt.connectionInfo.beaconFrame);
    CsrPfree(evt.connectionInfo.associationReqFrame);
    CsrPfree(evt.connectionInfo.associationRspFrame);
    CsrPfree(evt.connectionInfo.assocScanInfoElements);
    CsrPfree(evt.connectionInfo.assocReqInfoElements);
    CsrPfree(evt.connectionInfo.assocRspInfoElements);
}

static void event_to_unifi_mgt_mib_get_cfm(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtMibGetCfm_Evt evt;

    evt.appHandle = (void*) event_unpack_CsrUint32(&buffer);
    evt.status = (unifi_Status) event_unpack_CsrUint8(&buffer);
    evt.mibAttributeLength =  event_unpack_CsrUint16(&buffer);
    evt.mibAttribute = NULL;
    if (evt.mibAttributeLength)
    {
        evt.mibAttribute = (CsrUint8*)CsrPmalloc(evt.mibAttributeLength);
        event_unpack_buffer(&buffer, evt.mibAttribute, evt.mibAttributeLength);
    }

    unifi_mgt_mib_get_cfm(context, evt.appHandle, evt.status, evt.mibAttributeLength, evt.mibAttribute);

    CsrPfree(evt.mibAttribute);
}

static void event_to_unifi_mgt_mib_get_next_cfm(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtMibGetNextCfm_Evt evt;

    evt.appHandle = (void*) event_unpack_CsrUint32(&buffer);
    evt.status = (unifi_Status) event_unpack_CsrUint8(&buffer);
    evt.mibAttributeLength =  event_unpack_CsrUint16(&buffer);
    evt.mibAttribute = NULL;
    if (evt.mibAttributeLength)
    {
        evt.mibAttribute = (CsrUint8*)CsrPmalloc(evt.mibAttributeLength);
        event_unpack_buffer(&buffer, evt.mibAttribute, evt.mibAttributeLength);
    }

    unifi_mgt_mib_get_next_cfm(context, evt.appHandle, evt.status, evt.mibAttributeLength, evt.mibAttribute);

    CsrPfree(evt.mibAttribute);
}

static void event_to_unifi_mgt_mib_set_cfm(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtMibSetCfm_Evt evt;

    evt.appHandle = (void*) event_unpack_CsrUint32(&buffer);
    evt.status = (unifi_Status) event_unpack_CsrUint8(&buffer);

    unifi_mgt_mib_set_cfm(context, evt.appHandle, evt.status);

}

static void event_to_unifi_mgt_mic_failure_ind(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtMicFailureInd_Evt evt;

    evt.appHandlesCount =  event_unpack_CsrUint16(&buffer);
    evt.appHandles = NULL;
    if (evt.appHandlesCount)
    {
        CsrUint16 i1;
        evt.appHandles = (void**)CsrPmalloc(sizeof(void*) * evt.appHandlesCount);
        for(i1 = 0; i1 < evt.appHandlesCount; i1++)
        {
            evt.appHandles = (void*) event_unpack_CsrUint32(&buffer);
        }
    }
    evt.secondFailure = (CsrBool) event_unpack_CsrUint16(&buffer);
    evt.count =  event_unpack_CsrUint16(&buffer);
    event_unpack_buffer(&buffer, evt.address.data, 6);
    evt.keyType = (unifi_KeyType) event_unpack_CsrUint8(&buffer);
    evt.keyId =  event_unpack_CsrUint16(&buffer);
    {
    CsrUint16 i1;
    for(i1 = 0; i1 < 4; i1++)
    {
        evt.tsc[i1] =  event_unpack_CsrUint16(&buffer);
    }
    }

    unifi_mgt_mic_failure_ind(context, evt.appHandlesCount, evt.appHandles, evt.secondFailure, evt.count, &evt.address, evt.keyType, evt.keyId, evt.tsc);

    CsrPfree(evt.appHandles);
}

static void event_to_unifi_mgt_multicast_address_cfm(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtMulticastAddressCfm_Evt evt;

    evt.appHandle = (void*) event_unpack_CsrUint32(&buffer);
    evt.status = (unifi_Status) event_unpack_CsrUint8(&buffer);
    evt.action = (unifi_ListAction) event_unpack_CsrUint8(&buffer);
    evt.getAddressesCount =  event_unpack_CsrUint8(&buffer);
    evt.getAddresses = NULL;
    if (evt.getAddressesCount)
    {
        CsrUint16 i1;
        evt.getAddresses = (unifi_MACAddress*)CsrPmalloc(sizeof(unifi_MACAddress) * evt.getAddressesCount);
        for(i1 = 0; i1 < evt.getAddressesCount; i1++)
        {
            event_unpack_buffer(&buffer, evt.getAddresses[i1].data, 6);
        }
    }

    unifi_mgt_multicast_address_cfm(context, evt.appHandle, evt.status, evt.action, evt.getAddressesCount, evt.getAddresses);

    CsrPfree(evt.getAddresses);
}

static void event_to_unifi_mgt_packet_filter_set_cfm(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtPacketFilterSetCfm_Evt evt;

    evt.appHandle = (void*) event_unpack_CsrUint32(&buffer);
    evt.status = (unifi_Status) event_unpack_CsrUint8(&buffer);

    unifi_mgt_packet_filter_set_cfm(context, evt.appHandle, evt.status);

}

static void event_to_unifi_mgt_pmkid_cfm(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtPmkidCfm_Evt evt;

    evt.appHandle = (void*) event_unpack_CsrUint32(&buffer);
    evt.status = (unifi_Status) event_unpack_CsrUint8(&buffer);
    evt.action = (unifi_ListAction) event_unpack_CsrUint8(&buffer);
    evt.getPmkidsCount =  event_unpack_CsrUint8(&buffer);
    evt.getPmkids = NULL;
    if (evt.getPmkidsCount)
    {
        CsrUint16 i1;
        evt.getPmkids = (unifi_Pmkid*)CsrPmalloc(sizeof(unifi_Pmkid) * evt.getPmkidsCount);
        for(i1 = 0; i1 < evt.getPmkidsCount; i1++)
        {
            event_unpack_buffer(&buffer, evt.getPmkids[i1].bssid.data, 6);
            event_unpack_buffer(&buffer, evt.getPmkids[i1].pmkid, 16);
        }
    }

    unifi_mgt_pmkid_cfm(context, evt.appHandle, evt.status, evt.action, evt.getPmkidsCount, evt.getPmkids);

    CsrPfree(evt.getPmkids);
}

static void event_to_unifi_mgt_pmkid_candidate_list_ind(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtPmkidCandidateListInd_Evt evt;

    evt.appHandlesCount =  event_unpack_CsrUint16(&buffer);
    evt.appHandles = NULL;
    if (evt.appHandlesCount)
    {
        CsrUint16 i1;
        evt.appHandles = (void**)CsrPmalloc(sizeof(void*) * evt.appHandlesCount);
        for(i1 = 0; i1 < evt.appHandlesCount; i1++)
        {
            evt.appHandles = (void*) event_unpack_CsrUint32(&buffer);
        }
    }
    evt.pmkidCandidatesCount =  event_unpack_CsrUint8(&buffer);
    evt.pmkidCandidates = NULL;
    if (evt.pmkidCandidatesCount)
    {
        CsrUint16 i1;
        evt.pmkidCandidates = (unifi_PmkidCandidate*)CsrPmalloc(sizeof(unifi_PmkidCandidate) * evt.pmkidCandidatesCount);
        for(i1 = 0; i1 < evt.pmkidCandidatesCount; i1++)
        {
            event_unpack_buffer(&buffer, evt.pmkidCandidates[i1].bssid.data, 6);
            evt.pmkidCandidates[i1].preAuthAllowed = (CsrBool) event_unpack_CsrUint16(&buffer);
        }
    }

    unifi_mgt_pmkid_candidate_list_ind(context, evt.appHandlesCount, evt.appHandles, evt.pmkidCandidatesCount, evt.pmkidCandidates);

    CsrPfree(evt.appHandles);
    CsrPfree(evt.pmkidCandidates);
}

static void event_to_unifi_mgt_restricted_access_disable_cfm(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtRestrictedAccessDisableCfm_Evt evt;

    evt.appHandle = (void*) event_unpack_CsrUint32(&buffer);
    evt.status = (unifi_Status) event_unpack_CsrUint8(&buffer);

    unifi_mgt_restricted_access_disable_cfm(context, evt.appHandle, evt.status);

}

static void event_to_unifi_mgt_restricted_access_enable_cfm(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtRestrictedAccessEnableCfm_Evt evt;

    evt.appHandle = (void*) event_unpack_CsrUint32(&buffer);
    evt.status = (unifi_Status) event_unpack_CsrUint8(&buffer);

    unifi_mgt_restricted_access_enable_cfm(context, evt.appHandle, evt.status);

}

static void event_to_unifi_mgt_roam_complete_ind(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtRoamCompleteInd_Evt evt;

    evt.appHandlesCount =  event_unpack_CsrUint16(&buffer);
    evt.appHandles = NULL;
    if (evt.appHandlesCount)
    {
        CsrUint16 i1;
        evt.appHandles = (void**)CsrPmalloc(sizeof(void*) * evt.appHandlesCount);
        for(i1 = 0; i1 < evt.appHandlesCount; i1++)
        {
            evt.appHandles = (void*) event_unpack_CsrUint32(&buffer);
        }
    }
    evt.status = (unifi_Status) event_unpack_CsrUint8(&buffer);

    unifi_mgt_roam_complete_ind(context, evt.appHandlesCount, evt.appHandles, evt.status);

    CsrPfree(evt.appHandles);
}

static void event_to_unifi_mgt_roam_start_ind(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtRoamStartInd_Evt evt;

    evt.appHandlesCount =  event_unpack_CsrUint16(&buffer);
    evt.appHandles = NULL;
    if (evt.appHandlesCount)
    {
        CsrUint16 i1;
        evt.appHandles = (void**)CsrPmalloc(sizeof(void*) * evt.appHandlesCount);
        for(i1 = 0; i1 < evt.appHandlesCount; i1++)
        {
            evt.appHandles = (void*) event_unpack_CsrUint32(&buffer);
        }
    }
    evt.roamReason = (unifi_RoamReason) event_unpack_CsrUint8(&buffer);
    evt.reason80211 = (unifi_IEEE80211Reason) event_unpack_CsrUint16(&buffer);

    unifi_mgt_roam_start_ind(context, evt.appHandlesCount, evt.appHandles, evt.roamReason, evt.reason80211);

    CsrPfree(evt.appHandles);
}

static void event_to_unifi_mgt_scan_full_cfm(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtScanFullCfm_Evt evt;

    evt.appHandle = (void*) event_unpack_CsrUint32(&buffer);
    evt.status = (unifi_Status) event_unpack_CsrUint8(&buffer);

    unifi_mgt_scan_full_cfm(context, evt.appHandle, evt.status);

}

static void event_to_unifi_mgt_scan_result_ind(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtScanResultInd_Evt evt;

    evt.appHandlesCount =  event_unpack_CsrUint16(&buffer);
    evt.appHandles = NULL;
    if (evt.appHandlesCount)
    {
        CsrUint16 i1;
        evt.appHandles = (void**)CsrPmalloc(sizeof(void*) * evt.appHandlesCount);
        for(i1 = 0; i1 < evt.appHandlesCount; i1++)
        {
            evt.appHandles = (void*) event_unpack_CsrUint32(&buffer);
        }
    }
    event_unpack_buffer(&buffer, evt.result.ssid.ssid, 32);
    evt.result.ssid.length =  event_unpack_CsrUint8(&buffer);
    event_unpack_buffer(&buffer, evt.result.bssid.data, 6);
    evt.result.rssi =  event_unpack_CsrInt16(&buffer);
    evt.result.snr =  event_unpack_CsrInt16(&buffer);
    evt.result.ifIndex = (unifi_RadioIF) event_unpack_CsrUint8(&buffer);
    evt.result.beaconPeriodTu =  event_unpack_CsrUint16(&buffer);
    event_unpack_buffer(&buffer, evt.result.timeStamp.data, 8);
    event_unpack_buffer(&buffer, evt.result.localTime.data, 8);
    evt.result.channelFrequency =  event_unpack_CsrUint16(&buffer);
    evt.result.capabilityInformation =  event_unpack_CsrUint16(&buffer);
    evt.result.channelNumber =  event_unpack_CsrUint8(&buffer);
    evt.result.usability = (unifi_BasicUsability) event_unpack_CsrUint8(&buffer);
    evt.result.bssType = (unifi_BSSType) event_unpack_CsrUint8(&buffer);
    evt.result.informationElementsLength =  event_unpack_CsrUint16(&buffer);
    evt.result.informationElements = NULL;
    if (evt.result.informationElementsLength)
    {
        evt.result.informationElements = (CsrUint8*)CsrPmalloc(evt.result.informationElementsLength);
        event_unpack_buffer(&buffer, evt.result.informationElements, evt.result.informationElementsLength);
    }

    unifi_mgt_scan_result_ind(context, evt.appHandlesCount, evt.appHandles, &evt.result);

    CsrPfree(evt.appHandles);
    CsrPfree(evt.result.informationElements);
}

static void event_to_unifi_mgt_scan_results_flush_cfm(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtScanResultsFlushCfm_Evt evt;

    evt.appHandle = (void*) event_unpack_CsrUint32(&buffer);
    evt.status = (unifi_Status) event_unpack_CsrUint8(&buffer);

    unifi_mgt_scan_results_flush_cfm(context, evt.appHandle, evt.status);

}

static void event_to_unifi_mgt_scan_results_get_cfm(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtScanResultsGetCfm_Evt evt;

    evt.appHandle = (void*) event_unpack_CsrUint32(&buffer);
    evt.status = (unifi_Status) event_unpack_CsrUint8(&buffer);
    evt.scanResultsCount =  event_unpack_CsrUint16(&buffer);
    evt.scanResults = NULL;
    if (evt.scanResultsCount)
    {
        CsrUint16 i1;
        evt.scanResults = (unifi_ScanResult*)CsrPmalloc(sizeof(unifi_ScanResult) * evt.scanResultsCount);
        for(i1 = 0; i1 < evt.scanResultsCount; i1++)
        {
            event_unpack_buffer(&buffer, evt.scanResults[i1].ssid.ssid, 32);
            evt.scanResults[i1].ssid.length =  event_unpack_CsrUint8(&buffer);
            event_unpack_buffer(&buffer, evt.scanResults[i1].bssid.data, 6);
            evt.scanResults[i1].rssi =  event_unpack_CsrInt16(&buffer);
            evt.scanResults[i1].snr =  event_unpack_CsrInt16(&buffer);
            evt.scanResults[i1].ifIndex = (unifi_RadioIF) event_unpack_CsrUint8(&buffer);
            evt.scanResults[i1].beaconPeriodTu =  event_unpack_CsrUint16(&buffer);
            event_unpack_buffer(&buffer, evt.scanResults[i1].timeStamp.data, 8);
            event_unpack_buffer(&buffer, evt.scanResults[i1].localTime.data, 8);
            evt.scanResults[i1].channelFrequency =  event_unpack_CsrUint16(&buffer);
            evt.scanResults[i1].capabilityInformation =  event_unpack_CsrUint16(&buffer);
            evt.scanResults[i1].channelNumber =  event_unpack_CsrUint8(&buffer);
            evt.scanResults[i1].usability = (unifi_BasicUsability) event_unpack_CsrUint8(&buffer);
            evt.scanResults[i1].bssType = (unifi_BSSType) event_unpack_CsrUint8(&buffer);
            evt.scanResults[i1].informationElementsLength =  event_unpack_CsrUint16(&buffer);
            evt.scanResults[i1].informationElements = NULL;
            if (evt.scanResults[i1].informationElementsLength)
            {
                evt.scanResults[i1].informationElements = (CsrUint8*)CsrPmalloc(evt.scanResults[i1].informationElementsLength);
                event_unpack_buffer(&buffer, evt.scanResults[i1].informationElements, evt.scanResults[i1].informationElementsLength);
            }
        }
    }

    unifi_mgt_scan_results_get_cfm(context, evt.appHandle, evt.status, evt.scanResultsCount, evt.scanResults);

    {
        CsrUint16 i1;
        for(i1 = 0; i1 < evt.scanResultsCount; i1++)
        {
            CsrPfree(evt.scanResults[i1].informationElements);
        }
    }
    CsrPfree(evt.scanResults);
}

static void event_to_unifi_mgt_set_value_cfm(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtSetValueCfm_Evt evt;

    evt.appHandle = (void*) event_unpack_CsrUint32(&buffer);
    evt.status = (unifi_Status) event_unpack_CsrUint8(&buffer);
    evt.appValueId = (unifi_AppValueId) event_unpack_CsrUint8(&buffer);

    unifi_mgt_set_value_cfm(context, evt.appHandle, evt.status, evt.appValueId);

}

static void event_to_unifi_mgt_tspec_ind(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtTspecInd_Evt evt;

    evt.appHandlesCount =  event_unpack_CsrUint16(&buffer);
    evt.appHandles = NULL;
    if (evt.appHandlesCount)
    {
        CsrUint16 i1;
        evt.appHandles = (void**)CsrPmalloc(sizeof(void*) * evt.appHandlesCount);
        for(i1 = 0; i1 < evt.appHandlesCount; i1++)
        {
            evt.appHandles = (void*) event_unpack_CsrUint32(&buffer);
        }
    }
    evt.transactionId =  event_unpack_CsrUint32(&buffer);
    evt.tspecResultCode = (unifi_TspecResultCode) event_unpack_CsrUint8(&buffer);
    evt.tspecLength =  event_unpack_CsrUint16(&buffer);
    evt.tspec = NULL;
    if (evt.tspecLength)
    {
        evt.tspec = (CsrUint8*)CsrPmalloc(evt.tspecLength);
        event_unpack_buffer(&buffer, evt.tspec, evt.tspecLength);
    }

    unifi_mgt_tspec_ind(context, evt.appHandlesCount, evt.appHandles, evt.transactionId, evt.tspecResultCode, evt.tspecLength, evt.tspec);

    CsrPfree(evt.appHandles);
    CsrPfree(evt.tspec);
}

static void event_to_unifi_mgt_tspec_cfm(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtTspecCfm_Evt evt;

    evt.appHandle = (void*) event_unpack_CsrUint32(&buffer);
    evt.status = (unifi_Status) event_unpack_CsrUint8(&buffer);
    evt.transactionId =  event_unpack_CsrUint32(&buffer);
    evt.tspecResultCode = (unifi_TspecResultCode) event_unpack_CsrUint8(&buffer);
    evt.tspecLength =  event_unpack_CsrUint16(&buffer);
    evt.tspec = NULL;
    if (evt.tspecLength)
    {
        evt.tspec = (CsrUint8*)CsrPmalloc(evt.tspecLength);
        event_unpack_buffer(&buffer, evt.tspec, evt.tspecLength);
    }

    unifi_mgt_tspec_cfm(context, evt.appHandle, evt.status, evt.transactionId, evt.tspecResultCode, evt.tspecLength, evt.tspec);

    CsrPfree(evt.tspec);
}

static void event_to_unifi_mgt_wifi_flightmode_cfm(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtWifiFlightmodeCfm_Evt evt;

    evt.appHandle = (void*) event_unpack_CsrUint32(&buffer);
    evt.status = (unifi_Status) event_unpack_CsrUint8(&buffer);

    unifi_mgt_wifi_flightmode_cfm(context, evt.appHandle, evt.status);

}

static void event_to_unifi_mgt_wifi_off_ind(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtWifiOffInd_Evt evt;

    evt.appHandlesCount =  event_unpack_CsrUint16(&buffer);
    evt.appHandles = NULL;
    if (evt.appHandlesCount)
    {
        CsrUint16 i1;
        evt.appHandles = (void**)CsrPmalloc(sizeof(void*) * evt.appHandlesCount);
        for(i1 = 0; i1 < evt.appHandlesCount; i1++)
        {
            evt.appHandles = (void*) event_unpack_CsrUint32(&buffer);
        }
    }
    evt.controlIndication = (unifi_ControlIndication) event_unpack_CsrUint8(&buffer);

    unifi_mgt_wifi_off_ind(context, evt.appHandlesCount, evt.appHandles, evt.controlIndication);

    CsrPfree(evt.appHandles);
}

static void event_to_unifi_mgt_wifi_off_cfm(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtWifiOffCfm_Evt evt;

    evt.appHandle = (void*) event_unpack_CsrUint32(&buffer);
    evt.status = (unifi_Status) event_unpack_CsrUint8(&buffer);

    unifi_mgt_wifi_off_cfm(context, evt.appHandle, evt.status);

}

static void event_to_unifi_mgt_wifi_on_cfm(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiMgtWifiOnCfm_Evt evt;

    evt.appHandle = (void*) event_unpack_CsrUint32(&buffer);
    evt.status = (unifi_Status) event_unpack_CsrUint8(&buffer);

    unifi_mgt_wifi_on_cfm(context, evt.appHandle, evt.status);

}



typedef void (*event_to_fn)(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 size);

static const event_to_fn fnlookup1[56] = {
        NULL,
        event_to_unifi_mgt_wifi_on_cfm,
        NULL,
        event_to_unifi_mgt_wifi_off_cfm,
        event_to_unifi_mgt_wifi_off_ind,
        NULL,
        event_to_unifi_mgt_wifi_flightmode_cfm,
        NULL,
        event_to_unifi_mgt_set_value_cfm,
        NULL,
        event_to_unifi_mgt_get_value_cfm,
        NULL,
        event_to_unifi_mgt_mib_set_cfm,
        NULL,
        event_to_unifi_mgt_mib_get_cfm,
        NULL,
        event_to_unifi_mgt_mib_get_next_cfm,
        NULL,
        event_to_unifi_mgt_scan_full_cfm,
        NULL,
        event_to_unifi_mgt_scan_results_get_cfm,
        event_to_unifi_mgt_scan_result_ind,
        NULL,
        event_to_unifi_mgt_connect_cfm,
        event_to_unifi_mgt_media_status_ind,
        event_to_unifi_mgt_connection_quality_ind,
        NULL,
        event_to_unifi_mgt_disconnect_cfm,
        NULL,
        event_to_unifi_mgt_multicast_address_cfm,
        event_to_unifi_mgt_mic_failure_ind,
        event_to_unifi_mgt_pmkid_candidate_list_ind,
        NULL,
        event_to_unifi_mgt_pmkid_cfm,
        NULL,
        event_to_unifi_mgt_key_cfm,
        NULL,
        event_to_unifi_mgt_packet_filter_set_cfm,
        NULL,
        event_to_unifi_mgt_tspec_cfm,
        event_to_unifi_mgt_tspec_ind,
        NULL,
        event_to_unifi_mgt_scan_results_flush_cfm,
        NULL,
        event_to_unifi_mgt_blacklist_cfm,
        event_to_unifi_mgt_roam_start_ind,
        event_to_unifi_mgt_roam_complete_ind,
        event_to_unifi_mgt_association_start_ind,
        event_to_unifi_mgt_association_complete_ind,
        event_to_unifi_mgt_ibss_station_ind,
        NULL,
        event_to_unifi_mgt_event_mask_set_cfm,
        NULL,
        event_to_unifi_mgt_restricted_access_enable_cfm,
        NULL,
        event_to_unifi_mgt_restricted_access_disable_cfm,

};


CsrBool remote_mgt_signal_receive(FsmContext* context, CsrUint8* buffer, CsrUint16 size)
{
    CsrUint8* tempbuffer = buffer;
    CsrUint16 id = event_unpack_CsrUint16(&tempbuffer);

    if (id >= 0x9001 &&
        id <= 0x9038)
    {
        if (fnlookup1[id - 0x9001])
        {
            (*fnlookup1[id - 0x9001])(context, buffer, size);
            return TRUE;
        }
    }

    return FALSE;
}
