/* This is an autogenerated file */
/* Tag: noCheckHeader */

/*    CONFIDENTIAL */
/*    Copyright (C) Cambridge Silicon Radio Ltd 2008. All rights reserved. */

#include "sme_top_level_fsm/sme.h"
#include "smeio/smeio_fsm_events.h"
#include "event_pack_unpack/event_pack_unpack.h"

CsrUint16 serialise_unifi_mgt_blacklist_req(CsrUint8** resultBuffer, void* appHandle, unifi_ListAction action, CsrUint8 setAddressCount, const unifi_MACAddress *setAddresses)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 4;
    packedSize += 1;
    packedSize += 1;
    if (setAddressCount)
    {
        CsrUint16 i1;
        for(i1 = 0; i1 < setAddressCount; i1++)
        {
            packedSize += 6;
        }
    }

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_MGT_BLACKLIST_REQ_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint32(&buffer, (CsrUint32)appHandle);
    packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)action);
    packedLength += event_pack_CsrUint8(&buffer, setAddressCount);
    if (setAddressCount)
    {
        CsrUint16 i1;
        for(i1 = 0; i1 < setAddressCount; i1++)
        {
            packedLength += event_pack_buffer(&buffer, setAddresses[i1].data, 6);
        }
    }

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_mgt_connect_req(CsrUint8** resultBuffer, void* appHandle, const unifi_ConnectionConfig *connectionConfig)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 4;
    packedSize += 32;
    packedSize += 1;
    packedSize += 6;
    packedSize += 1;
    packedSize += 1;
    packedSize += 1;
    packedSize += 2;
    packedSize += 2;
    packedSize += 2;
    if (connectionConfig->mlmeAssociateReqInformationElementsLength)
    {
        packedSize += connectionConfig->mlmeAssociateReqInformationElementsLength;
    }
    packedSize += 1;
    packedSize += 2;
    packedSize += 1;

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_MGT_CONNECT_REQ_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint32(&buffer, (CsrUint32)appHandle);
    packedLength += event_pack_buffer(&buffer, connectionConfig->ssid.ssid, 32);
    packedLength += event_pack_CsrUint8(&buffer, connectionConfig->ssid.length);
    packedLength += event_pack_buffer(&buffer, connectionConfig->bssid.data, 6);
    packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)connectionConfig->bssType);
    packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)connectionConfig->ifIndex);
    packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)connectionConfig->privacyMode);
    packedLength += event_pack_CsrUint16(&buffer, connectionConfig->authModeMask);
    packedLength += event_pack_CsrUint16(&buffer, connectionConfig->encryptionModeMask);
    packedLength += event_pack_CsrUint16(&buffer, connectionConfig->mlmeAssociateReqInformationElementsLength);
    if (connectionConfig->mlmeAssociateReqInformationElementsLength)
    {
        packedLength += event_pack_buffer(&buffer, connectionConfig->mlmeAssociateReqInformationElements, connectionConfig->mlmeAssociateReqInformationElementsLength);
    }
    packedLength += event_pack_CsrUint8(&buffer, connectionConfig->wmmQosInfo);
    packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)connectionConfig->adhocJoinOnly);
    packedLength += event_pack_CsrUint8(&buffer, connectionConfig->adhocChannel);

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_mgt_disconnect_req(CsrUint8** resultBuffer, void* appHandle)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 4;

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_MGT_DISCONNECT_REQ_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint32(&buffer, (CsrUint32)appHandle);

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_mgt_event_mask_set_req(CsrUint8** resultBuffer, void* appHandle, CsrUint32 indMask)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 4;
    packedSize += 4;

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_MGT_EVENT_MASK_SET_REQ_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint32(&buffer, (CsrUint32)appHandle);
    packedLength += event_pack_CsrUint32(&buffer, indMask);

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_mgt_get_value_req(CsrUint8** resultBuffer, void* appHandle, unifi_AppValueId appValueId)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 4;
    packedSize += 1;

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_MGT_GET_VALUE_REQ_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint32(&buffer, (CsrUint32)appHandle);
    packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)appValueId);

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_mgt_key_req(CsrUint8** resultBuffer, void* appHandle, unifi_ListAction action, const unifi_Key *key)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 4;
    packedSize += 1;
    packedSize += 1;
    packedSize += 1;
    packedSize += 2;
    {
    CsrUint16 i2;
    for(i2 = 0; i2 < 8; i2++)
    {
        packedSize += 16;
    }
    }
    packedSize += 2;
    packedSize += 6;
    packedSize += 1;
    packedSize += 32;

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_MGT_KEY_REQ_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint32(&buffer, (CsrUint32)appHandle);
    packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)action);
    packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)key->keyType);
    packedLength += event_pack_CsrUint8(&buffer, key->keyIndex);
    packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)key->wepTxKey);
    {
    CsrUint16 i2;
    for(i2 = 0; i2 < 8; i2++)
    {
        packedLength += event_pack_CsrUint16(&buffer, key->keyRsc[i2]);
    }
    }
    packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)key->authenticator);
    packedLength += event_pack_buffer(&buffer, key->address.data, 6);
    packedLength += event_pack_CsrUint8(&buffer, key->keyLength);
    packedLength += event_pack_buffer(&buffer, key->key, 32);

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_mgt_mib_get_req(CsrUint8** resultBuffer, void* appHandle, CsrUint16 mibAttributeLength, const CsrUint8 *mibAttribute)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 4;
    packedSize += 2;
    if (mibAttributeLength)
    {
        packedSize += mibAttributeLength;
    }

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_MGT_MIB_GET_REQ_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint32(&buffer, (CsrUint32)appHandle);
    packedLength += event_pack_CsrUint16(&buffer, mibAttributeLength);
    if (mibAttributeLength)
    {
        packedLength += event_pack_buffer(&buffer, mibAttribute, mibAttributeLength);
    }

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_mgt_mib_get_next_req(CsrUint8** resultBuffer, void* appHandle, CsrUint16 mibAttributeLength, const CsrUint8 *mibAttribute)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 4;
    packedSize += 2;
    if (mibAttributeLength)
    {
        packedSize += mibAttributeLength;
    }

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_MGT_MIB_GET_NEXT_REQ_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint32(&buffer, (CsrUint32)appHandle);
    packedLength += event_pack_CsrUint16(&buffer, mibAttributeLength);
    if (mibAttributeLength)
    {
        packedLength += event_pack_buffer(&buffer, mibAttribute, mibAttributeLength);
    }

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_mgt_mib_set_req(CsrUint8** resultBuffer, void* appHandle, CsrUint16 mibAttributeLength, const CsrUint8 *mibAttribute)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 4;
    packedSize += 2;
    if (mibAttributeLength)
    {
        packedSize += mibAttributeLength;
    }

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_MGT_MIB_SET_REQ_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint32(&buffer, (CsrUint32)appHandle);
    packedLength += event_pack_CsrUint16(&buffer, mibAttributeLength);
    if (mibAttributeLength)
    {
        packedLength += event_pack_buffer(&buffer, mibAttribute, mibAttributeLength);
    }

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_mgt_multicast_address_req(CsrUint8** resultBuffer, void* appHandle, unifi_ListAction action, CsrUint8 setAddressesCount, const unifi_MACAddress *setAddresses)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 4;
    packedSize += 1;
    packedSize += 1;
    if (setAddressesCount)
    {
        CsrUint16 i1;
        for(i1 = 0; i1 < setAddressesCount; i1++)
        {
            packedSize += 6;
        }
    }

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_MGT_MULTICAST_ADDRESS_REQ_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint32(&buffer, (CsrUint32)appHandle);
    packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)action);
    packedLength += event_pack_CsrUint8(&buffer, setAddressesCount);
    if (setAddressesCount)
    {
        CsrUint16 i1;
        for(i1 = 0; i1 < setAddressesCount; i1++)
        {
            packedLength += event_pack_buffer(&buffer, setAddresses[i1].data, 6);
        }
    }

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_mgt_packet_filter_set_req(CsrUint8** resultBuffer, void* appHandle, CsrUint16 filterLength, const CsrUint8 *filter, unifi_PacketFilterMode mode, const unifi_IPV4Address *arpFilterAddress)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 4;
    packedSize += 2;
    if (filterLength)
    {
        packedSize += filterLength;
    }
    packedSize += 1;
    packedSize += 4;

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_MGT_PACKET_FILTER_SET_REQ_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint32(&buffer, (CsrUint32)appHandle);
    packedLength += event_pack_CsrUint16(&buffer, filterLength);
    if (filterLength)
    {
        packedLength += event_pack_buffer(&buffer, filter, filterLength);
    }
    packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)mode);
    packedLength += event_pack_buffer(&buffer, arpFilterAddress->a, 4);

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_mgt_pmkid_req(CsrUint8** resultBuffer, void* appHandle, unifi_ListAction action, CsrUint8 setPmkidsCount, const unifi_Pmkid *setPmkids)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 4;
    packedSize += 1;
    packedSize += 1;
    if (setPmkidsCount)
    {
        CsrUint16 i1;
        for(i1 = 0; i1 < setPmkidsCount; i1++)
        {
            packedSize += 6;
            packedSize += 16;
        }
    }

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_MGT_PMKID_REQ_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint32(&buffer, (CsrUint32)appHandle);
    packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)action);
    packedLength += event_pack_CsrUint8(&buffer, setPmkidsCount);
    if (setPmkidsCount)
    {
        CsrUint16 i1;
        for(i1 = 0; i1 < setPmkidsCount; i1++)
        {
            packedLength += event_pack_buffer(&buffer, setPmkids[i1].bssid.data, 6);
            packedLength += event_pack_buffer(&buffer, setPmkids[i1].pmkid, 16);
        }
    }

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_mgt_restricted_access_disable_req(CsrUint8** resultBuffer, void* appHandle)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 4;

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_MGT_RESTRICTED_ACCESS_DISABLE_REQ_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint32(&buffer, (CsrUint32)appHandle);

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_mgt_restricted_access_enable_req(CsrUint8** resultBuffer, void* appHandle)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 4;

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_MGT_RESTRICTED_ACCESS_ENABLE_REQ_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint32(&buffer, (CsrUint32)appHandle);

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_mgt_scan_full_req(CsrUint8** resultBuffer, void* appHandle, CsrUint8 ssidCount, const unifi_SSID *ssid, const unifi_MACAddress *bssid, CsrBool forceScan, unifi_BSSType bssType, unifi_ScanType scanType, CsrUint16 channelListCount, const CsrUint8 *channelList, CsrUint16 probeIeLength, const CsrUint8 *probeIe)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 4;
    packedSize += 1;
    if (ssidCount)
    {
        CsrUint16 i1;
        for(i1 = 0; i1 < ssidCount; i1++)
        {
            packedSize += 32;
            packedSize += 1;
        }
    }
    packedSize += 6;
    packedSize += 2;
    packedSize += 1;
    packedSize += 1;
    packedSize += 2;
    if (channelListCount)
    {
        packedSize += channelListCount;
    }
    packedSize += 2;
    if (probeIeLength)
    {
        packedSize += probeIeLength;
    }

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_MGT_SCAN_FULL_REQ_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint32(&buffer, (CsrUint32)appHandle);
    packedLength += event_pack_CsrUint8(&buffer, ssidCount);
    if (ssidCount)
    {
        CsrUint16 i1;
        for(i1 = 0; i1 < ssidCount; i1++)
        {
            packedLength += event_pack_buffer(&buffer, ssid[i1].ssid, 32);
            packedLength += event_pack_CsrUint8(&buffer, ssid[i1].length);
        }
    }
    packedLength += event_pack_buffer(&buffer, bssid->data, 6);
    packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)forceScan);
    packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)bssType);
    packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)scanType);
    packedLength += event_pack_CsrUint16(&buffer, channelListCount);
    if (channelListCount)
    {
        packedLength += event_pack_buffer(&buffer, channelList, channelListCount);
    }
    packedLength += event_pack_CsrUint16(&buffer, probeIeLength);
    if (probeIeLength)
    {
        packedLength += event_pack_buffer(&buffer, probeIe, probeIeLength);
    }

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_mgt_scan_results_flush_req(CsrUint8** resultBuffer, void* appHandle)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 4;

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_MGT_SCAN_RESULTS_FLUSH_REQ_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint32(&buffer, (CsrUint32)appHandle);

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_mgt_scan_results_get_req(CsrUint8** resultBuffer, void* appHandle)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 4;

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_MGT_SCAN_RESULTS_GET_REQ_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint32(&buffer, (CsrUint32)appHandle);

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_mgt_set_value_req(CsrUint8** resultBuffer, void* appHandle, const unifi_AppValue *appValue)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 4;
    packedSize += 1;
    switch(appValue->id)
    {
    case unifi_CloakedSsidConfigValue:
        packedSize += 1;
        if (appValue->unifi_Value_union.cloakedSsids.cloakedSsidsCount)
        {
            CsrUint16 i4;
            for(i4 = 0; i4 < appValue->unifi_Value_union.cloakedSsids.cloakedSsidsCount; i4++)
            {
                packedSize += 32;
                packedSize += 1;
            }
        }
        break;
    case unifi_ScanConfigValue:
        {
        CsrUint16 i4;
        for(i4 = 0; i4 < 4; i4++)
        {
            packedSize += 2;
            packedSize += 2;
            packedSize += 2;
            packedSize += 2;
            packedSize += 2;
            packedSize += 2;
        }
        }
        packedSize += 2;
        packedSize += 2;
        packedSize += 1;
        packedSize += 1;
        packedSize += 1;
        packedSize += 1;
        packedSize += 1;
        packedSize += 1;
        packedSize += 2;
        if (appValue->unifi_Value_union.scanConfig.passiveChannelListCount)
        {
            packedSize += appValue->unifi_Value_union.scanConfig.passiveChannelListCount;
        }
        break;
    case unifi_RegulatoryDomainInfoValue:
        packedSize += 2;
        packedSize += 2;
        packedSize += 1;
        packedSize += 2;
        break;
    case unifi_SmeConfigValue:
        packedSize += 1;
        packedSize += 1;
        packedSize += 1;
        packedSize += 2;
        packedSize += 1;
        packedSize += 1;
        packedSize += 1;
        packedSize += 2;
        packedSize += 2;
        break;
    case unifi_VersionsValue:
        packedSize += 4;
        packedSize += 4;
        packedSize += 4;
        packedSize += 4;
        packedSize += 4;
        packedSize += 4;
        packedSize += 4;
        packedSize += 4;
        packedSize += 4;
        packedSize += 4;
        packedSize += (CsrUint16)(CsrStrLen(appValue->unifi_Value_union.versions.smeIdString) + 3);
        break;
    case unifi_CoexConfigValue:
        packedSize += 2;
        packedSize += 2;
        packedSize += 2;
        packedSize += 2;
        packedSize += 1;
        packedSize += 2;
        packedSize += 2;
        packedSize += 2;
        packedSize += 2;
        packedSize += 2;
        packedSize += 2;
        packedSize += 2;
        break;
    case unifi_LinkQualityValue:
        packedSize += 2;
        packedSize += 2;
        break;
    case unifi_StationMACAddressValue:
        packedSize += 6;
        break;
    case unifi_MibConfigValue:
        packedSize += 2;
        packedSize += 1;
        packedSize += 2;
        packedSize += 2;
        packedSize += 2;
        break;
    case unifi_PermanentMACAddressValue:
        packedSize += 6;
        break;
    case unifi_ConnectionStatsValue:
        packedSize += 1;
        packedSize += 1;
        packedSize += 4;
        packedSize += 4;
        packedSize += 4;
        packedSize += 4;
        packedSize += 4;
        packedSize += 4;
        packedSize += 4;
        packedSize += 4;
        packedSize += 4;
        packedSize += 4;
        packedSize += 4;
        packedSize += 4;
        packedSize += 4;
        packedSize += 4;
        packedSize += 4;
        packedSize += 4;
        packedSize += 4;
        packedSize += 4;
        packedSize += 4;
        packedSize += 4;
        packedSize += 4;
        packedSize += 4;
        packedSize += 4;
        break;
    case unifi_RoamingConfigValue:
        {
        CsrUint16 i4;
        for(i4 = 0; i4 < 3; i4++)
        {
            packedSize += 2;
            packedSize += 2;
            packedSize += 2;
            packedSize += 2;
            packedSize += 4;
            packedSize += 4;
            packedSize += 1;
            packedSize += 1;
            packedSize += 1;
            packedSize += 1;
            packedSize += 1;
            packedSize += 1;
        }
        }
        packedSize += 1;
        packedSize += 1;
        packedSize += 1;
        packedSize += 1;
        packedSize += 2;
        packedSize += 1;
        {
        CsrUint16 i4;
        for(i4 = 0; i4 < 3; i4++)
        {
            packedSize += 2;
            packedSize += 2;
            packedSize += 2;
            packedSize += 2;
            packedSize += 2;
            packedSize += 2;
        }
        }
        break;
    case unifi_AdHocConfigValue:
        packedSize += 2;
        packedSize += 2;
        packedSize += 2;
        packedSize += 2;
        break;
    case unifi_ConnectionInfoValue:
        packedSize += 32;
        packedSize += 1;
        packedSize += 6;
        packedSize += 1;
        packedSize += 1;
        packedSize += 2;
        packedSize += 2;
        packedSize += 2;
        packedSize += 2;
        packedSize += 1;
        packedSize += 2;
        packedSize += 2;
        packedSize += 2;
        packedSize += 2;
        if (appValue->unifi_Value_union.connectionInfo.beaconFrameLength)
        {
            packedSize += appValue->unifi_Value_union.connectionInfo.beaconFrameLength;
        }
        packedSize += 2;
        if (appValue->unifi_Value_union.connectionInfo.associationReqFrameLength)
        {
            packedSize += appValue->unifi_Value_union.connectionInfo.associationReqFrameLength;
        }
        packedSize += 2;
        if (appValue->unifi_Value_union.connectionInfo.associationRspFrameLength)
        {
            packedSize += appValue->unifi_Value_union.connectionInfo.associationRspFrameLength;
        }
        packedSize += 2;
        if (appValue->unifi_Value_union.connectionInfo.assocScanInfoElementsLength)
        {
            packedSize += appValue->unifi_Value_union.connectionInfo.assocScanInfoElementsLength;
        }
        packedSize += 2;
        packedSize += 2;
        packedSize += 6;
        packedSize += 2;
        if (appValue->unifi_Value_union.connectionInfo.assocReqInfoElementsLength)
        {
            packedSize += appValue->unifi_Value_union.connectionInfo.assocReqInfoElementsLength;
        }
        packedSize += 2;
        packedSize += 2;
        packedSize += 2;
        packedSize += 2;
        if (appValue->unifi_Value_union.connectionInfo.assocRspInfoElementsLength)
        {
            packedSize += appValue->unifi_Value_union.connectionInfo.assocRspInfoElementsLength;
        }
        break;
    case unifi_CoexInfoValue:
        packedSize += 2;
        packedSize += 1;
        packedSize += 2;
        packedSize += 1;
        packedSize += 2;
        packedSize += 2;
        packedSize += 2;
        packedSize += 4;
        packedSize += 4;
        packedSize += 1;
        break;
    case unifi_CalibrationDataValue:
        packedSize += 2;
        if (appValue->unifi_Value_union.calibrationData.length)
        {
            packedSize += appValue->unifi_Value_union.calibrationData.length;
        }
        break;
    case unifi_ConnectionConfigValue:
        packedSize += 32;
        packedSize += 1;
        packedSize += 6;
        packedSize += 1;
        packedSize += 1;
        packedSize += 1;
        packedSize += 2;
        packedSize += 2;
        packedSize += 2;
        if (appValue->unifi_Value_union.connectionConfig.mlmeAssociateReqInformationElementsLength)
        {
            packedSize += appValue->unifi_Value_union.connectionConfig.mlmeAssociateReqInformationElementsLength;
        }
        packedSize += 1;
        packedSize += 2;
        packedSize += 1;
        break;
    case unifi_CcxConfigValue:
        packedSize += 1;
        packedSize += 2;
        packedSize += 1;
        packedSize += 2;
        break;
    case unifi_PowerConfigValue:
        packedSize += 1;
        packedSize += 2;
        packedSize += 2;
        packedSize += 1;
        break;
    case unifi_HostConfigValue:
        packedSize += 1;
        packedSize += 2;
        break;
    default:
        break;
    };

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_MGT_SET_VALUE_REQ_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint32(&buffer, (CsrUint32)appHandle);
    packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)appValue->id);
    switch(appValue->id)
    {
    case unifi_CloakedSsidConfigValue:
        packedLength += event_pack_CsrUint8(&buffer, appValue->unifi_Value_union.cloakedSsids.cloakedSsidsCount);
        if (appValue->unifi_Value_union.cloakedSsids.cloakedSsidsCount)
        {
            CsrUint16 i4;
            for(i4 = 0; i4 < appValue->unifi_Value_union.cloakedSsids.cloakedSsidsCount; i4++)
            {
                packedLength += event_pack_buffer(&buffer, appValue->unifi_Value_union.cloakedSsids.cloakedSsids[i4].ssid, 32);
                packedLength += event_pack_CsrUint8(&buffer, appValue->unifi_Value_union.cloakedSsids.cloakedSsids[i4].length);
            }
        }
        break;
    case unifi_ScanConfigValue:
        {
        CsrUint16 i4;
        for(i4 = 0; i4 < 4; i4++)
        {
            packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.scanConfig.scanCfg[i4].intervalSeconds);
            packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.scanConfig.scanCfg[i4].validitySeconds);
            packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.scanConfig.scanCfg[i4].minActiveChannelTimeTu);
            packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.scanConfig.scanCfg[i4].maxActiveChannelTimeTu);
            packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.scanConfig.scanCfg[i4].minPassiveChannelTimeTu);
            packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.scanConfig.scanCfg[i4].maxPassiveChannelTimeTu);
        }
        }
        packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)appValue->unifi_Value_union.scanConfig.disableAutonomousScans);
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.scanConfig.maxResults);
        packedLength += event_pack_CsrInt8(&buffer, appValue->unifi_Value_union.scanConfig.highRSSIThreshold);
        packedLength += event_pack_CsrInt8(&buffer, appValue->unifi_Value_union.scanConfig.lowRSSIThreshold);
        packedLength += event_pack_CsrInt8(&buffer, appValue->unifi_Value_union.scanConfig.deltaRSSIThreshold);
        packedLength += event_pack_CsrInt8(&buffer, appValue->unifi_Value_union.scanConfig.highSNRThreshold);
        packedLength += event_pack_CsrInt8(&buffer, appValue->unifi_Value_union.scanConfig.lowSNRThreshold);
        packedLength += event_pack_CsrInt8(&buffer, appValue->unifi_Value_union.scanConfig.deltaSNRThreshold);
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.scanConfig.passiveChannelListCount);
        if (appValue->unifi_Value_union.scanConfig.passiveChannelListCount)
        {
            packedLength += event_pack_buffer(&buffer, appValue->unifi_Value_union.scanConfig.passiveChannelList, appValue->unifi_Value_union.scanConfig.passiveChannelListCount);
        }
        break;
    case unifi_RegulatoryDomainInfoValue:
        packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)appValue->unifi_Value_union.regDomInfo.dot11MultiDomainCapabilityImplemented);
        packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)appValue->unifi_Value_union.regDomInfo.dot11MultiDomainCapabilityEnabled);
        packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)appValue->unifi_Value_union.regDomInfo.currentRegulatoryDomain);
        packedLength += event_pack_buffer(&buffer, appValue->unifi_Value_union.regDomInfo.currentCountryCode, 2);
        break;
    case unifi_SmeConfigValue:
        packedLength += event_pack_CsrUint8(&buffer, appValue->unifi_Value_union.smeConfig.connectionQualityRssiChangeTrigger);
        packedLength += event_pack_CsrUint8(&buffer, appValue->unifi_Value_union.smeConfig.connectionQualitySnrChangeTrigger);
        packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)appValue->unifi_Value_union.smeConfig.trustLevel);
        packedLength += event_pack_buffer(&buffer, appValue->unifi_Value_union.smeConfig.countryCode, 2);
        packedLength += event_pack_CsrUint8(&buffer, appValue->unifi_Value_union.smeConfig.wmmModeMask);
        packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)appValue->unifi_Value_union.smeConfig.ifIndex);
        packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)appValue->unifi_Value_union.smeConfig.firmwareDriverInterface);
        packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)appValue->unifi_Value_union.smeConfig.allowUnicastUseGroupCipher);
        packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)appValue->unifi_Value_union.smeConfig.enableRestrictedAccess);
        break;
    case unifi_VersionsValue:
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.versions.chipId);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.versions.chipVersion);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.versions.firmwareBuild);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.versions.firmwarePatch);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.versions.firmwareHip);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.versions.driverBuild);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.versions.driverHip);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.versions.smeBuild);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.versions.smeVariant);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.versions.smeHip);
        packedLength += event_pack_string(&buffer, appValue->unifi_Value_union.versions.smeIdString);
        break;
    case unifi_CoexConfigValue:
        packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)appValue->unifi_Value_union.coexConfig.coexEnable);
        packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)appValue->unifi_Value_union.coexConfig.coexAfhChannelEnable);
        packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)appValue->unifi_Value_union.coexConfig.coexAdvancedEnable);
        packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)appValue->unifi_Value_union.coexConfig.coexEnableSchemeManagement);
        packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)appValue->unifi_Value_union.coexConfig.coexDirection);
        packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)appValue->unifi_Value_union.coexConfig.coexPeriodicWakeHost);
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.coexConfig.coexTrafficBurstyLatencyMs);
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.coexConfig.coexTrafficContinuousLatencyMs);
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.coexConfig.coexObexBlackoutDurationMs);
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.coexConfig.coexObexBlackoutPeriodMs);
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.coexConfig.coexA2dpBlackoutDurationMs);
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.coexConfig.coexA2dpBlackoutPeriodMs);
        break;
    case unifi_LinkQualityValue:
        packedLength += event_pack_CsrInt16(&buffer, appValue->unifi_Value_union.linkQuality.unifiRssi);
        packedLength += event_pack_CsrInt16(&buffer, appValue->unifi_Value_union.linkQuality.unifiSnr);
        break;
    case unifi_StationMACAddressValue:
        packedLength += event_pack_buffer(&buffer, appValue->unifi_Value_union.stationMacAddress.data, 6);
        break;
    case unifi_MibConfigValue:
        packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)appValue->unifi_Value_union.mibConfig.unifiFixMaxTxDataRate);
        packedLength += event_pack_CsrUint8(&buffer, appValue->unifi_Value_union.mibConfig.unifiFixTxDataRate);
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.mibConfig.dot11RtsThreshold);
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.mibConfig.dot11FragmentationThreshold);
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.mibConfig.dot11CurrentTxPowerLevel);
        break;
    case unifi_PermanentMACAddressValue:
        packedLength += event_pack_buffer(&buffer, appValue->unifi_Value_union.permanentMacAddress.data, 6);
        break;
    case unifi_ConnectionStatsValue:
        packedLength += event_pack_CsrUint8(&buffer, appValue->unifi_Value_union.connectionStats.unifiTxDataRate);
        packedLength += event_pack_CsrUint8(&buffer, appValue->unifi_Value_union.connectionStats.unifiRxDataRate);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.connectionStats.dot11RetryCount);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.connectionStats.dot11MultipleRetryCount);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.connectionStats.dot11AckFailureCount);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.connectionStats.dot11FrameDuplicateCount);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.connectionStats.dot11FcsErrorCount);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.connectionStats.dot11RtsSuccessCount);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.connectionStats.dot11RtsFailureCount);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.connectionStats.dot11FailedCount);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.connectionStats.dot11TransmittedFragmentCount);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.connectionStats.dot11TransmittedFrameCount);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.connectionStats.dot11WEPExcludedCount);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.connectionStats.dot11WEPICVErrorCount);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.connectionStats.dot11WEPUndecryptableCount);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.connectionStats.dot11MulticastReceivedFrameCount);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.connectionStats.dot11MulticastTransmittedFrameCount);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.connectionStats.dot11ReceivedFragmentCount);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.connectionStats.dot11RSNA4WayHandshakeFailures);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.connectionStats.dot11RSNATKIPCounterMeasuresInvoked);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.connectionStats.dot11RSNAStatsTKIPLocalMICFailures);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.connectionStats.dot11RSNAStatsTKIPReplays);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.connectionStats.dot11RSNAStatsTKIPICVErrors);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.connectionStats.dot11RSNAStatsCCMPReplays);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.connectionStats.dot11RSNAStatsCCMPDecryptErrors);
        break;
    case unifi_RoamingConfigValue:
        {
        CsrUint16 i4;
        for(i4 = 0; i4 < 3; i4++)
        {
            packedLength += event_pack_CsrInt16(&buffer, appValue->unifi_Value_union.roamingConfig.roamingBands[i4].rssiHighThreshold);
            packedLength += event_pack_CsrInt16(&buffer, appValue->unifi_Value_union.roamingConfig.roamingBands[i4].rssiLowThreshold);
            packedLength += event_pack_CsrInt16(&buffer, appValue->unifi_Value_union.roamingConfig.roamingBands[i4].snrHighThreshold);
            packedLength += event_pack_CsrInt16(&buffer, appValue->unifi_Value_union.roamingConfig.roamingBands[i4].snrLowThreshold);
            packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.roamingConfig.roamingBands[i4].monitorInterval);
            packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.roamingConfig.roamingBands[i4].monitorWindow);
            packedLength += event_pack_CsrUint8(&buffer, appValue->unifi_Value_union.roamingConfig.roamingBands[i4].dot11RetryRatio);
            packedLength += event_pack_CsrUint8(&buffer, appValue->unifi_Value_union.roamingConfig.roamingBands[i4].dot11MultipleRetryRatio);
            packedLength += event_pack_CsrUint8(&buffer, appValue->unifi_Value_union.roamingConfig.roamingBands[i4].dot11AckFailureRatio);
            packedLength += event_pack_CsrUint8(&buffer, appValue->unifi_Value_union.roamingConfig.roamingBands[i4].dot11FcsErrorRatio);
            packedLength += event_pack_CsrUint8(&buffer, appValue->unifi_Value_union.roamingConfig.roamingBands[i4].dot11RtsFailureRatio);
            packedLength += event_pack_CsrUint8(&buffer, appValue->unifi_Value_union.roamingConfig.roamingBands[i4].beaconLossThreshold);
        }
        }
        packedLength += event_pack_CsrUint8(&buffer, appValue->unifi_Value_union.roamingConfig.lowQualHystWindow);
        packedLength += event_pack_CsrUint8(&buffer, appValue->unifi_Value_union.roamingConfig.apBlockTimeMs);
        packedLength += event_pack_CsrUint8(&buffer, appValue->unifi_Value_union.roamingConfig.roamMonitorPeriodMs);
        packedLength += event_pack_CsrUint8(&buffer, appValue->unifi_Value_union.roamingConfig.roamNumMaxTh);
        packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)appValue->unifi_Value_union.roamingConfig.disableRoamScans);
        packedLength += event_pack_CsrUint8(&buffer, appValue->unifi_Value_union.roamingConfig.reconnectLimit);
        {
        CsrUint16 i4;
        for(i4 = 0; i4 < 3; i4++)
        {
            packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.roamingConfig.roamScanCfg[i4].intervalSeconds);
            packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.roamingConfig.roamScanCfg[i4].validitySeconds);
            packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.roamingConfig.roamScanCfg[i4].minActiveChannelTimeTu);
            packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.roamingConfig.roamScanCfg[i4].maxActiveChannelTimeTu);
            packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.roamingConfig.roamScanCfg[i4].minPassiveChannelTimeTu);
            packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.roamingConfig.roamScanCfg[i4].maxPassiveChannelTimeTu);
        }
        }
        break;
    case unifi_AdHocConfigValue:
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.adHocConfig.atimWindowTu);
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.adHocConfig.beaconPeriodTu);
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.adHocConfig.joinOnlyAttempts);
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.adHocConfig.joinAttemptIntervalMs);
        break;
    case unifi_ConnectionInfoValue:
        packedLength += event_pack_buffer(&buffer, appValue->unifi_Value_union.connectionInfo.ssid.ssid, 32);
        packedLength += event_pack_CsrUint8(&buffer, appValue->unifi_Value_union.connectionInfo.ssid.length);
        packedLength += event_pack_buffer(&buffer, appValue->unifi_Value_union.connectionInfo.bssid.data, 6);
        packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)appValue->unifi_Value_union.connectionInfo.networkType80211);
        packedLength += event_pack_CsrUint8(&buffer, appValue->unifi_Value_union.connectionInfo.channelNumber);
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.connectionInfo.channelFrequency);
        packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)appValue->unifi_Value_union.connectionInfo.authMode);
        packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)appValue->unifi_Value_union.connectionInfo.pairwiseCipher);
        packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)appValue->unifi_Value_union.connectionInfo.groupCipher);
        packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)appValue->unifi_Value_union.connectionInfo.ifIndex);
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.connectionInfo.atimWindowTu);
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.connectionInfo.beaconPeriodTu);
        packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)appValue->unifi_Value_union.connectionInfo.reassociation);
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.connectionInfo.beaconFrameLength);
        if (appValue->unifi_Value_union.connectionInfo.beaconFrameLength)
        {
            packedLength += event_pack_buffer(&buffer, appValue->unifi_Value_union.connectionInfo.beaconFrame, appValue->unifi_Value_union.connectionInfo.beaconFrameLength);
        }
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.connectionInfo.associationReqFrameLength);
        if (appValue->unifi_Value_union.connectionInfo.associationReqFrameLength)
        {
            packedLength += event_pack_buffer(&buffer, appValue->unifi_Value_union.connectionInfo.associationReqFrame, appValue->unifi_Value_union.connectionInfo.associationReqFrameLength);
        }
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.connectionInfo.associationRspFrameLength);
        if (appValue->unifi_Value_union.connectionInfo.associationRspFrameLength)
        {
            packedLength += event_pack_buffer(&buffer, appValue->unifi_Value_union.connectionInfo.associationRspFrame, appValue->unifi_Value_union.connectionInfo.associationRspFrameLength);
        }
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.connectionInfo.assocScanInfoElementsLength);
        if (appValue->unifi_Value_union.connectionInfo.assocScanInfoElementsLength)
        {
            packedLength += event_pack_buffer(&buffer, appValue->unifi_Value_union.connectionInfo.assocScanInfoElements, appValue->unifi_Value_union.connectionInfo.assocScanInfoElementsLength);
        }
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.connectionInfo.assocReqCapabilities);
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.connectionInfo.assocReqListenIntervalBeacons);
        packedLength += event_pack_buffer(&buffer, appValue->unifi_Value_union.connectionInfo.assocReqApAddress.data, 6);
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.connectionInfo.assocReqInfoElementsLength);
        if (appValue->unifi_Value_union.connectionInfo.assocReqInfoElementsLength)
        {
            packedLength += event_pack_buffer(&buffer, appValue->unifi_Value_union.connectionInfo.assocReqInfoElements, appValue->unifi_Value_union.connectionInfo.assocReqInfoElementsLength);
        }
        packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)appValue->unifi_Value_union.connectionInfo.assocRspResult);
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.connectionInfo.assocRspCapabilityInfo);
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.connectionInfo.assocRspAssociationId);
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.connectionInfo.assocRspInfoElementsLength);
        if (appValue->unifi_Value_union.connectionInfo.assocRspInfoElementsLength)
        {
            packedLength += event_pack_buffer(&buffer, appValue->unifi_Value_union.connectionInfo.assocRspInfoElements, appValue->unifi_Value_union.connectionInfo.assocRspInfoElementsLength);
        }
        break;
    case unifi_CoexInfoValue:
        packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)appValue->unifi_Value_union.coexInfo.hasTrafficData);
        packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)appValue->unifi_Value_union.coexInfo.currentTrafficType);
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.coexInfo.currentPeriodMs);
        packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)appValue->unifi_Value_union.coexInfo.currentPowerSave);
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.coexInfo.currentCoexPeriodMs);
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.coexInfo.currentCoexLatencyMs);
        packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)appValue->unifi_Value_union.coexInfo.hasBtDevice);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.coexInfo.currentBlackoutDurationUs);
        packedLength += event_pack_CsrUint32(&buffer, appValue->unifi_Value_union.coexInfo.currentBlackoutPeriodUs);
        packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)appValue->unifi_Value_union.coexInfo.currentCoexScheme);
        break;
    case unifi_CalibrationDataValue:
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.calibrationData.length);
        if (appValue->unifi_Value_union.calibrationData.length)
        {
            packedLength += event_pack_buffer(&buffer, appValue->unifi_Value_union.calibrationData.data, appValue->unifi_Value_union.calibrationData.length);
        }
        break;
    case unifi_ConnectionConfigValue:
        packedLength += event_pack_buffer(&buffer, appValue->unifi_Value_union.connectionConfig.ssid.ssid, 32);
        packedLength += event_pack_CsrUint8(&buffer, appValue->unifi_Value_union.connectionConfig.ssid.length);
        packedLength += event_pack_buffer(&buffer, appValue->unifi_Value_union.connectionConfig.bssid.data, 6);
        packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)appValue->unifi_Value_union.connectionConfig.bssType);
        packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)appValue->unifi_Value_union.connectionConfig.ifIndex);
        packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)appValue->unifi_Value_union.connectionConfig.privacyMode);
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.connectionConfig.authModeMask);
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.connectionConfig.encryptionModeMask);
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.connectionConfig.mlmeAssociateReqInformationElementsLength);
        if (appValue->unifi_Value_union.connectionConfig.mlmeAssociateReqInformationElementsLength)
        {
            packedLength += event_pack_buffer(&buffer, appValue->unifi_Value_union.connectionConfig.mlmeAssociateReqInformationElements, appValue->unifi_Value_union.connectionConfig.mlmeAssociateReqInformationElementsLength);
        }
        packedLength += event_pack_CsrUint8(&buffer, appValue->unifi_Value_union.connectionConfig.wmmQosInfo);
        packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)appValue->unifi_Value_union.connectionConfig.adhocJoinOnly);
        packedLength += event_pack_CsrUint8(&buffer, appValue->unifi_Value_union.connectionConfig.adhocChannel);
        break;
    case unifi_CcxConfigValue:
        packedLength += event_pack_CsrUint8(&buffer, appValue->unifi_Value_union.ccxConfig.keepAliveTimeMs);
        packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)appValue->unifi_Value_union.ccxConfig.apRoamingEnabled);
        packedLength += event_pack_CsrUint8(&buffer, appValue->unifi_Value_union.ccxConfig.measurementsMask);
        packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)appValue->unifi_Value_union.ccxConfig.ccxRadioMgtEnabled);
        break;
    case unifi_PowerConfigValue:
        packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)appValue->unifi_Value_union.powerConfig.powerSaveLevel);
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.powerConfig.listenIntervalBeacons);
        packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)appValue->unifi_Value_union.powerConfig.rxDtims);
        packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)appValue->unifi_Value_union.powerConfig.d3AutoScanMode);
        break;
    case unifi_HostConfigValue:
        packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)appValue->unifi_Value_union.hostConfig.powerMode);
        packedLength += event_pack_CsrUint16(&buffer, appValue->unifi_Value_union.hostConfig.applicationDataPeriodMs);
        break;
    default:
        break;
    };

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_mgt_tspec_req(CsrUint8** resultBuffer, void* appHandle, unifi_ListAction action, CsrUint32 transactionId, CsrBool strict, CsrUint8 ctrlMask, CsrUint16 tspecLength, const CsrUint8 *tspec, CsrUint16 tclasLength, const CsrUint8 *tclas)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 4;
    packedSize += 1;
    packedSize += 4;
    packedSize += 2;
    packedSize += 1;
    packedSize += 2;
    if (tspecLength)
    {
        packedSize += tspecLength;
    }
    packedSize += 2;
    if (tclasLength)
    {
        packedSize += tclasLength;
    }

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_MGT_TSPEC_REQ_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint32(&buffer, (CsrUint32)appHandle);
    packedLength += event_pack_CsrUint8(&buffer, (CsrUint8)action);
    packedLength += event_pack_CsrUint32(&buffer, transactionId);
    packedLength += event_pack_CsrUint16(&buffer, (CsrUint16)strict);
    packedLength += event_pack_CsrUint8(&buffer, ctrlMask);
    packedLength += event_pack_CsrUint16(&buffer, tspecLength);
    if (tspecLength)
    {
        packedLength += event_pack_buffer(&buffer, tspec, tspecLength);
    }
    packedLength += event_pack_CsrUint16(&buffer, tclasLength);
    if (tclasLength)
    {
        packedLength += event_pack_buffer(&buffer, tclas, tclasLength);
    }

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_mgt_wifi_flightmode_req(CsrUint8** resultBuffer, void* appHandle, const unifi_MACAddress *address, CsrUint16 mibFilesCount, const unifi_DataBlock *mibFiles)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 4;
    packedSize += 6;
    packedSize += 2;
    if (mibFilesCount)
    {
        CsrUint16 i1;
        for(i1 = 0; i1 < mibFilesCount; i1++)
        {
            packedSize += 2;
            if (mibFiles[i1].length)
            {
                packedSize += mibFiles[i1].length;
            }
        }
    }

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_MGT_WIFI_FLIGHTMODE_REQ_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint32(&buffer, (CsrUint32)appHandle);
    packedLength += event_pack_buffer(&buffer, address->data, 6);
    packedLength += event_pack_CsrUint16(&buffer, mibFilesCount);
    if (mibFilesCount)
    {
        CsrUint16 i1;
        for(i1 = 0; i1 < mibFilesCount; i1++)
        {
            packedLength += event_pack_CsrUint16(&buffer, mibFiles[i1].length);
            if (mibFiles[i1].length)
            {
                packedLength += event_pack_buffer(&buffer, mibFiles[i1].data, mibFiles[i1].length);
            }
        }
    }

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_mgt_wifi_off_req(CsrUint8** resultBuffer, void* appHandle)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 4;

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_MGT_WIFI_OFF_REQ_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint32(&buffer, (CsrUint32)appHandle);

    *resultBuffer = evt;
    return packedLength;
}

CsrUint16 serialise_unifi_mgt_wifi_on_req(CsrUint8** resultBuffer, void* appHandle, const unifi_MACAddress *address, CsrUint16 mibFilesCount, const unifi_DataBlock *mibFiles)
{
    CsrUint16 packedLength = 0;
    CsrUint32 packedSize = 6;
    CsrUint8* evt;
    CsrUint8* buffer;

    /* Calc Dymanic Size */
    packedSize += 4;
    packedSize += 6;
    packedSize += 2;
    if (mibFilesCount)
    {
        CsrUint16 i1;
        for(i1 = 0; i1 < mibFilesCount; i1++)
        {
            packedSize += 2;
            if (mibFiles[i1].length)
            {
                packedSize += mibFiles[i1].length;
            }
        }
    }

    evt = (CsrUint8*)CsrPmalloc(packedSize);
    buffer = evt;
    packedLength += event_pack_CsrUint16(&buffer, UNIFI_MGT_WIFI_ON_REQ_ID);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint16(&buffer, 0);
    packedLength += event_pack_CsrUint32(&buffer, (CsrUint32)appHandle);
    packedLength += event_pack_buffer(&buffer, address->data, 6);
    packedLength += event_pack_CsrUint16(&buffer, mibFilesCount);
    if (mibFilesCount)
    {
        CsrUint16 i1;
        for(i1 = 0; i1 < mibFilesCount; i1++)
        {
            packedLength += event_pack_CsrUint16(&buffer, mibFiles[i1].length);
            if (mibFiles[i1].length)
            {
                packedLength += event_pack_buffer(&buffer, mibFiles[i1].data, mibFiles[i1].length);
            }
        }
    }

    *resultBuffer = evt;
    return packedLength;
}


