/* This is an autogenerated file */
/* Tag: noCheckHeader */

/*    CONFIDENTIAL */
/*    Copyright (C) Cambridge Silicon Radio Ltd 2008. All rights reserved. */

#include "event_pack_unpack/event_pack_unpack.h"
#include "sme_top_level_fsm/sme.h"
#include "smeio/smeio_fsm_events.h"

static void event_to_unifi_sys_capabilities_req(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiSysCapabilitiesReq_Evt evt;

    evt.appHandle = (void*) event_unpack_CsrUint32(&buffer);

    unifi_sys_capabilities_req(context, evt.appHandle);

}

static void event_to_unifi_sys_configure_power_mode_req(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiSysConfigurePowerModeReq_Evt evt;

    evt.mode = (unifi_LowPowerMode) event_unpack_CsrUint16(&buffer);
    evt.wakeHost = (CsrBool) event_unpack_CsrUint16(&buffer);

    unifi_sys_configure_power_mode_req(context, evt.mode, evt.wakeHost);

}

static void event_to_unifi_sys_eapol_req(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiSysEapolReq_Evt evt;

    evt.appHandle = (void*) event_unpack_CsrUint32(&buffer);
    evt.subscriptionHandle =  event_unpack_CsrUint8(&buffer);
    evt.frameLength =  event_unpack_CsrUint16(&buffer);
    evt.frame = NULL;
    if (evt.frameLength)
    {
        evt.frame = (CsrUint8*)CsrPmalloc(evt.frameLength);
        event_unpack_buffer(&buffer, evt.frame, evt.frameLength);
    }
    evt.freeFunction = NULL;
    buffer+=4;

    unifi_sys_eapol_req(context, evt.appHandle, evt.subscriptionHandle, evt.frameLength, evt.frame, evt.freeFunction);

    CsrPfree(evt.frame);
}

static void event_to_unifi_sys_hip_req(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiSysHipReq_Evt evt;

    evt.mlmeCommandLength =  event_unpack_CsrUint16(&buffer);
    evt.mlmeCommand = NULL;
    if (evt.mlmeCommandLength)
    {
        evt.mlmeCommand = (CsrUint8*)CsrPmalloc(evt.mlmeCommandLength);
        event_unpack_buffer(&buffer, evt.mlmeCommand, evt.mlmeCommandLength);
    }
    evt.dataRef1Length =  event_unpack_CsrUint16(&buffer);
    evt.dataRef1 = NULL;
    if (evt.dataRef1Length)
    {
        evt.dataRef1 = (CsrUint8*)CsrPmalloc(evt.dataRef1Length);
        event_unpack_buffer(&buffer, evt.dataRef1, evt.dataRef1Length);
    }
    evt.dataRef2Length =  event_unpack_CsrUint16(&buffer);
    evt.dataRef2 = NULL;
    if (evt.dataRef2Length)
    {
        evt.dataRef2 = (CsrUint8*)CsrPmalloc(evt.dataRef2Length);
        event_unpack_buffer(&buffer, evt.dataRef2, evt.dataRef2Length);
    }

    unifi_sys_hip_req(context, evt.mlmeCommandLength, evt.mlmeCommand, evt.dataRef1Length, evt.dataRef1, evt.dataRef2Length, evt.dataRef2);

    CsrPfree(evt.mlmeCommand);
    CsrPfree(evt.dataRef1);
    CsrPfree(evt.dataRef2);
}

static void event_to_unifi_sys_m4_transmit_req(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    unifi_sys_m4_transmit_req(context);

}

static void event_to_unifi_sys_ma_unitdata_req(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiSysMaUnitdataReq_Evt evt;

    evt.appHandle = (void*) event_unpack_CsrUint32(&buffer);
    evt.subscriptionHandle =  event_unpack_CsrUint8(&buffer);
    evt.frameLength =  event_unpack_CsrUint16(&buffer);
    evt.frame = NULL;
    if (evt.frameLength)
    {
        evt.frame = (CsrUint8*)CsrPmalloc(evt.frameLength);
        event_unpack_buffer(&buffer, evt.frame, evt.frameLength);
    }
    evt.freeFunction = NULL;
    buffer+=4;
    evt.priority = (unifi_Priority) event_unpack_CsrUint16(&buffer);
    evt.serviceClass = (unifi_ServiceClass) event_unpack_CsrUint16(&buffer);
    evt.reqIdentifier =  event_unpack_CsrUint32(&buffer);

    unifi_sys_ma_unitdata_req(context, evt.appHandle, evt.subscriptionHandle, evt.frameLength, evt.frame, evt.freeFunction, evt.priority, evt.serviceClass, evt.reqIdentifier);

    CsrPfree(evt.frame);
}

static void event_to_unifi_sys_ma_unitdata_rsp(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiSysMaUnitdataRsp_Evt evt;

    evt.subscriptionHandle =  event_unpack_CsrUint8(&buffer);
    evt.result = (unifi_Status) event_unpack_CsrUint8(&buffer);

    unifi_sys_ma_unitdata_rsp(context, evt.subscriptionHandle, evt.result);

}

static void event_to_unifi_sys_ma_unitdata_subscribe_req(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiSysMaUnitdataSubscribeReq_Evt evt;

    evt.appHandle = (void*) event_unpack_CsrUint32(&buffer);
    evt.encapsulation = (unifi_Encapsulation) event_unpack_CsrUint8(&buffer);
    evt.protocol =  event_unpack_CsrUint16(&buffer);
    evt.oui =  event_unpack_CsrUint32(&buffer);

    unifi_sys_ma_unitdata_subscribe_req(context, evt.appHandle, evt.encapsulation, evt.protocol, evt.oui);

}

static void event_to_unifi_sys_ma_unitdata_unsubscribe_req(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiSysMaUnitdataUnsubscribeReq_Evt evt;

    evt.appHandle = (void*) event_unpack_CsrUint32(&buffer);
    evt.subscriptionHandle =  event_unpack_CsrUint8(&buffer);

    unifi_sys_ma_unitdata_unsubscribe_req(context, evt.appHandle, evt.subscriptionHandle);

}

static void event_to_unifi_sys_media_status_req(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiSysMediaStatusReq_Evt evt;

    evt.mediaStatus = (unifi_MediaStatus) event_unpack_CsrUint8(&buffer);
    evt.mediaTypeMask =  event_unpack_CsrUint32(&buffer);

    unifi_sys_media_status_req(context, evt.mediaStatus, evt.mediaTypeMask);

}

static void event_to_unifi_sys_multicast_address_rsp(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiSysMulticastAddressRsp_Evt evt;

    evt.status = (unifi_Status) event_unpack_CsrUint8(&buffer);
    evt.action = (unifi_ListAction) event_unpack_CsrUint8(&buffer);
    evt.getAddressesCount =  event_unpack_CsrUint8(&buffer);
    evt.getAddresses = NULL;
    if (evt.getAddressesCount)
    {
        CsrUint16 i1;
        evt.getAddresses = (unifi_MACAddress*)CsrPmalloc(sizeof(unifi_MACAddress) * evt.getAddressesCount);
        for(i1 = 0; i1 < evt.getAddressesCount; i1++)
        {
            event_unpack_buffer(&buffer, evt.getAddresses[i1].data, 6);
        }
    }

    unifi_sys_multicast_address_rsp(context, evt.status, evt.action, evt.getAddressesCount, evt.getAddresses);

    CsrPfree(evt.getAddresses);
}

static void event_to_unifi_sys_port_configure_req(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiSysPortConfigureReq_Evt evt;

    evt.uncontrolledPortAction = (unifi_PortAction) event_unpack_CsrUint16(&buffer);
    evt.controlledPortAction = (unifi_PortAction) event_unpack_CsrUint16(&buffer);
    event_unpack_buffer(&buffer, evt.macAddress.data, 6);

    unifi_sys_port_configure_req(context, evt.uncontrolledPortAction, evt.controlledPortAction, &evt.macAddress);

}

static void event_to_unifi_sys_qos_control_req(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiSysQosControlReq_Evt evt;

    evt.control = (unifi_QoSControl) event_unpack_CsrUint16(&buffer);

    unifi_sys_qos_control_req(context, evt.control);

}

static void event_to_unifi_sys_resume_rsp(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiSysResumeRsp_Evt evt;

    evt.status = (unifi_Status) event_unpack_CsrUint8(&buffer);

    unifi_sys_resume_rsp(context, evt.status);

}

static void event_to_unifi_sys_suspend_rsp(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiSysSuspendRsp_Evt evt;

    evt.status = (unifi_Status) event_unpack_CsrUint8(&buffer);

    unifi_sys_suspend_rsp(context, evt.status);

}

static void event_to_unifi_sys_tclas_add_req(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiSysTclasAddReq_Evt evt;

    evt.tclasLength =  event_unpack_CsrUint16(&buffer);
    evt.tclas = NULL;
    if (evt.tclasLength)
    {
        evt.tclas = (CsrUint8*)CsrPmalloc(evt.tclasLength);
        event_unpack_buffer(&buffer, evt.tclas, evt.tclasLength);
    }

    unifi_sys_tclas_add_req(context, evt.tclasLength, evt.tclas);

    CsrPfree(evt.tclas);
}

static void event_to_unifi_sys_tclas_del_req(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiSysTclasDelReq_Evt evt;

    evt.tclasLength =  event_unpack_CsrUint16(&buffer);
    evt.tclas = NULL;
    if (evt.tclasLength)
    {
        evt.tclas = (CsrUint8*)CsrPmalloc(evt.tclasLength);
        event_unpack_buffer(&buffer, evt.tclas, evt.tclasLength);
    }

    unifi_sys_tclas_del_req(context, evt.tclasLength, evt.tclas);

    CsrPfree(evt.tclas);
}

static void event_to_unifi_sys_traffic_classification_req(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiSysTrafficClassificationReq_Evt evt;

    evt.trafficType = (unifi_TrafficType) event_unpack_CsrUint8(&buffer);
    evt.period =  event_unpack_CsrUint16(&buffer);

    unifi_sys_traffic_classification_req(context, evt.trafficType, evt.period);

}

static void event_to_unifi_sys_traffic_config_req(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiSysTrafficConfigReq_Evt evt;

    evt.trafficConfigType = (unifi_TrafficConfigType) event_unpack_CsrUint16(&buffer);
    evt.config.packetFilter =  event_unpack_CsrUint16(&buffer);
    evt.config.customFilter.etherType =  event_unpack_CsrUint32(&buffer);
    evt.config.customFilter.ipType =  event_unpack_CsrUint8(&buffer);
    evt.config.customFilter.udpSourcePort =  event_unpack_CsrUint32(&buffer);
    evt.config.customFilter.udpDestPort =  event_unpack_CsrUint32(&buffer);

    unifi_sys_traffic_config_req(context, evt.trafficConfigType, &evt.config);

}

static void event_to_unifi_sys_wifi_off_req(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiSysWifiOffReq_Evt evt;

    evt.appHandle = (void*) event_unpack_CsrUint32(&buffer);

    unifi_sys_wifi_off_req(context, evt.appHandle);

}

static void event_to_unifi_sys_wifi_off_rsp(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    unifi_sys_wifi_off_rsp(context);

}

static void event_to_unifi_sys_wifi_on_req(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiSysWifiOnReq_Evt evt;

    evt.appHandle = (void*) event_unpack_CsrUint32(&buffer);

    unifi_sys_wifi_on_req(context, evt.appHandle);

}

static void event_to_unifi_sys_wifi_on_rsp(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 length)
{
    CsrUint8* buffer = &inputbuffer[6];
    UnifiSysWifiOnRsp_Evt evt;

    evt.status = (unifi_Status) event_unpack_CsrUint8(&buffer);
    event_unpack_buffer(&buffer, evt.stationMacAddress.data, 6);
    evt.smeVersions.firmwarePatch =  event_unpack_CsrUint32(&buffer);
    evt.smeVersions.smeBuild =  event_unpack_CsrUint32(&buffer);
    evt.smeVersions.smeVariant =  event_unpack_CsrUint32(&buffer);
    evt.smeVersions.smeHip =  event_unpack_CsrUint32(&buffer);
    evt.smeVersions.smeIdString = event_unpack_string(&buffer);

    unifi_sys_wifi_on_rsp(context, evt.status, &evt.stationMacAddress, &evt.smeVersions);

    CsrPfree(evt.smeVersions.smeIdString);
}



typedef void (*event_to_fn)(FsmContext* context, CsrUint8* inputbuffer, CsrUint16 size);

static const event_to_fn fnlookup1[45] = {
        event_to_unifi_sys_wifi_on_req,
        NULL,
        event_to_unifi_sys_wifi_on_rsp,
        NULL,
        event_to_unifi_sys_wifi_off_req,
        NULL,
        event_to_unifi_sys_wifi_off_rsp,
        NULL,
        NULL,
        event_to_unifi_sys_suspend_rsp,
        NULL,
        event_to_unifi_sys_resume_rsp,
        event_to_unifi_sys_qos_control_req,
        NULL,
        event_to_unifi_sys_port_configure_req,
        NULL,
        event_to_unifi_sys_configure_power_mode_req,
        event_to_unifi_sys_traffic_config_req,
        NULL,
        NULL,
        NULL,
        event_to_unifi_sys_media_status_req,
        NULL,
        event_to_unifi_sys_multicast_address_rsp,
        event_to_unifi_sys_tclas_add_req,
        NULL,
        event_to_unifi_sys_tclas_del_req,
        NULL,
        event_to_unifi_sys_traffic_classification_req,
        event_to_unifi_sys_m4_transmit_req,
        NULL,
        event_to_unifi_sys_hip_req,
        NULL,
        event_to_unifi_sys_ma_unitdata_subscribe_req,
        NULL,
        event_to_unifi_sys_ma_unitdata_unsubscribe_req,
        NULL,
        event_to_unifi_sys_capabilities_req,
        NULL,
        event_to_unifi_sys_ma_unitdata_req,
        NULL,
        event_to_unifi_sys_ma_unitdata_rsp,
        NULL,
        event_to_unifi_sys_eapol_req,
        NULL,

};


CsrBool remote_sys_signal_receive(FsmContext* context, CsrUint8* buffer, CsrUint16 size)
{
    CsrUint8* tempbuffer = buffer;
    CsrUint16 id = event_unpack_CsrUint16(&tempbuffer);

    if (id >= 0x8001 &&
        id <= 0x802D)
    {
        if (fnlookup1[id - 0x8001])
        {
            (*fnlookup1[id - 0x8001])(context, buffer, size);
            return TRUE;
        }
    }

    return FALSE;
}
